/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.GroupAvatarDrawable_v2;
import com.zipow.videobox.view.AvatarView;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMSavedSessionsListView
extends ListView
implements AdapterView.OnItemClickListener {
    private SavedSessionsAdapter mAdapter;

    private static void startGroupChat(ZMActivity activity, String groupId) {
        MMChatActivity.showAsGroupChat(activity, groupId);
    }

    public MMSavedSessionsListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public MMSavedSessionsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMSavedSessionsListView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mAdapter = new SavedSessionsAdapter(this.getContext(), null);
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.reloadAll();
    }

    public void onGroupAction(int result, GroupAction action, String msgId) {
        this.reloadAll();
    }

    public void onNotify_ChatSessionListUpdate() {
        this.reloadAll();
    }

    public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        this.reloadAll();
    }

    public void reloadAll() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        List<String> sessionsJid = messenger.savedSessionGetAll();
        ArrayList<SavedSession> sessions = new ArrayList<SavedSession>();
        if (sessionsJid != null) {
            for (String jid : sessionsJid) {
                ZoomGroup group = messenger.getGroupById(jid);
                if (group == null) continue;
                SavedSession savedSession = new SavedSession();
                savedSession.setGroupNums(group.getBuddyCount());
                savedSession.setJid(jid);
                savedSession.setSessionName(group.getGroupDisplayName(this.getContext()));
                savedSession.setE2E(group.isForceE2EGroup());
                sessions.add(savedSession);
            }
        }
        this.mAdapter.addItems(sessions);
    }

    public void filter(String filter) {
        if (this.mAdapter != null) {
            this.mAdapter.filter(filter);
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        SavedSession session = this.mAdapter.getItem(position);
        if (session == null) {
            return;
        }
        this.onSessionClick(session);
    }

    private void onSessionClick(SavedSession session) {
        if (session == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomGroup group = messenger.getGroupById(session.getJid());
        if (group == null) {
            return;
        }
        String groupId = group.getGroupID();
        if (StringUtil.isEmptyOrNull((String)groupId)) {
            return;
        }
        MMSavedSessionsListView.startGroupChat((ZMActivity)this.getContext(), groupId);
    }

    private static class SavedSession {
        private String mSessionName;
        private int mGroupNums;
        private String mJid;
        private boolean mIsE2E;

        private SavedSession() {
        }

        public String getSessionName() {
            return this.mSessionName;
        }

        public void setSessionName(String sessionName) {
            this.mSessionName = sessionName;
        }

        public int getGroupNums() {
            return this.mGroupNums;
        }

        public void setGroupNums(int groupNums) {
            this.mGroupNums = groupNums;
        }

        public String getJid() {
            return this.mJid;
        }

        public void setJid(String jid) {
            this.mJid = jid;
        }

        public boolean isE2E() {
            return this.mIsE2E;
        }

        public void setE2E(boolean isE2E) {
            this.mIsE2E = isE2E;
        }
    }

    private static class SavedSessionsAdapter
    extends BaseAdapter {
        private List<SavedSession> mData;
        private Context mContext;
        private List<SavedSession> mVisiabelSessions = new ArrayList<SavedSession>();
        private String mFilter;

        public SavedSessionsAdapter(Context context, List<SavedSession> sessions) {
            this.mContext = context;
            this.mData = sessions;
            if (sessions != null) {
                this.mVisiabelSessions.addAll(this.mData);
            }
        }

        public void addItem(SavedSession session) {
            if (session == null) {
                return;
            }
            if (this.mData == null) {
                this.mData = new ArrayList<SavedSession>();
            }
            this.mData.add(session);
        }

        public void addItems(List<SavedSession> sessions) {
            this.mData = sessions;
            this.filter(this.mFilter);
        }

        public void filter(String filter) {
            this.mVisiabelSessions.clear();
            Locale locale = CompatUtils.getLocalDefault();
            if (filter != null) {
                filter = filter.toLowerCase(locale);
            }
            this.mFilter = filter;
            if (this.mData != null) {
                if (!StringUtil.isEmptyOrNull((String)filter)) {
                    for (SavedSession session : this.mData) {
                        String name = session.getSessionName();
                        if (StringUtil.isEmptyOrNull((String)name) || !(name = name.toLowerCase(locale)).contains(filter)) continue;
                        this.mVisiabelSessions.add(session);
                    }
                } else {
                    this.mVisiabelSessions.addAll(this.mData);
                }
            }
            this.notifyDataSetChanged();
        }

        public int getCount() {
            return this.mVisiabelSessions.size();
        }

        public SavedSession getItem(int position) {
            if (this.mVisiabelSessions.size() <= position || position < 0) {
                return null;
            }
            return this.mVisiabelSessions.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            if (convertView == null) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_addrbook_item, null);
            }
            SavedSession session = this.getItem(position);
            TextView mTxtGroupNums = (TextView)convertView.findViewById(R.id.txtGroupNums);
            convertView.findViewById(R.id.presenceStateView).setVisibility(8);
            convertView.findViewById(R.id.txtCustomMessage).setVisibility(8);
            mTxtGroupNums.setVisibility(0);
            mTxtGroupNums.setText((CharSequence)(session.getGroupNums() + ""));
            AvatarView avatarView = (AvatarView)convertView.findViewById(R.id.avatarView);
            avatarView.setAvatar(new GroupAvatarDrawable_v2(session.getJid()));
            TextView txtScreenName = (TextView)convertView.findViewById(R.id.txtScreenName);
            txtScreenName.setText((CharSequence)session.getSessionName());
            ImageView imgE2EFlag = (ImageView)convertView.findViewById(R.id.imgE2EFlag);
            imgE2EFlag.setVisibility(session.isE2E() ? 0 : 8);
            return convertView;
        }
    }
}

