/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentManager;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.zipow.videobox.fragment.MMNotificationExceptionGroupFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.NotificationSettingMgr;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.mm.MMZoomGroup;
import com.zipow.videobox.view.mm.MMZoomGroupComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MMNotificationExceptionGroupListView
extends ListView
implements View.OnClickListener {
    private MMNotificationExceptionGroupAdapter mAdapter;
    private View mTxtExceptionGroups;
    private View mLineHeadDivider;
    private MMNotificationExceptionGroupFragment mParentFragment;
    private View mPaneResetAll;

    public MMNotificationExceptionGroupListView(Context context) {
        super(context);
        this.init();
    }

    public MMNotificationExceptionGroupListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMNotificationExceptionGroupListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.initHeadView();
        this.initFooterView();
        this.mAdapter = new MMNotificationExceptionGroupAdapter(this.getContext());
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public void setParentFragment(MMNotificationExceptionGroupFragment fragment) {
        this.mParentFragment = fragment;
    }

    public void updateData() {
        List<MMZoomGroup> groups = this.loadAllGroups();
        this.mAdapter.setGroups(groups);
        boolean isEmpty = CollectionsUtil.isListEmpty(groups);
        if (isEmpty) {
            this.mLineHeadDivider.setVisibility(8);
            this.mTxtExceptionGroups.setVisibility(8);
            this.mPaneResetAll.setVisibility(8);
        } else {
            this.mLineHeadDivider.setVisibility(0);
            this.mTxtExceptionGroups.setVisibility(0);
            this.mPaneResetAll.setVisibility(0);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    @Nullable
    private List<MMZoomGroup> loadAllGroups() {
        NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
        if (mgr == null) {
            return null;
        }
        PTAppProtos.MUCNotifySettings settings = mgr.getMUCSettings();
        if (settings == null) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        ArrayList<MMZoomGroup> groups = new ArrayList<MMZoomGroup>();
        for (int i = 0; i < settings.getItemsCount(); ++i) {
            PTAppProtos.MUCNotifySettingItem item = settings.getItems(i);
            ZoomGroup group = messenger.getGroupById(item.getSessionId());
            if (group == null) continue;
            MMZoomGroup mmZoomGroup = MMZoomGroup.initWithZoomGroup(group);
            mmZoomGroup.setNotifyType(item.getType());
            groups.add(mmZoomGroup);
        }
        return groups;
    }

    private void initHeadView() {
        View view = View.inflate((Context)this.getContext(), (int)R.layout.zm_notification_exception_group_head, null);
        view.findViewById(R.id.panelAddGroup).setOnClickListener((View.OnClickListener)this);
        this.mLineHeadDivider = view.findViewById(R.id.lineHeadDivider);
        this.mTxtExceptionGroups = view.findViewById(R.id.txtExceptionGroups);
        this.addHeaderView(view);
    }

    private void initFooterView() {
        View view = View.inflate((Context)this.getContext(), (int)R.layout.zm_notification_exception_group_foot, null);
        this.mPaneResetAll = view.findViewById(R.id.paneResetAll);
        this.mPaneResetAll.setOnClickListener((View.OnClickListener)this);
        this.addFooterView(view);
    }

    public MMZoomGroup getItem(int position) {
        return this.mAdapter.getItem(position - this.getHeaderViewsCount());
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.panelAddGroup) {
            this.onClickPanelAddGroup();
        } else if (id2 == R.id.paneResetAll) {
            this.onClickPaneResetAll();
        }
    }

    private void onClickPaneResetAll() {
        ResetAllGroupNotificationDialog dialog = ResetAllGroupNotificationDialog.showResetAllGroupNotificationDialog((ZMActivity)this.getContext());
        dialog.setOnDialogClickListener(new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == -1) {
                    NotificationSettingMgr mgr = PTApp.getInstance().getNotificationSettingMgr();
                    if (mgr == null) {
                        return;
                    }
                    PTAppProtos.MUCNotifySettings settings = mgr.getMUCSettings();
                    if (settings == null) {
                        return;
                    }
                    ArrayList<String> sessions = new ArrayList<String>();
                    for (PTAppProtos.MUCNotifySettingItem item : settings.getItemsList()) {
                        sessions.add(item.getSessionId());
                    }
                    if (sessions.size() == 0) {
                        return;
                    }
                    mgr.resetMUCSettings(sessions);
                    MMNotificationExceptionGroupListView.this.updateData();
                }
            }
        });
    }

    private void onClickPanelAddGroup() {
        if (this.mParentFragment != null) {
            this.mParentFragment.addExceptionGroup();
        }
    }

    static class MMNotificationExceptionGroupAdapter
    extends BaseAdapter {
        private List<MMZoomGroup> mData = new ArrayList<MMZoomGroup>();
        private Context mContext;

        public MMNotificationExceptionGroupAdapter(Context context) {
            this.mContext = context;
        }

        public void setGroups(List<MMZoomGroup> groups) {
            if (groups == null) {
                return;
            }
            this.mData.clear();
            for (MMZoomGroup group : groups) {
                this.mData.add(group);
            }
        }

        public void notifyDataSetChanged() {
            MMZoomGroupComparator comparator = new MMZoomGroupComparator(CompatUtils.getLocalDefault());
            Collections.sort(this.mData, comparator);
            super.notifyDataSetChanged();
        }

        public int getCount() {
            return this.mData == null ? 0 : this.mData.size();
        }

        public MMZoomGroup getItem(int position) {
            return this.mData == null ? null : this.mData.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            MMZoomGroup group = this.getItem(position);
            if (group == null) {
                return null;
            }
            if (convertView == null) {
                convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_notification_group_item, null);
            }
            TextView txtGroupName = (TextView)convertView.findViewById(R.id.txtGroupName);
            TextView txtNotifyDes = (TextView)convertView.findViewById(R.id.txtNotifyDes);
            View listDivider = convertView.findViewById(R.id.listDivider);
            txtGroupName.setText((CharSequence)String.format("%s(%d)", group.getGroupName(), group.getMemberCount()));
            listDivider.setBackgroundResource(position == this.getCount() - 1 ? R.drawable.zm_settings_bottom_divider : R.drawable.zm_settings_center_divider);
            switch (group.getNotifyType()) {
                case 1: {
                    txtNotifyDes.setText(R.string.zm_lbl_notification_all_msg_19898);
                    break;
                }
                case 2: {
                    txtNotifyDes.setText(R.string.zm_lbl_notification_private_msg_19898);
                    break;
                }
                case 3: {
                    txtNotifyDes.setText(R.string.zm_lbl_notification_nothing_19898);
                    break;
                }
                default: {
                    txtNotifyDes.setText((CharSequence)"");
                }
            }
            return convertView;
        }
    }

    public static class ResetAllGroupNotificationDialog
    extends ZMDialogFragment {
        private DialogInterface.OnClickListener mOnClickListener;

        public static ResetAllGroupNotificationDialog showResetAllGroupNotificationDialog(ZMActivity activity) {
            ResetAllGroupNotificationDialog dlg = new ResetAllGroupNotificationDialog();
            Bundle args = new Bundle();
            dlg.setArguments(args);
            dlg.show(activity.getSupportFragmentManager(), ResetAllGroupNotificationDialog.class.getName());
            return dlg;
        }

        public static ResetAllGroupNotificationDialog getResetAllGroupNotificationDialog(FragmentManager fm) {
            ResetAllGroupNotificationDialog f = (ResetAllGroupNotificationDialog)fm.findFragmentByTag(ResetAllGroupNotificationDialog.class.getName());
            return f;
        }

        @NonNull
        public Dialog onCreateDialog(Bundle savedInstanceState) {
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_lbl_notification_reset_exception_group_des_19898).setCancelable(true).setNegativeButton(R.string.zm_btn_cancel, null).setPositiveButton(R.string.zm_btn_confirm_19898, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (ResetAllGroupNotificationDialog.this.mOnClickListener != null) {
                        ResetAllGroupNotificationDialog.this.mOnClickListener.onClick(dialog, which);
                    }
                }
            }).create();
        }

        public void setOnDialogClickListener(DialogInterface.OnClickListener onClickListener) {
            this.mOnClickListener = onClickListener;
        }
    }
}

