/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.MMMessageItem;
import java.io.File;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMMessageUnSupportView
extends AbsMessageView {
    private static final String TAG = MMMessageUnSupportView.class.getSimpleName();
    protected MMMessageItem mMessageItem;
    protected TextView mTxtMessage;
    protected AvatarView mAvatarView;
    protected ImageView mImgStatus;
    protected ProgressBar mProgressBar;
    protected TextView mTxtScreenName;
    protected View mPanelTextMessage;

    public MMMessageUnSupportView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMMessageUnSupportView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtMessage = (TextView)this.findViewById(R.id.txtMessage);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mImgStatus = (ImageView)this.findViewById(R.id.imgStatus);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progressBar1);
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mPanelTextMessage = this.findViewById(R.id.panel_textMessage);
        this.setStatusImage(false, 0);
        this.mProgressBar.setVisibility(8);
        if (this.mAvatarView != null) {
            this.mAvatarView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickAvatarListener l = MMMessageUnSupportView.this.getOnClickAvatarListener();
                    if (l != null) {
                        l.onClickAvatar(MMMessageUnSupportView.this.mMessageItem);
                    }
                }
            });
            this.mAvatarView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    AbsMessageView.OnLongClickAvatarListener l = MMMessageUnSupportView.this.getOnLongClickAvatarListener();
                    if (l != null) {
                        return l.onLongClickAvatar(MMMessageUnSupportView.this.mMessageItem);
                    }
                    return false;
                }
            });
        }
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_message_from, (ViewGroup)this);
    }

    protected int getTextColor() {
        return this.getResources().getColor(R.color.zm_text_on_light);
    }

    public void setAvatar(String avatar) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(avatar);
        }
    }

    public void setAvatar(Bitmap bitmap) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(bitmap);
        }
    }

    public void setStatusImage(boolean visible, int resId) {
        if (this.mImgStatus != null) {
            this.mImgStatus.setVisibility(visible ? 0 : 8);
            this.mImgStatus.setImageResource(resId);
        }
    }

    public void setScreenName(String screenName) {
        if (screenName != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText((CharSequence)screenName);
        }
    }

    protected Drawable getMesageBackgroudDrawable() {
        return null;
    }

    @SuppressLint(value={"NewApi"})
    private void updateChatMsgBackground() {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            this.mPanelTextMessage.setBackgroundDrawable(this.getMesageBackgroudDrawable());
        } else {
            this.mPanelTextMessage.setBackground(this.getMesageBackgroudDrawable());
        }
    }

    public MMMessageItem getMessageItem() {
        return this.mMessageItem;
    }

    public void setMessageItem(MMMessageItem item) {
        this.mMessageItem = item;
        if (this.mAvatarView != null) {
            this.mAvatarView.setName(item.fromScreenName);
            this.mAvatarView.setBgColorSeedString(item.fromJid);
        }
        if (this.mTxtMessage != null) {
            this.mTxtMessage.setText(R.string.zm_msg_unsupport_message_13802);
        }
        this.updateChatMsgBackground();
        LinearLayout content = (LinearLayout)this.findViewById(R.id.panelMsgLayout);
        if (item.onlyMessageShow) {
            this.mAvatarView.setVisibility(4);
            if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(8);
            }
            content.setPadding(content.getPaddingLeft(), 0, content.getPaddingRight(), content.getPaddingBottom());
        } else {
            content.setPadding(content.getPaddingLeft(), content.getPaddingBottom(), content.getPaddingRight(), content.getPaddingBottom());
            this.mAvatarView.setVisibility(0);
            if (this.mTxtScreenName != null && item.isIncomingMessage() && item.isGroupMessage) {
                this.setScreenName(item.fromScreenName);
                if (this.mTxtScreenName != null) {
                    this.mTxtScreenName.setVisibility(0);
                }
            } else if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(8);
            }
            if (!this.isInEditMode()) {
                String fromJid = item.fromJid;
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger != null) {
                    File file;
                    String phoneNumber = null;
                    ZoomBuddy buddy = null;
                    ZoomBuddy myself = messenger.getMyself();
                    if (myself != null && fromJid != null && fromJid.equals(myself.getJid())) {
                        buddy = myself;
                    } else {
                        buddy = messenger.getBuddyWithJID(fromJid);
                        if (buddy != null) {
                            phoneNumber = buddy.getPhoneNumber();
                        }
                    }
                    String avatarPath = null;
                    if (buddy != null) {
                        avatarPath = buddy.getLocalPicturePath();
                    }
                    boolean hasAvatarFile = false;
                    if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                        this.setAvatar(avatarPath);
                        hasAvatarFile = true;
                    }
                    if (!hasAvatarFile) {
                        if (item.fromContact == null && phoneNumber != null && buddy != null) {
                            item.fromContact = IMAddrBookItem.fromZoomBuddy(buddy);
                        }
                        if (item.fromContact != null) {
                            this.setAvatar(item.fromContact.getAvatarBitmap(this.getContext()));
                        } else {
                            this.setAvatar((String)null);
                        }
                    }
                }
            }
        }
    }
}

