/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.tempbean.IMessageTemplateActionItem;
import com.zipow.videobox.tempbean.IMessageTemplateActions;
import com.zipow.videobox.tempbean.IMessageTemplateAttachments;
import com.zipow.videobox.tempbean.IMessageTemplateBase;
import com.zipow.videobox.tempbean.IMessageTemplateFieldItem;
import com.zipow.videobox.tempbean.IMessageTemplateFields;
import com.zipow.videobox.tempbean.IMessageTemplateHead;
import com.zipow.videobox.tempbean.IMessageTemplateMessage;
import com.zipow.videobox.tempbean.IMessageTemplateTextStyle;
import com.zipow.videobox.tempbean.IZoomMessageTemplate;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.IEditTemplateListener;
import com.zipow.videobox.view.mm.MMMessageItem;
import com.zipow.videobox.view.mm.MMMessageTemplateAttachmentsView;
import com.zipow.videobox.view.mm.MMMessageTemplateFieldsView;
import com.zipow.videobox.view.mm.MMMessageTemplateItemView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMMessageTemplateView
extends AbsMessageView {
    protected MMMessageItem mMessageItem;
    private TextView title;
    private TextView mTxtScreenName;
    private AvatarView mAvatarView;
    private MMMessageTemplateAttachmentsView attachmentView;
    private MMMessageTemplateFieldsView fieldsView;
    private MMMessageTemplateItemView messageView;
    private TextView mActionBtn1;
    private TextView mActionBtn2;
    private TextView mActionBtn3;
    private TextView mActionBtnMore;
    private LinearLayout actionBtnLinear;

    public MMMessageTemplateView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public MMMessageTemplateView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMMessageTemplateView(Context context) {
        super(context);
        this.initView();
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_message_template, (ViewGroup)this);
    }

    private void initView() {
        this.inflateLayout();
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.title = (TextView)this.findViewById(R.id.titleTxt);
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.attachmentView = (MMMessageTemplateAttachmentsView)this.findViewById(R.id.zm_msg_attachments);
        this.messageView = (MMMessageTemplateItemView)this.findViewById(R.id.zm_msg_messages);
        this.fieldsView = (MMMessageTemplateFieldsView)this.findViewById(R.id.zm_msg_fields);
        this.mActionBtn1 = (TextView)this.findViewById(R.id.template_action_btn1);
        this.mActionBtn2 = (TextView)this.findViewById(R.id.template_action_btn2);
        this.mActionBtn3 = (TextView)this.findViewById(R.id.template_action_btn3);
        this.mActionBtnMore = (TextView)this.findViewById(R.id.template_action_btn_more);
        this.actionBtnLinear = (LinearLayout)this.findViewById(R.id.template_action_bar_linear);
    }

    public void setScreenName(String screenName) {
        if (screenName != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText((CharSequence)screenName);
        }
    }

    public void setAvatar(String avatar) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(avatar);
        }
    }

    public void setAvatar(Bitmap bitmap) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(bitmap);
        }
    }

    public void setMessageItem(MMMessageItem item) {
        IZoomMessageTemplate messageTemplate;
        this.mMessageItem = item;
        this.setScreenName(item.fromScreenName);
        if (!this.isInEditMode()) {
            String fromJid = item.fromJid;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger != null) {
                File file;
                String phoneNumber = null;
                ZoomBuddy buddy = null;
                ZoomBuddy myself = messenger.getMyself();
                if (myself != null && fromJid != null && fromJid.equals(myself.getJid())) {
                    buddy = myself;
                } else {
                    buddy = messenger.getBuddyWithJID(fromJid);
                    if (buddy != null) {
                        phoneNumber = buddy.getPhoneNumber();
                    }
                }
                String avatarPath = null;
                if (buddy != null) {
                    avatarPath = buddy.getLocalPicturePath();
                }
                boolean hasAvatarFile = false;
                if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                    this.setAvatar(avatarPath);
                    hasAvatarFile = true;
                }
                if (!hasAvatarFile) {
                    if (item.fromContact == null && phoneNumber != null && buddy != null) {
                        item.fromContact = IMAddrBookItem.fromZoomBuddy(buddy);
                    }
                    if (item.fromContact != null) {
                        this.setAvatar(item.fromContact.getAvatarBitmap(this.getContext()));
                    } else {
                        this.setAvatar((String)null);
                    }
                }
            }
        }
        if (item.onlyMessageShow) {
            if (this.mAvatarView != null) {
                this.mAvatarView.setVisibility(4);
            }
            if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(8);
            }
        } else {
            if (this.mAvatarView != null) {
                this.mAvatarView.setVisibility(0);
            }
            if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(0);
            }
        }
        this.setTitle((messageTemplate = item.template) != null ? messageTemplate.getHead() : null);
        List<IMessageTemplateBase> bodys = messageTemplate != null ? messageTemplate.getBody() : null;
        ArrayList<IMessageTemplateActionItem> actions = new ArrayList<IMessageTemplateActionItem>();
        ArrayList<IMessageTemplateAttachments> attachments = new ArrayList<IMessageTemplateAttachments>();
        ArrayList<IMessageTemplateFieldItem> fieldItems = new ArrayList<IMessageTemplateFieldItem>();
        ArrayList<IMessageTemplateMessage> messageItems = new ArrayList<IMessageTemplateMessage>();
        int limit = -1;
        if (bodys != null) {
            for (IMessageTemplateBase templateBase : bodys) {
                List<Object> items;
                if (templateBase instanceof IMessageTemplateActions) {
                    limit = ((IMessageTemplateActions)templateBase).getLimit();
                    items = ((IMessageTemplateActions)templateBase).getItems();
                    if (items == null) continue;
                    actions.addAll(items);
                    continue;
                }
                if (templateBase instanceof IMessageTemplateAttachments) {
                    attachments.add((IMessageTemplateAttachments)templateBase);
                    continue;
                }
                if (templateBase instanceof IMessageTemplateFields) {
                    items = ((IMessageTemplateFields)templateBase).getItems();
                    if (items == null) continue;
                    fieldItems.addAll(items);
                    continue;
                }
                if (!(templateBase instanceof IMessageTemplateMessage)) continue;
                messageItems.add((IMessageTemplateMessage)templateBase);
            }
        }
        if (messageItems.isEmpty() && fieldItems.isEmpty() && attachments.isEmpty() && actions.isEmpty()) {
            this.messageView.removeAllViews();
            this.fieldsView.removeAllViews();
            this.attachmentView.removeAllViews();
            this.messageView.setVisibility(4);
            this.fieldsView.setVisibility(4);
            this.attachmentView.setVisibility(4);
            this.actionBtnLinear.setVisibility(8);
        } else {
            this.setMessage(messageItems);
            this.setFields(fieldItems);
            this.setAttachments(attachments);
            this.setAction(actions, limit);
        }
    }

    private void setTitle(IMessageTemplateHead head) {
        if (this.title != null) {
            if (head == null) {
                this.title.setText((CharSequence)"");
                return;
            }
            IMessageTemplateTextStyle style2 = head.getStyle();
            if (style2 != null) {
                style2.applyStyle(this.title);
            }
            this.title.setText((CharSequence)head.getText());
        }
    }

    private void setMessage(List<IMessageTemplateMessage> list) {
        if (this.messageView != null) {
            this.messageView.setData(this.mMessageItem, list);
            this.messageView.setmEditTemplateListener(new IEditTemplateListener(){

                @Override
                public void onEditTemplate(String xmppid, String eventID) {
                    AbsMessageView.OnClickEditTemplateListener l = MMMessageTemplateView.this.getmOnClickEditTemplateListener();
                    if (l != null) {
                        l.onClickEditTemplate(xmppid, eventID);
                    }
                }
            });
        }
    }

    private void setFields(List<IMessageTemplateFieldItem> list) {
        if (this.fieldsView != null) {
            this.fieldsView.setData(this.mMessageItem, list);
            this.fieldsView.setmEditTemplateListener(new IEditTemplateListener(){

                @Override
                public void onEditTemplate(String xmppid, String eventID) {
                    AbsMessageView.OnClickEditTemplateListener l = MMMessageTemplateView.this.getmOnClickEditTemplateListener();
                    if (l != null) {
                        l.onClickEditTemplate(xmppid, eventID);
                    }
                }
            });
        }
    }

    private void setAttachments(List<IMessageTemplateAttachments> list) {
        if (this.attachmentView != null) {
            this.attachmentView.setData(list);
        }
    }

    private void setAction(List<IMessageTemplateActionItem> actions, int limit) {
        if (actions == null || actions.size() <= 0) {
            this.actionBtnLinear.setVisibility(8);
            return;
        }
        final ArrayList<IMessageTemplateActionItem> moreActions = new ArrayList<IMessageTemplateActionItem>();
        this.actionBtnLinear.setVisibility(0);
        this.mActionBtn3.setVisibility(8);
        final IMessageTemplateActionItem actionItem = actions.get(0);
        this.mActionBtn1.setVisibility(0);
        this.mActionBtn1.setText((CharSequence)(actionItem == null ? "" : actionItem.getText()));
        this.mActionBtn1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbsMessageView.OnClickActionListener l = MMMessageTemplateView.this.getmOnClickActionListener();
                if (l != null && actionItem != null) {
                    l.onClickAction(MMMessageTemplateView.this.mMessageItem.fromJid, actionItem.getEvent());
                }
            }
        });
        if (actions.size() > 1) {
            final IMessageTemplateActionItem actionItem2 = actions.get(1);
            this.mActionBtn2.setText((CharSequence)(actionItem2 == null ? "" : actionItem2.getText()));
            this.mActionBtn2.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickActionListener l = MMMessageTemplateView.this.getmOnClickActionListener();
                    if (l != null && actionItem2 != null) {
                        l.onClickAction(MMMessageTemplateView.this.mMessageItem.fromJid, actionItem2.getEvent());
                    }
                }
            });
        }
        if (actions.size() > 2) {
            final IMessageTemplateActionItem actionItem3 = actions.get(2);
            this.mActionBtn3.setText((CharSequence)(actionItem3 == null ? "" : actionItem3.getText()));
            this.mActionBtn3.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickActionListener l = MMMessageTemplateView.this.getmOnClickActionListener();
                    if (l != null && actionItem3 != null) {
                        l.onClickAction(MMMessageTemplateView.this.mMessageItem.fromJid, actionItem3.getEvent());
                    }
                }
            });
        }
        if (actions.size() == 1) {
            this.mActionBtnMore.setVisibility(8);
            this.mActionBtn2.setVisibility(8);
        } else if (actions.size() == 2) {
            if (limit == 1) {
                this.mActionBtnMore.setVisibility(0);
                this.mActionBtn1.setVisibility(8);
                this.mActionBtn2.setVisibility(8);
                moreActions.addAll(actions);
            } else {
                this.mActionBtnMore.setVisibility(8);
                this.mActionBtn2.setVisibility(0);
            }
        } else if (actions.size() == 3) {
            if (limit == 1) {
                this.mActionBtnMore.setVisibility(0);
                this.mActionBtn1.setVisibility(8);
                this.mActionBtn2.setVisibility(8);
                moreActions.addAll(actions);
            } else if (limit == 2) {
                this.mActionBtnMore.setVisibility(0);
                this.mActionBtn1.setVisibility(0);
                this.mActionBtn2.setVisibility(8);
                moreActions.addAll(actions.subList(1, actions.size()));
            } else {
                this.mActionBtnMore.setVisibility(8);
                this.mActionBtn2.setVisibility(0);
                this.mActionBtn3.setVisibility(0);
            }
        } else {
            this.mActionBtnMore.setVisibility(0);
            if (limit == 1) {
                this.mActionBtn1.setVisibility(8);
                this.mActionBtn2.setVisibility(8);
                moreActions.addAll(actions);
            } else if (limit == 2) {
                this.mActionBtn1.setVisibility(0);
                this.mActionBtn2.setVisibility(8);
                moreActions.addAll(actions.subList(1, actions.size()));
            } else {
                this.mActionBtn2.setVisibility(0);
                moreActions.addAll(actions.subList(2, actions.size()));
            }
        }
        this.mActionBtnMore.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbsMessageView.OnClickTemplateActionMoreListener l = MMMessageTemplateView.this.getmOnClickTemplateActionMoreListener();
                if (l != null) {
                    l.onClickTemplateActionMore(v, MMMessageTemplateView.this.mMessageItem.fromJid, moreActions);
                }
            }
        });
    }
}

