/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.tempbean.IMessageTemplateFieldItem;
import com.zipow.videobox.tempbean.IMessageTemplateTextStyle;
import com.zipow.videobox.view.mm.IEditTemplateListener;
import com.zipow.videobox.view.mm.MMMessageItem;
import java.util.List;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMMessageTemplateFieldsView
extends LinearLayout {
    private MMMessageItem mmMessageItem;
    private IEditTemplateListener mEditTemplateListener;

    public MMMessageTemplateFieldsView(Context context) {
        super(context);
        this.initView(context);
    }

    public MMMessageTemplateFieldsView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public MMMessageTemplateFieldsView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public MMMessageTemplateFieldsView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        this.setOrientation(1);
    }

    public void setmEditTemplateListener(IEditTemplateListener mEditTemplateListener) {
        this.mEditTemplateListener = mEditTemplateListener;
    }

    public void setData(MMMessageItem item, List<IMessageTemplateFieldItem> list) {
        if (item == null || list == null || list.isEmpty()) {
            this.setVisibility(8);
            return;
        }
        this.setVisibility(0);
        this.mmMessageItem = item;
        this.removeAllViews();
        for (IMessageTemplateFieldItem fieldItem : list) {
            this.addFieldsItem(fieldItem);
        }
    }

    private void addFieldsItem(final IMessageTemplateFieldItem item) {
        if (item != null) {
            ZoomBuddy buddy;
            String name;
            ZoomMessenger messager;
            IMessageTemplateTextStyle style2;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
            if (this.getChildCount() > 0) {
                params.topMargin = UIUtil.dip2px((Context)this.getContext(), (float)7.0f);
            }
            View child = MMMessageTemplateFieldsView.inflate((Context)this.getContext(), (int)R.layout.zm_mm_message_template_fields, null);
            TextView key = (TextView)child.findViewById(R.id.key);
            TextView value = (TextView)child.findViewById(R.id.value);
            ImageView edit = (ImageView)child.findViewById(R.id.edit);
            key.setText((CharSequence)item.getKey());
            if (!TextUtils.isEmpty((CharSequence)item.getLink())) {
                value.setMovementMethod(LinkMovementMethod.getInstance());
                SpannableString spannableString = new SpannableString((CharSequence)item.getValue());
                spannableString.setSpan((Object)new ClickableSpan(){

                    public void onClick(View widget) {
                        UIUtil.openURL((Context)MMMessageTemplateFieldsView.this.getContext(), (String)item.getLink());
                    }

                    public void updateDrawState(TextPaint ds) {
                        ds.setColor(ContextCompat.getColor((Context)MMMessageTemplateFieldsView.this.getContext(), (int)R.color.zm_template_link));
                        ds.setUnderlineText(false);
                    }
                }, 0, spannableString.length(), 33);
                value.setText((CharSequence)spannableString);
            } else {
                value.setText((CharSequence)item.getValue());
            }
            if (item.isEditable()) {
                edit.setVisibility(0);
                edit.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (MMMessageTemplateFieldsView.this.mEditTemplateListener != null) {
                            MMMessageTemplateFieldsView.this.mEditTemplateListener.onEditTemplate(((MMMessageTemplateFieldsView)MMMessageTemplateFieldsView.this).mmMessageItem.messageXMPPId, item.getEvent_id());
                        }
                    }
                });
            }
            if ((style2 = item.getStyle()) != null) {
                style2.applyStyle(value);
            }
            if (item.isName() && (messager = PTApp.getInstance().getZoomMessenger()) != null && !TextUtils.isEmpty((CharSequence)(name = (buddy = messager.getMyself()).getScreenName())) && !TextUtils.isEmpty((CharSequence)item.getValue()) && name.equalsIgnoreCase(item.getValue())) {
                value.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.zm_template_fields_txt_light));
                value.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.zm_template_link));
            }
            this.addView(child, (ViewGroup.LayoutParams)params);
        }
    }
}

