/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.tempbean.IMessageTemplateAttachmentDescription;
import com.zipow.videobox.tempbean.IMessageTemplateAttachmentInfo;
import com.zipow.videobox.tempbean.IMessageTemplateAttachmentTitle;
import com.zipow.videobox.tempbean.IMessageTemplateAttachments;
import com.zipow.videobox.tempbean.IMessageTemplateTextStyle;
import com.zipow.videobox.util.ImageLoader;
import java.util.List;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMMessageTemplateAttachmentsView
extends LinearLayout {
    private LinearLayout attachmentGroup;
    private TextView sizeTxt;

    public MMMessageTemplateAttachmentsView(Context context) {
        super(context);
        this.initView(context);
    }

    public MMMessageTemplateAttachmentsView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public MMMessageTemplateAttachmentsView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public MMMessageTemplateAttachmentsView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        MMMessageTemplateAttachmentsView.inflate((Context)context, (int)R.layout.zm_mm_message_template_attachments, (ViewGroup)this);
        this.attachmentGroup = (LinearLayout)this.findViewById(R.id.attachments_group);
        this.sizeTxt = (TextView)this.findViewById(R.id.attachments_size);
    }

    public void setData(List<IMessageTemplateAttachments> list) {
        if (list == null || list.isEmpty()) {
            this.setVisibility(8);
            return;
        }
        this.setVisibility(0);
        if (this.attachmentGroup != null) {
            this.attachmentGroup.removeAllViews();
        }
        int size = 0;
        for (IMessageTemplateAttachments item : list) {
            this.addAttachments(item);
            size += item.getSize();
        }
        this.sizeTxt.setText((CharSequence)String.format(this.getResources().getString(R.string.zm_mm_template_attachments_40639), FileUtils.toFileSizeString((Context)this.getContext(), (long)size)));
    }

    private void addAttachments(final IMessageTemplateAttachments attachments) {
        IMessageTemplateAttachmentInfo attachmentInfo;
        if (attachments == null || this.attachmentGroup == null) {
            return;
        }
        View item = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.zm_mm_message_template_attachments_item, (ViewGroup)this, false);
        TextView title = (TextView)item.findViewById(R.id.attachments_file_name);
        TextView subTitle = (TextView)item.findViewById(R.id.attachments_file_sub);
        ImageView img = (ImageView)item.findViewById(R.id.img);
        item.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UIUtil.openURL((Context)v.getContext(), (String)attachments.getResource_url());
            }
        });
        if (!TextUtils.isEmpty((CharSequence)attachments.getImg_url())) {
            ImageLoader.getInstance().displayImage(img, attachments.getImg_url());
        }
        if ((attachmentInfo = attachments.getInformation()) != null) {
            IMessageTemplateAttachmentDescription description;
            IMessageTemplateAttachmentTitle attachmentTitle = attachmentInfo.getTitle();
            if (attachmentTitle != null) {
                IMessageTemplateTextStyle style2 = attachmentTitle.getStyle();
                if (style2 != null) {
                    style2.applyStyle(title);
                }
                title.setText((CharSequence)attachmentTitle.getText());
            }
            if ((description = attachmentInfo.getDescription()) != null) {
                IMessageTemplateTextStyle style3 = description.getStyle();
                if (style3 != null) {
                    style3.applyStyle(subTitle);
                }
                subTitle.setText((CharSequence)description.getText());
            }
        }
        this.attachmentGroup.addView(item);
    }
}

