/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.Html;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.view.mm.MMContentSearchMessagesListView;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMMessageSearchFragment
extends ZMDialogFragment
implements SimpleActivity.ExtListener,
View.OnClickListener {
    public static final String TAG = MMMessageSearchFragment.class.getSimpleName();
    private static final String ARG_SEARCH_FILTER = "search_filter";
    private String mContextMsgReqId;
    private String mContextAnchorMsgGUID;
    private TextView mTxtLoadingError;
    private View mTxtContentLoading;
    private View mPanelEmptyView;
    private View mPanelMessageTitle;
    private View mTxtEmptyView;
    private EditText mEdtSearch;
    private Button mBtnClearSearchView;
    private Button mBtnBack;
    private MMContentSearchMessagesListView mMessagesListView;
    private boolean mbKeyboardOpen = false;
    private boolean mbIgnoreKeyboardCloseEvent = false;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void Indicate_MessageContentSearchResult(String reqID, int result, PTAppProtos.MessageContentSearchResponse response) {
            MMMessageSearchFragment.this.Indicate_MessageContentSearchResult(reqID, result, response);
        }
    };

    public static void showAsFragment(Object obj) {
        MMMessageSearchFragment.showAsFragment(obj, null);
    }

    public static void showAsFragment(Object obj, String filter) {
        MMMessageSearchFragment.showAsFragment(obj, -1, filter);
    }

    public static void showAsFragment(Object obj, int requestCode, String filter) {
        Bundle args = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)filter)) {
            args.putString(ARG_SEARCH_FILTER, filter);
        }
        if (obj instanceof Fragment) {
            SimpleActivity.show((Fragment)obj, MMMessageSearchFragment.class.getName(), args, requestCode, 2);
        } else if (obj instanceof ZMActivity) {
            SimpleActivity.show((ZMActivity)obj, MMMessageSearchFragment.class.getName(), args, requestCode, true);
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            View decorView;
            Window window = this.getActivity().getWindow();
            if (Build.VERSION.SDK_INT >= 23 && (decorView = window.getDecorView()) != null) {
                int vis = decorView.getSystemUiVisibility();
                decorView.setSystemUiVisibility(vis |= 0x2000);
            }
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(this.getResources().getColor(R.color.zm_im_search_bar_bg));
        }
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_message_search, container, false);
        final Button btnSearch = (Button)view.findViewById(R.id.btnSearch);
        this.mEdtSearch = (EditText)view.findViewById(R.id.edtSearch);
        this.mBtnClearSearchView = (Button)view.findViewById(R.id.btnClearSearchView);
        this.mMessagesListView = (MMContentSearchMessagesListView)view.findViewById(R.id.listViewContentMessages);
        this.mTxtLoadingError = (TextView)view.findViewById(R.id.txtLoadingError);
        this.mTxtContentLoading = view.findViewById(R.id.txtContentLoading);
        this.mPanelEmptyView = view.findViewById(R.id.panelEmptyView);
        this.mTxtEmptyView = view.findViewById(R.id.txtEmptyView);
        this.mPanelMessageTitle = view.findViewById(R.id.panel_listview_message_title);
        this.mBtnBack = (Button)view.findViewById(R.id.btnBack);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        btnSearch.setVisibility(8);
        btnSearch.setOnClickListener((View.OnClickListener)this);
        this.mMessagesListView.setParentFragment(this);
        this.mEdtSearch.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 3) {
                    MMMessageSearchFragment.this.startSearch();
                }
                return false;
            }
        });
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                MMMessageSearchFragment.this.mBtnClearSearchView.setVisibility(s.length() != 0 ? 0 : 8);
                btnSearch.setVisibility(s.length() != 0 ? 0 : 8);
            }
        });
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mTxtLoadingError.setOnClickListener((View.OnClickListener)this);
        this.mTxtLoadingError.setText((CharSequence)Html.fromHtml((String)this.getString(R.string.zm_lbl_content_load_error)));
        if (savedInstanceState != null) {
            this.mContextMsgReqId = savedInstanceState.getString("mContextMsgReqId");
            this.mContextAnchorMsgGUID = savedInstanceState.getString("mContextAnchorMsgGUID");
            this.mbIgnoreKeyboardCloseEvent = savedInstanceState.getBoolean("mbIgnoreKeyboardCloseEvent");
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
        return view;
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        String filter;
        Bundle bundle;
        if (savedInstanceState == null) {
            this.getActivity().getWindow().setSoftInputMode(21);
        }
        if ((bundle = this.getArguments()) != null && !TextUtils.isEmpty((CharSequence)(filter = bundle.getString(ARG_SEARCH_FILTER)))) {
            this.mEdtSearch.setText((CharSequence)filter);
            this.mEdtSearch.setSelection(this.mEdtSearch.getText().length());
            this.startSearch();
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onDestroyView() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onDestroyView();
    }

    public void onResume() {
        super.onResume();
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        this.mbKeyboardOpen = true;
        this.mbIgnoreKeyboardCloseEvent = false;
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mbKeyboardOpen) {
            this.mbKeyboardOpen = false;
            if (!this.mbIgnoreKeyboardCloseEvent && this.isResultEmpty()) {
                this.dismiss();
            }
        }
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    private boolean isResultEmpty() {
        boolean empty = true;
        if (this.mMessagesListView != null) {
            empty = this.mMessagesListView.isResultEmpty();
        }
        return empty;
    }

    private void updateEmptyViewStatus() {
        boolean isEmpty = false;
        boolean isLoading = false;
        boolean isLoadSuccess = false;
        isEmpty = this.mMessagesListView.isEmpty();
        isLoading = this.mMessagesListView.isLoading();
        isLoadSuccess = this.mMessagesListView.isLoadSuccess();
        this.mPanelEmptyView.setVisibility((isEmpty &= this.mEdtSearch.getText().toString().trim().length() != 0) ? 0 : 8);
        this.mPanelMessageTitle.setVisibility(isEmpty ? 8 : 0);
        if (isLoading) {
            this.mTxtContentLoading.setVisibility(0);
            this.mTxtEmptyView.setVisibility(8);
            this.mTxtLoadingError.setVisibility(8);
        } else {
            this.mTxtContentLoading.setVisibility(8);
            this.mTxtEmptyView.setVisibility(isLoadSuccess ? 0 : 8);
            this.mTxtLoadingError.setVisibility(!isLoadSuccess ? 0 : 8);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (outState != null) {
            outState.putString("mContextMsgReqId", this.mContextMsgReqId);
            outState.putString("mContextAnchorMsgGUID", this.mContextAnchorMsgGUID);
            outState.putBoolean("mbIgnoreKeyboardCloseEvent", this.mbIgnoreKeyboardCloseEvent);
        }
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }

    public void Indicate_MessageContentSearchResult(String reqID, int result, PTAppProtos.MessageContentSearchResponse response) {
        this.mMessagesListView.Indicate_MessageContentSearchResult(reqID, result, response);
        this.updateEmptyViewStatus();
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnSearch) {
            this.onClickBtnSearch();
        } else if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.txtLoadingError) {
            this.onClickTxtLoadingError();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private void onClickTxtLoadingError() {
        if (!this.mMessagesListView.isLoadSuccess()) {
            this.mMessagesListView.searchMessage(null);
        }
        this.updateEmptyViewStatus();
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
    }

    private void onClickBtnSearch() {
        this.startSearch();
    }

    private void startSearch() {
        String filter = this.mEdtSearch.getText().toString().trim();
        if (StringUtil.isEmptyOrNull((String)filter)) {
            return;
        }
        this.mMessagesListView.setFilter(filter, null);
        this.updateEmptyViewStatus();
        this.mbIgnoreKeyboardCloseEvent = true;
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.mEdtSearch);
    }
}

