/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Environment;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Toast;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.fragment.MMImageViewerFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PTSettingHelper;
import com.zipow.videobox.ptapp.mm.CrawlerLinkPreview;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.tempbean.IMessageTemplateActionItem;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.LinkPreviewMetaInfo;
import com.zipow.videobox.view.mm.MMAddonMessage;
import com.zipow.videobox.view.mm.MMContentFileViewerFragment;
import com.zipow.videobox.view.mm.MMMessageItem;
import com.zipow.videobox.view.mm.MMMessageListView;
import com.zipow.videobox.view.mm.PendingFileDataHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.ZMLog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MMMessageListAdapter
extends BaseAdapter
implements AbsMessageView.OnShowContextMenuListener,
AbsMessageView.OnClickMessageListener,
AbsMessageView.OnClickStatusImageListener,
AbsMessageView.OnClickAvatarListener,
AbsMessageView.OnClickCancelListener,
AbsMessageView.OnLongClickAvatarListener,
AbsMessageView.OnClickAddonListener,
AbsMessageView.OnClickMeetingNOListener,
AbsMessageView.OnClickActionListener,
AbsMessageView.OnClickActionMoreListener,
AbsMessageView.OnClickLinkPreviewListener,
AbsMessageView.OnClickGiphyBtnListener,
AbsMessageView.OnClickTemplateActionMoreListener,
AbsMessageView.OnClickEditTemplateListener {
    private static final String TAG = MMMessageListAdapter.class.getSimpleName();
    public static final int E2E_MESSAGE_TIME_OUT = 10000;
    private List<MMMessageItem> items = new ArrayList<MMMessageItem>();
    private List<MMMessageItem> msgItems = new ArrayList<MMMessageItem>();
    private List<MMMessageItem> mE2EPendingItems = new ArrayList<MMMessageItem>();
    private Context mContext;
    private String mSessionId;
    private MMMessageListView mListView;
    private String mPendingPlayMsgId = null;
    private String mPendingOpenMsgId = null;

    public MMMessageListAdapter(Context context) {
        assert (context != null);
        this.mContext = context;
    }

    public void setParentListView(MMMessageListView listView) {
        this.mListView = listView;
    }

    public void setSessionId(String sessionId) {
        this.mSessionId = sessionId;
    }

    public void clear() {
        this.msgItems.clear();
        this.items.clear();
    }

    public void removeUnincludeMsg(List<String> msgIds) {
        if (CollectionsUtil.isCollectionEmpty(this.msgItems)) {
            return;
        }
        if (CollectionsUtil.isCollectionEmpty(msgIds)) {
            this.msgItems.clear();
        }
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (item != null && !msgIds.contains(item.messageId)) continue;
            this.msgItems.remove(i);
            --i;
        }
    }

    public void addItem(MMMessageItem item) {
        this.insertMessageSortByTime(item);
    }

    public void addItemAtFirst(MMMessageItem item) {
        this.addUpdateItem(0, item);
    }

    public void removeItem(String messageId) {
        if (messageId == null) {
            return;
        }
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (!messageId.equals(item.messageId)) continue;
            this.msgItems.remove(i);
            return;
        }
    }

    public void removeOldMsg(long anchorTimestamp) {
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (item.serverSideTime >= anchorTimestamp) continue;
            this.msgItems.remove(i);
            ZMLog.i((String)TAG, (String)"removeOldMsg remove item %s", (Object[])new Object[]{item.messageId});
            --i;
        }
    }

    public void removeItemByXMPPGuid(String guid) {
        if (guid == null) {
            return;
        }
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (!guid.equals(item.messageXMPPId)) continue;
            this.msgItems.remove(i);
            return;
        }
    }

    public void removeItemByFileId(String fileId) {
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (!StringUtil.isSameString((String)item.fileId, (String)fileId)) continue;
            this.msgItems.remove(i);
            return;
        }
    }

    public void notifyDataSetChanged() {
        this.rebuildListItems();
        super.notifyDataSetChanged();
    }

    public long getLatestMessageStamp() {
        if (this.msgItems == null || this.msgItems.size() == 0) {
            return 0L;
        }
        long stamp = this.msgItems.get((int)0).messageTime;
        for (MMMessageItem item : this.msgItems) {
            if (item.messageTime <= stamp) continue;
            stamp = item.messageTime;
        }
        return stamp;
    }

    public long getEarliestMessageStamp() {
        if (this.msgItems == null || this.msgItems.size() == 0) {
            return 0L;
        }
        long stamp = this.msgItems.get((int)0).messageTime;
        for (MMMessageItem item : this.msgItems) {
            if (item.messageTime >= stamp) continue;
            stamp = item.messageTime;
        }
        return stamp;
    }

    @Nullable
    public String getEarliestMessageId() {
        if (this.msgItems == null || this.msgItems.size() == 0) {
            return null;
        }
        String msgId = null;
        long stamp = this.msgItems.get((int)0).messageTime;
        msgId = this.msgItems.get((int)0).messageId;
        for (MMMessageItem item : this.msgItems) {
            if (item.messageTime >= stamp) continue;
            stamp = item.messageTime;
            msgId = item.messageId;
        }
        return msgId;
    }

    public boolean hasMessageFromJid(String jid) {
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (!jid.equals(item.fromJid)) continue;
            return true;
        }
        return false;
    }

    public void removeHistory(long erase) {
        Iterator<MMMessageItem> it = this.msgItems.iterator();
        while (it.hasNext()) {
            MMMessageItem mmMessageItem = it.next();
            if (mmMessageItem.messageTime >= erase) continue;
            it.remove();
        }
    }

    private void rebuildListItems() {
        this.items.clear();
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (i == 0 || this.items.size() == 0) {
                item.onlyMessageShow = false;
            } else {
                ZoomChatSession session;
                ZoomMessenger messenger;
                item.onlyMessageShow = false;
                MMMessageItem preItem = this.msgItems.get(i - 1);
                if (TextUtils.equals((CharSequence)preItem.fromJid, (CharSequence)item.fromJid) && TextUtils.equals((CharSequence)preItem.toJid, (CharSequence)item.toJid) && preItem.messageType != 18 && (messenger = PTApp.getInstance().getZoomMessenger()) != null && (session = messenger.getSessionById(this.mSessionId)) != null && !session.isMessageMarkUnread(item.messageXMPPId) && !session.isMessageMarkUnread(preItem.messageXMPPId)) {
                    item.onlyMessageShow = true;
                }
            }
            this.addItemToListItems(item);
        }
    }

    public void checkE2ETimeoutMsg() {
        boolean findTimeout = false;
        for (int i = 0; i < this.mE2EPendingItems.size(); ++i) {
            MMMessageItem item = this.mE2EPendingItems.get(i);
            if (item.isE2EMessagePending()) {
                if (CmmTime.getMMNow() - item.messageTime <= 10000L) continue;
                item.messageState = 4;
                findTimeout = true;
                this.mE2EPendingItems.remove(i);
                --i;
                continue;
            }
            this.mE2EPendingItems.remove(i);
            --i;
        }
        if (findTimeout) {
            this.notifyDataSetChanged();
        }
    }

    public void insertMessageSortByTime(MMMessageItem messageItem) {
        if (messageItem == null) {
            return;
        }
        int idx = this.findItem(messageItem.messageId);
        if (idx >= 0) {
            this.msgItems.set(idx, messageItem);
        } else {
            int position = -1;
            for (int i = 0; i < this.msgItems.size(); ++i) {
                MMMessageItem item = this.msgItems.get(i);
                if (item.messageTime <= messageItem.messageTime && (item.messageTime != messageItem.messageTime || item.serverSideTime <= messageItem.serverSideTime)) continue;
                position = i;
                break;
            }
            if (position < 0) {
                this.msgItems.add(messageItem);
            } else {
                this.msgItems.add(position, messageItem);
            }
        }
        this.notifyDataSetChanged();
    }

    public boolean updateE2EPendingMessageState(String sessionID, String messageID, int e2eSessionState) {
        boolean isMessageInPending = false;
        for (int i = 0; i < this.mE2EPendingItems.size(); ++i) {
            MMMessageItem item = this.mE2EPendingItems.get(i);
            if (!TextUtils.equals((CharSequence)messageID, (CharSequence)item.messageId)) continue;
            item.messageState = e2eSessionState;
            this.mE2EPendingItems.remove(i);
            --i;
            isMessageInPending = true;
        }
        if (isMessageInPending) {
            this.notifyDataSetChanged();
        }
        return isMessageInPending;
    }

    private void addItemToListItems(MMMessageItem item) {
        int idxLastTimeItem;
        MMMessageItem lastTimeItem = null;
        if (this.items.size() > 0 && (idxLastTimeItem = this.getLastTimeItemIndex()) >= 0) {
            lastTimeItem = this.items.get(idxLastTimeItem);
        }
        if (lastTimeItem == null || item.messageTime - lastTimeItem.messageTime > 300000L || item.messageTime < lastTimeItem.messageTime) {
            MMMessageItem timeItem = new MMMessageItem();
            timeItem.sessionId = this.mSessionId;
            timeItem.messageTime = item.messageTime;
            timeItem.messageType = 19;
            timeItem.messageId = "time" + System.currentTimeMillis();
            if (!item.messageId.equals("TIMED_CHAT_MSG_ID")) {
                this.items.add(timeItem);
            }
            item.onlyMessageShow = false;
        }
        this.items.add(item);
    }

    private int getLastTimeItemIndex() {
        MMMessageItem item = null;
        if (this.items.size() == 0) {
            return -1;
        }
        for (int i = this.getCount() - 1; i >= 0; --i) {
            item = this.items.get(i);
            if (item.messageType != 19) continue;
            return i;
        }
        return -1;
    }

    private void addUpdateItem(int idx, MMMessageItem item) {
        assert (item != null);
        int pos = this.findItem(item.messageId);
        if (pos >= 0) {
            this.msgItems.set(pos, item);
        } else if (idx < 0) {
            this.msgItems.add(item);
        } else {
            this.msgItems.add(idx, item);
        }
    }

    public int findItemByXmppId(String xmppId) {
        if (xmppId == null) {
            return -1;
        }
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (!xmppId.equals(item.messageXMPPId)) continue;
            return i;
        }
        return -1;
    }

    public MMMessageItem findRealItemByXmppId(String xmppId) {
        if (xmppId == null) {
            return null;
        }
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (!xmppId.equals(item.messageXMPPId)) continue;
            return item;
        }
        return null;
    }

    public int findItem(String messageId) {
        if (messageId == null) {
            return -1;
        }
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (!messageId.equals(item.messageId)) continue;
            return i;
        }
        return -1;
    }

    public int findItem(long serverSideTime) {
        if (serverSideTime <= 0L) {
            return -1;
        }
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (serverSideTime != item.serverSideTime) continue;
            return i;
        }
        return -1;
    }

    public MMMessageItem getItemByMessageXmppId(String xmppId) {
        int idx = this.findItem(xmppId);
        if (idx >= 0) {
            return this.msgItems.get(idx);
        }
        return null;
    }

    public MMMessageItem getItemByMessageId(String messageId) {
        int idx = this.findItem(messageId);
        if (idx >= 0) {
            return this.msgItems.get(idx);
        }
        return null;
    }

    public MMMessageItem getItemByServerSideTime(long serverSideTime) {
        int idx = this.findItem(serverSideTime);
        if (idx >= 0) {
            return this.msgItems.get(idx);
        }
        return null;
    }

    public List<MMMessageItem> getItemsByFileId(String fileId) {
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return null;
        }
        ArrayList<MMMessageItem> msgs = new ArrayList<MMMessageItem>();
        for (int i = 0; i < this.msgItems.size(); ++i) {
            MMMessageItem item = this.msgItems.get(i);
            if (!fileId.equals(item.fileId)) continue;
            msgs.add(item);
        }
        return msgs;
    }

    public String addOrUpdateGiphyMsg(MMMessageItem item) {
        if (item == null || TextUtils.isEmpty((CharSequence)item.giphyID)) {
            return null;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        int pos = this.findItem(item.messageId);
        String reqID = "";
        PTAppProtos.GiphyMsgInfo info = messenger.getGiphyInfo(item.giphyID);
        if (info != null && !messenger.checkGiphyFileIsExist(item.giphyID)) {
            reqID = messenger.downloadGIFFromGiphyByUrl(item.giphyID, "", "", info.getMobileUrl());
        }
        if (pos == -1) {
            this.insertMessageSortByTime(item);
        } else {
            this.msgItems.set(pos, item);
        }
        return reqID;
    }

    @Nullable
    public MMMessageItem getLatestMsgIdInCache(List<String> msgIds) {
        if (CollectionsUtil.isCollectionEmpty(msgIds)) {
            return null;
        }
        for (MMMessageItem item : this.msgItems) {
            if (!msgIds.contains(item.messageId)) continue;
            return item;
        }
        return null;
    }

    public List<String> addOrUpdateLinkPreviewMsg(MMMessageItem message) {
        if (message == null || CollectionsUtil.isListEmpty(message.linkPreviewMetaInfos) || StringUtil.isEmptyOrNull((String)message.messageId)) {
            return null;
        }
        CrawlerLinkPreview mgr = PTApp.getInstance().getLinkCrawler();
        if (mgr == null) {
            return null;
        }
        int pos = this.findItem(message.messageId);
        boolean showDetail = PTSettingHelper.isImLlinkPreviewDescription();
        ArrayList<String> reqIds = new ArrayList<String>();
        List<LinkPreviewMetaInfo> infos = message.linkPreviewMetaInfos;
        for (LinkPreviewMetaInfo info : infos) {
            String reqId;
            if (!new File(info.getFaviconPath()).exists() && mgr.NeedDownloadFavicon(info.getUrl()) && !StringUtil.isEmptyOrNull((String)(reqId = mgr.DownloadFavicon(info.getUrl(), PendingFileDataHelper.getContenFileRandomPath())))) {
                reqIds.add(reqId);
            }
            if (!showDetail || new File(info.getImagePath()).exists() || !mgr.NeedDownloadImage(info.getUrl()) || StringUtil.isEmptyOrNull((String)(reqId = mgr.DownloadImage(info.getUrl(), PendingFileDataHelper.getContenFileRandomPath())))) continue;
            reqIds.add(reqId);
        }
        if (pos == -1) {
            this.insertMessageSortByTime(message);
        } else {
            this.msgItems.set(pos, message);
        }
        return reqIds;
    }

    public int getCount() {
        return this.items.size();
    }

    public boolean isLastItem(String messageId) {
        if (messageId == null) {
            return false;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            MMMessageItem item = this.items.get(i);
            if (!messageId.equals(item.messageId)) continue;
            return i == this.items.size() - 1;
        }
        return false;
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.items.get(position);
    }

    public int getMessageItemsCount() {
        return this.msgItems.size();
    }

    public MMMessageItem getMessageItem(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        return this.msgItems.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        int type = 0;
        MMMessageItem item = (MMMessageItem)this.getItem(position);
        if (item != null) {
            type = item.messageType;
        }
        return type;
    }

    public int getViewTypeCount() {
        return 42;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        MMMessageItem item = (MMMessageItem)this.getItem(position);
        if (item == null) {
            return null;
        }
        AbsMessageView msgView = item.getView(this.mContext, convertView);
        msgView.setOnShowContextMenuListener(this);
        msgView.setOnClickMessageListener(this);
        msgView.setOnClickStatusImageListener(this);
        msgView.setOnClickAvatarListener(this);
        msgView.setOnClickCancelListenter(this);
        msgView.setOnLongClickAvatarListener(this);
        msgView.setOnClickAddonListener(this);
        msgView.setOnClickMeetingNOListener(this);
        msgView.setmOnClickActionListener(this);
        msgView.setmOnClickActionMoreListener(this);
        msgView.setOnClickLinkPreviewListener(this);
        msgView.setmOnClickGiphyBtnListener(this);
        msgView.setmOnClickTemplateActionMoreListener(this);
        msgView.setmOnClickEditTemplateListener(this);
        if (this.mListView != null) {
            this.mListView.onMessageShowed(item.messageId);
        }
        return msgView;
    }

    @Override
    public boolean onShowContextMenu(MMMessageItem message) {
        int position = this.items.indexOf(message);
        if (this.mListView != null && position >= 0) {
            this.mListView.showMessageContextMenu(position, message);
        }
        return true;
    }

    @Override
    public void onClickMessage(MMMessageItem message) {
        this.doMessageItem(message);
    }

    public void doMessageItem(MMMessageItem message) {
        switch (message.messageType) {
            case 2: 
            case 3: {
                if (message.isPlaying) {
                    this.mListView.stopPlayAudioMessage();
                    return;
                }
                boolean needDownload = false;
                if (!StringUtil.isEmptyOrNull((String)message.localFilePath) && new File(message.localFilePath).exists()) {
                    if (!this.playAudioMessage(message)) {
                        new File(message.localFilePath).delete();
                        needDownload = true;
                    }
                } else {
                    needDownload = true;
                }
                if (!needDownload) break;
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                if (message.messageType == 3 && message.messageState != 2) {
                    return;
                }
                ZoomChatSession session = messenger.getSessionById(this.mSessionId);
                if (session == null) {
                    return;
                }
                boolean res = session.downloadFileForMessage(message.messageId);
                if (!res) break;
                message.isDownloading = true;
                this.mPendingPlayMsgId = message.messageId;
                this.notifyDataSetChanged();
                this.mListView.onStartToDownloadFileForMessage(message, false);
                break;
            }
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 27: 
            case 28: {
                if (!(message.messageType != 5 && message.messageType != 28 && message.messageType != 11 || message.messageState != 4 && message.messageState != 1)) {
                    return;
                }
                MMContentFileViewerFragment.showAsActivity((ZMActivity)this.mContext, this.mSessionId, message.messageId, message.messageXMPPId, message.fileId, 0);
                break;
            }
        }
    }

    private static boolean isUploadState(int transState) {
        switch (transState) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public void showMessageNoAppToOpenFile() {
        ZMAlertDialog dlg = new ZMAlertDialog.Builder(this.mContext).setMessage(R.string.zm_ft_msg_no_app_to_open_this_file).setPositiveButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    private void alertDownloadUsingMobileDataNetwork(final MMMessageItem message) {
        ZMAlertDialog dlg = new ZMAlertDialog.Builder(this.mContext).setMessage(R.string.zm_ft_alert_download_using_mobile_data_network).setPositiveButton(R.string.zm_btn_yes, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MMMessageListAdapter.this.startFTDownload(message);
            }
        }).setNegativeButton(R.string.zm_btn_no, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        }).create();
        dlg.show();
    }

    private void startFTDownload(MMMessageItem message) {
        if (!NetworkUtil.hasDataNetwork((Context)this.mContext)) {
            Toast.makeText((Context)this.mContext, (int)R.string.zm_mm_msg_network_unavailable, (int)1).show();
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        String fileName = null;
        ZoomMessage.FileInfo fileInfo = message.fileInfo;
        if (fileInfo != null) {
            fileName = fileInfo.name;
        }
        if (fileName == null) {
            return;
        }
        String state = Environment.getExternalStorageState();
        if (!"mounted".equals(state)) {
            this.showMessageCannotDownloadForNoStorage();
            return;
        }
        String filePath = this.buildFileDownloadPath(fileName);
        if (filePath == null) {
            return;
        }
        boolean res = false;
        res = !StringUtil.isEmptyOrNull((String)message.localFilePath) && message.transferInfo != null && (message.transferInfo.state == 12 || message.transferInfo.state == 11) ? messenger.FT_Resume(this.mSessionId, message.messageId) : messenger.FT_Download(this.mSessionId, message.messageId, filePath);
        if (res) {
            message.isDownloading = true;
            this.mPendingOpenMsgId = message.messageId;
            this.notifyDataSetChanged();
            this.mListView.onStartToDownloadFileForMessage(message, true);
        }
    }

    private String buildFileDownloadPath(String fileName) {
        File fDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        if (fDir == null || !fDir.canWrite()) {
            return null;
        }
        return FileUtils.makeNewFilePathWithName((String)fDir.getAbsolutePath(), (String)fileName);
    }

    private void showMessageCannotDownloadForNoStorage() {
        Toast.makeText((Context)this.mContext, (int)R.string.zm_ft_alert_cannot_download_for_no_storage, (int)1).show();
    }

    public void cancelPendingPlay() {
        this.mPendingPlayMsgId = null;
    }

    @Override
    public void onClickStatusImage(MMMessageItem message) {
        ZoomGroup group;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(this.mSessionId);
        if (session == null) {
            return;
        }
        if (session.isGroup() && ((group = session.getSessionGroup()) == null || !group.amIInGroup())) {
            return;
        }
        if (message.isE2E) {
            if (!messenger.isConnectionGood()) {
                return;
            }
            if (message.isMessageE2EWaitDecrypt()) {
                int code = messenger.e2eTryDecodeMessage(this.mSessionId, message.messageId);
                if (code == 0) {
                    ZoomMessage msg = session.getMessageById(message.messageId);
                    if (msg != null) {
                        message.message = msg.getBody();
                        message.messageState = msg.getMessageState();
                    }
                } else if (code == 37) {
                    message.messageState = 3;
                    message.message = this.mContext.getResources().getString(R.string.zm_msg_e2e_message_decrypting);
                }
                this.notifyDataSetChanged();
                return;
            }
        }
        boolean sendFileFailed = false;
        if (message.messageType == 11 || message.messageType == 5 || message.messageType == 28) {
            ZoomMessage.FileTransferInfo transInfo = message.transferInfo;
            if (transInfo != null) {
                sendFileFailed = transInfo.state == 2 || transInfo.state == 18;
            } else {
                ZoomFile file;
                MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
                if (mgr != null && (file = mgr.getFileWithMessageID(this.mSessionId, message.messageXMPPId)) != null) {
                    if (file.getFileTransferState() == 18) {
                        sendFileFailed = true;
                    }
                    mgr.destroyFileObject(file);
                }
            }
        }
        if (sendFileFailed || message.messageState == 4 || message.messageState == 5) {
            this.mListView.askToResendMessage(message);
        }
        if (message.messageType == 4) {
            session.checkAutoDownloadForMessage(message.messageId);
            message.isPreviewDownloadFailed = false;
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void onClickAvatar(MMMessageItem message) {
        this.mListView.onClickMessageAvatar(message);
    }

    @Override
    public boolean onLongClickAvatar(MMMessageItem message) {
        return this.mListView.onLongClickMessageAvatar(message);
    }

    private void showPictureFile(String sessionId, String messageId) {
        if (this.mContext == null) {
            return;
        }
        MMImageViewerFragment.showAsActivity((ZMActivity)this.mContext, sessionId, messageId);
    }

    private boolean playAudioMessage(MMMessageItem message) {
        return this.mListView.playAudioMessage(message);
    }

    public void onConfirmFileDownloaded(String sessionId, String messageId, int result) {
        if (!StringUtil.isSameString((String)this.mSessionId, (String)sessionId)) {
            return;
        }
        if (StringUtil.isSameString((String)this.mPendingPlayMsgId, (String)messageId)) {
            this.mPendingPlayMsgId = null;
            MMMessageItem message = this.getItemByMessageId(messageId);
            if (message == null) {
                return;
            }
            switch (message.messageType) {
                case 2: 
                case 3: {
                    if (message.isFileDownloaded && !StringUtil.isEmptyOrNull((String)message.localFilePath) && new File(message.localFilePath).exists()) {
                        if (this.playAudioMessage(message)) break;
                        Toast.makeText((Context)this.mContext, (int)R.string.zm_mm_msg_play_audio_failed, (int)1).show();
                        break;
                    }
                    if (result == 0) break;
                    Toast.makeText((Context)this.mContext, (int)R.string.zm_mm_msg_download_audio_failed, (int)1).show();
                }
            }
        } else if (StringUtil.isSameString((String)this.mPendingOpenMsgId, (String)messageId)) {
            this.mPendingOpenMsgId = null;
            if (this.mListView.isParentFragmentResumed() && result == 0) {
                MMMessageItem message = this.getItemByMessageId(messageId);
                if (message == null) {
                    return;
                }
                this.openFileForMessage(message);
            }
        }
    }

    @Override
    public void onClickCancel(MMMessageItem message) {
        if (message == null) {
            return;
        }
        if (this.mListView != null) {
            this.mListView.FT_Cancel(message);
        }
    }

    public void FT_OnSent(String sessionID, String messageID, int result) {
    }

    public void FT_OnProgress(String sessionID, String messageID, int ratio, long completeSize, long bitPerSecond) {
    }

    public void FT_OnResumed(String sessionID, String messageID, int result) {
    }

    private void openFileForMessage(MMMessageItem messageItem) {
        String filePath = messageItem.localFilePath;
        if (StringUtil.isEmptyOrNull((String)filePath)) {
            return;
        }
        File file = new File(filePath);
        AndroidAppUtil.MimeType mimeType = AndroidAppUtil.getMimeTypeOfFile((String)file.getAbsolutePath());
        if (mimeType != null && mimeType.fileType == 3 && ImageUtil.isValidImageFile(file.getAbsolutePath())) {
            this.showPictureFile(this.mSessionId, messageItem.messageId);
            return;
        }
        if (!AndroidAppUtil.hasActivityToOpenFile((Context)this.mContext, (File)file)) {
            this.showMessageNoAppToOpenFile();
            return;
        }
        AndroidAppUtil.openFile((Context)this.mContext, (File)file);
    }

    @Override
    public void onClickAddon(MMAddonMessage.NodeMsgHref href) {
        if (this.mListView != null) {
            this.mListView.onClickAddon(href);
        }
    }

    @Override
    public void onClickMeetingNO(String no) {
        if (this.mListView != null) {
            this.mListView.onClickMeetingNO(no);
        }
    }

    @Override
    public void onClickActionMore(String jid, List<MMAddonMessage.AddonNode> nodes) {
        if (this.mListView != null) {
            this.mListView.onClickActionMore(jid, nodes);
        }
    }

    @Override
    public void onClickAction(String jid, String action) {
        if (this.mListView != null) {
            this.mListView.onClickAction(jid, action);
        }
    }

    @Override
    public void onClickLinkPreview(MMMessageItem message, LinkPreviewMetaInfo url) {
        if (this.mListView != null) {
            this.mListView.onClickLinkPreview(message, url);
        }
    }

    @Override
    public void onClickGiphyBtn(MMMessageItem message, View view) {
        if (view.getId() == R.id.giphy_cancel_btn) {
            this.removeItem(message.messageId);
            this.notifyDataSetChanged();
        } else if (view.getId() == R.id.giphy_shuffle_btn) {
            String reqID;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            message.messageId = reqID = messenger.getGiphyInfoByStr(String.valueOf(message.message), message.sessionId, 1);
        } else if (view.getId() == R.id.giphy_send_btn && this.mListView != null) {
            this.mListView.onClickSendGiphyBtn(message, view);
        }
    }

    @Override
    public void onClickTemplateActionMore(View v, String jid, List<IMessageTemplateActionItem> actionItems) {
        if (this.mListView != null) {
            this.mListView.onClickTemplateActionMore(v, jid, actionItems);
        }
    }

    @Override
    public void onClickEditTemplate(String xmppid, String eventID) {
        if (this.mListView != null) {
            this.mListView.onClickEditTemplate(xmppid, eventID);
        }
    }
}

