/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.MMMessageItem;
import java.io.File;
import java.text.NumberFormat;
import us.zoom.androidlib.util.AndroidAppUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMMessageFileView
extends AbsMessageView {
    private static final int ONE_KB = 1024;
    private static final int ONE_MB = 0x100000;
    protected MMMessageItem mMessageItem;
    protected AvatarView mAvatarView;
    protected ImageView mImgStatus;
    protected View mPanelMessage;
    protected ImageView mImgFileIcon;
    protected TextView mTxtFileName;
    protected TextView mTxtFileSize;
    protected ProgressBar mProgressBar;
    protected TextView mTxtScreenName;
    protected View mBtnCancel;
    protected ImageView mImgFileStatus;
    protected ProgressBar mDownloadPercent;

    public MMMessageFileView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMMessageFileView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mImgStatus = (ImageView)this.findViewById(R.id.imgStatus);
        this.mProgressBar = (ProgressBar)this.findViewById(R.id.progressBar1);
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mPanelMessage = this.findViewById(R.id.panelMessage);
        this.mImgFileIcon = (ImageView)this.findViewById(R.id.imgFileIcon);
        this.mTxtFileName = (TextView)this.findViewById(R.id.txtFileName);
        this.mTxtFileSize = (TextView)this.findViewById(R.id.txtFileSize);
        this.mBtnCancel = this.findViewById(R.id.btnCancel);
        this.mImgFileStatus = (ImageView)this.findViewById(R.id.imgFileStatus);
        this.mDownloadPercent = (ProgressBar)this.findViewById(R.id.downloadPercent);
        this.setStatusImage(false, 0);
        if (this.mPanelMessage != null) {
            this.mPanelMessage.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    AbsMessageView.OnShowContextMenuListener l = MMMessageFileView.this.getOnShowContextMenuListener();
                    if (l != null) {
                        return l.onShowContextMenu(MMMessageFileView.this.mMessageItem);
                    }
                    return false;
                }
            });
            this.mPanelMessage.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickMessageListener l = MMMessageFileView.this.getOnClickMessageListener();
                    if (l != null) {
                        l.onClickMessage(MMMessageFileView.this.mMessageItem);
                    }
                }
            });
        }
        if (this.mImgStatus != null) {
            this.mImgStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickStatusImageListener l = MMMessageFileView.this.getOnClickStatusImageListener();
                    if (l != null) {
                        l.onClickStatusImage(MMMessageFileView.this.mMessageItem);
                    }
                }
            });
        }
        if (this.mAvatarView != null) {
            this.mAvatarView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickAvatarListener l = MMMessageFileView.this.getOnClickAvatarListener();
                    if (l != null) {
                        l.onClickAvatar(MMMessageFileView.this.mMessageItem);
                    }
                }
            });
            this.mAvatarView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    AbsMessageView.OnLongClickAvatarListener l = MMMessageFileView.this.getOnLongClickAvatarListener();
                    if (l != null) {
                        return l.onLongClickAvatar(MMMessageFileView.this.mMessageItem);
                    }
                    return false;
                }
            });
        }
        if (this.mBtnCancel != null) {
            this.mBtnCancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickCancelListener l = MMMessageFileView.this.getOnClickCancelListenter();
                    if (l != null) {
                        l.onClickCancel(MMMessageFileView.this.mMessageItem);
                    }
                }
            });
        }
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_message_file_from, (ViewGroup)this);
    }

    public void setAvatar(String avatar) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(avatar);
        }
    }

    protected Drawable getMesageBackgroudDrawable() {
        return null;
    }

    public void setAvatar(Bitmap bitmap) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(bitmap);
        }
    }

    public void setStatusImage(boolean visible, int resId) {
        if (this.mImgStatus != null) {
            this.mImgStatus.setVisibility(visible ? 0 : 8);
            this.mImgStatus.setImageResource(resId);
        }
    }

    public void setScreenName(String screenName) {
        if (screenName != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText((CharSequence)screenName);
        }
    }

    private void setFileInfo(ZoomMessage.FileInfo fileInfo, String path, ZoomMessage.FileTransferInfo transInfo) {
        boolean fileExists = false;
        if (path != null) {
            fileExists = new File(path).exists();
        }
        String name = null;
        long transferedSize = 0L;
        long totalSize = 0L;
        int error = 0;
        long bitsPerSecond = 0L;
        int transState = 0;
        if (fileInfo != null) {
            name = fileInfo.name;
            totalSize = fileInfo.size;
        }
        if (transInfo != null) {
            bitsPerSecond = transInfo.bitsPerSecond;
            transferedSize = transInfo.transferredSize;
            error = transInfo.prevError;
            transState = transInfo.state;
            if (!(fileExists || transState != 13 && transState != 4)) {
                transState = 0;
            }
        }
        if (this.mTxtFileName != null && name != null) {
            this.mTxtFileName.setText((CharSequence)name);
        }
        if (this.mImgFileIcon != null) {
            int icon = AndroidAppUtil.getIconForFile((String)name);
            this.mImgFileIcon.setImageResource(icon);
        }
        switch (transState) {
            case 1: 
            case 10: {
                this.showProgressStatus(transferedSize, totalSize, bitsPerSecond, false, 0);
                break;
            }
            case 3: 
            case 12: {
                this.showProgressStatus(transferedSize, totalSize, bitsPerSecond, true, 0);
                break;
            }
            case 2: 
            case 11: {
                this.showProgressStatus(transferedSize, totalSize, bitsPerSecond, true, error);
                break;
            }
            case 4: 
            case 13: {
                this.showNonProgressStatus(totalSize, fileExists);
                break;
            }
            default: {
                this.showNonProgressStatus(totalSize, false);
            }
        }
    }

    private void showNonProgressStatus(long totalSize, boolean fileExists) {
        if (this.mDownloadPercent != null) {
            this.mDownloadPercent.setVisibility(8);
        }
        if (this.mTxtFileSize != null && totalSize >= 0L) {
            String strSize = null;
            strSize = totalSize > 0x100000L ? this.toFileSizeString((double)totalSize / 1048576.0, R.string.zm_file_size_mb) : (totalSize > 1024L ? this.toFileSizeString((double)totalSize / 1024.0, R.string.zm_file_size_kb) : this.toFileSizeString(totalSize, R.string.zm_file_size_bytes));
            this.mTxtFileSize.setText((CharSequence)strSize);
        }
        this.mBtnCancel.setVisibility(8);
        if (fileExists) {
            if (this.mImgFileStatus != null) {
                this.mImgFileStatus.setImageResource(R.drawable.zm_filebadge_success);
            }
        } else if (this.mImgFileStatus != null) {
            this.mImgFileStatus.setImageDrawable(null);
        }
    }

    private void showProgressStatus(long transferedSize, long totalSize, long bitsPerSecond, boolean paused, int error) {
        if (this.mDownloadPercent != null) {
            this.mDownloadPercent.setVisibility(0);
            if (totalSize > 0L) {
                this.mDownloadPercent.setProgress((int)(transferedSize * 100L / totalSize));
            } else {
                this.mDownloadPercent.setProgress(0);
            }
        }
        if (error == 0 && this.mTxtFileSize != null && totalSize >= 0L) {
            String strSize = null;
            strSize = totalSize > 0x100000L ? this.toFileSizeString((double)totalSize / 1048576.0, (double)transferedSize / 1048576.0, R.string.zm_ft_transfered_size_mb) : (totalSize > 1024L ? this.toFileSizeString((double)totalSize / 1024.0, (double)transferedSize / 1024.0, R.string.zm_ft_transfered_size_kb) : this.toFileSizeString(totalSize, transferedSize, R.string.zm_ft_transfered_size_bytes));
            if (paused) {
                this.mTxtFileSize.setText((CharSequence)strSize);
            } else {
                this.mTxtFileSize.setText((CharSequence)(strSize + " (" + this.toDownloadingSpeedString(bitsPerSecond) + ")"));
            }
        }
        this.mBtnCancel.setVisibility(0);
        if (error != 0) {
            if (this.mImgFileStatus != null) {
                this.mImgFileStatus.setImageResource(R.drawable.zm_filebadge_error);
            }
            if (this.mTxtFileSize != null) {
                this.mTxtFileSize.setText((CharSequence)this.errorCodeToMessage(error));
            }
        } else if (paused) {
            if (this.mImgFileStatus != null) {
                this.mImgFileStatus.setImageResource(R.drawable.zm_filebadge_paused);
            }
        } else if (this.mImgFileStatus != null) {
            this.mImgFileStatus.setImageDrawable(null);
        }
    }

    private String toFileSizeString(double totalSize, double transferedSize, int resId) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(1);
        String sTotalSize = format.format(totalSize);
        String sTransSize = format.format(transferedSize);
        return this.getResources().getString(resId, new Object[]{sTransSize, sTotalSize});
    }

    private String toFileSizeString(double totalSize, int resId) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(1);
        String sTotalSize = format.format(totalSize);
        return this.getResources().getString(resId, new Object[]{sTotalSize});
    }

    private String toDownloadingSpeedString(long bitsPerSecond) {
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(1);
        if (bitsPerSecond > 0x100000L) {
            String speed = format.format((double)bitsPerSecond / 1048576.0);
            return this.getResources().getString(R.string.zm_ft_speed_mb, new Object[]{speed});
        }
        if (bitsPerSecond > 1024L) {
            String speed = format.format((double)bitsPerSecond / 1024.0);
            return this.getResources().getString(R.string.zm_ft_speed_kb, new Object[]{speed});
        }
        String speed = format.format((double)bitsPerSecond);
        return this.getResources().getString(R.string.zm_ft_speed_bytes, new Object[]{speed});
    }

    private String errorCodeToMessage(int error) {
        switch (error) {
            case 20: {
                return this.getResources().getString(R.string.zm_ft_error_invalid_file);
            }
            case 21: {
                return this.getResources().getString(R.string.zm_ft_error_file_too_big);
            }
            case 22: {
                return this.getResources().getString(R.string.zm_ft_error_no_disk_space);
            }
            case 23: {
                return this.getResources().getString(R.string.zm_ft_error_disk_io_error);
            }
            case 24: {
                return this.getResources().getString(R.string.zm_ft_error_url_timeout);
            }
            case 25: {
                return this.getResources().getString(R.string.zm_ft_error_network_disconnected);
            }
        }
        return this.getResources().getString(R.string.zm_ft_error_unknown);
    }

    private void updateChatMsgBackground() {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk < 16) {
            this.mPanelMessage.setBackgroundDrawable(this.getMesageBackgroudDrawable());
        } else {
            this.mPanelMessage.setBackground(this.getMesageBackgroudDrawable());
        }
    }

    public void setMessageItem(MMMessageItem item) {
        this.mMessageItem = item;
        if (this.mAvatarView != null) {
            this.mAvatarView.setName(item.fromScreenName);
            this.mAvatarView.setBgColorSeedString(item.fromJid);
        }
        this.setFileInfo(item.fileInfo, item.localFilePath, item.transferInfo);
        this.updateChatMsgBackground();
        LinearLayout content = (LinearLayout)this.findViewById(R.id.panelMsgLayout);
        if (item.onlyMessageShow) {
            this.mAvatarView.setVisibility(4);
            if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(8);
            }
            content.setPadding(content.getPaddingLeft(), 0, content.getPaddingRight(), content.getPaddingBottom());
        } else {
            content.setPadding(content.getPaddingLeft(), content.getPaddingBottom(), content.getPaddingRight(), content.getPaddingBottom());
            this.mAvatarView.setVisibility(0);
            if (this.mTxtScreenName != null && item.isIncomingMessage() && item.isGroupMessage) {
                this.setScreenName(item.fromScreenName);
                if (this.mTxtScreenName != null) {
                    this.mTxtScreenName.setVisibility(0);
                }
            } else if (this.mTxtScreenName != null) {
                this.mTxtScreenName.setVisibility(8);
            }
            if (!this.isInEditMode()) {
                String fromJid = item.fromJid;
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger != null) {
                    File file;
                    String phoneNumber = null;
                    ZoomBuddy buddy = null;
                    ZoomBuddy myself = messenger.getMyself();
                    if (myself != null && fromJid != null && fromJid.equals(myself.getJid())) {
                        buddy = myself;
                    } else {
                        buddy = messenger.getBuddyWithJID(fromJid);
                        if (buddy != null) {
                            phoneNumber = buddy.getPhoneNumber();
                        }
                    }
                    String avatarPath = null;
                    if (buddy != null) {
                        avatarPath = buddy.getLocalPicturePath();
                    }
                    boolean hasAvatarFile = false;
                    if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                        this.setAvatar(avatarPath);
                        hasAvatarFile = true;
                    }
                    if (!hasAvatarFile) {
                        if (item.fromContact == null && phoneNumber != null && buddy != null) {
                            item.fromContact = IMAddrBookItem.fromZoomBuddy(buddy);
                        }
                        if (item.fromContact != null) {
                            this.setAvatar(item.fromContact.getAvatarBitmap(this.getContext()));
                        } else {
                            this.setAvatar((String)null);
                        }
                    }
                }
            }
        }
    }
}

