/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.view.mm.MMChatMessageBgDrawable;
import com.zipow.videobox.view.mm.MMMessageFileView;
import com.zipow.videobox.view.mm.MMMessageItem;
import us.zoom.videomeetings.R;

public class MMMessageFileToView
extends MMMessageFileView {
    public MMMessageFileToView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public MMMessageFileToView(Context context) {
        super(context);
    }

    @Override
    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_message_file_to, (ViewGroup)this);
    }

    @Override
    public void setMessageItem(MMMessageItem item) {
        int res = item.transferInfo != null && MMMessageFileToView.isUploadState(item.transferInfo.state) ? R.drawable.zm_uploading_percent : R.drawable.zm_downloading_percent_ondark;
        Drawable draw = this.getResources().getDrawable(res);
        draw.setBounds(this.mDownloadPercent.getProgressDrawable().getBounds());
        this.mDownloadPercent.setProgressDrawable(draw);
        this.mDownloadPercent.setProgress(0);
        super.setMessageItem(item);
        this.setSending(item.messageState == 1);
        boolean sendFileFailed = false;
        ZoomMessage.FileTransferInfo transInfo = item.transferInfo;
        if (transInfo != null) {
            sendFileFailed = transInfo.state == 2 || transInfo.state == 18;
        }
        this.setFailed(sendFileFailed || item.messageState == 4 || item.messageState == 5);
    }

    private static boolean isUploadState(int transState) {
        switch (transState) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public void setSending(boolean sending) {
        if (this.mProgressBar != null) {
            this.mProgressBar.setVisibility(sending ? 0 : 8);
        }
    }

    public void setFailed(boolean isFailed) {
        this.setStatusImage(isFailed, R.drawable.zm_mm_msg_state_fail);
        if (isFailed) {
            this.setSending(false);
        }
    }

    @Override
    protected Drawable getMesageBackgroudDrawable() {
        return new MMChatMessageBgDrawable(this.getContext(), 0, this.mMessageItem.onlyMessageShow, false, 0, 0, 0, 0);
    }
}

