/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.gson.Gson;
import com.zipow.videobox.fragment.ZMCodeViewFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.CodeSnipptUtils;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.MMMessageItem;
import com.zipow.videobox.view.mm.ProportyBean;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.FileUtils;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMMessageCodeSnippetFromView
extends AbsMessageView {
    private static final String TAG = MMMessageCodeSnippetFromView.class.getSimpleName();
    protected AvatarView mAvatarView;
    protected TextView mAvatarName;
    protected TextView mTitile;
    protected TextView mTitleType;
    protected LinearLayout mTitleLinear;
    protected LinearLayout mItemOne;
    protected TextView mItemOneTxt;
    protected LinearLayout mItemTwo;
    protected TextView mItemTwoTxt;
    protected LinearLayout mItemThree;
    protected TextView mItemThreeTxt;
    protected LinearLayout mItemFour;
    protected TextView mItemFourTxt;
    protected LinearLayout mItemFive;
    protected TextView mItemFiveTxt;
    protected TextView mItemMore;
    protected LinearLayout codeSnippetList;
    protected LinearLayout holderProgress;
    protected LinearLayout holderFailed;
    protected MMMessageItem mMessageItem;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void onConfirmFileDownloaded(String sessionId, String messageId, int result) {
            super.onConfirmFileDownloaded(sessionId, messageId, result);
            if (MMMessageCodeSnippetFromView.this.mMessageItem != null && MMMessageCodeSnippetFromView.this.mMessageItem.messageXMPPId.equals(messageId)) {
                if (result == 0) {
                    MMMessageCodeSnippetFromView.this.setMessageItem(MMMessageCodeSnippetFromView.this.mMessageItem);
                } else {
                    MMMessageCodeSnippetFromView.this.setHolderFailed();
                }
            }
        }

        @Override
        public void confirm_EditedFileDownloadedIml(int result, Map<String, String> map) {
            super.confirm_EditedFileDownloadedIml(result, map);
            if (MMMessageCodeSnippetFromView.this.mMessageItem != null && map.containsKey(MMMessageCodeSnippetFromView.this.mMessageItem.sessionId) && map.get(MMMessageCodeSnippetFromView.this.mMessageItem.sessionId).equalsIgnoreCase(MMMessageCodeSnippetFromView.this.mMessageItem.messageXMPPId)) {
                if (result == 0) {
                    MMMessageCodeSnippetFromView.this.setMessageItem(MMMessageCodeSnippetFromView.this.mMessageItem);
                } else {
                    MMMessageCodeSnippetFromView.this.setHolderFailed();
                }
            }
        }

        @Override
        public void Indicate_FileDownloaded(String reqID, String webFileID, int result) {
            super.Indicate_FileDownloaded(reqID, webFileID, result);
        }

        @Override
        public void FT_OnDownloadByFileIDTimeOut(String reqID, String webFileID) {
            super.FT_OnDownloadByFileIDTimeOut(reqID, webFileID);
        }

        @Override
        public void FT_OnDownloadByMsgIDTimeOut(String sessionID, String messageID) {
            super.FT_OnDownloadByMsgIDTimeOut(sessionID, messageID);
            if (MMMessageCodeSnippetFromView.this.mMessageItem != null && MMMessageCodeSnippetFromView.this.mMessageItem.messageXMPPId.equals(messageID)) {
                MMMessageCodeSnippetFromView.this.setHolderFailed();
            }
        }
    };

    public MMMessageCodeSnippetFromView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public MMMessageCodeSnippetFromView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMMessageCodeSnippetFromView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)this.getLayoutId(), (ViewGroup)this);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.code_snippet_avatar);
        this.mAvatarName = (TextView)this.findViewById(R.id.code_snippet_name);
        this.mTitleLinear = (LinearLayout)this.findViewById(R.id.code_snippet_title_linear);
        this.mTitile = (TextView)this.findViewById(R.id.code_snippet_title);
        this.mTitleType = (TextView)this.findViewById(R.id.code_snippet_title_type);
        this.mItemOne = (LinearLayout)this.findViewById(R.id.code_snippet_item_one);
        this.mItemOneTxt = (TextView)this.findViewById(R.id.code_snippet_item_one_txt);
        this.mItemTwo = (LinearLayout)this.findViewById(R.id.code_snippet_item_two);
        this.mItemTwoTxt = (TextView)this.findViewById(R.id.code_snippet_item_two_txt);
        this.mItemThree = (LinearLayout)this.findViewById(R.id.code_snippet_item_three);
        this.mItemThreeTxt = (TextView)this.findViewById(R.id.code_snippet_item_three_txt);
        this.mItemFour = (LinearLayout)this.findViewById(R.id.code_snippet_item_four);
        this.mItemFourTxt = (TextView)this.findViewById(R.id.code_snippet_item_four_txt);
        this.mItemFive = (LinearLayout)this.findViewById(R.id.code_snippet_item_five);
        this.mItemFiveTxt = (TextView)this.findViewById(R.id.code_snippet_item_five_txt);
        this.mItemMore = (TextView)this.findViewById(R.id.code_snippet_item_more);
        this.codeSnippetList = (LinearLayout)this.findViewById(R.id.code_snippet_list);
        this.holderProgress = (LinearLayout)this.findViewById(R.id.code_snippet_holder_progress);
        this.holderFailed = (LinearLayout)this.findViewById(R.id.code_snippet_holder_failed);
    }

    protected int getLayoutId() {
        return R.layout.zm_mm_message_code_snippet_msg_from;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
    }

    public void setMessageName(String name) {
        if (this.mAvatarName != null) {
            this.mAvatarName.setText((CharSequence)name);
        }
    }

    public void setScreenName(String screenName) {
        if (screenName != null && this.mAvatarName != null) {
            this.mAvatarName.setText((CharSequence)screenName);
        }
    }

    public void setAvatar(Bitmap bitmap) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(bitmap);
        }
    }

    public void setAvatar(String avatar) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(avatar);
        }
    }

    public void setTitle(String fileName) {
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            String[] tmp = fileName.split("\\.");
            if (tmp != null && tmp.length > 0) {
                fileName = tmp[0];
            }
        } else {
            fileName = "";
        }
        this.mTitile.setText((CharSequence)fileName);
    }

    public void setHolderVisible(int visible) {
        this.holderFailed.setVisibility(8);
        if (visible == 0) {
            this.codeSnippetList.setVisibility(8);
            this.holderProgress.setVisibility(0);
        } else {
            this.codeSnippetList.setVisibility(0);
            this.holderProgress.setVisibility(8);
        }
    }

    public void setHolderFailed() {
        this.holderFailed.setVisibility(0);
        this.codeSnippetList.setVisibility(8);
        this.holderProgress.setVisibility(8);
    }

    public void setCodeSnippet(ZoomMessage message) {
        if (message == null || TextUtils.isEmpty((CharSequence)message.getLocalFilePath())) {
            return;
        }
        CodeSnipptUtils.CodeSnippetInfo info = CodeSnipptUtils.parseZipSnippet(message, "html", 5);
        if (info != null) {
            int count = info.getLineNo();
            List<CharSequence> list = info.getContents();
            if (count < 1) {
                this.mItemMore.setVisibility(8);
                this.mItemFive.setVisibility(8);
                this.mItemFour.setVisibility(8);
                this.mItemThree.setVisibility(8);
                this.mItemTwo.setVisibility(8);
                this.mItemOne.setVisibility(0);
                this.mItemOneTxt.setText((CharSequence)"");
            } else if (count == 1) {
                this.mItemMore.setVisibility(8);
                this.mItemFive.setVisibility(8);
                this.mItemFour.setVisibility(8);
                this.mItemThree.setVisibility(8);
                this.mItemTwo.setVisibility(8);
                this.mItemOne.setVisibility(0);
                if (list != null && list.size() > 0) {
                    this.mItemOneTxt.setText(list.get(0));
                }
            } else if (count == 2) {
                this.mItemMore.setVisibility(8);
                this.mItemFive.setVisibility(8);
                this.mItemFour.setVisibility(8);
                this.mItemThree.setVisibility(8);
                this.mItemTwo.setVisibility(0);
                this.mItemOne.setVisibility(0);
                if (list != null && list.size() > 1) {
                    this.mItemOneTxt.setText(list.get(0));
                    this.mItemTwoTxt.setText(list.get(1));
                }
            } else if (count == 3) {
                this.mItemMore.setVisibility(8);
                this.mItemFive.setVisibility(8);
                this.mItemFour.setVisibility(8);
                this.mItemThree.setVisibility(0);
                this.mItemTwo.setVisibility(0);
                this.mItemOne.setVisibility(0);
                if (list != null && list.size() > 2) {
                    this.mItemOneTxt.setText(list.get(0));
                    this.mItemTwoTxt.setText(list.get(1));
                    this.mItemThreeTxt.setText(list.get(2));
                }
            } else if (count == 4) {
                this.mItemMore.setVisibility(8);
                this.mItemFive.setVisibility(8);
                this.mItemFour.setVisibility(0);
                this.mItemThree.setVisibility(0);
                this.mItemTwo.setVisibility(0);
                this.mItemOne.setVisibility(0);
                if (list != null && list.size() > 3) {
                    this.mItemOneTxt.setText(list.get(0));
                    this.mItemTwoTxt.setText(list.get(1));
                    this.mItemThreeTxt.setText(list.get(2));
                    this.mItemFourTxt.setText(list.get(3));
                }
            } else if (count == 5) {
                this.mItemMore.setVisibility(8);
                this.mItemFive.setVisibility(0);
                this.mItemFour.setVisibility(0);
                this.mItemThree.setVisibility(0);
                this.mItemTwo.setVisibility(0);
                this.mItemOne.setVisibility(0);
                if (list != null && list.size() > 4) {
                    this.mItemOneTxt.setText(list.get(0));
                    this.mItemTwoTxt.setText(list.get(1));
                    this.mItemThreeTxt.setText(list.get(2));
                    this.mItemFourTxt.setText(list.get(3));
                    this.mItemFiveTxt.setText(list.get(4));
                }
            } else {
                this.mItemMore.setVisibility(0);
                this.mItemFive.setVisibility(0);
                this.mItemFour.setVisibility(0);
                this.mItemThree.setVisibility(0);
                this.mItemTwo.setVisibility(0);
                this.mItemOne.setVisibility(0);
                if (list != null && list.size() >= 5) {
                    this.mItemOneTxt.setText(list.get(0));
                    this.mItemTwoTxt.setText(list.get(1));
                    this.mItemThreeTxt.setText(list.get(2));
                    this.mItemFourTxt.setText(list.get(3));
                    this.mItemFiveTxt.setText(list.get(4));
                    this.mItemMore.setText((CharSequence)this.getContext().getString(R.string.zm_mm_code_snippet_more_31945, new Object[]{count - 5}));
                }
            }
        }
    }

    public void setMessageItem(final MMMessageItem item) {
        this.mMessageItem = item;
        this.setMessageName(String.valueOf(item.message));
        if (this.mAvatarView != null) {
            this.mAvatarView.setName(item.fromScreenName);
            this.mAvatarView.setBgColorSeedString(item.fromJid);
            this.mAvatarView.setVisibility(0);
        }
        if (this.mAvatarName != null) {
            this.mAvatarName.setVisibility(0);
        }
        this.setScreenName(item.fromScreenName);
        if (!this.isInEditMode()) {
            String fromJid = item.fromJid;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger != null) {
                File file;
                String phoneNumber = null;
                ZoomBuddy buddy = null;
                ZoomBuddy myself = messenger.getMyself();
                if (myself != null && fromJid != null && fromJid.equals(myself.getJid())) {
                    buddy = myself;
                } else {
                    buddy = messenger.getBuddyWithJID(fromJid);
                    if (buddy != null) {
                        phoneNumber = buddy.getPhoneNumber();
                    }
                }
                String avatarPath = null;
                if (buddy != null) {
                    avatarPath = buddy.getLocalPicturePath();
                }
                boolean hasAvatarFile = false;
                if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                    this.setAvatar(avatarPath);
                    hasAvatarFile = true;
                }
                if (!hasAvatarFile) {
                    if (item.fromContact == null && phoneNumber != null && buddy != null) {
                        item.fromContact = IMAddrBookItem.fromZoomBuddy(buddy);
                    }
                    if (item.fromContact != null) {
                        this.setAvatar(item.fromContact.getAvatarBitmap(this.getContext()));
                    } else {
                        this.setAvatar((String)null);
                    }
                }
            }
            if (item.fileInfo != null) {
                this.setTitle(item.fileInfo.name);
            }
            if (messenger == null) {
                this.setHolderFailed();
                return;
            }
            this.mTitleLinear.setVisibility(8);
            ZoomChatSession session = messenger.getSessionById(item.sessionId);
            if (session == null) {
                return;
            }
            ZoomMessage message = session.getMessageById(item.messageXMPPId);
            if (message == null) {
                return;
            }
            ZoomMessage.FileTransferInfo info = message.getFileTransferInfo();
            if (info == null) {
                return;
            }
            String filePath = message.getLocalFilePath();
            if (info.state != 13) {
                if (messenger.isConnectionGood()) {
                    this.setHolderVisible(0);
                    if (info.state == 0) {
                        if (TextUtils.isEmpty((CharSequence)filePath)) {
                            session.downloadFileForMessage(item.messageXMPPId);
                        } else {
                            File parent;
                            File tmp = new File(filePath);
                            if (tmp.exists()) {
                                tmp.delete();
                            }
                            if ((parent = tmp.getParentFile()) != null) {
                                parent = parent.getParentFile();
                            }
                            if (parent != null && item.fileInfo != null) {
                                try {
                                    File newPath = new File(parent, UUID.randomUUID().toString());
                                    newPath.mkdirs();
                                    File newFile = new File(newPath, item.fileInfo.name);
                                    session.downloadFileForMessage(item.messageXMPPId, newFile.getAbsolutePath());
                                }
                                catch (Exception e) {
                                    this.setHolderFailed();
                                }
                            } else {
                                this.setHolderFailed();
                            }
                        }
                    } else {
                        if (info.state == 10) {
                            return;
                        }
                        session.downloadFileForMessage(item.messageXMPPId);
                    }
                } else {
                    this.setHolderFailed();
                }
            } else {
                String property = FileUtils.readZipFile((String)filePath, (String)"properties");
                if (TextUtils.isEmpty((CharSequence)property)) {
                    this.setHolderFailed();
                } else {
                    this.mTitleLinear.setVisibility(0);
                    this.setHolderVisible(8);
                    try {
                        ProportyBean bean = (ProportyBean)new Gson().fromJson(property, ProportyBean.class);
                        if (bean != null) {
                            this.mTitleType.setText((CharSequence)this.getContext().getString(R.string.zm_mm_code_snippet_title_31945, new Object[]{bean.getType() == null ? "" : bean.getType()}));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.setCodeSnippet(message);
                }
            }
            this.codeSnippetList.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                    if (messenger == null) {
                        return;
                    }
                    ZoomChatSession session = messenger.getSessionById(item.sessionId);
                    if (session == null) {
                        return;
                    }
                    ZoomMessage message = session.getMessageById(item.messageXMPPId);
                    if (message == null) {
                        return;
                    }
                    String path = message.getLocalFilePath();
                    if (TextUtils.isEmpty((CharSequence)path)) {
                        return;
                    }
                    File zipFile = new File(path);
                    if (zipFile.exists() && zipFile.isFile() && MMMessageCodeSnippetFromView.this.getContext() instanceof ZMActivity && MMMessageCodeSnippetFromView.this.mMessageItem != null) {
                        ZMCodeViewFragment.showAsFragment((ZMActivity)MMMessageCodeSnippetFromView.this.getContext(), MMMessageCodeSnippetFromView.this.mMessageItem.sessionId, MMMessageCodeSnippetFromView.this.mMessageItem.messageId, zipFile, MMMessageCodeSnippetFromView.this.mTitile.getText().toString());
                    }
                }
            });
            this.codeSnippetList.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    AbsMessageView.OnShowContextMenuListener l = MMMessageCodeSnippetFromView.this.getOnShowContextMenuListener();
                    if (l != null) {
                        return l.onShowContextMenu(MMMessageCodeSnippetFromView.this.mMessageItem);
                    }
                    return false;
                }
            });
            this.holderFailed.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                    if (messenger == null) {
                        return;
                    }
                    ZoomChatSession session = messenger.getSessionById(item.sessionId);
                    if (session == null) {
                        return;
                    }
                    ZoomMessage message = session.getMessageById(item.messageXMPPId);
                    if (message == null) {
                        return;
                    }
                    ZoomMessage.FileTransferInfo info = message.getFileTransferInfo();
                    if (info == null) {
                        return;
                    }
                    if (info.state != 13 && messenger.isConnectionGood()) {
                        MMMessageCodeSnippetFromView.this.setHolderVisible(0);
                        session.downloadFileForMessage(item.messageXMPPId);
                    }
                }
            });
        }
    }
}

