/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ImageUtil;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.ZMGifView;
import java.io.File;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.TouchImageView;
import us.zoom.videomeetings.R;

public class MMImageViewPage
extends ZMFragment
implements View.OnClickListener {
    private static final String TAG = MMImageViewPage.class.getSimpleName();
    private static final int MAX_IMAGE_SIZE_IN_AREA = 1000000;
    private TouchImageView mImageView;
    private ZMGifView mGifview;
    private View mProgressBar;
    private View mViewPlaceHolder;
    private TextView mTxtMessage;
    private String mSessionId = null;
    private String mMessageId = null;
    private boolean mIsImageLoaded = false;
    private boolean mIsFullSizeImage = false;
    private String mFilePath;
    private Bitmap mBitmap = null;
    private Handler mHandler = new Handler();
    private ImageViewPageListener mImageViewPageListener;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mSessionId = savedInstanceState.getString("mSessionId");
            this.mMessageId = savedInstanceState.getString("mMessageId");
        }
        View view = inflater.inflate(R.layout.zm_mm_image_viewer_page, container, false);
        this.mImageView = (TouchImageView)view.findViewById(R.id.imageview);
        this.mProgressBar = view.findViewById(R.id.progressBar1);
        this.mViewPlaceHolder = view.findViewById(R.id.viewPlaceHolder);
        this.mTxtMessage = (TextView)view.findViewById(R.id.txtMessage);
        this.mGifview = (ZMGifView)view.findViewById(R.id.gifview);
        if (this.mIsFullSizeImage && "image/gif".equals(ImageUtil.getImageMimeType(this.mFilePath))) {
            this.mGifview.setGifResourse(this.mFilePath);
            this.mGifview.setVisibility(0);
            this.mImageView.setVisibility(8);
        } else {
            if (this.mBitmap != null) {
                this.mImageView.setImageBitmap(this.mBitmap);
            }
            this.mGifview.setVisibility(8);
            this.mImageView.setVisibility(0);
        }
        this.mViewPlaceHolder.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void setImageViewPageListener(ImageViewPageListener listener) {
        this.mImageViewPageListener = listener;
    }

    public boolean isFullSizeImage() {
        return this.mIsFullSizeImage;
    }

    public boolean isImageLoaded() {
        return this.mIsImageLoaded;
    }

    public String getMessageId() {
        return this.mMessageId;
    }

    private void setImage(Bitmap bm) {
        this.mBitmap = bm;
        if (this.mImageView != null) {
            this.mImageView.setImageBitmap(bm);
        }
    }

    private void clearImage() {
        this.mIsFullSizeImage = false;
        this.mIsImageLoaded = false;
        this.mFilePath = null;
        this.setImage(null);
    }

    public void onResume() {
        super.onResume();
        if (!this.isFullSizeImage() && this.mMessageId != null) {
            this.loadImage(this.mSessionId, this.mMessageId);
        } else {
            if (this.mProgressBar != null) {
                this.mProgressBar.setVisibility(8);
            }
            if (this.mViewPlaceHolder != null) {
                this.mViewPlaceHolder.setVisibility(8);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putString("mSessionId", this.mSessionId);
        outState.putString("mMessageId", this.mMessageId);
    }

    public void setImageMessage(String sessionId, String messageId) {
        if (!StringUtil.isSameString((String)this.mSessionId, (String)sessionId) || !StringUtil.isSameString((String)this.mMessageId, (String)messageId)) {
            this.mSessionId = sessionId;
            this.mMessageId = messageId;
            this.mIsFullSizeImage = false;
            this.mIsImageLoaded = false;
            this.mFilePath = null;
        }
    }

    public boolean loadImage(String sessionId, String messageId) {
        if (StringUtil.isSameString((String)sessionId, (String)this.mSessionId) && StringUtil.isSameString((String)messageId, (String)this.mMessageId) && this.isFullSizeImage()) {
            return true;
        }
        this.clearImage();
        if (this.mProgressBar != null) {
            this.mProgressBar.setVisibility(8);
        }
        if (this.mViewPlaceHolder != null) {
            this.mViewPlaceHolder.setVisibility(8);
        }
        if (sessionId == null || messageId == null) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            return false;
        }
        ZoomMessage message = session.getMessageById(messageId);
        if (message == null) {
            return false;
        }
        this.mSessionId = sessionId;
        this.mMessageId = messageId;
        String path = message.getLocalFilePath();
        ZoomMessage.FileTransferInfo transInfo = message.getFileTransferInfo();
        if (!StringUtil.isEmptyOrNull((String)path) && new File(path).exists() && transInfo != null && (transInfo.state == 13 || MMImageViewPage.isUploadState(transInfo.state))) {
            this.mFilePath = path;
            this.mIsFullSizeImage = true;
        } else {
            this.mFilePath = message.getPicturePreviewPath();
            if (!new File(this.mFilePath).exists()) {
                this.mFilePath = null;
            }
        }
        if (this.mFilePath != null) {
            Bitmap bmp;
            if ("image/gif".equals(ImageUtil.getImageMimeType(this.mFilePath))) {
                if (this.mGifview != null) {
                    this.mGifview.setVisibility(0);
                    this.mGifview.setGifResourse(this.mFilePath);
                }
                if (this.mImageView != null) {
                    this.mImageView.setVisibility(8);
                }
                this.mIsImageLoaded = true;
                return true;
            }
            if (this.mImageView != null) {
                this.mGifview.setVisibility(8);
                this.mImageView.setVisibility(0);
            }
            if ((bmp = ZMBitmapFactory.decodeFile(this.mFilePath, 1000000, false, false)) != null) {
                this.setImage(bmp);
                this.mIsImageLoaded = true;
                this.checkShowDownloadingStatus(transInfo);
                return true;
            }
            if (this.mViewPlaceHolder != null) {
                this.mViewPlaceHolder.setVisibility(0);
            }
            if (this.mTxtMessage != null) {
                this.mTxtMessage.setText(R.string.zm_mm_msg_load_image_failed);
            }
        } else if (this.mImageView != null) {
            this.mGifview.setVisibility(8);
            this.mImageView.setVisibility(0);
        }
        this.mIsFullSizeImage = false;
        ZoomBuddy myself = messenger.getMyself();
        if (myself != null && StringUtil.isSameString((String)message.getSenderID(), (String)myself.getJid()) && (message.getMessageState() == 1 || message.getMessageState() == 4)) {
            if (this.mViewPlaceHolder != null) {
                this.mViewPlaceHolder.setVisibility(0);
            }
            if (this.mTxtMessage != null) {
                this.mTxtMessage.setText(R.string.zm_mm_msg_load_image_failed);
            }
        }
        this.checkShowDownloadingStatus(transInfo);
        return false;
    }

    public void checkShowDownloadingStatus(ZoomMessage.FileTransferInfo transInfo) {
        if (transInfo != null && transInfo.state == 10) {
            this.showDownloadingStatus();
        }
    }

    public void onStartDownloadingImage() {
        this.showDownloadingStatus();
    }

    public void showDownloadingStatus() {
        if (this.mViewPlaceHolder != null) {
            this.mViewPlaceHolder.setVisibility(8);
        }
        if (this.mProgressBar != null) {
            this.mProgressBar.setVisibility(0);
        }
    }

    public void onDownloadImageFailed() {
        Runnable taskShowFailure = new Runnable(){

            @Override
            public void run() {
                if (MMImageViewPage.this.mViewPlaceHolder != null) {
                    MMImageViewPage.this.mViewPlaceHolder.setVisibility(0);
                }
                if (MMImageViewPage.this.mProgressBar != null) {
                    MMImageViewPage.this.mProgressBar.setVisibility(8);
                }
                if (MMImageViewPage.this.mTxtMessage != null) {
                    MMImageViewPage.this.mTxtMessage.setText(R.string.zm_mm_msg_download_image_failed);
                }
            }
        };
        if (this.isAdded()) {
            taskShowFailure.run();
        } else {
            this.mHandler.post(taskShowFailure);
        }
    }

    public String getImageFilePath() {
        return this.mFilePath;
    }

    private static boolean isUploadState(int transState) {
        switch (transState) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.viewPlaceHolder) {
            this.onClickViewPlaceHolder();
        }
    }

    private void onClickViewPlaceHolder() {
        if (this.mImageViewPageListener != null) {
            this.mImageViewPageListener.downloadImage(this.mSessionId, this.mMessageId);
        }
    }

    public static interface ImageViewPageListener {
        public void downloadImage(String var1, String var2);
    }
}

