/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ImageLoader;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.AbsMessageView;
import com.zipow.videobox.view.mm.MMGiphyView;
import com.zipow.videobox.view.mm.MMMessageItem;
import java.io.File;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMGiphyToView
extends MMGiphyView {
    private TextView mSendBtn;
    private TextView mShuffleBtn;
    private TextView mCancelBtn;
    private ImageView mImgStatus;

    public MMGiphyToView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public MMGiphyToView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMGiphyToView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.mSendBtn = (TextView)this.findViewById(R.id.giphy_send_btn);
        this.mShuffleBtn = (TextView)this.findViewById(R.id.giphy_shuffle_btn);
        this.mCancelBtn = (TextView)this.findViewById(R.id.giphy_cancel_btn);
        this.mImgStatus = (ImageView)this.findViewById(R.id.imgStatus);
        if (this.mImgStatus != null) {
            this.mImgStatus.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickStatusImageListener l = MMGiphyToView.this.getOnClickStatusImageListener();
                    if (l != null) {
                        l.onClickStatusImage(MMGiphyToView.this.mMessageItem);
                    }
                }
            });
        }
        if (this.mSendBtn != null) {
            this.mSendBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickGiphyBtnListener listener = MMGiphyToView.this.getmOnClickGiphyBtnListener();
                    if (listener != null) {
                        listener.onClickGiphyBtn(MMGiphyToView.this.mMessageItem, v);
                    }
                }
            });
        }
        if (this.mShuffleBtn != null) {
            this.mShuffleBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickGiphyBtnListener listener = MMGiphyToView.this.getmOnClickGiphyBtnListener();
                    if (listener != null) {
                        listener.onClickGiphyBtn(MMGiphyToView.this.mMessageItem, v);
                    }
                }
            });
        }
        if (this.mCancelBtn != null) {
            this.mCancelBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsMessageView.OnClickGiphyBtnListener listener = MMGiphyToView.this.getmOnClickGiphyBtnListener();
                    if (listener != null) {
                        listener.onClickGiphyBtn(MMGiphyToView.this.mMessageItem, v);
                    }
                }
            });
        }
    }

    @Override
    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_giphy_to, (ViewGroup)this);
    }

    public void setStatusImage(boolean visible, int resId) {
        if (this.mImgStatus != null) {
            this.mImgStatus.setVisibility(visible ? 0 : 8);
            this.mImgStatus.setImageResource(resId);
        }
    }

    public void setFailed(boolean isFailed) {
        this.setStatusImage(isFailed, R.drawable.zm_mm_msg_state_fail);
    }

    @Override
    public void setMessageItem(MMMessageItem item) {
        this.mMessageItem = item;
        this.setFailed(item.messageState == 4 || item.messageState == 5 || item.messageState == 6);
        this.mGifView.setVisibility(8);
        this.mProgress.setVisibility(0);
        if (this.mAvatarView != null) {
            this.mAvatarView.setName(item.fromScreenName);
            this.mAvatarView.setBgColorSeedString(item.fromJid);
            this.mAvatarView.setVisibility(0);
        }
        if (this.mAvatarName != null) {
            this.mAvatarName.setVisibility(0);
        }
        this.setScreenName(item.fromScreenName);
        if (!this.isInEditMode()) {
            String fromJid = item.fromJid;
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger != null) {
                PTAppProtos.GiphyMsgInfo info;
                File file;
                String phoneNumber = null;
                ZoomBuddy buddy = null;
                ZoomBuddy myself = messenger.getMyself();
                if (myself != null && fromJid != null && fromJid.equals(myself.getJid())) {
                    buddy = myself;
                } else {
                    buddy = messenger.getBuddyWithJID(fromJid);
                    if (buddy != null) {
                        phoneNumber = buddy.getPhoneNumber();
                    }
                }
                String avatarPath = null;
                if (buddy != null) {
                    avatarPath = buddy.getLocalPicturePath();
                }
                boolean hasAvatarFile = false;
                if (!StringUtil.isEmptyOrNull((String)avatarPath) && (file = new File(avatarPath)).exists() && file.isFile()) {
                    this.setAvatar(avatarPath);
                    hasAvatarFile = true;
                }
                if (!hasAvatarFile) {
                    if (item.fromContact == null && phoneNumber != null && buddy != null) {
                        item.fromContact = IMAddrBookItem.fromZoomBuddy(buddy);
                    }
                    if (item.fromContact != null) {
                        this.setAvatar(item.fromContact.getAvatarBitmap(this.getContext()));
                    } else {
                        this.setAvatar((String)null);
                    }
                }
                if ((info = messenger.getGiphyInfo(item.giphyID)) != null) {
                    int netWorkType = NetworkUtil.getDataNetworkType((Context)this.getContext());
                    if (netWorkType == 1 || netWorkType == 4 || netWorkType == 3) {
                        ImageLoader.getInstance().displayGif(this.mGifView, this.mProgress, info.getPcUrl());
                    } else {
                        File cacheFile = ImageLoader.getInstance().getCacheFile(info.getPcUrl());
                        if (cacheFile != null && cacheFile.exists()) {
                            ImageLoader.getInstance().displayGif(this.mGifView, this.mProgress, info.getPcUrl());
                        } else {
                            ImageLoader.getInstance().displayGif(this.mGifView, this.mProgress, info.getMobileUrl());
                        }
                    }
                }
            }
        }
    }
}

