/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckedTextView;
import android.widget.EditText;
import android.widget.ImageView;
import com.zipow.videobox.MMSelectContactsActivity;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.videomeetings.R;

public class MMCreateGroupFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private static final int REQUEST_INVITE_MEMEBERS = 1;
    public static final String RESULT_ARGS_GROUP_TYPE = "groupType";
    public static final String RESULT_ARGS_ACCESS_HISTORY = "accessHistory";
    public static final String RESULT_ARG_SELECTED_ITEMS = "selectedItems";
    public static final String RESULT_ARG_GROUP_NAME = "groupName";
    public static final String RESULT_ARGS_ONLY_ORGANIZAION = "mChkOnlyOrganization";
    private static final String ARGS_GROUP_TYPE = "groupType";
    private static final String ARGS_ACCESS_HISTORY = "accessHistory";
    private static final String ARGS_ONLY_ORGANIZAION = "mChkOnlyOrganization";
    private ImageView mImgPrivateGroupType;
    private ImageView mImgPublicGroupType;
    private boolean mIsPrivateGroup = true;
    private boolean mAccessHistory = false;
    private boolean mOnlyOrganization = false;
    private EditText mEdtGroupName;
    private Button mBtnNext;
    private CheckedTextView mChkAccessHistory;
    private CheckedTextView mChkOnlyOrganization;
    private View mOptionOnlyOrganization;

    public static void showAsActivity(ZMActivity activity, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(activity, MMCreateGroupFragment.class.getName(), args, requestCode, true, 1);
    }

    public static void showAsActivity(Fragment fragment, int requestCode) {
        Bundle args = new Bundle();
        SimpleActivity.show(fragment, MMCreateGroupFragment.class.getName(), args, requestCode, true, 1);
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_mm_create_new_group, container, false);
        this.mImgPrivateGroupType = (ImageView)view.findViewById(R.id.imgPrivateGroupType);
        this.mImgPublicGroupType = (ImageView)view.findViewById(R.id.imgPublicGroupType);
        this.mEdtGroupName = (EditText)view.findViewById(R.id.edtGroupName);
        this.mBtnNext = (Button)view.findViewById(R.id.btnNext);
        this.mChkAccessHistory = (CheckedTextView)view.findViewById(R.id.chkAccessHistory);
        this.mChkOnlyOrganization = (CheckedTextView)view.findViewById(R.id.chkOnlyOrganization);
        this.mOptionOnlyOrganization = view.findViewById(R.id.optionOnlyOrganization);
        view.findViewById(R.id.panelPrivateGroup).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.panelPublicGroup).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.btnCancel).setOnClickListener((View.OnClickListener)this);
        this.mOptionOnlyOrganization.setOnClickListener((View.OnClickListener)this);
        this.mChkAccessHistory.setOnClickListener((View.OnClickListener)this);
        this.mBtnNext.setOnClickListener((View.OnClickListener)this);
        this.mEdtGroupName.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                MMCreateGroupFragment.this.mBtnNext.setEnabled(s.length() > 0);
            }
        });
        if (savedInstanceState != null) {
            this.mIsPrivateGroup = savedInstanceState.getBoolean("groupType", true);
            this.mAccessHistory = savedInstanceState.getBoolean("accessHistory", false);
            this.mOnlyOrganization = savedInstanceState.getBoolean("mChkOnlyOrganization", false);
        }
        return view;
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putBoolean("groupType", this.mIsPrivateGroup);
        outState.putBoolean("accessHistory", this.mAccessHistory);
        outState.putBoolean("mChkOnlyOrganization", this.mOnlyOrganization);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 1: {
                if (resultCode != -1) {
                    return;
                }
                String groupName = this.mEdtGroupName.getText().toString();
                if (StringUtil.isEmptyOrNull((String)groupName) || groupName.trim().length() == 0) {
                    return;
                }
                data.putExtra("groupType", this.mIsPrivateGroup ? 12 : 14);
                data.putExtra("accessHistory", this.mAccessHistory);
                data.putExtra("mChkOnlyOrganization", this.mOnlyOrganization);
                data.putExtra(RESULT_ARG_GROUP_NAME, groupName);
                this.getActivity().setResult(-1, data);
                this.dismiss();
                break;
            }
        }
    }

    public void onResume() {
        super.onResume();
        this.updateGroupType();
        this.updateOption();
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnCancel) {
            this.dismiss();
        } else if (id2 == R.id.panelPrivateGroup) {
            this.onClickPanelPrivateGroup();
        } else if (id2 == R.id.panelPublicGroup) {
            this.onClickPanelPublicGroup();
        } else if (id2 == R.id.btnNext) {
            this.onClickBtnNext();
        } else if (id2 == R.id.chkAccessHistory) {
            this.onClickChkAccessHistory();
        } else if (id2 == R.id.optionOnlyOrganization) {
            this.onClickOnlyOrganization();
        }
    }

    private void onClickOnlyOrganization() {
        this.mOnlyOrganization = !this.mChkOnlyOrganization.isChecked();
        this.mChkOnlyOrganization.setChecked(!this.mChkOnlyOrganization.isChecked());
    }

    private void onClickChkAccessHistory() {
        this.mAccessHistory = !this.mChkAccessHistory.isChecked();
        this.mChkAccessHistory.setChecked(!this.mChkAccessHistory.isChecked());
    }

    private void onClickBtnNext() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (messenger.checkGroupNameIsExist(this.mEdtGroupName.getText().toString())) {
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setMessage(R.string.zm_mm_create_same_group_name_error_22375).setPositiveButton(R.string.zm_btn_ok, null);
            builder.show();
        } else {
            MMSelectContactsActivity.SelectContactsParamter paramter = new MMSelectContactsActivity.SelectContactsParamter();
            paramter.title = this.getString(R.string.zm_mm_title_invite_member);
            paramter.btnOkText = this.getString(R.string.zm_btn_create);
            paramter.isAnimBottomTop = true;
            paramter.isOnlySameOrganization = !this.mIsPrivateGroup || this.mOnlyOrganization;
            paramter.isContainsAllInGroup = false;
            paramter.includeRobot = false;
            paramter.minSelectCount = this.mIsPrivateGroup ? 2 : 0;
            paramter.maxSelectCount = PTApp.getInstance().getMaxChatGroupBuddyNumber();
            MMSelectContactsActivity.show((Fragment)this, paramter, 1, null);
        }
    }

    private void onClickPanelPrivateGroup() {
        this.mIsPrivateGroup = true;
        this.updateGroupType();
    }

    private void onClickPanelPublicGroup() {
        this.mIsPrivateGroup = false;
        this.updateGroupType();
    }

    private void updateGroupType() {
        if (this.mIsPrivateGroup) {
            this.mImgPrivateGroupType.setVisibility(0);
            this.mImgPublicGroupType.setVisibility(8);
            this.mOptionOnlyOrganization.setVisibility(0);
        } else {
            this.mImgPrivateGroupType.setVisibility(8);
            this.mImgPublicGroupType.setVisibility(0);
            this.mOptionOnlyOrganization.setVisibility(8);
        }
    }

    private void updateOption() {
        this.mChkAccessHistory.setChecked(this.mAccessHistory);
        this.mChkOnlyOrganization.setChecked(this.mOnlyOrganization);
    }

    public void dismiss() {
        this.finishFragment(true);
    }
}

