/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.view.mm.MMContentMessageItem;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;

public class MMContentSearchMessagesAdapter
extends BaseAdapter {
    private List<MMContentMessageItem> mMessageList = new ArrayList<MMContentMessageItem>();
    private Context mContext;
    private String myJid;
    private MemCache<String, Drawable> mAvatarCache;

    public MMContentSearchMessagesAdapter(Context context) {
        ZoomBuddy self;
        this.mContext = context;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && (self = messenger.getMyself()) != null) {
            this.myJid = self.getJid();
        }
    }

    public void addSearchedFiles(PTAppProtos.MessageContentSearchResponse response) {
        if (response == null || response.getSearchResponseCount() == 0) {
            return;
        }
        for (PTAppProtos.MessageSearchResult result : response.getSearchResponseList()) {
            MMContentMessageItem item = MMContentMessageItem.initWithFileFilterSearchResult(result, this.mContext);
            if (item == null) continue;
            this.mMessageList.add(item);
        }
    }

    public void setAvatarCache(MemCache<String, Drawable> avatarCache) {
        this.mAvatarCache = avatarCache;
    }

    public boolean isDataEmpty() {
        return this.mMessageList.isEmpty();
    }

    public void removeItem(String sessionId) {
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        for (int i = 0; i < this.mMessageList.size(); ++i) {
            MMContentMessageItem item = this.mMessageList.get(i);
            if (!StringUtil.isSameString((String)item.getSessionId(), (String)sessionId)) continue;
            this.mMessageList.remove(i);
            break;
        }
    }

    public void clearAll() {
        this.mMessageList.clear();
    }

    public int getCount() {
        return this.mMessageList.size();
    }

    public MMContentMessageItem getItem(int position) {
        if (position < 0 || position >= this.mMessageList.size()) {
            return null;
        }
        return this.mMessageList.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public boolean isEmpty() {
        return false;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.createFileItemView(position, convertView, parent);
    }

    private View createFileItemView(int position, View convertView, ViewGroup parent) {
        MMContentMessageItem item = this.getItem(position);
        return item.getView(this.mContext, position, convertView, parent, this.myJid, this.mAvatarCache);
    }
}

