/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.view.mm.MMContentSearchFilesListView;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.MMZoomFileView;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import us.zoom.androidlib.util.StringUtil;

public class MMContentSearchFilesAdapter
extends BaseAdapter
implements MMZoomFileView.OnShowAllShareActionListener {
    private List<DisplayItem> mContentFiles = new ArrayList<DisplayItem>();
    private Context mContext;
    private boolean mIsPersonalMode = false;
    private MMContentSearchFilesListView mParentListView;
    private Set<String> mShowAllSharesFileIds = new HashSet<String>();

    public MMContentSearchFilesAdapter(Context context, boolean isPersonalMode) {
        this.mContext = context;
        this.mIsPersonalMode = isPersonalMode;
    }

    public void addSearchedFiles(PTAppProtos.FileFilterSearchResults results) {
        if (results == null || results.getSearchResultCount() == 0) {
            return;
        }
        for (PTAppProtos.FileFilterSearchResult result : results.getSearchResultList()) {
            DisplayItem item = DisplayItem.initWithFileFilterSearchResult(result);
            if (item == null || item.file == null || item.file.getFileType() == 6) continue;
            String webId = item.file.getWebID();
            int idx = this.findFileByWebId(webId);
            if (idx == -1) {
                this.mContentFiles.add(item);
                continue;
            }
            this.mContentFiles.set(idx, item);
        }
    }

    public void Indicate_FileDeleted(String reqID, String webFileID, int result) {
        int idx = this.findFileByWebId(webFileID);
        if (idx != -1 && result == 0) {
            this.mContentFiles.remove(idx);
            this.notifyDataSetChanged();
        }
    }

    public void updateZoomFile(String fileId) {
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = mgr.getFileWithWebFileID(fileId);
        if (file == null) {
            return;
        }
        MMZoomFile mmFile = MMZoomFile.initWithZoomFile(file, mgr);
        if (mmFile == null) {
            return;
        }
        int idx = this.findFileByWebId(fileId);
        DisplayItem item = new DisplayItem(mmFile);
        if (idx != -1) {
            DisplayItem local = this.mContentFiles.get(idx);
            if (local != null) {
                List<MMZoomFile.FileMatchInfo> infos = local.file.getMatchInfos();
                mmFile.setMatchInfos(infos);
            }
            this.mContentFiles.set(idx, item);
            this.notifyDataSetChanged();
        }
    }

    public void onDownloadByFileIDOnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        int idx = this.findFileByWebId(webFileID);
        if (idx < 0) {
            return;
        }
        MMZoomFile file = this.mContentFiles.get((int)idx).file;
        file.setPending(true);
        file.setRatio(ratio);
        file.setReqId(reqId);
        file.setFileDownloading(true);
        file.setCompleteSize(completeSize);
        file.setBitPerSecond(bitPerSecond);
        this.notifyDataSetChanged();
    }

    public void Indicate_FileDownloaded(MMZoomFile file) {
        int idx = this.findFileByWebId(file.getWebID());
        if (idx != -1) {
            MMZoomFile local = this.mContentFiles.get((int)idx).file;
            local.setFileDownloaded(true);
            local.setPending(false);
            local.setFileDownloading(false);
        }
        this.notifyDataSetChanged();
    }

    public void Indicate_PreviewDownloaded(MMZoomFile file) {
        int idx = this.findFileByWebId(file.getWebID());
        if (idx != -1) {
            MMZoomFile local = this.mContentFiles.get((int)idx).file;
            local.setPicturePreviewPath(file.getPicturePreviewPath());
        }
        this.notifyDataSetChanged();
    }

    public boolean containsFile(String webId) {
        return this.findFileByWebId(webId) != -1;
    }

    private int findFileByWebId(String webId) {
        if (StringUtil.isEmptyOrNull((String)webId)) {
            return -1;
        }
        for (int i = 0; i < this.mContentFiles.size(); ++i) {
            MMZoomFile file = this.mContentFiles.get((int)i).file;
            if (!webId.equals(file.getWebID())) continue;
            return i;
        }
        return -1;
    }

    public void endFileTransfer(String webFileId) {
        int idx = this.findFileByWebId(webFileId);
        if (idx != -1) {
            MMZoomFile file = this.mContentFiles.get((int)idx).file;
            if (!file.isFileDownloading()) {
                this.mContentFiles.remove(idx);
            } else {
                file.setPending(false);
                file.setFileDownloading(false);
            }
            this.notifyDataSetChanged();
        }
    }

    public void Indicate_RenameFileResponse(int result, String reqId, String fileId, String newName) {
        if (result != 0) {
            return;
        }
        int idx = this.findFileByWebId(fileId);
        if (idx != -1) {
            MMZoomFile file = this.mContentFiles.get((int)idx).file;
            file.setFileName(newName);
            this.notifyDataSetChanged();
        }
    }

    public void Indicate_FileActionStatus(int actionType, String fileId, String actionOwner, String fileName, String sessionId, String msgId) {
        int idx = this.findFileByWebId(fileId);
        if (idx == -1) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = mgr.getFileWithWebFileID(fileId);
        if (file == null) {
            return;
        }
        MMZoomFile mmFile = MMZoomFile.initWithZoomFile(file, mgr);
        if (mmFile == null) {
            return;
        }
        if (actionType == 1 || actionType == 2 && (mmFile.getShareAction() == null || mmFile.getShareAction().size() == 0)) {
            this.mContentFiles.remove(idx);
        } else {
            this.mContentFiles.get((int)idx).file = mmFile;
        }
        this.notifyDataSetChanged();
    }

    public boolean isDataEmpty() {
        return this.mContentFiles.isEmpty();
    }

    public long getLastTimeStamp() {
        if (this.mContentFiles.isEmpty()) {
            return 0L;
        }
        if (this.mIsPersonalMode) {
            long time = this.mContentFiles.get((int)0).file.getTimeStamp();
            for (DisplayItem item : this.mContentFiles) {
                if (item.file.getTimeStamp() >= time) continue;
                time = item.file.getTimeStamp();
            }
            return time;
        }
        long time = this.mContentFiles.get((int)0).file.getEarliestShareTime();
        for (DisplayItem item : this.mContentFiles) {
            if (item.file.getEarliestShareTime() >= time) continue;
            time = item.file.getEarliestShareTime();
        }
        return time;
    }

    public void clearAll() {
        this.mContentFiles.clear();
        this.mShowAllSharesFileIds.clear();
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mContentFiles.size();
    }

    public DisplayItem getItem(int position) {
        return this.mContentFiles.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public boolean isEmpty() {
        return false;
    }

    public MMZoomFile getItemAtPosition(int position) {
        if (position < 0 || position >= this.mContentFiles.size()) {
            return null;
        }
        return this.mContentFiles.get((int)position).file;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        return this.createFileItemView(position, convertView, parent);
    }

    private View createFileItemView(int position, View convertView, ViewGroup parent) {
        MMZoomFileView view = null;
        DisplayItem item = this.getItem(position);
        if (item == null || item.file == null) {
            return null;
        }
        if (convertView instanceof MMZoomFileView) {
            view = (MMZoomFileView)convertView;
        } else {
            view = new MMZoomFileView(this.mContext);
            view.setOnClickOperatorListener(this.mParentListView);
            view.setOnMoreShareActionListener(this);
        }
        item.file.setShowAllShareActions(this.mShowAllSharesFileIds.contains(item.file.getWebID()));
        view.setMMZoomFile(item.file, false);
        return view;
    }

    public void setParentListView(MMContentSearchFilesListView listview) {
        this.mParentListView = listview;
    }

    @Override
    public void onShowAllShareAction(String fileId) {
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        this.mShowAllSharesFileIds.add(fileId);
        this.notifyDataSetChanged();
    }

    static class DisplayItem {
        String mLabel;
        MMZoomFile file;

        DisplayItem(MMZoomFile file) {
            this.file = file;
        }

        DisplayItem() {
        }

        static DisplayItem initWithFileFilterSearchResult(PTAppProtos.FileFilterSearchResult result) {
            if (result == null || StringUtil.isEmptyOrNull((String)result.getFileId())) {
                return null;
            }
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            if (mgr == null) {
                return null;
            }
            ZoomFile file = mgr.getFileWithWebFileID(result.getFileId());
            if (file == null) {
                return null;
            }
            DisplayItem displayItem = new DisplayItem();
            ArrayList<MMZoomFile.FileMatchInfo> matchInfos = new ArrayList<MMZoomFile.FileMatchInfo>();
            displayItem.file = MMZoomFile.initWithZoomFile(file, mgr);
            for (PTAppProtos.FileMatchInfo matchInfo : result.getMatchInfosList()) {
                MMZoomFile.FileMatchInfo info = new MMZoomFile.FileMatchInfo();
                info.mContent = matchInfo.getContent();
                info.mType = matchInfo.getType();
                for (PTAppProtos.HighlightPositionItem pItem : matchInfo.getMatchInfosList()) {
                    MMZoomFile.HighlightPosition position = new MMZoomFile.HighlightPosition();
                    position.end = pItem.getEnd();
                    position.start = pItem.getStart();
                    info.mHighlightPositions.add(position);
                }
                matchInfos.add(info);
            }
            displayItem.file.setMatchInfos(matchInfos);
            return displayItem;
        }
    }
}

