/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import com.zipow.cmmlib.CmmTime;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ZmPtUtils;
import com.zipow.videobox.view.mm.MMContentImagesAdapter;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.OnContentFileOperatorListener;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.PullDownRefreshListView;

public class MMContentImagesListview
extends PullDownRefreshListView
implements AbsListView.OnScrollListener,
PullDownRefreshListView.PullDownRefreshListener {
    private MMContentImagesAdapter mAdapter;
    private static final int MAX_COUNT_PER_PAGE = 20;
    private boolean mIsOwnerMode = false;
    private String mReqId;
    private String mSessionId;
    private OnContentFileOperatorListener mListener;

    public MMContentImagesListview(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public MMContentImagesListview(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMContentImagesListview(Context context) {
        super(context);
        this.init();
    }

    public void setSessionId(String sessionId) {
        this.mSessionId = sessionId;
    }

    public Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable("superState", super.onSaveInstanceState());
        bundle.putString("reqId", this.mReqId);
        return bundle;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state != null && state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            this.mReqId = bundle.getString("reqId");
            Parcelable superState = bundle.getParcelable("superState");
            super.onRestoreInstanceState(superState);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public void Indicate_QueryMyFilesResponse(String reqId, int result, List<String> arrWebFileID, long queryEndTime) {
        if (StringUtil.isSameString((String)this.mReqId, (String)reqId)) {
            this.updateImages(arrWebFileID, false);
            this.showRefreshing(false);
        }
    }

    public void Indicate_FileDeletedByOthers(String fileID) {
        this.mAdapter.Indicate_FileDeletedByOthers(fileID);
    }

    public void setOnContentFileOperatorListener(OnContentFileOperatorListener listener) {
        this.mListener = listener;
    }

    public void onZoomFileClicked(MMZoomFile file) {
        if (this.mListener != null && file != null) {
            this.mListener.onZoomFileClick(file.getWebID());
        }
    }

    public void notifyDataSetChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void Indicate_QueryFilesSharedWithMeResponse(String reqId, int result, List<String> arrWebFiles, long queryEndTime) {
        if (StringUtil.isSameString((String)this.mReqId, (String)reqId)) {
            this.updateImages(arrWebFiles, false);
            this.showRefreshing(false);
        }
    }

    public void Indicate_QueryAllFilesResponse(String reqId, int result, List<String> arrWebFiles, long queryEndTime) {
    }

    public void Indicate_QuerySessionFilesResponse(String reqId, String session, int result, List<String> arrWebFileID, long queryEndTime) {
        if (StringUtil.isSameString((String)this.mReqId, (String)reqId)) {
            this.updateImages(arrWebFileID, false);
            this.showRefreshing(false);
        }
    }

    private void init() {
        this.mAdapter = new MMContentImagesAdapter(this.getContext(), this.mIsOwnerMode);
        this.setAdapter((ListAdapter)this.mAdapter);
        this.mAdapter.setParentListView(this);
        this.setOnScrollListener(this);
        this.setPullDownRefreshListener(this);
    }

    public void setMode(boolean isOwnerMode) {
        this.mIsOwnerMode = isOwnerMode;
    }

    public void loadData(boolean isForceLoad) {
        this.loadImages(isForceLoad, false);
    }

    public void Indicate_FileDeleted(String reqID, String webFileID, int result) {
        this.mAdapter.Indicate_FileDeleted(reqID, webFileID, result);
    }

    public void onDownloadByFileIDOnProgress(String reqId, String webFileID, int ratio, int completeSize, int bitPerSecond) {
        this.mAdapter.onDownloadByFileIDOnProgress(reqId, webFileID, ratio, completeSize, bitPerSecond);
        this.mAdapter.notifyDataSetChanged();
    }

    private void loadImages(boolean isForceLoad, boolean doRefresh) {
        MMFileContentMgr mgr;
        boolean isFirstLoad;
        long timeStamp = this.mAdapter.getLastTimeStamp();
        if (timeStamp != 0L && !isForceLoad) {
            return;
        }
        boolean bl = isFirstLoad = timeStamp == 0L;
        if (doRefresh || timeStamp == 0L) {
            timeStamp = CmmTime.getMMNow();
        }
        if ((mgr = PTApp.getInstance().getZoomFileContentMgr()) == null) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return;
        }
        String jid = myself.getJid();
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return;
        }
        PTAppProtos.FileQueryResult res = null;
        res = StringUtil.isEmptyOrNull((String)this.mSessionId) ? (this.mIsOwnerMode ? mgr.queryOwnedImageFiles(jid, timeStamp, 20) : mgr.queryImagesSharedWithMe(jid, timeStamp, 20)) : mgr.queryImagesForSession(this.mSessionId, timeStamp, 20);
        if (res == null) {
            return;
        }
        this.mReqId = res.getReqid();
        List<String> fileIds = res.getFileIdsList();
        if (res.getWebSearchTriggered() && isFirstLoad && fileIds.size() == 0) {
            this.showRefreshing(true);
        } else {
            this.showRefreshing(false);
        }
        this.updateImages(fileIds, isFirstLoad || doRefresh);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.mAdapter.onConfigurationChanged(newConfig);
    }

    public void Indicate_PreviewDownloaded(String reqId, String webFileID, int result) {
        if (this.mAdapter.containsFile(webFileID) && result == 0) {
            MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
            if (mgr == null) {
                return;
            }
            ZoomFile file = mgr.getFileWithWebFileID(webFileID);
            if (file == null) {
                return;
            }
            this.mAdapter.Indicate_PreviewDownloaded(MMZoomFile.initWithZoomFile(file, mgr));
        }
    }

    private void updateImages(List<String> fileIds, boolean isFirstLoad) {
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ArrayList<MMZoomFile> files = new ArrayList<MMZoomFile>();
        if (fileIds != null && fileIds.size() > 0) {
            for (String fileId : fileIds) {
                int fileType;
                MMZoomFile mmFile;
                ZoomFile file = mgr.getFileWithWebFileID(fileId);
                if (file == null || (mmFile = MMZoomFile.initWithZoomFile(file, mgr)) == null || !ZmPtUtils.isImageFile(fileType = mmFile.getFileType())) continue;
                if (fileType != 5 && StringUtil.isEmptyOrNull((String)mmFile.getPicturePreviewPath())) {
                    mgr.downloadImgPreview(mmFile.getWebID());
                }
                files.add(mmFile);
            }
        }
        if (isFirstLoad) {
            this.mAdapter.clearAll();
        }
        this.mAdapter.addContentImages(files);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
        if (firstVisibleItem > 0 && visibleItemCount + firstVisibleItem == totalItemCount && StringUtil.isEmptyOrNull((String)this.mReqId)) {
            this.loadImages(false, false);
        }
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
    }

    public void onPullDownRefresh() {
        this.loadImages(true, true);
    }
}

