/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.mm.MMFileContentMgr;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomFile;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.mm.MMContentFilesListView;
import com.zipow.videobox.view.mm.MMMessageRemoveHistory;
import com.zipow.videobox.view.mm.MMZoomFile;
import com.zipow.videobox.view.mm.MMZoomFileView;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.TimeUtil;
import us.zoom.androidlib.widget.PinnedSectionListView;
import us.zoom.videomeetings.R;

public class MMContentFilesAdapter
extends BaseAdapter
implements MMZoomFileView.OnShowAllShareActionListener,
PinnedSectionListView.PinnedSectionListAdapter {
    private static final String TAG_ITEM_LABEL = "TAG_ITEM_LABEL";
    private static final int ITEM_TYPE_LABEL = 0;
    private static final int ITEM_TYPE_FILES = 1;
    private static final int ITEM_TYPE_TIME_CHAT = 2;
    private List<MMZoomFile> mContentFiles = new ArrayList<MMZoomFile>();
    private List<DisplayItem> mDisplayItems = new ArrayList<DisplayItem>();
    private Context mContext;
    private MMContentFilesListView mParentListView;
    private boolean mIsPersonalMode = false;
    private boolean mIsDataInited = false;
    private Set<String> mShowAllSharesFileIds = new HashSet<String>();
    private boolean mIsGroupOwner = false;
    private String mSessionId;
    private boolean isTimeChat = false;
    private long eraseTime = -1L;

    public MMContentFilesAdapter(Context context) {
        this.mContext = context;
    }

    public void setMode(boolean isPersonalMode) {
        this.mIsPersonalMode = isPersonalMode;
    }

    public void setSessionId(String sessionId) {
        this.mSessionId = sessionId;
    }

    public MMZoomFile getItemAtPosition(int position) {
        if (position < 0 || position >= this.getCount()) {
            return null;
        }
        DisplayItem item = this.getItem(position);
        return item.file;
    }

    public void addContenFiles(List<MMZoomFile> files) {
        if (files == null || files.size() == 0) {
            return;
        }
        for (MMZoomFile file : files) {
            this.updateOrAddContentFile(file);
        }
    }

    public void updateContentFile(String webFileID) {
        if (StringUtil.isEmptyOrNull((String)webFileID)) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = mgr.getFileWithWebFileID(webFileID);
        if (file == null) {
            return;
        }
        MMZoomFile mmFile = MMZoomFile.initWithZoomFile(file, mgr);
        if (mmFile == null) {
            return;
        }
        if (file.isDeletePending()) {
            return;
        }
        int idx = this.findFileIndexByWebId(webFileID);
        if (idx != -1) {
            this.mContentFiles.set(idx, mmFile);
        }
    }

    public void updateOrAddContentFile(String webFileID) {
        if (StringUtil.isEmptyOrNull((String)webFileID)) {
            return;
        }
        MMFileContentMgr mgr = PTApp.getInstance().getZoomFileContentMgr();
        if (mgr == null) {
            return;
        }
        ZoomFile file = mgr.getFileWithWebFileID(webFileID);
        if (file == null || file.isDeletePending()) {
            this.deleteContentFile(webFileID);
            return;
        }
        MMZoomFile mmFile = MMZoomFile.initWithZoomFile(file, mgr);
        if (mmFile == null) {
            return;
        }
        this.updateOrAddContentFile(mmFile);
    }

    public void insertTimedChat() {
        this.isTimeChat = true;
        this.notifyDataSetChanged();
    }

    public void updateOrAddContentFile(MMZoomFile file) {
        if (!this.mIsDataInited) {
            return;
        }
        if (file == null || file.isDeletePending() || TextUtils.isEmpty((CharSequence)file.getOwnerJid()) || TextUtils.isEmpty((CharSequence)file.getOwnerName()) || "null".equalsIgnoreCase(file.getOwnerName()) || 6 == file.getFileType()) {
            if (file != null) {
                this.deleteContentFile(file.getWebID());
            }
            return;
        }
        int idx = this.findFileIndexByWebId(file.getWebID());
        if (idx != -1) {
            this.mContentFiles.set(idx, file);
        } else {
            this.mContentFiles.add(file);
        }
    }

    public void setIsGroupOwner(boolean isGroupOwner) {
        this.mIsGroupOwner = isGroupOwner;
    }

    public void setDataInited(boolean isInited) {
        this.mIsDataInited = isInited;
    }

    public MMZoomFile deleteContentFile(String webFileID) {
        int idx = this.findFileIndexByWebId(webFileID);
        if (idx != -1) {
            MMZoomFile file = this.mContentFiles.remove(idx);
            this.notifyDataSetChanged();
            return file;
        }
        return null;
    }

    public MMZoomFile findFileByWebId(String webId) {
        if (StringUtil.isEmptyOrNull((String)webId)) {
            return null;
        }
        for (int i = 0; i < this.mContentFiles.size(); ++i) {
            MMZoomFile file = this.mContentFiles.get(i);
            if (!webId.equals(file.getWebID())) continue;
            return file;
        }
        return null;
    }

    private int findFileIndexByWebId(String webId) {
        if (StringUtil.isEmptyOrNull((String)webId)) {
            return -1;
        }
        for (int i = 0; i < this.mContentFiles.size(); ++i) {
            MMZoomFile file = this.mContentFiles.get(i);
            if (!webId.equals(file.getWebID())) continue;
            return i;
        }
        return -1;
    }

    public boolean isDataEmpty() {
        return this.mContentFiles.isEmpty();
    }

    public long getLastTimeStamp() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return 0L;
        }
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return 0L;
        }
        String jid = myself.getJid();
        if (this.mContentFiles.isEmpty()) {
            return 0L;
        }
        if (!StringUtil.isEmptyOrNull((String)this.mSessionId)) {
            long time = this.mContentFiles.get(0).getShareTimeInSession(this.mSessionId);
            for (MMZoomFile file : this.mContentFiles) {
                long tmp = file.getShareTimeInSession(this.mSessionId);
                if (tmp >= time) continue;
                time = tmp;
            }
            return time;
        }
        if (this.mIsPersonalMode) {
            long time = this.mContentFiles.get(0).getTimeStamp();
            for (MMZoomFile file : this.mContentFiles) {
                if (file.getTimeStamp() >= time) continue;
                time = file.getTimeStamp();
            }
            return time;
        }
        long time = this.mContentFiles.get(0).getEarliestShareTime();
        for (MMZoomFile file : this.mContentFiles) {
            long tmp = 0L;
            tmp = StringUtil.isSameString((String)file.getOwnerJid(), (String)jid) ? file.getTimeStamp() : file.getEarliestShareTime();
            if (tmp >= time) continue;
            time = tmp;
        }
        return time;
    }

    public void clearAll() {
        this.mContentFiles.clear();
        this.mShowAllSharesFileIds.clear();
    }

    private void updateDisplayData() {
        this.mDisplayItems.clear();
        Collections.sort(this.mContentFiles, new ContentFileComparator(this.mIsPersonalMode));
        long timeStamp = 0L;
        for (int i = 0; i < this.mContentFiles.size(); ++i) {
            DisplayItem item;
            long time;
            MMZoomFile fileTemp = this.mContentFiles.get(i);
            if (this.mIsGroupOwner && CollectionsUtil.isListEmpty(fileTemp.getOperatorAbleSessions())) {
                fileTemp.addOperatorAbleSession(this.mSessionId);
            }
            long l = time = this.mIsPersonalMode ? fileTemp.getTimeStamp() : fileTemp.getEarliestShareTime();
            if (this.isTimeChat && this.eraseTime != -1L && time < this.eraseTime) continue;
            if (timeStamp != 0L && TimeUtil.isInSameMonth((long)timeStamp, (long)time)) {
                item = new DisplayItem();
                item.mItemType = 1;
                item.file = fileTemp;
                this.mDisplayItems.add(item);
                continue;
            }
            timeStamp = time;
            item = new DisplayItem();
            item.mItemType = 0;
            item.mLabel = this.formatTime(timeStamp);
            this.mDisplayItems.add(item);
            item = new DisplayItem();
            item.mItemType = 1;
            item.file = fileTemp;
            this.mDisplayItems.add(item);
        }
        if (this.isTimeChat && this.mDisplayItems.size() > 0) {
            DisplayItem displayItem1 = new DisplayItem();
            displayItem1.mItemType = 2;
            displayItem1.mLabel = this.getTimeChatMsg();
            this.mDisplayItems.add(displayItem1);
        }
    }

    private String getTimeChatMsg() {
        String end = "";
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        PTAppProtos.LocalStorageTimeInterval interval = messenger.getLocalStorageTimeInterval();
        if (interval != null) {
            end = this.mContext.getResources().getString(R.string.zm_mm_msg_remove_history_message2_33479, new Object[]{this.timeInterval(interval.getYear(), interval.getMonth(), interval.getDay())});
        }
        return end;
    }

    private String timeInterval(long year, long month, long day) {
        if (year != 0L) {
            return this.mContext.getResources().getQuantityString(R.plurals.zm_mm_msg_year_33479, (int)year, new Object[]{year});
        }
        if (month != 0L) {
            return this.mContext.getResources().getQuantityString(R.plurals.zm_mm_msg_month_33479, (int)month, new Object[]{month});
        }
        if (day == 1L) {
            return this.mContext.getResources().getQuantityString(R.plurals.zm_mm_msg_hour_33479, 24, new Object[]{24});
        }
        return this.mContext.getResources().getQuantityString(R.plurals.zm_mm_msg_day_33479, (int)day, new Object[]{day});
    }

    public boolean isEnabled(int position) {
        DisplayItem item = this.getItem(position);
        if (item == null) {
            return false;
        }
        return item.file != null;
    }

    public void setEraseTime(long eraseTime, boolean erase) {
        this.eraseTime = eraseTime;
        this.isTimeChat = erase;
    }

    public long getEraseTime() {
        return this.eraseTime;
    }

    public void notifyDataSetChanged() {
        this.updateDisplayData();
        super.notifyDataSetChanged();
    }

    public int getCount() {
        return this.mDisplayItems.size();
    }

    public DisplayItem getItem(int position) {
        return this.mDisplayItems.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public int getViewTypeCount() {
        return 3;
    }

    public int getItemViewType(int position) {
        DisplayItem item = this.getItem(position);
        return item.mItemType;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int type = this.getItemViewType(position);
        switch (type) {
            case 1: {
                return this.createFileItemView(position, convertView, parent);
            }
            case 0: {
                return this.createLabelItemView(position, convertView, parent);
            }
            case 2: {
                return this.createTimeChatItemView(position, convertView, parent);
            }
        }
        return null;
    }

    private View createFileItemView(int position, View convertView, ViewGroup parent) {
        MMZoomFileView view = null;
        DisplayItem item = this.getItem(position);
        if (item == null || item.file == null) {
            return null;
        }
        if (convertView instanceof MMZoomFileView) {
            view = (MMZoomFileView)convertView;
        } else {
            view = new MMZoomFileView(this.mContext);
            view.setOnClickOperatorListener(this.mParentListView);
            view.setOnMoreShareActionListener(this);
        }
        item.file.setShowAllShareActions(this.mShowAllSharesFileIds.contains(item.file.getWebID()));
        view.setMMZoomFile(item.file, this.mIsPersonalMode, this.mSessionId);
        return view;
    }

    private View createLabelItemView(int position, View convertView, ViewGroup parent) {
        DisplayItem item;
        if (convertView == null || !TAG_ITEM_LABEL.equals(convertView.getTag())) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_listview_label_item, null);
            convertView.setTag((Object)TAG_ITEM_LABEL);
        }
        if ((item = this.getItem(position)) != null && item.mItemType == 0) {
            TextView txtHeaderLabel = (TextView)convertView.findViewById(R.id.txtHeaderLabel);
            txtHeaderLabel.setText((CharSequence)item.mLabel);
        }
        return convertView;
    }

    private View createTimeChatItemView(int position, View convertView, ViewGroup parent) {
        MMMessageRemoveHistory mmMessageRemoveHistory = new MMMessageRemoveHistory(this.mContext);
        DisplayItem item = this.getItem(position);
        if (item != null && item.mItemType == 2) {
            mmMessageRemoveHistory.setMessage(item.mLabel);
        }
        return mmMessageRemoveHistory;
    }

    private String formatTime(long time) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-M");
        return df.format(new Date(time));
    }

    public void setParentListView(MMContentFilesListView listview) {
        this.mParentListView = listview;
    }

    @Override
    public void onShowAllShareAction(String fileId) {
        if (StringUtil.isEmptyOrNull((String)fileId)) {
            return;
        }
        this.mShowAllSharesFileIds.add(fileId);
        this.notifyDataSetChanged();
    }

    public boolean isItemViewTypePinned(int viewType) {
        return viewType == 0;
    }

    static class ContentFileComparator
    implements Comparator<MMZoomFile> {
        private boolean mIsPersonalMode;

        public ContentFileComparator(boolean isPersonalMode) {
            this.mIsPersonalMode = isPersonalMode;
        }

        @Override
        public int compare(MMZoomFile lhs, MMZoomFile rhs) {
            long t;
            long l = t = this.mIsPersonalMode ? lhs.getTimeStamp() - rhs.getTimeStamp() : lhs.getEarliestShareTime() - rhs.getEarliestShareTime();
            if (t > 0L) {
                return -1;
            }
            if (t == 0L) {
                return 0;
            }
            return 1;
        }
    }

    static class DisplayItem {
        int mItemType;
        String mLabel;
        MMZoomFile file;

        DisplayItem() {
        }
    }
}

