/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.zipow.videobox.ConfActivity;
import com.zipow.videobox.fragment.IMAddrBookListFragment;
import com.zipow.videobox.fragment.InviteFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.delegate.PTAppDelegation;
import com.zipow.videobox.ptapp.mm.ZMBuddySyncInstance;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.IMView;
import com.zipow.videobox.view.mm.MMContactsRoomAdapter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.QuickSearchListView;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class MMContactsRoomsListView
extends QuickSearchListView
implements AdapterView.OnItemClickListener,
AbsListView.OnScrollListener {
    private static final String TAG = MMContactsRoomsListView.class.getSimpleName();
    private MMContactsRoomAdapter mAdapter;
    private IMAddrBookListFragment mParentFragment;
    private static final int MSG_REFRESH_BUDDY_VCARDS = 1;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    MMContactsRoomsListView.this.refreshBuddyVcards();
                    this.sendEmptyMessageDelayed(1, 2000L);
                    break;
                }
            }
        }
    };

    public MMContactsRoomsListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    public MMContactsRoomsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MMContactsRoomsListView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mAdapter = new MMContactsRoomAdapter(this.getContext());
        this.setAdapter(this.mAdapter);
        this.setOnItemClickListener(this);
        this.getListView().setOnScrollListener((AbsListView.OnScrollListener)this);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mHandler.sendEmptyMessageDelayed(1, 2000L);
    }

    protected void onDetachedFromWindow() {
        this.mHandler.removeMessages(1);
        super.onDetachedFromWindow();
    }

    public void filter(String key) {
        this.mAdapter.filter(key);
    }

    public void onBuddyInfoUpdate(List<String> presenceChangeJids, List<String> infoChangeJids) {
        IMAddrBookItem item;
        boolean isRoomChanged = false;
        ZMBuddySyncInstance instance = ZMBuddySyncInstance.getInsatance();
        if (!CollectionsUtil.isListEmpty(presenceChangeJids)) {
            for (String jid : presenceChangeJids) {
                item = instance.getBuddyByJid(jid);
                if (item == null || !item.isZoomRoomContact()) continue;
                isRoomChanged = true;
                break;
            }
        }
        if (!isRoomChanged && !CollectionsUtil.isListEmpty(infoChangeJids)) {
            for (String jid : infoChangeJids) {
                item = instance.getBuddyByJid(jid);
                if (item == null || !item.isZoomRoomContact()) continue;
                isRoomChanged = true;
                break;
            }
        }
        if (isRoomChanged) {
            this.refreshAllData();
        }
    }

    public void refreshAllData() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        this.mAdapter.clearAll();
        PTAppProtos.AllBuddyInfo info = messenger.getAllRooms();
        if (info == null) {
            this.mAdapter.notifyDataSetChanged();
            return;
        }
        for (int i = 0; i < info.getJidsCount(); ++i) {
            String jid = info.getJids(i);
            IMAddrBookItem item = new IMAddrBookItem(jid, info.getScreenName(i), info.getPhoneNumber(i), info.getIsBuddy(i), info.getIsDesktopOnLine(i), info.getIsMobileOnLine(i), info.getEmail(i), info.getIsZoomRoom(i), info.getSipPhoneNumber(i));
            this.mAdapter.addOrUpdateItem(item);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void setParentFragment(IMAddrBookListFragment fragment) {
        this.mParentFragment = fragment;
    }

    public void setEmptyView(View emptyView) {
        this.getListView().setEmptyView(emptyView);
    }

    public int getCount() {
        return this.mAdapter.getCount();
    }

    public boolean hasRooms() {
        return this.mAdapter.hasRooms();
    }

    public boolean isParentFragmentResumed() {
        if (this.mParentFragment == null) {
            return false;
        }
        return this.mParentFragment.isResumed();
    }

    private void refreshBuddyVcards() {
        List<String> jids = this.mAdapter.getWaitRefreshJids();
        HashSet<String> cache = new HashSet<String>();
        int maxNums = this.getListView().getChildCount() * 2;
        for (int i = jids.size() - 1; i >= 0; --i) {
            cache.add(jids.get(i));
            if (cache.size() >= maxNums) break;
        }
        if (cache.size() == 0) {
            return;
        }
        this.mAdapter.clearWaitRefreshJids();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ArrayList<String> temp = new ArrayList<String>();
        temp.addAll(cache);
        for (String jid : cache) {
            messenger.refreshBuddyVCard(jid);
        }
        if (temp.size() > 0 && messenger.isAnyBuddyGroupLarge()) {
            messenger.getBuddiesPresence(temp, false);
        }
    }

    private void onItemClick(final IMAddrBookItem item) {
        if (item != null) {
            Context context = this.getContext();
            if (context == null) {
                return;
            }
            final ZMMenuAdapter menuAdapter = new ZMMenuAdapter(context, false);
            ArrayList<RoomListContextMenuItem> items = new ArrayList<RoomListContextMenuItem>();
            String title = item.getScreenName();
            items.add(new RoomListContextMenuItem(context.getString(R.string.zm_btn_video_call), 0));
            items.add(new RoomListContextMenuItem(context.getString(R.string.zm_btn_audio_call), 1));
            if (PTApp.getInstance().getCallStatus() == 2) {
                items.add(new RoomListContextMenuItem(context.getString(R.string.zm_btn_invite_to_conf), 2));
            }
            menuAdapter.addAll(items);
            ZMAlertDialog dialog = new ZMAlertDialog.Builder(context).setTitle(title).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    RoomListContextMenuItem mi = (RoomListContextMenuItem)((Object)menuAdapter.getItem(which));
                    MMContactsRoomsListView.this.onSelectContextMenuItem(item, mi);
                }
            }).create();
            dialog.setCanceledOnTouchOutside(true);
            dialog.show();
        }
    }

    private void onSelectContextMenuItem(IMAddrBookItem item, RoomListContextMenuItem mi) {
        int callStatus;
        if (mi.getAction() == 1) {
            int callStatus2 = PTApp.getInstance().getCallStatus();
            if (callStatus2 == 0) {
                this.callABContact(0, item);
            }
        } else if (mi.getAction() == 0) {
            int callStatus3 = PTApp.getInstance().getCallStatus();
            if (callStatus3 == 0) {
                this.callABContact(1, item);
            }
        } else if (mi.getAction() == 2 && ((callStatus = PTApp.getInstance().getCallStatus()) == 1 || callStatus == 2)) {
            this.inviteABContact(item);
        }
    }

    private void callABContact(int abCallType, IMAddrBookItem contact) {
        if (contact == null) {
            return;
        }
        Context context = this.getContext();
        if (context == null || !(context instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)context;
        int ret = ConfActivity.inviteToVideoCall((Context)activity, contact.getJid(), abCallType);
        if (ret != 0) {
            IMView.StartHangoutFailedDialog.show(((ZMActivity)activity).getSupportFragmentManager(), IMView.StartHangoutFailedDialog.class.getName(), ret);
        }
    }

    private void inviteABContact(IMAddrBookItem contact) {
        if (contact == null) {
            return;
        }
        Context context = this.getContext();
        if (context == null || !(context instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)context;
        String jid = contact.getJid();
        if (StringUtil.isEmptyOrNull((String)jid)) {
            return;
        }
        String[] buddyJids = new String[]{contact.getJid()};
        String confId = PTApp.getInstance().getActiveCallId();
        long meetingNum = PTApp.getInstance().getActiveMeetingNo();
        int ret = PTAppDelegation.getInstance().inviteBuddiesToConf(buddyJids, null, confId, meetingNum, activity.getString(R.string.zm_msg_invitation_message_template));
        if (ret != 0) {
            this.onSentInvitationFailed();
        } else {
            this.onSentInvitationDone(activity);
        }
    }

    private void onSentInvitationFailed() {
        Context context = this.getContext();
        if (context == null || !(context instanceof ZMActivity)) {
            return;
        }
        new InviteFragment.InviteFailedDialog().show(((ZMActivity)context).getSupportFragmentManager(), InviteFragment.InviteFailedDialog.class.getName());
    }

    private void onSentInvitationDone(Activity activity) {
        ConfActivity.returnToConf((Context)activity);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object oItem = this.getItemAtPosition(position);
        if (oItem instanceof IMAddrBookItem) {
            this.onItemClick((IMAddrBookItem)oItem);
        }
    }

    public void updateBuddyInfoWithJid(String jid) {
        if (this.mAdapter == null || !this.mAdapter.isContainRoom(jid)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(jid);
        if (buddy == null) {
            return;
        }
        IMAddrBookItem item = IMAddrBookItem.fromZoomBuddy(buddy);
        if (item == null) {
            return;
        }
        this.mAdapter.addOrUpdateItem(item);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (scrollState == 2) {
            this.mHandler.removeMessages(1);
        } else if (!this.mHandler.hasMessages(1)) {
            this.mHandler.sendEmptyMessageDelayed(1, 1000L);
        }
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
    }

    public static class RoomListContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_VIDEO_CALL = 0;
        public static final int ACTION_AUDIO_CALL = 1;
        public static final int ACTION_INVITE_CALL = 2;

        public RoomListContextMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

