/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.GroupMemberSynchronizer;
import com.zipow.videobox.util.GroupAvatarDrawable_v2;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.mm.MMZoomGroup;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class MMContactsGroupAdapter
extends BaseAdapter {
    private static final String TAG_GROUPS_LABEL = "label";
    private static final String TAG_GROUPS_ITEM = "item";
    private static final int TYPE_GROUPS_LABEL = 0;
    private static final int TYPE_GROUPS_ITEM = 1;
    private List<Object> mDisplayDatas = new ArrayList<Object>();
    private Context mContext;
    private List<MMZoomGroup> mGroups = new ArrayList<MMZoomGroup>();
    private String mFilter;

    public MMContactsGroupAdapter(Context context) {
        this.mContext = context;
    }

    public void clearAll() {
        this.mGroups.clear();
    }

    public void addOrUpdateItem(MMZoomGroup group) {
        if (group == null) {
            return;
        }
        GroupMemberSynchronizer groupMemberSynchronizer = PTApp.getInstance().getGroupMemberSynchronizer();
        if (groupMemberSynchronizer == null) {
            return;
        }
        if (group.getMemberCount() > 0 || groupMemberSynchronizer.needReadGroupMemberFromDB(group.getGroupId())) {
            int idx = this.findGroupIndex(group);
            if (idx == -1) {
                this.mGroups.add(group);
            } else {
                this.mGroups.set(idx, group);
            }
        } else {
            groupMemberSynchronizer.safeSyncGroupMemberFromXmpp(group.getGroupId());
        }
    }

    public void filter(String key) {
        if (StringUtil.isSameString((String)key, (String)this.mFilter)) {
            return;
        }
        this.mFilter = key == null ? null : key.toLowerCase(CompatUtils.getLocalDefault());
        this.notifyDataSetChanged();
    }

    public void removeItem(MMZoomGroup group) {
        if (group == null) {
            return;
        }
        int idx = this.findGroupIndex(group);
        if (idx != -1) {
            this.mGroups.remove(idx);
        }
    }

    public void removeItem(String groupid) {
        if (TextUtils.isEmpty((CharSequence)groupid)) {
            return;
        }
        int idx = this.findGroupIndex(groupid);
        if (idx != -1) {
            this.mGroups.remove(idx);
        }
    }

    private int findGroupIndex(MMZoomGroup group) {
        if (group == null) {
            return -1;
        }
        return this.findGroupIndex(group.getGroupId());
    }

    private int findGroupIndex(String groupid) {
        if (TextUtils.isEmpty((CharSequence)groupid)) {
            return -1;
        }
        for (int i = 0; i < this.mGroups.size(); ++i) {
            MMZoomGroup item = this.mGroups.get(i);
            if (!StringUtil.isSameString((String)item.getGroupId(), (String)groupid)) continue;
            return i;
        }
        return -1;
    }

    public MMZoomGroup findGroup(String groupid) {
        int index = this.findGroupIndex(groupid);
        if (index < 0) {
            return null;
        }
        return this.mGroups.get(index);
    }

    public int getCount() {
        return this.mDisplayDatas.size();
    }

    private void updateDisplayDatas() {
        ArrayList<MMZoomGroup> privateGroups = new ArrayList<MMZoomGroup>();
        ArrayList<MMZoomGroup> publicGroups = new ArrayList<MMZoomGroup>();
        boolean isFilterEmpty = StringUtil.isEmptyOrNull((String)this.mFilter);
        Locale locale = CompatUtils.getLocalDefault();
        for (MMZoomGroup group : this.mGroups) {
            if (group.isPublic()) {
                if (!isFilterEmpty && !group.getGroupName().toLowerCase(locale).contains(this.mFilter)) continue;
                publicGroups.add(group);
                continue;
            }
            if (!isFilterEmpty && !group.getGroupName().toLowerCase(locale).contains(this.mFilter)) continue;
            privateGroups.add(group);
        }
        this.mDisplayDatas.clear();
        if (privateGroups.size() > 0) {
            Collections.sort(privateGroups, new MMZoomGroupComparator(locale));
            this.mDisplayDatas.add(this.mContext.getString(R.string.zm_lbl_contact_private_groups, new Object[]{privateGroups.size()}));
            this.mDisplayDatas.addAll(privateGroups);
        }
        if (publicGroups.size() > 0) {
            Collections.sort(publicGroups, new MMZoomGroupComparator(locale));
            this.mDisplayDatas.add(this.mContext.getString(R.string.zm_lbl_contact_public_groups, new Object[]{publicGroups.size()}));
            this.mDisplayDatas.addAll(publicGroups);
        }
    }

    public void notifyDataSetChanged() {
        this.updateDisplayDatas();
        super.notifyDataSetChanged();
    }

    public int getItemViewType(int position) {
        if (position < 0 || position >= this.mDisplayDatas.size()) {
            return 0;
        }
        Object item = this.mDisplayDatas.get(position);
        if (item instanceof MMZoomGroup) {
            return 1;
        }
        return 0;
    }

    public int getViewTypeCount() {
        return 2;
    }

    public Object getItem(int position) {
        if (position < 0 || position >= this.mDisplayDatas.size()) {
            return null;
        }
        return this.mDisplayDatas.get(position);
    }

    public long getItemId(int position) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        switch (this.getItemViewType(position)) {
            case 1: {
                return this.createGroupsItem(position, convertView, parent);
            }
            case 0: {
                return this.createGroupsLabel(position, convertView, parent);
            }
        }
        return null;
    }

    private View createGroupsLabel(int position, View convertView, ViewGroup parent) {
        if (convertView == null || !TAG_GROUPS_LABEL.equals(convertView.getTag())) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_listview_label_item, null);
            convertView.setTag((Object)TAG_GROUPS_LABEL);
        }
        TextView txtHeaderLabel = (TextView)convertView.findViewById(R.id.txtHeaderLabel);
        Object item = this.getItem(position);
        if (item != null) {
            txtHeaderLabel.setText((CharSequence)item.toString());
        }
        return convertView;
    }

    private View createGroupsItem(int position, View convertView, ViewGroup parent) {
        if (convertView == null || !TAG_GROUPS_ITEM.equals(convertView.getTag())) {
            convertView = View.inflate((Context)this.mContext, (int)R.layout.zm_contacts_group_item, null);
            convertView.setTag((Object)TAG_GROUPS_LABEL);
        }
        MMZoomGroup group = (MMZoomGroup)this.getItem(position);
        AvatarView avatarView = (AvatarView)convertView.findViewById(R.id.avatarView);
        TextView txtGroupName = (TextView)convertView.findViewById(R.id.txtGroupName);
        TextView txtMemberNo = (TextView)convertView.findViewById(R.id.txtMemberNo);
        TextView txtGroupdes = (TextView)convertView.findViewById(R.id.txtGroupdes);
        avatarView.setAvatar(new GroupAvatarDrawable_v2(group.getGroupId()));
        txtGroupName.setText((CharSequence)group.getGroupName());
        txtMemberNo.setText((CharSequence)String.format("(%s)", group.getMemberCount()));
        if (group.isPublic()) {
            txtGroupdes.setVisibility(0);
            String creatorHtml = "";
            creatorHtml = !StringUtil.isEmptyOrNull((String)group.getGroupOwnerName()) ? String.format("<b>%s</b>", group.getGroupOwnerName()) : String.format("<b>%s</b>", group.getAdminScreenName());
            txtGroupdes.setText((CharSequence)Html.fromHtml((String)this.mContext.getString(R.string.zm_lbl_contact_group_description, new Object[]{creatorHtml})));
        } else {
            txtGroupdes.setVisibility(8);
        }
        return convertView;
    }

    static class MMZoomGroupComparator
    implements Comparator<MMZoomGroup> {
        private Collator mCollator;

        public MMZoomGroupComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(MMZoomGroup lhs, MMZoomGroup rhs) {
            if (lhs == rhs) {
                return 0;
            }
            String str1 = this.getItemSortKey(lhs);
            String str2 = this.getItemSortKey(rhs);
            return this.mCollator.compare(str1, str2);
        }

        private String getItemSortKey(MMZoomGroup item) {
            return SortUtil.getSortKey((String)item.getGroupName(), (Locale)CompatUtils.getLocalDefault());
        }
    }
}

