/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.view.IMSearchView;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class MMContactSearchFragment
extends ZMDialogFragment
implements View.OnClickListener,
SimpleActivity.ExtListener {
    private static final String ARG_SEARCH_FILTER = "search_filter";
    private Button mBtnClearSearchView;
    private IMSearchView mSearchResultListView;
    private EditText mEdtSearch;
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener;
    private TextView mTxtEmptyView;
    private boolean mbKeyboardOpen = false;

    public static void showAsFragment(Object obj) {
        MMContactSearchFragment.showAsFragment(obj, null);
    }

    public static void showAsFragment(Object obj, String filter) {
        MMContactSearchFragment.showAsFragment(obj, -1, filter);
    }

    public static void showAsFragment(Object obj, int requestCode, String filter) {
        Bundle args = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)filter)) {
            args.putString(ARG_SEARCH_FILTER, filter);
        }
        if (obj instanceof Fragment) {
            SimpleActivity.show((Fragment)obj, MMContactSearchFragment.class.getName(), args, requestCode, 2);
        } else if (obj instanceof ZMActivity) {
            SimpleActivity.show((ZMActivity)obj, MMContactSearchFragment.class.getName(), args, requestCode, true);
        }
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        String filter;
        this.getActivity().getWindow().setSoftInputMode(21);
        Bundle bundle = this.getArguments();
        if (bundle != null && !TextUtils.isEmpty((CharSequence)(filter = bundle.getString(ARG_SEARCH_FILTER)))) {
            this.mEdtSearch.setText((CharSequence)filter);
            this.mEdtSearch.setSelection(this.mEdtSearch.getText().length());
        }
        super.onActivityCreated(savedInstanceState);
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (Build.VERSION.SDK_INT >= 21) {
            View decorView;
            Window window = this.getActivity().getWindow();
            if (Build.VERSION.SDK_INT >= 23 && (decorView = window.getDecorView()) != null) {
                int vis = decorView.getSystemUiVisibility();
                decorView.setSystemUiVisibility(vis |= 0x2000);
            }
            window.addFlags(Integer.MIN_VALUE);
            window.clearFlags(0x4000000);
            window.setStatusBarColor(this.getResources().getColor(R.color.zm_im_search_bar_bg));
        }
    }

    public View onCreateView(LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        View content = inflater.inflate(R.layout.zm_mm_contact_search, container, false);
        this.mBtnClearSearchView = (Button)content.findViewById(R.id.btnClearSearchView);
        this.mSearchResultListView = (IMSearchView)content.findViewById(R.id.searchResultListView);
        this.mEdtSearch = (EditText)content.findViewById(R.id.edtSearch);
        this.mTxtEmptyView = (TextView)content.findViewById(R.id.txtEmptyView);
        content.findViewById(R.id.btnBack).setOnClickListener((View.OnClickListener)this);
        this.mEdtSearch.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 6) {
                    MMContactSearchFragment.this.mSearchResultListView.setFilter(MMContactSearchFragment.this.mEdtSearch.getText().toString());
                }
                return false;
            }
        });
        this.mEdtSearch.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void afterTextChanged(Editable s) {
                MMContactSearchFragment.this.mSearchResultListView.setFilter(s.toString());
                MMContactSearchFragment.this.mBtnClearSearchView.setVisibility(s.length() != 0 ? 0 : 8);
            }
        });
        this.mBtnClearSearchView.setOnClickListener((View.OnClickListener)this);
        this.mSearchResultListView.setEmptyView((View)this.mTxtEmptyView);
        this.mEdtSearch.requestFocus();
        return content;
    }

    public void onIndicateZoomMessengerBuddyListUpdated() {
        this.mSearchResultListView.onIndicateZoomMessengerBuddyListUpdated();
    }

    public void onIndicateZoomMessengerInfoUpdatedWithJID(String jid) {
        this.mSearchResultListView.updateBuddyInfoWithJid(jid);
    }

    public void onZoomMessengerSearchBuddyPicDownloaded(String jid) {
        this.mSearchResultListView.updateBuddyInfoWithJid(jid);
    }

    public void onZoomMessengerRemoveBuddy(String jid, int result) {
        this.mSearchResultListView.onZoomMessengerRemoveBuddy(jid, result);
    }

    public void onGroupAction(int result, GroupAction action, String msgId) {
        this.mSearchResultListView.onGroupAction(result, action, msgId);
    }

    public void onConfirm_MessageSent(String sessionId, String messageId, int result) {
        this.mSearchResultListView.onConfirm_MessageSent(sessionId, messageId, result);
    }

    public boolean onIndicateMessageReceived(String sessionId, String senderJid, String messageId) {
        this.mSearchResultListView.onReceiveMessage(sessionId, senderJid, messageId);
        return false;
    }

    public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        this.mSearchResultListView.onNotify_MUCGroupInfoUpdatedImpl(groupID);
    }

    public void onNotify_ChatSessionListUpdate() {
        this.mSearchResultListView.onNotify_ChatSessionListUpdate();
    }

    public void onZoomMessengerSearchBuddyByKey(String key, int result) {
        this.mSearchResultListView.onSearchBuddyByKey(key, result);
    }

    public void Indicate_OnlineBuddies(List<String> jidList) {
        if (jidList != null) {
            if (jidList.size() > 10) {
                this.mSearchResultListView.refreshSearchResult(false);
            } else {
                for (String jid : jidList) {
                    this.mSearchResultListView.updateBuddyInfoWithJid(jid);
                }
            }
        }
    }

    public void Indicate_GetContactsPresence(List<String> onLines, List<String> offlines) {
        ArrayList<String> jidList = new ArrayList<String>();
        if (onLines != null) {
            jidList.addAll(onLines);
        }
        if (offlines != null) {
            jidList.addAll(offlines);
        }
        if (jidList.size() > 10) {
            this.mSearchResultListView.refreshSearchResult(false);
        } else {
            for (String jid : jidList) {
                this.mSearchResultListView.updateBuddyInfoWithJid(jid);
            }
        }
    }

    public void onResume() {
        super.onResume();
        this.mSearchResultListView.onResume();
        if (this.mZoomMessengerUIListener == null) {
            this.mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

                @Override
                public void onSearchBuddyByKey(String key, int result) {
                    MMContactSearchFragment.this.onZoomMessengerSearchBuddyByKey(key, result);
                }

                @Override
                public void onIndicateBuddyListUpdated() {
                    MMContactSearchFragment.this.onIndicateZoomMessengerBuddyListUpdated();
                }

                @Override
                public void onIndicateInfoUpdatedWithJID(String jid) {
                    MMContactSearchFragment.this.onIndicateZoomMessengerInfoUpdatedWithJID(jid);
                }

                @Override
                public void onSearchBuddyPicDownloaded(String jid) {
                    MMContactSearchFragment.this.onZoomMessengerSearchBuddyPicDownloaded(jid);
                }

                @Override
                public void onRemoveBuddy(String jid, int result) {
                    MMContactSearchFragment.this.onZoomMessengerRemoveBuddy(jid, result);
                }

                @Override
                public void onGroupAction(int result, GroupAction action, String msgId) {
                    MMContactSearchFragment.this.onGroupAction(result, action, msgId);
                }

                @Override
                public void onConfirm_MessageSent(String sessionId, String messageId, int result) {
                    MMContactSearchFragment.this.onConfirm_MessageSent(sessionId, messageId, result);
                }

                @Override
                public boolean onIndicateMessageReceived(String sessionId, String senderJid, String messageId) {
                    return MMContactSearchFragment.this.onIndicateMessageReceived(sessionId, senderJid, messageId);
                }

                @Override
                public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
                    MMContactSearchFragment.this.onNotify_MUCGroupInfoUpdatedImpl(groupID);
                }

                @Override
                public void onNotify_ChatSessionListUpdate() {
                    MMContactSearchFragment.this.onNotify_ChatSessionListUpdate();
                }

                @Override
                public void Indicate_OnlineBuddies(List<String> jidList) {
                    MMContactSearchFragment.this.Indicate_OnlineBuddies(jidList);
                }

                @Override
                public void Indicate_GetContactsPresence(List<String> onLines, List<String> offlines) {
                    MMContactSearchFragment.this.Indicate_GetContactsPresence(onLines, offlines);
                }

                @Override
                public void Indicate_BuddyPresenceChanged(String jid) {
                    MMContactSearchFragment.this.onIndicateZoomMessengerInfoUpdatedWithJID(jid);
                }
            };
        }
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
    }

    public void onPause() {
        if (this.mZoomMessengerUIListener != null) {
            ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        }
        super.onPause();
    }

    @Override
    public boolean onSearchRequested() {
        return false;
    }

    @Override
    public boolean onTipLayerTouched() {
        return false;
    }

    @Override
    public void onKeyboardOpen() {
        this.mbKeyboardOpen = true;
    }

    @Override
    public void onKeyboardClosed() {
        if (this.mbKeyboardOpen) {
            this.mbKeyboardOpen = false;
            if (this.isResultEmpty()) {
                this.dismiss();
            }
        }
    }

    @Override
    public boolean onBackPressed() {
        return false;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnClearSearchView) {
            this.onClickBtnClearSearchView();
        } else if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(0);
    }

    private void onClickBtnClearSearchView() {
        this.mEdtSearch.setText((CharSequence)"");
    }

    private boolean isResultEmpty() {
        if (this.mSearchResultListView == null) {
            return true;
        }
        return this.mSearchResultListView.isResultEmpty();
    }
}

