/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.MMChatActivity;
import com.zipow.videobox.MeetingInfoActivity;
import com.zipow.videobox.fragment.MMChatsListFragment;
import com.zipow.videobox.fragment.SystemNotificationFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.GroupAction;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomChatSession;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessage;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.ptapp.mm.ZoomSubscribeRequest;
import com.zipow.videobox.util.MemCache;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.view.ChatMeetToolbar;
import com.zipow.videobox.view.ScheduledMeetingItem;
import com.zipow.videobox.view.mm.MMChatsListAdapter;
import com.zipow.videobox.view.mm.MMChatsListItem;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class MMChatsListView
extends ListView
implements AdapterView.OnItemClickListener,
AdapterView.OnItemLongClickListener,
AbsListView.OnScrollListener,
ChatMeetToolbar.IUpComingMeetingCallback {
    private static final String TAG = MMChatsListView.class.getSimpleName();
    private MMChatsListAdapter mAdapter;
    private boolean mLoaded = false;
    private MMChatsListFragment mParentFragment;
    private ChatMeetToolbar mChatMeetToolbar;
    private MemCache<String, Drawable> mAvatarCache = new MemCache(10);
    private Handler mHandler = new Handler();
    private Runnable mTaskLazyNotifyDataSetChanged = null;
    public static final int REQUEST_SCHEDULE = 1002;
    private boolean mIsSearchLastMsg4SyncLoaded = false;
    private Runnable mRefreshUpcomingMeetingRunnable = new Runnable(){

        @Override
        public void run() {
            if (MMChatsListView.this.mChatMeetToolbar != null) {
                MMChatsListView.this.mChatMeetToolbar.refresh();
            }
        }
    };

    public MMChatsListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public MMChatsListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MMChatsListView(Context context) {
        super(context);
        this.initView();
    }

    public void setParentFragment(MMChatsListFragment fragment) {
        this.mParentFragment = fragment;
        this.mChatMeetToolbar.setParentFragment(fragment);
    }

    public boolean isParentFragmentResumed() {
        if (this.mParentFragment == null) {
            return false;
        }
        return this.mParentFragment.isResumed() || this.mParentFragment.isInMultWindowMode();
    }

    public void onParentFragmentResume() {
        if (this.mChatMeetToolbar != null) {
            this.mChatMeetToolbar.setmIUpComingMeetingCallback(this);
        }
        this.refresh();
    }

    public void refresh() {
        this.loadData(false, true);
        this.mChatMeetToolbar.refresh();
        this.mAdapter.notifyDataSetChanged();
    }

    public void onParentFragmentStart() {
        this.mAdapter.notifyDataSetChanged();
        this.mChatMeetToolbar.refresh();
    }

    public void onParentFragmentPause() {
        this.mAvatarCache.clear();
        this.mHandler.removeCallbacks(this.mRefreshUpcomingMeetingRunnable);
        if (this.mChatMeetToolbar != null) {
            this.mChatMeetToolbar.setmIUpComingMeetingCallback(null);
        }
    }

    public void onCallStatusChanged() {
        this.mChatMeetToolbar.refresh();
        this.mAdapter.notifyDataSetChanged();
    }

    public void onWebLogin(long result) {
        this.mChatMeetToolbar.refresh();
        this.mAdapter.notifyDataSetChanged();
    }

    private void initView() {
        this.mAdapter = new MMChatsListAdapter(this.getContext());
        this.mAdapter.setAvatarCache(this.mAvatarCache);
        if (this.isInEditMode()) {
            this._editmode_loadData(this.mAdapter);
        }
        View header = View.inflate((Context)this.getContext(), (int)R.layout.zm_mm_chat_meet_header, null);
        this.addHeaderView(header);
        this.mChatMeetToolbar = (ChatMeetToolbar)header.findViewById(R.id.chatMeetToolbar);
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(this);
        this.setOnItemLongClickListener(this);
        this.setOnScrollListener(this);
    }

    private void _editmode_loadData(MMChatsListAdapter adapter) {
        for (int i = 0; i < 5; ++i) {
            MMChatsListItem item = new MMChatsListItem();
            item.setSessionId(String.valueOf(i));
            item.setTitle("Buddy " + (i + 1));
            item.setLatestMessage("Hello!");
            item.setIsGroup(false);
            item.setUnreadMessageCount(i == 0 ? 10 : 0);
            adapter.addItem(item);
        }
    }

    public void refreshSystemNotificationSession() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || messenger.imChatGetOption() == 2) {
            return;
        }
        MMChatsListItem systemNotififySession = this.getSystemNotificationSessionItem();
        if (systemNotififySession != null) {
            this.mAdapter.addItem(systemNotififySession);
        }
    }

    public void subscribeChatsPresence() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null || !messenger.isAnyBuddyGroupLarge()) {
            return;
        }
        int cntSessions = messenger.getChatSessionCount();
        ArrayList<String> temp = new ArrayList<String>();
        for (int i = 0; i < cntSessions; ++i) {
            ZoomChatSession session = messenger.getSessionAt(i);
            if (session == null || session.isGroup()) continue;
            temp.add(session.getSessionId());
        }
        if (temp.size() > 0) {
            messenger.subBuddyTempPresence(temp);
        }
    }

    public void getChatsPresence() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ArrayList<String> buddies = new ArrayList<String>();
        int cntSessions = messenger.getChatSessionCount();
        for (int i = 0; i < cntSessions; ++i) {
            ZoomChatSession session = messenger.getSessionAt(i);
            if (session == null || session.isGroup()) continue;
            buddies.add(session.getSessionId());
        }
        messenger.subBuddyTempPresence(buddies);
    }

    public void loadData(boolean ignoreIfLoaded, boolean forceUpdateUnreadMsgCount) {
        if (this.mLoaded && ignoreIfLoaded) {
            if (forceUpdateUnreadMsgCount) {
                this.updateAllUnreadMsgCount();
            }
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        this.mAdapter.clear();
        this.refreshSystemNotificationSession();
        int cntSessions = messenger.getChatSessionCount();
        for (int i = 0; i < cntSessions; ++i) {
            ZoomChatSession session = messenger.getSessionAt(i);
            if (session == null) continue;
            this.addSessionToAdapter(this.mAdapter, session, messenger, false);
        }
        this.mLoaded = true;
    }

    private MMChatsListItem getSystemNotificationSessionItem() {
        String showName;
        Object item;
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return null;
        }
        long stamp = messenger.getLatestRequestTimeStamp();
        if (stamp == 0L) {
            return null;
        }
        Resources res = this.getResources();
        if (res == null) {
            return null;
        }
        boolean isSessionDelete = PreferenceUtil.readBooleanValue("system_notification_delete_flag", false);
        if (isSessionDelete) {
            return null;
        }
        int count = messenger.getSubscribeRequestCount();
        Object request = null;
        ZoomBuddy buddy = null;
        ZoomBuddy myself = messenger.getMyself();
        if (myself == null) {
            return null;
        }
        for (int i = 0; i < count; ++i) {
            item = messenger.getSubscribeRequestAt(i);
            if (((ZoomSubscribeRequest)item).getRequestType() != 0 && (((ZoomSubscribeRequest)item).getRequestType() != 1 || ((ZoomSubscribeRequest)item).getRequestStatus() != 1 && ((ZoomSubscribeRequest)item).getRequestStatus() != 2) || (buddy = messenger.getBuddyWithJID(((ZoomSubscribeRequest)item).getRequestJID())) == null) continue;
            request = item;
            break;
        }
        if (request == null) {
            return null;
        }
        final String requestJid = ((ZoomSubscribeRequest)request).getRequestJID();
        if (StringUtil.isEmptyOrNull((String)requestJid)) {
            return null;
        }
        if (buddy == null) {
            return null;
        }
        item = new MMChatsListItem();
        ((MMChatsListItem)item).setIsGroup(true);
        ((MMChatsListItem)item).setTimeStamp(stamp);
        ((MMChatsListItem)item).setSessionId("######SYSTEM_NOTIFICATION_SESSION");
        ((MMChatsListItem)item).setTitle(res.getString(R.string.zm_system_notification_title));
        ((MMChatsListItem)item).setUnreadMessageCount(messenger.getUnreadRequestCount());
        String msg = null;
        int showStatus = ((ZoomSubscribeRequest)request).getRequestType() == 0 ? 0 : ((ZoomSubscribeRequest)request).getRequestStatus();
        String string2 = showName = (buddy.isPending() || ((ZoomSubscribeRequest)request).getRequestStatus() == 2) && ((ZoomSubscribeRequest)request).getRequestType() != 0 ? buddy.getEmail() : buddy.getScreenName();
        if (StringUtil.isEmptyOrNull((String)showName)) {
            showName = buddy.getScreenName();
        }
        if (StringUtil.isEmptyOrNull((String)showName)) {
            Runnable mTaskLazyLoadVCard = new Runnable(){

                @Override
                public void run() {
                    ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                    if (messenger == null) {
                        return;
                    }
                    messenger.refreshBuddyVCard(requestJid, true);
                    MMChatsListView.this.lazyNotifyDataSetChanged();
                }
            };
            this.mHandler.postDelayed(mTaskLazyLoadVCard, 3000L);
        }
        switch (showStatus) {
            case 1: {
                msg = res.getString(R.string.zm_session_contact_request_accept_byother, new Object[]{showName});
                break;
            }
            case 2: {
                msg = res.getString(R.string.zm_session_contact_request_decline_byother, new Object[]{showName});
                break;
            }
            case 0: {
                msg = res.getString(R.string.zm_session_recive_contact_request, new Object[]{showName});
                break;
            }
            default: {
                return null;
            }
        }
        ((MMChatsListItem)item).setLatestMessage(msg);
        return item;
    }

    public void notifyDataSetChanged() {
        this.notifyDataSetChanged(false);
    }

    public void notifyDataSetChanged(boolean disableLazyLoadAvatar) {
        if (disableLazyLoadAvatar) {
            this.mAdapter.setLazyLoadAvatarDisabled(true);
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MMChatsListView.this.mAdapter.setLazyLoadAvatarDisabled(false);
                }
            }, 1000L);
        }
        this.mAdapter.notifyDataSetChanged();
        if (!this.loadLastMessages4Sync(false)) {
            this.searchSessionLastMessageCtx();
        }
    }

    public void onConnectReturn(int errorCode) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger != null && messenger.isConnectionGood()) {
            this.mIsSearchLastMsg4SyncLoaded = false;
        }
    }

    public void onIndicateBuddyInfoUpdated(String phoneNumber) {
        if (!this.isParentFragmentResumed()) {
            this.loadData(false, false);
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        boolean dataUpdated = false;
        int count = this.mAdapter.getChatsItemsCount();
        for (int i = 0; i < count; ++i) {
            MMChatsListItem item = this.mAdapter.getChatsItem(i);
            if (item == null || !item.isBuddyWithPhoneNumberInSession(phoneNumber)) continue;
            ZoomChatSession session = messenger.getSessionById(item.getSessionId());
            this.mAvatarCache.removeItem(item.getSessionId());
            if (session != null) {
                this.addSessionToAdapter(this.mAdapter, session, messenger, true);
            }
            dataUpdated = true;
        }
        if (dataUpdated && this.isParentFragmentResumed()) {
            this.lazyNotifyDataSetChanged();
        }
    }

    public void onIndicateBuddyInfoUpdatedWithJID(String jid) {
        if (!this.isParentFragmentResumed()) {
            this.loadData(false, false);
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        boolean dataUpdated = false;
        int count = this.mAdapter.getChatsItemsCount();
        for (int i = 0; i < count; ++i) {
            MMChatsListItem item = this.mAdapter.getChatsItem(i);
            if (item == null || !item.isBuddyWithJIDInSession(jid)) continue;
            ZoomChatSession session = messenger.getSessionById(item.getSessionId());
            this.mAvatarCache.removeItem(item.getSessionId());
            if (session != null) {
                this.addSessionToAdapter(this.mAdapter, session, messenger, true);
            }
            dataUpdated = true;
        }
        if (dataUpdated && this.isParentFragmentResumed()) {
            this.lazyNotifyDataSetChanged();
        }
    }

    private void lazyNotifyDataSetChanged() {
        if (this.mTaskLazyNotifyDataSetChanged == null) {
            this.mTaskLazyNotifyDataSetChanged = new Runnable(){

                @Override
                public void run() {
                    if (MMChatsListView.this.isParentFragmentResumed()) {
                        MMChatsListView.this.notifyDataSetChanged(true);
                    }
                }
            };
        }
        this.mHandler.removeCallbacks(this.mTaskLazyNotifyDataSetChanged);
        this.mHandler.postDelayed(this.mTaskLazyNotifyDataSetChanged, 1000L);
    }

    private void updateAllUnreadMsgCount() {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        int cntSessions = messenger.getChatSessionCount();
        for (int i = 0; i < cntSessions; ++i) {
            ZoomChatSession session = messenger.getSessionAt(i);
            if (session == null) continue;
            this.updateUnreadMsgCountForSession(this.mAdapter, session, messenger);
        }
    }

    private void updateUnreadMsgCountForSession(MMChatsListAdapter adapter, ZoomChatSession session, ZoomMessenger messenger) {
        MMChatsListItem item = adapter.getItemBySessionId(session.getSessionId());
        if (item != null) {
            item.setUnreadMessageCount(session.getUnreadMessageCount() + session.getMarkUnreadMessageCount());
            adapter.notifyDataSetChanged();
        }
    }

    public void filter(String filter) {
        this.mAdapter.filter(filter);
    }

    private void addSessionToAdapter(MMChatsListAdapter adapter, ZoomChatSession session, ZoomMessenger messenger, boolean override) {
        if (messenger == null || messenger.imChatGetOption() == 2) {
            return;
        }
        List<String> blockers = messenger.blockUserGetAll();
        if (blockers != null && blockers.contains(session.getSessionId())) {
            return;
        }
        MMChatsListItem item = MMChatsListItem.fromZoomChatSession(session, messenger, this.getContext());
        if (item == null || StringUtil.isEmptyOrNull((String)item.getTitle()) && item.getUnreadMessageCount() == 0) {
            return;
        }
        ZoomMessage message = session.getLastMessage();
        if (message == null) {
            item.setTimeStamp(0L);
            item.setLatestMessage("");
            if (override) {
                adapter.removeItem(session.getSessionId());
            }
            if (!session.isGroup()) {
                return;
            }
            adapter.addItem(item);
            return;
        }
        if (adapter.getItemBySessionId(item.getSessionId()) == null && !session.isGroup() && messenger.isAnyBuddyGroupLarge()) {
            ArrayList<String> temp = new ArrayList<String>();
            temp.add(session.getSessionId());
            messenger.subBuddyTempPresence(temp);
        }
        adapter.addItem(item);
    }

    public void onConfirm_MessageSent(String sessionId, String messageId, int result) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)messageId)) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            return;
        }
        this.mAdapter.removeItem(sessionId);
        this.addSessionToAdapter(this.mAdapter, session, messenger, false);
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onReceiveMessage(String sessionId, String senderJid, String messageId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)messageId)) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            return;
        }
        this.mAdapter.removeItem(sessionId);
        this.addSessionToAdapter(this.mAdapter, session, messenger, false);
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Object oItem = this.mAdapter.getItem(position -= this.getHeaderViewsCount());
        if (oItem instanceof MMChatsListItem) {
            this.onClickChatItem((MMChatsListItem)oItem);
        }
    }

    private void onClickChatItem(MMChatsListItem item) {
        if (item == null) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        if ("######SYSTEM_NOTIFICATION_SESSION".equals(item.getSessionId())) {
            SystemNotificationFragment.showAsActivity(activity, 0);
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(item.getSessionId());
        if (session == null) {
            return;
        }
        if (session.isGroup()) {
            ZoomGroup group = session.getSessionGroup();
            if (group == null) {
                return;
            }
            String groupId = group.getGroupID();
            if (StringUtil.isEmptyOrNull((String)groupId)) {
                return;
            }
            MMChatsListView.startGroupChat(activity, groupId);
        } else {
            ZoomBuddy buddy = session.getSessionBuddy();
            if (buddy == null) {
                return;
            }
            MMChatsListView.startOneToOneChat(activity, buddy);
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id2) {
        Object oItem = this.mAdapter.getItem(position -= this.getHeaderViewsCount());
        if (!(oItem instanceof MMChatsListItem)) {
            return false;
        }
        final MMChatsListItem item = (MMChatsListItem)oItem;
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return false;
        }
        final ZMMenuAdapter menuAdapter = new ZMMenuAdapter((Context)activity, false);
        ArrayList<ChatsListContextMenuItem> items = new ArrayList<ChatsListContextMenuItem>();
        String title = "";
        if (item.isGroup()) {
            String label = "";
            if ("######SYSTEM_NOTIFICATION_SESSION".equals(item.getSessionId())) {
                title = activity.getString(R.string.zm_system_notification_title);
                label = activity.getString(R.string.zm_mm_lbl_delete_system_notification);
            } else {
                title = activity.getString(R.string.zm_mm_title_chatslist_context_menu_group_chat);
                label = activity.getString(R.string.zm_mm_lbl_delete_group_chat_20762);
            }
            items.add(new ChatsListContextMenuItem(label, 0));
        } else {
            title = item.getTitle();
            items.add(new ChatsListContextMenuItem(activity.getString(R.string.zm_mm_lbl_delete_chat_20762), 0));
        }
        menuAdapter.addAll(items);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder((Context)activity).setTitle(title).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                ChatsListContextMenuItem mi = (ChatsListContextMenuItem)((Object)menuAdapter.getItem(which));
                MMChatsListView.this.onSelectContextMenuItem(item, mi);
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
        return true;
    }

    private void onSelectContextMenuItem(MMChatsListItem listItem, ChatsListContextMenuItem mi) {
        if (mi.getAction() == 0) {
            ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
            if (messenger == null) {
                return;
            }
            String sessionId = listItem.getSessionId();
            boolean deleteFlag = false;
            if (StringUtil.isSameString((String)sessionId, (String)"######SYSTEM_NOTIFICATION_SESSION")) {
                PreferenceUtil.saveBooleanValue("system_notification_delete_flag", true);
                int unreadCount = messenger.getUnreadRequestCount();
                if (messenger.setAllRequestAsReaded() && unreadCount > 0) {
                    messenger.syncAllSubScribeReqAsReaded();
                }
                deleteFlag = true;
            } else {
                ZoomChatSession session = messenger.getSessionById(sessionId);
                if (session != null) {
                    session.storeMessageDraft(null);
                }
                deleteFlag = messenger.deleteSession(sessionId, false);
            }
            if (deleteFlag) {
                if (this.mParentFragment != null) {
                    this.mParentFragment.onChatItemDelete(sessionId);
                } else {
                    this.loadData(false, false);
                    this.mAdapter.notifyDataSetChanged();
                }
            }
        }
    }

    private static void startOneToOneChat(ZMActivity activity, ZoomBuddy buddy) {
        MMChatActivity.showAsOneToOneChat(activity, buddy);
    }

    private static void startGroupChat(ZMActivity activity, String groupId) {
        MMChatActivity.showAsGroupChat(activity, groupId);
    }

    public void onGroupAction(int result, GroupAction action, String msgId) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        String sessionId = action.getGroupId();
        if (StringUtil.isEmptyOrNull((String)sessionId)) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            this.mAdapter.removeItem(sessionId);
        } else {
            this.addSessionToAdapter(this.mAdapter, session, messenger, true);
        }
        switch (action.getActionType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.mAvatarCache.removeItem(sessionId);
            }
        }
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onNotifySubscribeRequest() {
        this.refreshSystemNotificationSession();
        this.mAdapter.notifyDataSetChanged();
    }

    public void Indicate_EditMessageResultIml(String actionOwner, String sessionId, String guid, long msgTime, long serverTime, boolean result) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(sessionId);
        if (session == null) {
            this.mAdapter.removeItem(sessionId);
        } else {
            this.addSessionToAdapter(this.mAdapter, session, messenger, false);
        }
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void refreshChatSessionUnread() {
        this.loadData(true, true);
    }

    public void notify_DBLoadSessionLastMessagesDone() {
        this.loadLastMessages4Sync(true);
    }

    public boolean loadLastMessages4Sync(boolean forceLoad) {
        if (!forceLoad && this.mIsSearchLastMsg4SyncLoaded) {
            return false;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return false;
        }
        ArrayList<String> items = new ArrayList<String>();
        for (int i = 0; i < this.mAdapter.getChatsItemsCount() && items.size() < 15; ++i) {
            MMChatsListItem item = this.mAdapter.getChatsItem(i);
            if (item == null) continue;
            items.add(item.getSessionId());
        }
        if (items.isEmpty()) {
            return true;
        }
        messenger.searchSessionLastMessageCtx(items);
        this.mIsSearchLastMsg4SyncLoaded = true;
        return true;
    }

    public void onNotify_MUCGroupInfoUpdatedImpl(String groupID) {
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (StringUtil.isEmptyOrNull((String)groupID)) {
            return;
        }
        ZoomChatSession session = messenger.getSessionById(groupID);
        if (session == null) {
            this.mAdapter.removeItem(groupID);
        } else {
            this.addSessionToAdapter(this.mAdapter, session, messenger, true);
        }
        this.mAvatarCache.removeItem(groupID);
        if (this.isParentFragmentResumed()) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1002 && resultCode == -1) {
            if (data == null) {
                return;
            }
            ScheduledMeetingItem item = (ScheduledMeetingItem)data.getSerializableExtra("meetingItem");
            this.onScheduleSuccess(item);
        }
    }

    private void onScheduleSuccess(final ScheduledMeetingItem item) {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        activity.getNonNullEventTaskManagerOrThrowException().push(new EventAction("onScheduleSuccess"){

            public void run(IUIElement ui) {
                MeetingInfoActivity.show((ZMActivity)ui, item, R.string.zm_title_schedule_or_host_a_meeting_21854, true, 104);
            }
        });
    }

    public void onScrollStateChanged(AbsListView view, int scrollState) {
        if (scrollState == 0) {
            this.searchSessionLastMessageCtx();
        }
    }

    private void searchSessionLastMessageCtx() {
        List<String> items = this.mAdapter.getLoadedItems();
        if (CollectionsUtil.isListEmpty(items)) {
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (items.size() > this.getChildCount()) {
            items = items.subList(items.size() - this.getChildCount(), items.size());
        }
        messenger.searchSessionLastMessageCtx(items);
        this.mAdapter.clearLoadedItemCache();
    }

    public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
    }

    @Override
    public void onRefresh(List<Long> intervals) {
        this.mHandler.removeCallbacks(this.mRefreshUpcomingMeetingRunnable);
        if (!CollectionsUtil.isListEmpty(intervals)) {
            for (Long interval : intervals) {
                if (interval == null) continue;
                this.mHandler.postDelayed(this.mRefreshUpcomingMeetingRunnable, interval + 2000L);
            }
        }
    }

    public static class ChatsListContextMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_DELETE = 0;

        public ChatsListContextMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

