/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.GridView;
import android.widget.ListAdapter;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomGroup;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.view.IMAddrBookItem;
import com.zipow.videobox.view.mm.MMBuddyItem;
import com.zipow.videobox.view.mm.MMChatBuddiesGridViewAdapter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import us.zoom.androidlib.util.CollectionsUtil;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;

public class MMChatBuddiesGridView
extends GridView {
    private static final String TAG = MMChatBuddiesGridView.class.getSimpleName();
    private MMChatBuddiesGridViewAdapter mAdapter;
    private boolean mIsGroup = false;
    private BuddyOperationListener buddyOperationListener;

    public MMChatBuddiesGridView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    public MMChatBuddiesGridView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public MMChatBuddiesGridView(Context context) {
        super(context);
        this.initView(context);
    }

    public void setMax(int max) {
        this.mAdapter.setMax(max);
    }

    public void setBuddyOperationListener(BuddyOperationListener callback) {
        this.buddyOperationListener = callback;
    }

    private void initView(Context context) {
        this.setNumColumns(5);
        this.mAdapter = new MMChatBuddiesGridViewAdapter(context, this);
        if (this.isInEditMode()) {
            this._editmode_loadAllBuddies();
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (MMChatBuddiesGridView.this.mAdapter.isRemoveMode() && event.getAction() != 0 && !MMChatBuddiesGridView.this.isClickOnItems(event)) {
                    MMChatBuddiesGridView.this.setIsRemoveMode(false);
                    return true;
                }
                return false;
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mAdapter.getMax() != 0) {
            super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)UIUtil.dip2px((Context)this.getContext(), (float)200000.0f), (int)Integer.MIN_VALUE));
        } else {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
    }

    private boolean isClickOnItems(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            int top = child.getTop();
            int left = child.getLeft();
            int right = child.getRight();
            int bottom = child.getBottom();
            if (!(x > (float)left) || !(x < (float)right) || !(y > (float)top) || !(y < (float)bottom)) continue;
            return true;
        }
        return false;
    }

    private void _editmode_loadAllBuddies() {
        for (int i = 0; i < 3; ++i) {
            MMBuddyItem item = new MMBuddyItem();
            item.setScreenName("Buddy " + (i + 1));
            this.mAdapter.addItem(item);
        }
        this.mAdapter.setGroupOperatorable(true);
    }

    public void setIsRemoveMode(boolean isRemoveMode) {
        this.mAdapter.setIsRemoveMode(isRemoveMode);
        this.mAdapter.notifyDataSetChanged();
    }

    public void loadAllBuddies(IMAddrBookItem addrItem, String buddyId, String groupId) {
        this.mAdapter.clear();
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)groupId)) {
            this.mIsGroup = true;
            ZoomGroup group = messenger.getGroupById(groupId);
            if (group == null) {
                return;
            }
            String ownerId = group.getGroupOwner();
            ZoomBuddy myself = messenger.getMyself();
            if (myself == null) {
                return;
            }
            this.mAdapter.setGroupOperatorable(group.isGroupOperatorable());
            List<String> admins = group.getGroupAdmins();
            if (!StringUtil.isEmptyOrNull((String)groupId)) {
                if (admins == null) {
                    admins = new ArrayList<String>();
                }
                if (CollectionsUtil.isListEmpty(admins)) {
                    admins.add(ownerId);
                }
            }
            this.mAdapter.setGroupAdmin(admins);
            int count = group.getBuddyCount();
            for (int i = 0; i < count; ++i) {
                ZoomBuddy buddy = group.getBuddyAt(i);
                if (buddy == null) continue;
                IMAddrBookItem abItem = IMAddrBookItem.fromZoomBuddy(buddy);
                MMBuddyItem item = new MMBuddyItem(buddy, abItem);
                if (StringUtil.isSameString((String)buddy.getJid(), (String)myself.getJid())) {
                    item.setIsMySelf(true);
                    String name = myself.getScreenName();
                    if (!StringUtil.isEmptyOrNull((String)name)) {
                        item.setScreenName(name);
                    }
                }
                if (StringUtil.isSameString((String)ownerId, (String)buddy.getJid())) {
                    item.setSortKey("!");
                } else {
                    item.setSortKey(SortUtil.getSortKey((String)item.screenName, (Locale)CompatUtils.getLocalDefault()));
                }
                this.mAdapter.addItem(item);
            }
            this.mAdapter.sort();
        } else {
            this.mIsGroup = false;
            this.mAdapter.setGroupOperatorable(false);
            MMBuddyItem item = null;
            ZoomBuddy buddy = messenger.getBuddyWithJID(buddyId);
            item = buddy != null ? new MMBuddyItem(buddy, addrItem) : new MMBuddyItem(addrItem);
            this.mAdapter.addItem(item);
        }
        List<MMBuddyItem> allItems = this.getAllItems();
        if (allItems != null) {
            for (MMBuddyItem item : allItems) {
                messenger.refreshBuddyVCard(item.getBuddyJid());
            }
        }
    }

    public void notifyDataSetChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    public List<MMBuddyItem> getAllItems() {
        if (this.mAdapter == null) {
            return null;
        }
        return this.mAdapter.getBuddyItems();
    }

    public void onClickAddBtn() {
        if (this.mAdapter.isRemoveMode()) {
            this.setIsRemoveMode(false);
            return;
        }
        if (this.buddyOperationListener != null) {
            this.buddyOperationListener.onClickAddBtn();
        }
    }

    public void onClickRemoveBtn() {
        this.mAdapter.setIsRemoveMode(true);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onClickBuddyRemoveBtn(MMBuddyItem item) {
        if (this.buddyOperationListener != null) {
            this.buddyOperationListener.onRemoveBuddy(item);
        }
    }

    public void onClickBuddyItem(MMBuddyItem item) {
        if (this.mAdapter.isRemoveMode()) {
            this.setIsRemoveMode(false);
            return;
        }
        if (this.buddyOperationListener != null) {
            this.buddyOperationListener.onClickBuddyItem(item);
        }
    }

    public static interface BuddyOperationListener {
        public void onClickAddBtn();

        public void onRemoveBuddy(MMBuddyItem var1);

        public void onClickBuddyItem(MMBuddyItem var1);
    }
}

