/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import com.zipow.videobox.ptapp.mm.BuddyNameUtil;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.view.IMAddrBookItem;
import java.io.Serializable;

public class MMBuddyItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String itemId;
    protected String buddyJid;
    protected String phoneNumber;
    protected String normalizedPhoneNumber;
    protected String screenName;
    protected String contactName;
    protected String avatar;
    protected String email;
    protected String sortKey;
    protected IMAddrBookItem localContact;
    protected boolean myself = false;
    protected boolean isRobot = false;

    public MMBuddyItem() {
    }

    public MMBuddyItem(ZoomBuddy buddy, IMAddrBookItem abItem) {
        if (buddy != null) {
            this.buddyJid = buddy.getJid();
            this.phoneNumber = abItem != null && abItem.getPhoneNumberCount() > 0 ? abItem.getPhoneNumber(0) : buddy.getPhoneNumber();
            this.normalizedPhoneNumber = buddy.getPhoneNumber();
            this.screenName = BuddyNameUtil.getBuddyDisplayName(buddy, abItem, false);
            this.avatar = buddy.getLocalPicturePath();
            this.isRobot = buddy.isRobot();
        } else if (abItem != null) {
            this.isRobot = abItem.getIsRobot();
            this.contactName = abItem.getScreenName();
            this.buddyJid = abItem.getJid();
            if (abItem.getPhoneNumberCount() > 0) {
                this.phoneNumber = abItem.getPhoneNumber(0);
            }
            this.normalizedPhoneNumber = abItem.getNormalizedPhoneNumber(0);
            this.screenName = abItem.getScreenName();
        }
        this.localContact = abItem;
    }

    public MMBuddyItem(IMAddrBookItem abItem) {
        if (abItem != null) {
            this.contactName = abItem.getScreenName();
            this.buddyJid = abItem.getJid();
            this.isRobot = abItem.getIsRobot();
            if (abItem.getPhoneNumberCount() > 0) {
                this.phoneNumber = abItem.getPhoneNumber(0);
            }
            this.normalizedPhoneNumber = abItem.getNormalizedPhoneNumber(0);
            this.screenName = abItem.getScreenName();
            this.avatar = null;
        }
    }

    public boolean isRobot() {
        return this.isRobot;
    }

    public String getBuddyJid() {
        return this.buddyJid;
    }

    public void setBuddyJid(String buddyJid) {
        this.buddyJid = buddyJid;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public String getNormalizedPhoneNumber() {
        return this.normalizedPhoneNumber;
    }

    public void setNormalizedPhoneNumber(String normalizedPhoneNumber) {
        this.normalizedPhoneNumber = normalizedPhoneNumber;
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        this.screenName = screenName;
    }

    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isMySelf() {
        return this.myself;
    }

    public void setIsMySelf(boolean myself) {
        this.myself = myself;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public IMAddrBookItem getLocalContact() {
        return this.localContact;
    }

    public void setLocalContact(IMAddrBookItem localContact) {
        this.localContact = localContact;
    }
}

