/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.Editable;
import android.text.SpannableString;
import android.text.style.ImageSpan;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import com.zipow.videobox.util.EmojiHelper;
import com.zipow.videobox.util.PreferenceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.ZMViewPager;
import us.zoom.videomeetings.R;

public class EmojiInputView
extends LinearLayout {
    private EditText mEmojiInputEditText;
    private LinearLayout mPanelIndicator;
    private ZMViewPager mEmojiPager;
    private int mKeyboardHeight;
    private static final int EMOJI_CELL_HEIGHT_DP = 50;

    public EmojiInputView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public EmojiInputView(Context context) {
        super(context);
        this.init();
    }

    public void setKeyboardHeight(int height) {
        if (height != this.mKeyboardHeight) {
            PreferenceUtil.saveIntValue("keyboard_height", height);
        }
        this.mKeyboardHeight = height;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int miniHeight = UIUtil.dip2px((Context)this.getContext(), (float)150.0f);
        if (this.mPanelIndicator.isShown()) {
            miniHeight += this.mPanelIndicator.getLayoutParams().height;
        }
        int height = miniHeight;
        if (this.getResources().getConfiguration().orientation == 1) {
            height = miniHeight > this.mKeyboardHeight ? miniHeight : this.mKeyboardHeight;
        }
        super.onMeasure(widthMeasureSpec, View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    public void setEmojiInputEditText(EditText editText) {
        this.mEmojiInputEditText = editText;
    }

    private void init() {
        this.setOrientation(1);
        this.mEmojiPager = new ZMViewPager(this.getContext());
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, 0);
        lp.weight = 1.0f;
        this.addView((View)this.mEmojiPager, (ViewGroup.LayoutParams)lp);
        this.mEmojiPager.setAdapter((PagerAdapter)new EmojiAdapter(this.getContext(), EmojiHelper.getInstance().getZMEmojis(), this));
        this.mPanelIndicator = new LinearLayout(this.getContext());
        this.mPanelIndicator.setGravity(17);
        lp = new LinearLayout.LayoutParams(-1, UIUtil.dip2px((Context)this.getContext(), (float)10.0f));
        this.addView((View)this.mPanelIndicator, (ViewGroup.LayoutParams)lp);
        this.mEmojiPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageSelected(int position) {
                EmojiInputView.this.refreshIndicator();
            }

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.refreshIndicator();
        this.mKeyboardHeight = PreferenceUtil.readIntValue("keyboard_height", 0);
    }

    public void onEmojiDelete() {
        if (this.mEmojiInputEditText == null) {
            return;
        }
        this.mEmojiInputEditText.dispatchKeyEvent(new KeyEvent(0, 67));
    }

    public void onEmojiInput(EmojiHelper.EmojiIndex emoji) {
        if (this.mEmojiInputEditText == null || emoji == null) {
            return;
        }
        int start = this.mEmojiInputEditText.getSelectionStart();
        int end = this.mEmojiInputEditText.getSelectionEnd();
        Editable value = this.mEmojiInputEditText.getText();
        SpannableString text = new SpannableString((CharSequence)emoji.getShortCut());
        Drawable dd = this.getResources().getDrawable(emoji.getDrawResource());
        dd.setBounds(0, 0, dd.getIntrinsicWidth(), dd.getIntrinsicHeight());
        ImageSpan is = new ImageSpan(dd);
        text.setSpan((Object)is, 0, text.length(), 33);
        value.replace(start, end, (CharSequence)text);
    }

    private void refreshIndicator() {
        int selectPos = this.mEmojiPager.getCurrentItem();
        PagerAdapter adapter = this.mEmojiPager.getAdapter();
        if (adapter == null || selectPos >= adapter.getCount()) {
            return;
        }
        int count = adapter.getCount();
        this.mPanelIndicator.removeAllViews();
        if (count == 1) {
            this.mPanelIndicator.setVisibility(8);
            return;
        }
        this.mPanelIndicator.setVisibility(0);
        for (int i = 0; i < count; ++i) {
            ImageView imageView = new ImageView(this.getContext());
            int imageRes = R.drawable.zm_btn_switch_scene_selected_normal;
            if (i == selectPos) {
                imageRes = R.drawable.zm_btn_switch_scene_unselected_normal;
            }
            imageView.setImageResource(imageRes);
            int padding = UIUtil.dip2px((Context)this.getContext(), (float)3.0f);
            imageView.setPadding(padding, 0, padding, 0);
            this.mPanelIndicator.addView((View)imageView);
        }
    }

    private static class EmojiAdapter
    extends PagerAdapter
    implements View.OnClickListener {
        private Context mContext;
        private List<EmojiHelper.EmojiIndex> mEmojis;
        private Map<Integer, View> mPanelEmojis = new HashMap<Integer, View>();
        private EmojiInputView mEmojiInputView;

        public EmojiAdapter(Context context, List<EmojiHelper.EmojiIndex> emojis, EmojiInputView emojiInputView) {
            this.mContext = context;
            this.mEmojis = emojis;
            this.mEmojiInputView = emojiInputView;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView(this.mPanelEmojis.get(position));
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View view = this.mPanelEmojis.get(position);
            if (view == null) {
                LinearLayout panel = new LinearLayout(this.mContext);
                panel.setGravity(17);
                panel.setOrientation(1);
                int start = position * 20;
                int end = start + 20;
                LinearLayout panelRow = null;
                for (int i = start; i < end; ++i) {
                    if (panelRow == null || panelRow.getChildCount() == 7) {
                        panelRow = new LinearLayout(this.mContext);
                        panelRow.setOrientation(0);
                        panelRow.setGravity(16);
                        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, UIUtil.dip2px((Context)this.mContext, (float)50.0f));
                        panel.addView((View)panelRow, (ViewGroup.LayoutParams)lp);
                    }
                    ImageView cell = new ImageView(this.mContext);
                    int padding = UIUtil.dip2px((Context)this.mContext, (float)8.0f);
                    cell.setPadding(padding, padding, padding, padding);
                    cell.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    cell.setBackgroundColor(0);
                    if (i < this.mEmojis.size()) {
                        EmojiHelper.EmojiIndex emoji = this.mEmojis.get(i);
                        cell.setImageResource(emoji.getDrawResource());
                        cell.setTag((Object)emoji);
                        cell.setOnClickListener((View.OnClickListener)this);
                    }
                    LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1);
                    lp.weight = 1.0f;
                    panelRow.addView((View)cell, (ViewGroup.LayoutParams)lp);
                }
                ImageView cell = new ImageView(this.mContext);
                int padding = UIUtil.dip2px((Context)this.mContext, (float)8.0f);
                cell.setPadding(padding, padding, padding, padding);
                cell.setScaleType(ImageView.ScaleType.FIT_CENTER);
                cell.setBackgroundColor(0);
                cell.setImageResource(R.drawable.zm_mm_delete_btn);
                cell.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (EmojiAdapter.this.mEmojiInputView != null) {
                            EmojiAdapter.this.mEmojiInputView.onEmojiDelete();
                        }
                    }
                });
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(0, -1);
                lp.weight = 1.0f;
                panelRow.addView((View)cell, (ViewGroup.LayoutParams)lp);
                view = panel;
                this.mPanelEmojis.put(position, view);
            }
            container.addView(view);
            return view;
        }

        public int getCount() {
            if (this.mEmojis == null || this.mEmojis.size() == 0) {
                return 0;
            }
            return (this.mEmojis.size() - 1) / 20 + 1;
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public void onClick(View v) {
            Object tag = v.getTag();
            if (tag instanceof EmojiHelper.EmojiIndex) {
                EmojiHelper.EmojiIndex emoji = (EmojiHelper.EmojiIndex)tag;
                if (this.mEmojiInputView != null) {
                    this.mEmojiInputView.onEmojiInput(emoji);
                }
            }
        }
    }
}

