/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.mm;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.mm.AddCompanyContactsItem;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

class AddCompanyContactsItemView
extends LinearLayout {
    private AddCompanyContactsItem mItem;
    private TextView mTxtScreenName;
    private TextView mTxtEmail;
    private AvatarView mAvatarView;
    private CheckedTextView mCheckbox;

    public AddCompanyContactsItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public AddCompanyContactsItemView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mTxtEmail = (TextView)this.findViewById(R.id.txtEmail);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mCheckbox = (CheckedTextView)this.findViewById(R.id.check);
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_add_favorite_item, (ViewGroup)this);
    }

    public void setScreenName(CharSequence name) {
        if (name != null && this.mTxtScreenName != null) {
            this.mTxtScreenName.setText(name);
        }
    }

    public void setEmail(String email) {
        if (this.mTxtEmail != null) {
            if (email != null) {
                this.mTxtEmail.setText((CharSequence)email);
                this.mTxtEmail.setVisibility(0);
            } else {
                this.mTxtEmail.setVisibility(8);
            }
        }
    }

    public void setAvatar(String imgPathName) {
        if (this.mAvatarView != null) {
            this.mAvatarView.setAvatar(imgPathName, 0);
        }
    }

    private void setChecked(boolean bChecked) {
        if (this.mCheckbox != null) {
            this.mCheckbox.setChecked(bChecked);
        }
    }

    public void setFavoriteItem(AddCompanyContactsItem item) {
        if (item == null) {
            return;
        }
        this.mItem = item;
        String name = this.mItem.getScreenName();
        if (StringUtil.isEmptyOrNull((String)name)) {
            name = this.mItem.getEmail();
            this.setEmail(null);
        } else {
            this.setEmail(this.mItem.getEmail());
        }
        this.setScreenName(name);
        this.setAvatar(this.mItem.getAvatar());
        this.setChecked(this.mItem.isChecked());
    }
}

