/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.bookmark;

import android.util.Base64;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.view.bookmark.BookmarkItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class BookmarkMgr {
    private static final String TAG = BookmarkMgr.class.getSimpleName();
    public static final String BOOKMARK_TITLE = "bookmark_title";
    public static final String BOOKMARK_URL = "bookmark_url";
    public static final String BOOKMARK_ITEM_POS = "bookmark_pos";
    private final int DFT_MAX_NUM = 128;
    private final int MINIMUM_CAPACITY = 32;
    private ArrayList<BookmarkItem> mBookmarks;
    private int mMaxNum = 128;

    public BookmarkMgr() {
        this.init();
    }

    public BookmarkMgr(int max) {
        if (max > 0) {
            this.mMaxNum = max;
        }
        this.init();
    }

    private void init() {
        this.mBookmarks = new ArrayList();
        this.mBookmarks.ensureCapacity(32);
        this.loadBookmarksFromConfig();
    }

    public void clear() {
        this.mBookmarks.clear();
        this.saveBookmarksToConfig();
    }

    public boolean isEmpty() {
        return this.mBookmarks.isEmpty();
    }

    public boolean add(BookmarkItem item) {
        if (this.mBookmarks.size() > this.mMaxNum) {
            return false;
        }
        boolean flag = this.mBookmarks.add(item);
        if (flag) {
            this.saveBookmarksToConfig();
        }
        return flag;
    }

    public int indexOf(Object object) {
        return this.mBookmarks.indexOf(object);
    }

    public BookmarkItem remove(int index) {
        BookmarkItem old = this.mBookmarks.remove(index);
        this.saveBookmarksToConfig();
        return old;
    }

    public boolean remove(Object object) {
        boolean flag = this.mBookmarks.remove(object);
        if (flag) {
            this.saveBookmarksToConfig();
        }
        return flag;
    }

    public BookmarkItem set(int index, BookmarkItem object) {
        BookmarkItem old = this.mBookmarks.set(index, object);
        this.saveBookmarksToConfig();
        return old;
    }

    public BookmarkItem get(int index) {
        return this.mBookmarks.get(index);
    }

    public ArrayList<BookmarkItem> getAll() {
        return this.mBookmarks;
    }

    public int size() {
        return this.mBookmarks.size();
    }

    public List<BookmarkItem> subList(int start, int end) {
        return this.mBookmarks.subList(start, end);
    }

    public Object[] toArray() {
        return this.mBookmarks.toArray();
    }

    public <T> T[] toArray(T[] contents) {
        return this.mBookmarks.toArray(contents);
    }

    public void reload() {
        this.mBookmarks.clear();
        this.loadBookmarksFromConfig();
    }

    private boolean loadBookmarksFromConfig() {
        String strData = PreferenceUtil.readStringValue("bookmarks", null);
        if (strData == null || strData.length() == 0) {
            return false;
        }
        byte[] buff = null;
        try {
            buff = Base64.decode((String)strData, (int)8);
        }
        catch (Exception e) {
            return false;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(buff);
        try {
            ObjectInputStream is = new ObjectInputStream(bis);
            Object obj = is.readObject();
            ArrayList bookmarks = (ArrayList)obj;
            if (!bookmarks.isEmpty()) {
                this.mBookmarks.clear();
                this.mBookmarks.addAll(bookmarks);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void saveBookmarksToConfig() {
        if (this.mBookmarks.isEmpty()) {
            PreferenceUtil.saveStringValue("bookmarks", null);
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream os = new ObjectOutputStream(bos);
            os.writeObject(this.mBookmarks);
        }
        catch (IOException e) {
            return;
        }
        byte[] buff = bos.toByteArray();
        String strData = Base64.encodeToString((byte[])buff, (int)8);
        PreferenceUtil.saveStringValue("bookmarks", strData);
    }
}

