/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.bookmark;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.view.bookmark.BookmarkAdapter;
import com.zipow.videobox.view.bookmark.BookmarkItem;
import com.zipow.videobox.view.bookmark.BookmarkListItemView;
import com.zipow.videobox.view.bookmark.BookmarkMgr;

public class BookmarkListView
extends ListView
implements BookmarkListItemView.onBookmarkItemNotify {
    private BookmarkAdapter mAdapter;
    private BookmarkMgr mBookmarkMgr;
    private boolean bEditMode = false;
    private onChangeListener mListener;

    public BookmarkListView(Context context) {
        super(context);
        this.initView(context);
    }

    public BookmarkListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public BookmarkListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context);
    }

    private void initView(Context context) {
        if (this.isInEditMode()) {
            return;
        }
        this.mBookmarkMgr = new BookmarkMgr();
        this.mAdapter = new BookmarkAdapter(context, this);
        if (this.isInEditMode()) {
            for (int i = 0; i < 5; ++i) {
                this.mAdapter.addItem(new BookmarkItem());
            }
        }
        this.setAdapter((ListAdapter)this.mAdapter);
        this.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                if (position >= BookmarkListView.this.mAdapter.getCount() || position < 0) {
                    return;
                }
                Object item = BookmarkListView.this.getItemAtPosition(position);
                if (item == null) {
                    return;
                }
                if (item instanceof BookmarkItem) {
                    int pos = BookmarkListView.this.mBookmarkMgr.indexOf(item);
                    if (BookmarkListView.this.bEditMode) {
                        if (BookmarkListView.this.mListener != null) {
                            BookmarkListView.this.mListener.onEditItem(pos);
                        }
                    } else if (BookmarkListView.this.mListener != null) {
                        BookmarkListView.this.mListener.onSelectItem((BookmarkItem)item);
                    }
                }
            }
        });
    }

    private void notifyDataChange() {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onDataChange();
    }

    public void registerListener(onChangeListener l) {
        this.mListener = l;
    }

    public void setMode(boolean edit) {
        boolean prevMode = this.bEditMode;
        this.bEditMode = edit;
        if (this.bEditMode != prevMode) {
            this.mAdapter.setMode(this.bEditMode);
            this.notifyDataChange();
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void reloadAllItems() {
        this.mAdapter.clear();
        this.loadAllItems();
        this.notifyDataChange();
        this.mAdapter.notifyDataSetChanged();
    }

    public void loadAllItems() {
        this.mBookmarkMgr.reload();
        this.mAdapter.addAll(this.mBookmarkMgr.getAll());
    }

    public int getItemCount() {
        if (this.mAdapter == null) {
            return 0;
        }
        return this.mAdapter.getCount();
    }

    @Override
    public void onDelete(BookmarkItem item) {
        if (item == null) {
            return;
        }
        this.mBookmarkMgr.remove(item);
        this.mAdapter.remove(item);
        this.notifyDataChange();
        this.mAdapter.notifyDataSetChanged();
    }

    public static interface onChangeListener {
        public void onSelectItem(BookmarkItem var1);

        public void onEditItem(int var1);

        public void onDataChange();
    }
}

