/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.bookmark;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.view.bookmark.BookmarkItem;
import com.zipow.videobox.view.bookmark.BookmarkMgr;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class BookmarkEditViewFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private View mBtnBack;
    private View mBtnSave;
    private EditText mTitle;
    private EditText mURL;
    private int mIndex = -1;
    private String mCurPageTitle;
    private String mCurPageUrl;
    private BookmarkMgr mBookmarMgr = new BookmarkMgr();

    public static void showAsActivity(Fragment fragment, Bundle args, int requestCode) {
        if (fragment == null) {
            return;
        }
        if (args == null) {
            args = new Bundle();
        }
        SimpleActivity.show(fragment, BookmarkEditViewFragment.class.getName(), args, requestCode);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_bookmark_edit_view, container, false);
        this.mBtnBack = view.findViewById(R.id.btnBack);
        this.mBtnSave = view.findViewById(R.id.btnSave);
        this.mTitle = (EditText)view.findViewById(R.id.edtTitle);
        this.mURL = (EditText)view.findViewById(R.id.txtURL);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnSave.setOnClickListener((View.OnClickListener)this);
        Bundle arg = this.getArguments();
        if (arg != null) {
            this.mIndex = arg.getInt("bookmark_pos", -1);
            BookmarkItem item = this.mBookmarMgr.get(this.mIndex);
            if (this.mIndex >= 0 && item != null) {
                this.mCurPageTitle = item.getItemName();
                this.mCurPageUrl = item.getItemUrl();
            }
        }
        if (StringUtil.isEmptyOrNull((String)this.mCurPageUrl)) {
            this.mCurPageUrl = "";
        }
        this.mURL.setText((CharSequence)this.mCurPageUrl);
        if (StringUtil.isEmptyOrNull((String)this.mCurPageTitle)) {
            this.mCurPageTitle = "";
        }
        this.mTitle.setText((CharSequence)this.mCurPageTitle);
        this.checkInput();
        this.mTitle.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s == null) {
                    return;
                }
                String title = s.toString().trim();
                if (StringUtil.isEmptyOrNull((String)title)) {
                    BookmarkEditViewFragment.this.mCurPageTitle = "";
                    return;
                }
                BookmarkEditViewFragment.this.mCurPageTitle = title;
            }
        });
        this.mURL.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s == null) {
                    return;
                }
                String title = s.toString().trim();
                if (StringUtil.isEmptyOrNull((String)title)) {
                    BookmarkEditViewFragment.this.mCurPageUrl = "";
                } else {
                    BookmarkEditViewFragment.this.mCurPageUrl = title;
                }
                BookmarkEditViewFragment.this.checkInput();
            }
        });
        return view;
    }

    private void checkInput() {
        this.mBtnSave.setEnabled(!StringUtil.isEmptyOrNull((String)this.mCurPageUrl));
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    public void onClick(View v) {
        if (v == this.mBtnBack) {
            this.onClickBtnBack();
        } else if (v == this.mBtnSave) {
            this.onClickBtnSave();
        }
    }

    private void onClickBtnSave() {
        if (!StringUtil.isEmptyOrNull((String)this.mCurPageUrl)) {
            BookmarkItem item = new BookmarkItem(this.mCurPageTitle, this.mCurPageUrl);
            this.mBookmarMgr.set(this.mIndex, item);
        }
        this.dismiss();
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }
}

