/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.bookmark;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.TextView;
import com.zipow.videobox.SimpleActivity;
import com.zipow.videobox.view.bookmark.BookmarkItem;
import com.zipow.videobox.view.bookmark.BookmarkMgr;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class BookmarkAddViewFragment
extends ZMDialogFragment
implements View.OnClickListener {
    private View mBtnBack;
    private View mBtnStore;
    private EditText mTitle;
    private TextView mURL;
    private String mCurPageTitle;
    private String mCurPageUrl;
    private BookmarkMgr mBookmarMgr = new BookmarkMgr();

    public static void showAsActivity(Fragment fragment, Bundle args) {
        if (fragment == null) {
            return;
        }
        if (args == null) {
            args = new Bundle();
        }
        SimpleActivity.show(fragment, BookmarkAddViewFragment.class.getName(), args, 0);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View view = inflater.inflate(R.layout.zm_bookmark_add_view, container, false);
        this.mBtnBack = view.findViewById(R.id.btnBack);
        this.mBtnStore = view.findViewById(R.id.btnStore);
        this.mTitle = (EditText)view.findViewById(R.id.edtTitle);
        this.mURL = (TextView)view.findViewById(R.id.txtURL);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnStore.setOnClickListener((View.OnClickListener)this);
        Bundle arg = this.getArguments();
        if (arg != null) {
            this.mCurPageTitle = arg.getString("bookmark_title");
            this.mCurPageUrl = arg.getString("bookmark_url");
        }
        if (this.mCurPageTitle == null) {
            this.mCurPageUrl = "";
        }
        if (this.mCurPageUrl == null) {
            this.mCurPageUrl = "";
        }
        this.mTitle.setText((CharSequence)this.mCurPageTitle);
        this.mURL.setText((CharSequence)this.mCurPageUrl);
        this.checkInput();
        this.mTitle.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s == null) {
                    return;
                }
                String title = s.toString().trim();
                if (StringUtil.isEmptyOrNull((String)title)) {
                    BookmarkAddViewFragment.this.mCurPageTitle = "";
                    return;
                }
                BookmarkAddViewFragment.this.mCurPageTitle = title;
            }
        });
        this.mURL.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s == null) {
                    return;
                }
                String url = s.toString().trim();
                if (StringUtil.isEmptyOrNull((String)url)) {
                    BookmarkAddViewFragment.this.mCurPageUrl = "";
                } else {
                    BookmarkAddViewFragment.this.mCurPageUrl = url;
                }
                BookmarkAddViewFragment.this.checkInput();
            }
        });
        return view;
    }

    private void checkInput() {
        this.mBtnStore.setEnabled(!StringUtil.isEmptyOrNull((String)this.mCurPageUrl));
    }

    public void onPause() {
        super.onPause();
    }

    public void onResume() {
        super.onResume();
    }

    public void onClick(View v) {
        if (v == this.mBtnStore) {
            this.onClickBtnStore();
        } else if (v == this.mBtnBack) {
            this.onClickBtnBack();
        }
    }

    private void onClickBtnBack() {
        this.dismiss();
    }

    private void onClickBtnStore() {
        if (!StringUtil.isEmptyOrNull((String)this.mCurPageUrl)) {
            BookmarkItem item = new BookmarkItem(this.mCurPageTitle, this.mCurPageUrl);
            this.mBookmarMgr.add(item);
        }
        this.dismiss();
    }

    public void dismiss() {
        UIUtil.closeSoftKeyboard((Context)this.getActivity(), (View)this.getView());
        this.finishFragment(true);
    }
}

