/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view.adapter;

import android.content.Context;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckedTextView;
import android.widget.TextView;
import com.zipow.videobox.confapp.meeting.AudioOptionItemModel;
import com.zipow.videobox.confapp.meeting.AudioOptionParcelItem;
import com.zipow.videobox.fragment.AudioOptionFragment;
import com.zipow.videobox.fragment.SelectDialInCountryFragment;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUserProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.widget.adapter.ZmSingleChoiceAdapter;
import us.zoom.androidlib.widget.adapter.ZmSingleChoiceItem;
import us.zoom.androidlib.widget.recyclerviewhelper.RVHAdapter;
import us.zoom.androidlib.widget.recyclerviewhelper.RVHItemClickListener;
import us.zoom.androidlib.widget.recyclerviewhelper.RVHViewHolder;
import us.zoom.videomeetings.R;

public class ZmAudioOptionAdapter
extends RecyclerView.Adapter
implements RVHAdapter {
    private final ZMActivity mActivity;
    private final AudioOptionParcelItem mAudioOptionParcelItem;
    private List<AudioOptionItemModel> mAudioOptionItemModels;

    public ZmAudioOptionAdapter(ZMActivity activity, AudioOptionParcelItem audioOptionParcelItem) {
        this.mActivity = activity;
        this.mAudioOptionParcelItem = audioOptionParcelItem;
        this.updateData();
    }

    public void refresh(List<String> addedCountries, List<String> minusCountries) {
        ArrayList<String> selectedCountries = this.mAudioOptionParcelItem.getmShowSelectedDialInCountries();
        if (selectedCountries == null) {
            selectedCountries = new ArrayList();
        }
        if (minusCountries != null && !minusCountries.isEmpty()) {
            for (String country : minusCountries) {
                int index = selectedCountries.indexOf(country);
                int pos = index + 1;
                if (index == -1 || pos >= this.mAudioOptionItemModels.size()) continue;
                selectedCountries.remove(index);
                this.mAudioOptionItemModels.remove(pos);
                this.notifyItemRemoved(pos);
                if (pos == this.mAudioOptionItemModels.size() - 1) continue;
                this.notifyItemRangeChanged(pos, this.mAudioOptionItemModels.size() - pos);
            }
        }
        if (addedCountries != null && !addedCountries.isEmpty()) {
            ArrayList<AudioOptionItemModel<String>> audioOptionItemModels = new ArrayList<AudioOptionItemModel<String>>();
            for (String country : addedCountries) {
                AudioOptionItemModel<String> audioOptionItemModel = new AudioOptionItemModel<String>(1, country);
                audioOptionItemModels.add(audioOptionItemModel);
            }
            if (this.mAudioOptionItemModels == null) {
                this.mAudioOptionItemModels = new ArrayList<AudioOptionItemModel>();
            }
            int insertStart = this.findInsertedPos();
            this.mAudioOptionItemModels.addAll(insertStart, audioOptionItemModels);
            selectedCountries.addAll(addedCountries);
            this.notifyItemRangeInserted(insertStart, audioOptionItemModels.size());
            if (insertStart != this.mAudioOptionItemModels.size() - 1) {
                this.notifyItemRangeChanged(insertStart, this.mAudioOptionItemModels.size() - insertStart);
            }
        }
        this.mAudioOptionParcelItem.setmSelectedDialInCountries(selectedCountries);
    }

    private void onAudioOptionChange(boolean oldCanEditCountry, boolean curCanEditCountry) {
        if (oldCanEditCountry && !curCanEditCountry) {
            if (this.mAudioOptionItemModels != null && !this.mAudioOptionItemModels.isEmpty()) {
                int start = 0;
                int end = 0;
                start = 1;
                end = this.mAudioOptionItemModels.size() - 1;
                int itemCount = end - start;
                if (itemCount > 0) {
                    for (int i = 0; i <= itemCount; ++i) {
                        this.mAudioOptionItemModels.remove(start);
                    }
                    this.notifyItemRangeRemoved(start, itemCount);
                }
            }
        } else if (!oldCanEditCountry && curCanEditCountry) {
            AudioOptionItemModel<Object> audioOptionItemModel;
            int insertStart = 1;
            ArrayList<String> selectedCountries = this.mAudioOptionParcelItem.getmShowSelectedDialInCountries();
            if (selectedCountries == null) {
                selectedCountries = new ArrayList();
            }
            ArrayList<AudioOptionItemModel<Integer>> audioOptionItemModels = new ArrayList<AudioOptionItemModel<Integer>>();
            for (String country : selectedCountries) {
                audioOptionItemModel = new AudioOptionItemModel<String>(1, country);
                audioOptionItemModels.add(audioOptionItemModel);
            }
            audioOptionItemModel = new AudioOptionItemModel<Integer>(2, 2);
            audioOptionItemModels.add(audioOptionItemModel);
            this.mAudioOptionItemModels.addAll(insertStart, audioOptionItemModels);
            this.notifyItemRangeInserted(insertStart, audioOptionItemModels.size());
            if (insertStart != this.mAudioOptionItemModels.size() - 1) {
                this.notifyItemRangeChanged(insertStart, this.mAudioOptionItemModels.size() - insertStart);
            }
        }
        this.notifyDataSetChanged();
    }

    private int findInsertedPos() {
        if (this.mAudioOptionItemModels == null || this.mAudioOptionItemModels.isEmpty()) {
            return 0;
        }
        return this.mAudioOptionItemModels.size() - 1;
    }

    private void updateData() {
        ArrayList<AudioOptionItemModel> audioOptionItemModels = new ArrayList<AudioOptionItemModel>();
        AudioOptionItemModel<Object> audioOptionItemModel = new AudioOptionItemModel<ArrayList<String>>(0, this.mAudioOptionParcelItem.getmShowSelectedDialInCountries());
        audioOptionItemModels.add(audioOptionItemModel);
        ArrayList<String> selectedCountries = this.mAudioOptionParcelItem.getmShowSelectedDialInCountries();
        if (selectedCountries != null && !selectedCountries.isEmpty()) {
            for (String country : selectedCountries) {
                audioOptionItemModel = new AudioOptionItemModel<String>(1, country);
                audioOptionItemModels.add(audioOptionItemModel);
            }
        }
        if (this.mAudioOptionParcelItem.isCanEditCountry()) {
            audioOptionItemModel = new AudioOptionItemModel<Integer>(2, 2);
            audioOptionItemModels.add(audioOptionItemModel);
        }
        this.mAudioOptionItemModels = audioOptionItemModels;
    }

    public ArrayList<String> getSelectedCountries() {
        if (this.mAudioOptionItemModels != null && !this.mAudioOptionItemModels.isEmpty()) {
            ArrayList<String> selectedCountries = new ArrayList<String>();
            for (AudioOptionItemModel audioOptionItemModel : this.mAudioOptionItemModels) {
                String country;
                if (audioOptionItemModel == null || audioOptionItemModel.type != 1 || StringUtil.isEmptyOrNull((String)(country = (String)audioOptionItemModel.data))) continue;
                selectedCountries.add(country);
            }
            return selectedCountries;
        }
        return null;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return new HeaderViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.zm_item_audio_option, parent, false));
        }
        if (viewType == 2) {
            return new FooterViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.zm_item_audio_option_footer, parent, false));
        }
        return new SelectedCountryViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.zm_item_selected_dial_in_country, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        if (holder instanceof HeaderViewHolder) {
            HeaderViewHolder headerViewHolder = (HeaderViewHolder)holder;
            headerViewHolder.bind((Context)this.mActivity, this.mAudioOptionParcelItem.getmSelectedAudioType());
        } else if (holder instanceof FooterViewHolder) {
            FooterViewHolder footerViewHolder = (FooterViewHolder)holder;
            footerViewHolder.bind(this.mAudioOptionParcelItem.isIncludeTollFree());
        } else if (holder instanceof SelectedCountryViewHolder) {
            String country = this.mAudioOptionItemModels.get((int)position).data.toString();
            SelectedCountryViewHolder selectedCountryViewHolder = (SelectedCountryViewHolder)holder;
            selectedCountryViewHolder.bind(country);
        }
    }

    public int getItemViewType(int position) {
        return this.mAudioOptionItemModels.get((int)position).type;
    }

    public int getItemCount() {
        return this.mAudioOptionItemModels == null ? 0 : this.mAudioOptionItemModels.size();
    }

    public boolean onItemMove(int fromPosition, int toPosition) {
        this.swap(fromPosition, toPosition);
        return false;
    }

    public void onItemDismiss(int position, int direction) {
        this.remove(position);
    }

    public boolean isCanSwipe() {
        ArrayList<String> selectedCountries = this.mAudioOptionParcelItem.getmShowSelectedDialInCountries();
        return selectedCountries != null && selectedCountries.size() > 1;
    }

    private void remove(int position) {
        this.mAudioOptionItemModels.remove(position);
        this.notifyItemRemoved(position);
        this.mAudioOptionParcelItem.setmSelectedDialInCountries(this.getSelectedCountries());
    }

    private void swap(int firstPosition, int secondPosition) {
        Collections.swap(this.mAudioOptionItemModels, firstPosition, secondPosition);
        this.notifyItemMoved(firstPosition, secondPosition);
    }

    public class FooterViewHolder
    extends RecyclerView.ViewHolder
    implements View.OnClickListener {
        final CheckedTextView chkIncludeTollFree;

        public FooterViewHolder(View itemView) {
            super(itemView);
            this.chkIncludeTollFree = (CheckedTextView)itemView.findViewById(R.id.chkIncludeTollFree);
            itemView.findViewById(R.id.optionIncludeTollFree).setOnClickListener((View.OnClickListener)this);
            itemView.findViewById(R.id.txtEditCountry).setOnClickListener((View.OnClickListener)this);
        }

        public void bind(boolean isChecked) {
            this.chkIncludeTollFree.setChecked(isChecked);
        }

        public void onClick(View v) {
            AudioOptionFragment audioOptionFragment;
            int id2 = v.getId();
            if (id2 == R.id.optionIncludeTollFree) {
                boolean isChecked = !this.chkIncludeTollFree.isChecked();
                this.chkIncludeTollFree.setChecked(isChecked);
                ZmAudioOptionAdapter.this.mAudioOptionParcelItem.setIncludeTollFree(isChecked);
            } else if (id2 == R.id.txtEditCountry && (audioOptionFragment = AudioOptionFragment.getAudioOptionFragment(ZmAudioOptionAdapter.this.mActivity)) != null) {
                SelectDialInCountryFragment.showAsActivity((Fragment)audioOptionFragment, 1, this.getDialInCountries(), ZmAudioOptionAdapter.this.mAudioOptionParcelItem.getmShowSelectedDialInCountries());
            }
        }

        private ArrayList<SelectDialInCountryFragment.DialInCountry> getDialInCountries() {
            ArrayList<SelectDialInCountryFragment.DialInCountry> dialInCountries = new ArrayList<SelectDialInCountryFragment.DialInCountry>();
            List<String> allCountries = ZmAudioOptionAdapter.this.mAudioOptionParcelItem.getmAllDialInCountries();
            if (allCountries != null && !allCountries.isEmpty()) {
                ArrayList<String> selectedCountries = ZmAudioOptionAdapter.this.mAudioOptionParcelItem.getmShowSelectedDialInCountries();
                if (selectedCountries == null) {
                    selectedCountries = new ArrayList();
                }
                for (String country : ZmAudioOptionAdapter.this.mAudioOptionParcelItem.getmAllDialInCountries()) {
                    dialInCountries.add(new SelectDialInCountryFragment.DialInCountry(country, selectedCountries.contains(country)));
                }
            }
            return dialInCountries;
        }
    }

    public class HeaderViewHolder
    extends RecyclerView.ViewHolder {
        final RecyclerView recyclerViewAudioOption;
        final ZmSingleChoiceAdapter mAudioOptionAdapter;
        final TextView txtDialInSelectDesc;

        public HeaderViewHolder(View itemView) {
            super(itemView);
            this.recyclerViewAudioOption = (RecyclerView)itemView.findViewById(R.id.recyclerViewAudioOption);
            this.recyclerViewAudioOption.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(itemView.getContext()));
            this.txtDialInSelectDesc = (TextView)itemView.findViewById(R.id.txtDialInSelectDesc);
            this.mAudioOptionAdapter = new ZmSingleChoiceAdapter();
            this.recyclerViewAudioOption.setAdapter((RecyclerView.Adapter)this.mAudioOptionAdapter);
            this.recyclerViewAudioOption.addOnItemTouchListener((RecyclerView.OnItemTouchListener)new RVHItemClickListener((Context)ZmAudioOptionAdapter.this.mActivity, new RVHItemClickListener.OnItemClickListener(){

                public void onItemClick(View view, int position) {
                    ZmSingleChoiceItem zmSingleChoiceItem = HeaderViewHolder.this.mAudioOptionAdapter.getItem(position);
                    if (zmSingleChoiceItem != null) {
                        boolean oldCanEditCountry = ZmAudioOptionAdapter.this.mAudioOptionParcelItem.isCanEditCountry();
                        ZmAudioOptionAdapter.this.mAudioOptionParcelItem.setmSelectedAudioType((Integer)zmSingleChoiceItem.getData());
                        boolean curCanEditCountry = ZmAudioOptionAdapter.this.mAudioOptionParcelItem.isCanEditCountry();
                        ZmAudioOptionAdapter.this.onAudioOptionChange(oldCanEditCountry, curCanEditCountry);
                    }
                }
            }));
        }

        public void bind(Context context, int selectedAudioOption) {
            this.initAudioOption(context, selectedAudioOption);
            this.txtDialInSelectDesc.setVisibility(ZmAudioOptionAdapter.this.mAudioOptionParcelItem.isCanEditCountry() ? 0 : 8);
        }

        private void initAudioOption(Context context, int selectedAudioOption) {
            PTUserProfile profile = PTApp.getInstance().getCurrentUserProfile();
            if (profile == null) {
                return;
            }
            ArrayList<ZmSingleChoiceItem> audioOptionChoiceItemList = new ArrayList<ZmSingleChoiceItem>();
            new Integer(1);
            ZmSingleChoiceItem audioOptionChoiceItem = new ZmSingleChoiceItem((Object)0, context.getString(R.string.zm_lbl_audio_option_voip), R.drawable.zm_group_type_select, context.getString(R.string.zm_accessibility_icon_item_selected_19247), selectedAudioOption == 0);
            audioOptionChoiceItemList.add(audioOptionChoiceItem);
            if (!profile.isDisablePSTN()) {
                audioOptionChoiceItem = new ZmSingleChoiceItem((Object)1, context.getString(R.string.zm_lbl_audio_option_telephony), R.drawable.zm_group_type_select, context.getString(R.string.zm_accessibility_icon_item_selected_19247), selectedAudioOption == 1);
                audioOptionChoiceItemList.add(audioOptionChoiceItem);
                if (!profile.isScheduleAudioBothDisabled()) {
                    audioOptionChoiceItem = new ZmSingleChoiceItem((Object)2, context.getString(R.string.zm_lbl_audio_option_voip_and_telephony), R.drawable.zm_group_type_select, context.getString(R.string.zm_accessibility_icon_item_selected_19247), selectedAudioOption == 2);
                    audioOptionChoiceItemList.add(audioOptionChoiceItem);
                }
            }
            if (profile.hasSelfTelephony()) {
                audioOptionChoiceItem = new ZmSingleChoiceItem((Object)3, context.getString(R.string.zm_lbl_audio_option_3rd_party), R.drawable.zm_group_type_select, context.getString(R.string.zm_accessibility_icon_item_selected_19247), selectedAudioOption == 3);
                audioOptionChoiceItemList.add(audioOptionChoiceItem);
            }
            this.mAudioOptionAdapter.setmZmSingleChoiceItemList(audioOptionChoiceItemList);
        }
    }

    public class SelectedCountryViewHolder
    extends RecyclerView.ViewHolder
    implements RVHViewHolder {
        final TextView txtCountry;

        public SelectedCountryViewHolder(View itemView) {
            super(itemView);
            this.txtCountry = (TextView)itemView.findViewById(R.id.txtCountry);
        }

        public void bind(String country) {
            this.txtCountry.setText((CharSequence)country);
        }

        public void onItemSelected(int actionState) {
            if (actionState != 0) {
                this.itemView.setPressed(true);
            }
        }

        public void onItemClear() {
            this.itemView.setPressed(false);
        }
    }
}

