/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.zipow.videobox.view.IFeccListener;
import com.zipow.videobox.view.ZMFeccEventTimeRunnable;
import us.zoom.videomeetings.R;

public class ZMPieView
extends RelativeLayout {
    private static final String TAG = ZMPieView.class.getSimpleName();
    private ImageView mBackground;
    private ImageView mLeft;
    private ImageView mRight;
    private ImageView mUp;
    private ImageView mDown;
    private float mBgX = 0.0f;
    private float mBgY = 0.0f;
    private float mBgRadius = 0.0f;
    private int mEvent = 0;
    private Handler mHandler;
    private IFeccListener mListener;
    private ZMFeccEventTimeRunnable mTimeRunnable;

    public ZMPieView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public ZMPieView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public ZMPieView(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
        this.inflateLayout();
        this.mBackground = (ImageView)this.findViewById(R.id.imgCircle);
        this.mLeft = (ImageView)this.findViewById(R.id.imgFocusLeft);
        this.mRight = (ImageView)this.findViewById(R.id.imgFocusRight);
        this.mUp = (ImageView)this.findViewById(R.id.imgFocusUp);
        this.mDown = (ImageView)this.findViewById(R.id.imgFocusDown);
        this.mHandler = new Handler();
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_pie_view, (ViewGroup)this);
    }

    public void setListener(IFeccListener l) {
        this.mListener = l;
    }

    private int getAngleByCoordinat(float x1, float y1, float x2, float y2) {
        double angle = Math.atan2(y2 - y1, x2 - x1);
        int value = Math.round((float)(angle / Math.PI * 180.0));
        if (value < 0) {
            value += 360;
        }
        return value;
    }

    private float getRadius(float circleX, float circleY, float x, float y) {
        float w = Math.abs(x - circleX);
        float h = Math.abs(y - circleY);
        double radius = Math.sqrt(w * w + h * h);
        return (float)radius;
    }

    private void refreshUI() {
        if (this.mEvent == 0 || this.mEvent == -1) {
            this.mLeft.setVisibility(8);
            this.mRight.setVisibility(8);
            this.mUp.setVisibility(8);
            this.mDown.setVisibility(8);
        } else if (this.mEvent == 1) {
            this.mLeft.setVisibility(8);
            this.mRight.setVisibility(8);
            this.mUp.setVisibility(8);
            this.mDown.setVisibility(0);
        } else if (this.mEvent == 2) {
            this.mLeft.setVisibility(8);
            this.mRight.setVisibility(8);
            this.mUp.setVisibility(0);
            this.mDown.setVisibility(8);
        } else if (this.mEvent == 3) {
            this.mLeft.setVisibility(0);
            this.mRight.setVisibility(8);
            this.mUp.setVisibility(8);
            this.mDown.setVisibility(8);
        } else if (this.mEvent == 4) {
            this.mLeft.setVisibility(8);
            this.mRight.setVisibility(0);
            this.mUp.setVisibility(8);
            this.mDown.setVisibility(8);
        }
    }

    private int getEvent(float x, float y) {
        float radius = this.getRadius(this.mBgX, this.mBgY, x, y);
        int event = 0;
        if (radius > this.mBgRadius) {
            return -1;
        }
        int angle = this.getAngleByCoordinat(this.mBgX, this.mBgY, x, y);
        if (angle >= 45 && angle < 135) {
            event = 1;
        } else if (angle >= 135 && angle < 225) {
            event = 3;
        } else if (angle >= 225 && angle < 315) {
            event = 2;
        } else if (angle >= 315 || angle < 45) {
            event = 4;
        }
        return event;
    }

    private void updateEvent(int event) {
        this.mEvent = event;
        if (this.mTimeRunnable != null) {
            this.mTimeRunnable.updateEvent(this.mEvent);
        }
    }

    private boolean handleTouchEvent(int action, float x, float y) {
        boolean ret = false;
        int event = this.getEvent(x, y);
        this.updateEvent(event);
        if (this.mEvent == -1) {
            if (this.mTimeRunnable != null) {
                this.mHandler.removeCallbacks((Runnable)this.mTimeRunnable);
            }
            if (this.mListener != null) {
                this.mListener.onFeccClick(3, this.mEvent);
            }
            return false;
        }
        if (action == 0) {
            if (this.mListener != null) {
                this.mListener.onFeccClick(1, this.mEvent);
            }
            if (this.mTimeRunnable == null) {
                this.mTimeRunnable = new ZMFeccEventTimeRunnable();
            }
            this.mTimeRunnable.initial(this.mEvent, this.mHandler, this.mListener);
            this.mHandler.postDelayed((Runnable)this.mTimeRunnable, 300L);
            ret = true;
        } else if (action == 1) {
            if (this.mTimeRunnable != null) {
                this.mHandler.removeCallbacks((Runnable)this.mTimeRunnable);
            }
            if (this.mListener != null) {
                this.mListener.onFeccClick(3, this.mEvent);
            }
            this.playSoundEffect(0);
            this.updateEvent(0);
            ret = true;
        } else if (action == 2) {
            ret = true;
        }
        return ret;
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean ret;
        if (this.mBgX <= 0.0f || this.mBgY <= 0.0f) {
            int[] location = new int[2];
            this.mBackground.getLocationOnScreen(location);
            this.mBgX = location[0] + this.mBackground.getWidth() / 2;
            this.mBgY = location[1] + this.mBackground.getHeight() / 2;
            this.mBgRadius = this.mBackground.getWidth() / 2;
        }
        if (ret = this.handleTouchEvent(event.getAction(), event.getRawX(), event.getRawY())) {
            this.refreshUI();
            return true;
        }
        return super.onTouchEvent(event);
    }
}

