/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.load.resource.gif.GifDrawable;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.zipow.videobox.util.GifException;
import com.zipow.videobox.util.ZMGlideRequestListener;
import com.zipow.videobox.util.ZMGlideUtil;
import us.zoom.androidlib.util.UIUtil;

@TargetApi(value=11)
public class ZMGifView
extends ImageView {
    private float mScale = 1.0f;
    private float mFitXScale = 1.0f;
    private float mFitYScale = 1.0f;
    private int mGifWidth;
    private int mGifHeight;
    private int mRatio = -1;
    private int[] mRadius;
    private Rect mCoverRect = null;
    private Paint mCoverPaint = null;
    private String mGifPath;
    private boolean fitXY = false;
    private int mMaxWidth;
    private int mMaxHeight;
    private static final String TAG = ZMGifView.class.getSimpleName();
    private Target mTarget;
    private ZMGlideRequestListener mGifRequestListener;

    public ZMGifView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public ZMGifView(Context context) {
        super(context);
    }

    public void enableFitXY() {
        this.fitXY = true;
    }

    public void setRatio(int ratio) {
        this.mRatio = ratio;
    }

    public void setmScale(float mScale) {
        this.mScale = mScale;
    }

    public void clearRatio() {
        this.mRatio = -1;
    }

    public void setRadius(int[] radius) {
        if (radius == null || radius.length != 4) {
            return;
        }
        this.mRadius = radius;
    }

    public void setRadius(int radius) {
        this.setRadius(new int[]{radius, radius, radius, radius});
    }

    public void setGifResourse(String path) {
        this.setGifRemoteResourse(path, null);
    }

    public void setGifRemoteResourse(String path, ZMGlideRequestListener gifRequestListener) {
        this.setTag(null);
        if (TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        if (this.mGifPath != null) {
            this.clear();
        }
        this.mGifPath = path;
        this.mGifRequestListener = gifRequestListener;
        if (this.getLayerType() != 1) {
            this.setLayerType(1, null);
        }
        this.loadAndShowImage();
    }

    private void loadAndShowImage() {
        RequestListener<GifDrawable> requestListener = new RequestListener<GifDrawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<GifDrawable> target, boolean isFirstResource) {
                if (ZMGifView.this.mGifRequestListener != null) {
                    ZMGifView.this.mGifRequestListener.onError(ZMGifView.this.mGifPath, new GifException("RequestListener.onLoadFailed", (Throwable)e));
                }
                return false;
            }

            public boolean onResourceReady(GifDrawable resource, Object model, Target<GifDrawable> target, DataSource dataSource, boolean isFirstResource) {
                return false;
            }
        };
        this.mTarget = new SimpleTarget<GifDrawable>(){

            public void onResourceReady(GifDrawable resource, Transition<? super GifDrawable> transition) {
                int width = UIUtil.dip2px((Context)ZMGifView.this.getContext(), (float)resource.getIntrinsicWidth());
                int height = UIUtil.dip2px((Context)ZMGifView.this.getContext(), (float)resource.getIntrinsicHeight());
                if (width != ZMGifView.this.mGifWidth || height != ZMGifView.this.mGifHeight) {
                    ZMGifView.this.mGifHeight = height;
                    ZMGifView.this.mGifWidth = width;
                }
                ZMGifView.this.setImageDrawable((Drawable)resource);
                if (ZMGifView.this.mGifRequestListener != null) {
                    ZMGifView.this.mGifRequestListener.onSuccess(ZMGifView.this.mGifPath);
                }
                resource.start();
            }
        };
        ZMGlideUtil.loadGif(this.getContext(), this.mTarget, this.mGifPath, (RequestListener)requestListener);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mGifWidth == 0 || this.mGifHeight == 0) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            int paddingLeft = this.getPaddingLeft();
            int paddingTop = this.getPaddingTop();
            int paddingRight = this.getPaddingRight();
            int paddingBottom = this.getPaddingBottom();
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            if (widthSpecMode == 0x40000000) {
                int heightSpecSize;
                int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                float widthScale = (float)(widthSpecSize - paddingLeft - paddingRight) / ((float)this.mGifWidth + 0.0f);
                if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
                    heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                    float heightScale = (float)(heightSpecSize - paddingLeft - paddingRight) / ((float)this.mGifHeight + 0.0f);
                    if (this.fitXY) {
                        this.mFitXScale = widthScale;
                        this.mFitYScale = heightScale;
                    } else {
                        this.mScale = widthScale > heightScale ? heightScale : widthScale;
                    }
                } else {
                    this.mScale = widthScale;
                    heightSpecSize = (int)(this.mScale * (float)this.mGifHeight) + paddingTop + paddingBottom;
                }
                this.setMeasuredDimension(widthSpecSize, heightSpecSize);
            } else {
                int maxWidth = this.getMaxWidth();
                int maxHeight = this.getMaxHeight();
                if (maxWidth == 0) {
                    maxWidth = UIUtil.getDisplayWidth((Context)this.getContext());
                }
                if (maxHeight == 0) {
                    maxHeight = UIUtil.getDisplayHeight((Context)this.getContext());
                }
                maxWidth = maxWidth - paddingLeft - paddingRight;
                maxHeight = maxHeight - paddingTop - paddingBottom;
                if (this.mGifWidth >= maxWidth || this.mGifHeight >= maxHeight) {
                    float widthScale = (float)maxWidth / ((float)this.mGifWidth + 0.0f);
                    float heightScale = (float)maxHeight / ((float)this.mGifHeight + 0.0f);
                    this.mScale = widthScale > heightScale ? heightScale : widthScale;
                }
                this.setMeasuredDimension((int)((float)this.mGifWidth * this.mScale) + paddingLeft + paddingRight, (int)((float)this.mGifHeight * this.mScale) + paddingTop + paddingBottom);
            }
        }
    }

    public void setMaxHeight(int maxHeight) {
        super.setMaxHeight(maxHeight);
        this.mMaxHeight = maxHeight;
    }

    public void setMaxWidth(int maxWidth) {
        super.setMaxWidth(maxWidth);
        this.mMaxWidth = maxWidth;
    }

    public int getMaxHeight() {
        if (Build.VERSION.SDK_INT >= 16) {
            return super.getMaxHeight();
        }
        return this.mMaxHeight;
    }

    public int getMaxWidth() {
        if (Build.VERSION.SDK_INT >= 16) {
            return super.getMaxWidth();
        }
        return this.mMaxWidth;
    }

    public Path getShapePath(int width, int height) {
        if (width == 0 || height == 0 || this.mRadius == null) {
            return null;
        }
        int arcX = 0;
        int arcY = 0;
        RectF oval = null;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        Path path = new Path();
        path.moveTo((float)(paddingLeft + this.mRadius[0]), (float)paddingTop);
        path.lineTo((float)(width - this.mRadius[1] - paddingRight), (float)paddingTop);
        if (this.mRadius[1] != 0) {
            arcX = width - 2 * this.mRadius[1] - paddingRight;
            arcY = paddingTop;
            oval = this.getArcOval(arcX, arcY, this.mRadius[1]);
            path.arcTo(oval, 270.0f, 90.0f);
        }
        path.lineTo((float)(width - paddingRight), (float)(height - this.mRadius[2] - paddingBottom));
        if (this.mRadius[2] != 0) {
            arcX = width - 2 * this.mRadius[2] - paddingRight;
            arcY = height - 2 * this.mRadius[2] - paddingBottom;
            oval = this.getArcOval(arcX, arcY, this.mRadius[2]);
            path.arcTo(oval, 0.0f, 90.0f);
        }
        path.lineTo((float)(this.mRadius[3] + paddingLeft), (float)(height - paddingBottom));
        if (this.mRadius[3] != 0) {
            arcX = paddingLeft;
            arcY = height - 2 * this.mRadius[3] - paddingBottom;
            oval = this.getArcOval(arcX, arcY, this.mRadius[3]);
            path.arcTo(oval, 90.0f, 90.0f);
        }
        path.lineTo((float)paddingLeft, (float)(this.mRadius[0] + paddingTop));
        if (this.mRadius[0] != 0) {
            arcX = paddingLeft;
            arcY = paddingTop;
            oval = this.getArcOval(arcX, arcY, this.mRadius[0]);
            path.arcTo(oval, 180.0f, 90.0f);
        }
        return path;
    }

    private RectF getArcOval(int arcX, int arcY, int radius) {
        RectF oval = new RectF();
        oval.left = arcX;
        oval.top = arcY;
        oval.right = arcX + radius * 2;
        oval.bottom = arcY + radius * 2;
        return oval;
    }

    protected void onDraw(Canvas canvas) {
        Path path;
        int viewWidth = this.getMeasuredWidth();
        int viewHeight = this.getMeasuredHeight();
        if (viewHeight == 0 || viewWidth == 0) {
            viewWidth = canvas.getWidth();
            viewHeight = canvas.getHeight();
        }
        if ((path = this.getShapePath(viewWidth, viewHeight)) != null) {
            boolean notSupportClip;
            canvas.save();
            boolean bl = notSupportClip = Build.VERSION.SDK_INT <= 17 && this.isHardwareAccelerated();
            if (!notSupportClip) {
                canvas.clipPath(path);
            }
        }
        super.onDraw(canvas);
        if (path != null) {
            if (this.mRatio >= 0 && this.mRatio < 100) {
                int height = viewHeight * (100 - this.mRatio) / 100;
                if (this.mCoverRect == null) {
                    this.mCoverRect = new Rect(0, 0, viewWidth, height);
                } else {
                    this.mCoverRect.right = viewWidth;
                    this.mCoverRect.bottom = height;
                }
                if (this.mCoverPaint == null) {
                    this.mCoverPaint = new Paint();
                    this.mCoverPaint.setColor(Integer.MIN_VALUE);
                }
                canvas.drawRect(this.mCoverRect, this.mCoverPaint);
            }
            canvas.restore();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.clear();
    }

    private void clear() {
        this.mTarget = null;
        this.mGifRequestListener = null;
        this.mGifPath = null;
        this.mGifWidth = 0;
        this.mGifHeight = 0;
    }
}

