/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.qa.ZoomQABuddy;
import com.zipow.videobox.util.ConfLocalHelper;
import com.zipow.videobox.util.ZMConfUtil;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.BaseAttendeeItem;
import com.zipow.videobox.view.ConfChatAttendeeItem;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.SortUtil;
import us.zoom.videomeetings.R;

public class WebinarRaiseHandListItem
extends BaseAttendeeItem {
    private static final long serialVersionUID = 4804252551400086512L;
    public static int ITEM_TYPE_PANELIST = 1;
    public static int ITEM_TYPE_ATTENDEE = 2;
    private boolean mIsShowGuest;
    private String mName;
    private String mJid;
    private long mUserId;
    private int mType;
    private long mRaiseHandTimestamp;
    private String sortKey;

    public ConfChatAttendeeItem getConfChatAttendeeItem() {
        ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(this.mUserId);
        if (buddy != null) {
            return new ConfChatAttendeeItem(buddy);
        }
        return null;
    }

    public WebinarRaiseHandListItem(String name, String Jid, long nodeId, int type) {
        this.set(name, Jid, nodeId, type);
    }

    public WebinarRaiseHandListItem(ZoomQABuddy buddy) {
        if (buddy != null) {
            this.set(buddy.getName(), buddy.getJID(), buddy.getNodeID(), ITEM_TYPE_ATTENDEE);
            this.mRaiseHandTimestamp = buddy.getRaiseHandTimestamp();
            this.mIsShowGuest = ConfLocalHelper.isGuest(buddy) && !ConfLocalHelper.isGuestForMyself();
            this.isSupportTempTalk = buddy.isAttendeeSupportTemporarilyFeature();
            if (this.isSupportTempTalk) {
                this.isAllowTalked = buddy.isAttendeeCanTalk();
                this.updateAudio(this.mUserId);
            }
        }
    }

    public WebinarRaiseHandListItem(CmmUser user) {
        if (user != null) {
            this.mIsShowGuest = ConfLocalHelper.isGuest(user) && !ConfLocalHelper.isGuestForMyself();
            this.mRaiseHandTimestamp = user.getRaiseHandTimestamp();
            this.set(user.getScreenName(), null, user.getNodeId(), ITEM_TYPE_PANELIST);
        }
    }

    private void set(String name, String Jid, long nodeId, int type) {
        this.mName = name;
        this.mJid = Jid;
        this.mUserId = nodeId;
        this.mType = type;
        this.sortKey = SortUtil.getSortKey((String)name, (Locale)CompatUtils.getLocalDefault());
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public String getName() {
        return this.mName;
    }

    public String getJid() {
        return this.mJid;
    }

    public long getUserId() {
        return this.mUserId;
    }

    public int getItemType() {
        return this.mType;
    }

    public long getmRaiseHandTimestamp() {
        return this.mRaiseHandTimestamp;
    }

    public static WebinarRaiseHandListItem getWebinarAttendeeItemByNodeId(long nodeId) {
        ZoomQABuddy buddy = ZMConfUtil.getZoomQABuddyByNodeId(nodeId);
        if (buddy == null) {
            return null;
        }
        if (buddy.getRole() != 0) {
            return null;
        }
        return new WebinarRaiseHandListItem(buddy);
    }

    private View createViewByType(Context context) {
        View view = null;
        if (this.mType == ITEM_TYPE_PANELIST) {
            view = View.inflate((Context)context, (int)R.layout.zm_plist_item, null);
            view.setTag((Object)"panelist");
        } else if (this.mType == ITEM_TYPE_ATTENDEE) {
            view = View.inflate((Context)context, (int)R.layout.zm_qa_webinar_attendee_item, null);
            view.setTag((Object)"attendeeList");
        }
        return view;
    }

    public View getView(Context context, View convertView) {
        View view = convertView;
        boolean createView = false;
        if (view == null) {
            createView = true;
        } else if (this.mType == ITEM_TYPE_PANELIST) {
            if (!"panelist".equals(convertView.getTag())) {
                createView = true;
            }
        } else if (this.mType == ITEM_TYPE_ATTENDEE && !"attendeeList".equals(convertView.getTag())) {
            createView = true;
        }
        if (createView) {
            view = this.createViewByType(context);
        }
        this.bindView(context, view);
        return view;
    }

    private void bindView(Context context, View view) {
        view.setBackgroundResource(this.mIsShowGuest ? R.drawable.zm_list_selector_guest : R.color.zm_transparent);
        if (this.mType == ITEM_TYPE_PANELIST) {
            AvatarView avatarView = (AvatarView)view.findViewById(R.id.avatarView);
            TextView txtScreenName = (TextView)view.findViewById(R.id.txtScreenName);
            TextView txtRole = (TextView)view.findViewById(R.id.txtRole);
            view.findViewById(R.id.imgArrow).setVisibility(8);
            view.findViewById(R.id.txtUnreadMessageCount).setVisibility(8);
            view.findViewById(R.id.imgAudio).setVisibility(8);
            view.findViewById(R.id.imgVideo).setVisibility(8);
            view.findViewById(R.id.imgRecording).setVisibility(8);
            view.findViewById(R.id.imgCMRRecording).setVisibility(8);
            View attention = view.findViewById(R.id.imgAttention);
            if (attention != null) {
                attention.setVisibility(8);
            }
            txtScreenName.setText((CharSequence)this.mName);
            avatarView.setName(this.mName);
            txtRole.setVisibility(8);
        } else if (this.mType == ITEM_TYPE_ATTENDEE) {
            ImageView imgAudio = (ImageView)view.findViewById(R.id.imgAudio);
            TextView txtScreenName = (TextView)view.findViewById(R.id.txtName);
            TextView txtRole = (TextView)view.findViewById(R.id.txtRole);
            txtScreenName.setText((CharSequence)this.mName);
            txtRole.setVisibility(8);
            if (this.isSupportTempTalk && this.audioType != 2L) {
                imgAudio.setVisibility(0);
                imgAudio.setContentDescription((CharSequence)context.getString(this.audioOn ? R.string.zm_description_plist_status_audio_on : R.string.zm_description_plist_status_audio_off));
                imgAudio.setImageResource(ZMConfUtil.getAudioImageResId(view.isInEditMode(), this.audioOn, this.audioType, this.mUserId));
                Drawable drawable2 = imgAudio.getDrawable();
                if (drawable2 instanceof AnimationDrawable) {
                    ((AnimationDrawable)drawable2).start();
                }
            } else {
                imgAudio.setVisibility(8);
            }
        }
    }

    public static class WebinarAttendeeItemComparator
    implements Comparator<WebinarRaiseHandListItem> {
        private Collator mCollator;

        public WebinarAttendeeItemComparator(Locale locale) {
            this.mCollator = Collator.getInstance(locale);
            this.mCollator.setStrength(0);
        }

        @Override
        public int compare(WebinarRaiseHandListItem lhs, WebinarRaiseHandListItem rhs) {
            if (lhs == rhs) {
                return 0;
            }
            long delta = lhs.getmRaiseHandTimestamp() - rhs.getmRaiseHandTimestamp();
            if (delta > 0L) {
                return 1;
            }
            if (delta < 0L) {
                return -1;
            }
            return this.mCollator.compare(lhs.getSortKey(), rhs.getSortKey());
        }
    }
}

