/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.bo.BOMgr;
import com.zipow.videobox.view.WaitingListAdapter;
import com.zipow.videobox.view.WaitingListItem;
import java.util.List;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.StringUtil;

public class WaitingListView
extends ListView {
    private static final String TAG = WaitingListView.class.getSimpleName();
    private WaitingListAdapter mAdapter;
    private String mFilter;

    public WaitingListView(Context context) {
        super(context);
        this.initView(context);
    }

    public WaitingListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public WaitingListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mAdapter = new WaitingListAdapter(context);
        this.setItemsCanFocus(true);
        if (this.isInEditMode()) {
            this._editmode_loadAllItems(this.mAdapter);
        } else {
            this.loadAllItems(this.mAdapter);
        }
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    private void _editmode_loadAllItems(WaitingListAdapter adapter) {
        for (int i = 0; i < 10; ++i) {
            WaitingListItem item = new WaitingListItem();
            item.userId = i;
            item.screenName = "User " + i;
            adapter.addItem(item, null);
        }
    }

    private void loadAllItems(WaitingListAdapter adapter) {
        if (adapter == null) {
            return;
        }
        List<CmmUser> lists = ConfMgr.getInstance().getClientOnHoldUserList();
        for (CmmUser user : lists) {
            if (user == null) continue;
            WaitingListItem item = new WaitingListItem(user);
            adapter.addItem(item, this.mFilter);
        }
    }

    public void reloadAllItems() {
        this.mAdapter.clear();
        this.loadAllItems(this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    private boolean checkUserValid(CmmUser user) {
        if (user != null) {
            boolean isFailoverUser = user.isFailoverUser();
            BOMgr boMgr = ConfMgr.getInstance().getBOMgr();
            boolean userInBO = user.isInBOMeeting();
            if (!isFailoverUser || boMgr != null && boMgr.isInBOMeeting() == userInBO) {
                return true;
            }
        }
        return false;
    }

    public void onUserJoin(long userId, int flag) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (this.checkUserValid(user) && ConfMgr.getInstance().isUserOnHold(user)) {
            WaitingListItem item = new WaitingListItem(user);
            this.mAdapter.addItem(item, this.mFilter);
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public void onUserLeave(long userId, int flag) {
        this.mAdapter.removeItem(userId);
        this.mAdapter.notifyDataSetChanged();
    }

    public void onUserUpdate(int cmd, long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        if (user == null) {
            return;
        }
        if (!this.checkUserValid(user)) {
            return;
        }
        if (ConfMgr.getInstance().isUserOnHold(user)) {
            WaitingListItem item = new WaitingListItem(user);
            this.mAdapter.updateItem(item, this.mFilter);
        } else {
            this.mAdapter.removeItem(userId);
        }
        this.mAdapter.notifyDataSetChanged();
    }

    public void filter(String filter) {
        if (filter == null) {
            filter = "";
        }
        filter = filter.trim().toLowerCase(CompatUtils.getLocalDefault());
        String oldFilter = this.mFilter;
        this.mFilter = filter;
        if (oldFilter == null) {
            oldFilter = "";
        }
        if (oldFilter.equals(filter)) {
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)filter)) {
            if (!StringUtil.isEmptyOrNull((String)oldFilter) && filter.contains(oldFilter)) {
                this.mAdapter.filter(filter);
                this.mAdapter.notifyDataSetChanged();
            } else {
                this.reloadAllItems();
            }
        } else {
            this.reloadAllItems();
        }
    }
}

