/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmAttentionTrackMgr;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.CmmUser;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.view.AvatarView;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class WaitingListItem
implements View.OnClickListener,
View.OnLongClickListener {
    public String screenName;
    public String userFBID;
    public long userId;
    public String avatar;
    private Button mBtnAdmin;

    public WaitingListItem() {
    }

    public WaitingListItem(CmmUser user) {
        this.update(user);
    }

    public WaitingListItem(long userId) {
        CmmUser user = ConfMgr.getInstance().getUserById(userId);
        this.update(user);
    }

    private WaitingListItem update(CmmUser user) {
        if (user == null) {
            return this;
        }
        this.screenName = user.getScreenName();
        this.userFBID = user.getUserFBID();
        this.userId = user.getNodeId();
        this.avatar = user.getSmallPicPath();
        return this;
    }

    public View getView(Context context, View convertView) {
        View view = convertView;
        if (view == null || !"waitinglist".equals(view.getTag())) {
            view = View.inflate((Context)context, (int)R.layout.zm_waitinglist_item, null);
            view.setTag((Object)"waitinglist");
        }
        AvatarView avatarView = (AvatarView)view.findViewById(R.id.avatarView);
        TextView txtScreenName = (TextView)view.findViewById(R.id.txtScreenName);
        this.mBtnAdmin = (Button)view.findViewById(R.id.btnAdmin);
        ImageView imgAttention = (ImageView)view.findViewById(R.id.imgAttention);
        txtScreenName.setText((CharSequence)this.screenName);
        avatarView.setName(this.screenName);
        if (!view.isInEditMode()) {
            boolean isShare;
            CmmConfContext confContext;
            ConfMgr confMgr = ConfMgr.getInstance();
            CmmUser user = confMgr.getUserById(this.userId);
            if (user != null) {
                if (user.isPureCallInUser()) {
                    avatarView.setAvatar(R.drawable.zm_phone_avatar);
                } else if (user.isH323User()) {
                    avatarView.setAvatar(R.drawable.zm_h323_avatar);
                } else {
                    avatarView.setAvatar(this.avatar);
                }
            }
            if ((confContext = confMgr.getConfContext()).isMeetingSupportSilentMode()) {
                this.mBtnAdmin.setVisibility(0);
                if (confContext.supportPutUserinWaitingListUponEntryFeature()) {
                    this.mBtnAdmin.setText((CharSequence)context.getString(R.string.zm_btn_admit));
                } else {
                    this.mBtnAdmin.setText((CharSequence)context.getString(R.string.zm_mi_leave_silent_mode));
                }
            } else {
                this.mBtnAdmin.setVisibility(8);
            }
            CmmUser myself = confMgr.getMyself();
            CmmAttentionTrackMgr atMgr = confMgr.getAttentionTrackAPI();
            ShareSessionMgr shareMgr = confMgr.getShareObj();
            boolean bl = isShare = shareMgr != null && (shareMgr.getShareStatus() == 3 || shareMgr.getShareStatus() == 2);
            if (atMgr != null && atMgr.isConfAttentionTrackEnabled() && isShare && (myself.isHost() || myself.isCoHost() || myself.isBOModerator())) {
                imgAttention.setVisibility(4);
            } else {
                imgAttention.setVisibility(8);
            }
        }
        view.setOnLongClickListener((View.OnLongClickListener)this);
        this.mBtnAdmin.setOnClickListener((View.OnClickListener)this);
        return view;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnAdmin) {
            this.onClickAdmin();
        }
    }

    private void onClickAdmin() {
        this.doAdmitCmd();
    }

    private void onClickRemove() {
        ConfMgr mgr = ConfMgr.getInstance();
        if (mgr == null) {
            return;
        }
        mgr.handleUserCmd(29, this.userId);
    }

    public void doAdmitCmd() {
        ConfMgr mgr = ConfMgr.getInstance();
        if (mgr == null) {
            return;
        }
        mgr.handleUserCmd(42, this.userId);
    }

    public boolean onLongClick(View v) {
        if (v == null) {
            return false;
        }
        Context context = v.getContext();
        if (context == null) {
            return false;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (!confContext.isMeetingSupportSilentMode() && !confContext.supportPutUserinWaitingListUponEntryFeature()) {
            return false;
        }
        ZMMenuAdapter menuAdapter = new ZMMenuAdapter(context, false);
        WaitingListActionMenuItem item = new WaitingListActionMenuItem(context.getString(R.string.zm_btn_remove), 0);
        menuAdapter.addItem((IZMMenuItem)item);
        ZMAlertDialog dialog = new ZMAlertDialog.Builder(context).setAdapter((ListAdapter)menuAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                WaitingListItem.this.onClickRemove();
            }
        }).create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
        return false;
    }

    public static class WaitingListActionMenuItem
    extends ZMSimpleMenuItem {
        public static final int ACTION_REMOVE = 0;

        public WaitingListActionMenuItem(String label, int action) {
            super(action, label);
        }
    }
}

