/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.dialog.LeaveAlertDialog;
import com.zipow.videobox.ptapp.MeetingInfo;
import com.zipow.videobox.util.TimeFormatUtil;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class WaitingJoinView
extends LinearLayout
implements View.OnClickListener {
    private Button mBtnLeave = null;
    private View mPanelTitle;
    private TextView mTxtTopic = null;
    private TextView mTxtMeetingId = null;
    private TextView mTxtDate = null;
    private TextView mTxtTime = null;
    private View mPanelForScheduler = null;
    private Button mBtnLogin = null;
    private View mPanelDate = null;
    private TextView mTxtWaitingMessage = null;
    private String mCustomMeetingId;

    public WaitingJoinView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public WaitingJoinView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mBtnLeave = (Button)this.findViewById(R.id.btnLeave);
        this.mTxtTopic = (TextView)this.findViewById(R.id.txtTopic);
        this.mTxtMeetingId = (TextView)this.findViewById(R.id.txtMeetingId);
        this.mTxtTopic = (TextView)this.findViewById(R.id.txtTopic);
        this.mTxtDate = (TextView)this.findViewById(R.id.txtDate);
        this.mTxtTime = (TextView)this.findViewById(R.id.txtTime);
        this.mBtnLogin = (Button)this.findViewById(R.id.btnLogin);
        this.mPanelForScheduler = this.findViewById(R.id.panelForScheduler);
        this.mPanelDate = this.findViewById(R.id.tableRowDate);
        this.mPanelTitle = this.findViewById(R.id.panelTitle);
        this.mTxtWaitingMessage = (TextView)this.findViewById(R.id.txtWaiting);
        this.mBtnLeave.setOnClickListener((View.OnClickListener)this);
        this.mBtnLogin.setOnClickListener((View.OnClickListener)this);
        this.updateData();
    }

    public void setTitlePadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.mPanelTitle.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_waiting_join, (ViewGroup)this);
    }

    public void updateData() {
        if (this.isInEditMode()) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        MeetingInfo meetingInfo = confContext.getMeetingItem();
        if (meetingInfo == null) {
            return;
        }
        this.mTxtTopic.setText((CharSequence)meetingInfo.getTopic());
        if (!StringUtil.isEmptyOrNull((String)this.mCustomMeetingId)) {
            this.mTxtMeetingId.setText((CharSequence)this.mCustomMeetingId);
        } else {
            this.mTxtMeetingId.setText((CharSequence)StringUtil.formatConfNumber((long)meetingInfo.getMeetingNumber()));
        }
        if (meetingInfo.getType() == MeetingInfo.MeetingType.REPEAT) {
            this.mPanelDate.setVisibility(8);
            this.mTxtTime.setText(R.string.zm_lbl_time_recurring);
        } else {
            this.mTxtDate.setText((CharSequence)TimeFormatUtil.formatDate(this.getContext(), meetingInfo.getStartTime() * 1000L, false));
            this.mTxtTime.setText((CharSequence)TimeFormatUtil.formatTime(this.getContext(), meetingInfo.getStartTime() * 1000L));
        }
        if (this.isWebinearViewOnlyWaitingInPracticeStatus()) {
            this.mTxtWaitingMessage.setText(R.string.zm_msg_waiting_webinear_start);
        } else if (meetingInfo.getProgressingMeetingCount() > 0) {
            this.mTxtWaitingMessage.setText(R.string.zm_msg_waiting_for_has_in_meeting);
        } else {
            this.mTxtWaitingMessage.setText(R.string.zm_msg_waiting_for_scheduler);
        }
        if ((this.isWebinearViewOnlyWaitingInPracticeStatus() || VideoBoxApplication.getInstance().isSDKMode()) && this.mPanelForScheduler != null) {
            this.mPanelForScheduler.setVisibility(8);
        }
    }

    public void setCustomMeetingId(String meetingId) {
        this.mCustomMeetingId = meetingId;
    }

    private boolean isWebinearViewOnlyWaitingInPracticeStatus() {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return false;
        }
        MeetingInfo item = confContext.getMeetingItem();
        if (item == null) {
            return false;
        }
        int waitingStatus = item.getMeetingWaitStatus();
        return confContext.isWebinar() && ConfMgr.getInstance().isViewOnlyMeeting() && waitingStatus == 3;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnLeave) {
            this.onClickBtnLeave();
        } else if (id2 == R.id.btnLogin) {
            this.onClickBtnLogin();
        }
    }

    private void onClickBtnLogin() {
        ConfMgr.getInstance().notifyPTStartLogin("Login to start meeting");
        ((ZMActivity)this.getContext()).finish();
    }

    private void onClickBtnLeave() {
        new LeaveAlertDialog().show(((ZMActivity)this.getContext()).getSupportFragmentManager(), LeaveAlertDialog.class.getName());
    }
}

