/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import us.zoom.videomeetings.R;

public class ToolbarButton
extends LinearLayout {
    private View.OnClickListener mOnClickListener;
    private ImageView mImgIcon;
    private TextView mTxtTitle;
    private TextView mTxtNoteBubble;

    public ToolbarButton(Context context) {
        this(context, null);
    }

    public ToolbarButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0);
    }

    @SuppressLint(value={"NewApi"})
    public ToolbarButton(Context context, AttributeSet attrs, int style2) {
        super(context, attrs, style2);
        this.init(context, attrs, style2);
    }

    private void init(Context context, AttributeSet attrs, int style2) {
        float verticalDivider;
        View.inflate((Context)this.getContext(), (int)R.layout.zm_toolbar_button, (ViewGroup)this);
        this.mImgIcon = (ImageView)this.findViewById(R.id.icon);
        this.mTxtTitle = (TextView)this.findViewById(R.id.title);
        this.mTxtNoteBubble = (TextView)this.findViewById(R.id.txtNoteBubble);
        if (context == null || attrs == null) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ToolbarButton);
        int resId = a.getResourceId(R.styleable.ToolbarButton_zm_icon, 0);
        float textSize = a.getDimension(R.styleable.ToolbarButton_zm_textSize, 0.0f);
        if (textSize != 0.0f) {
            this.mTxtTitle.setTextSize(0, textSize);
        }
        if ((verticalDivider = a.getDimension(R.styleable.ToolbarButton_zm_vertical_divide_icon_text, 0.0f)) != 0.0f) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mImgIcon.getLayoutParams();
            layoutParams.bottomMargin = (int)verticalDivider;
            this.mImgIcon.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        this.setImageResource(resId);
        String text = a.getString(R.styleable.ToolbarButton_zm_text);
        this.setText(text);
        if (a.hasValue(R.styleable.ToolbarButton_zm_textColor)) {
            ColorStateList colors = a.getColorStateList(R.styleable.ToolbarButton_zm_textColor);
            if (colors != null) {
                this.mTxtTitle.setTextColor(colors);
            } else {
                int color2 = a.getColor(R.styleable.ToolbarButton_zm_textColor, 0);
                this.mTxtTitle.setTextColor(color2);
            }
        }
        a.recycle();
        super.setOnClickListener(new View.OnClickListener(){
            private long mLastClickTime = 0L;

            public void onClick(View view) {
                if (ToolbarButton.this.mOnClickListener == null) {
                    return;
                }
                long curTime = SystemClock.elapsedRealtime();
                if (curTime - this.mLastClickTime > 500L) {
                    ToolbarButton.this.mOnClickListener.onClick(view);
                }
                this.mLastClickTime = curTime;
            }
        });
    }

    public void setText(CharSequence text) {
        if (this.mTxtTitle != null) {
            if (text == null || text.length() == 0) {
                this.mTxtTitle.setVisibility(8);
            } else {
                this.mTxtTitle.setText(text);
            }
        }
    }

    public void setText(int resId) {
        if (this.mTxtTitle != null) {
            if (resId <= 0) {
                this.mTxtTitle.setVisibility(8);
            } else {
                this.mTxtTitle.setText(resId);
            }
        }
    }

    public void setTextColor(ColorStateList colorStateList) {
        if (this.mTxtTitle != null) {
            this.mTxtTitle.setTextColor(colorStateList);
        }
    }

    public void setTextStyle(int style2) {
        if (this.mTxtTitle != null) {
            this.mTxtTitle.setTypeface(null, style2);
        }
    }

    public void setImageResource(int resId) {
        if (this.mImgIcon != null) {
            this.mImgIcon.setImageResource(resId);
        }
    }

    public void setIconBackgroundResource(int resId) {
        if (this.mImgIcon != null) {
            this.mImgIcon.setBackgroundResource(resId);
        }
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if (this.mImgIcon != null) {
            this.mImgIcon.setPadding(left, top, right, bottom);
        }
    }

    public void setIconSize(int width, int height) {
        if (this.mImgIcon != null) {
            ViewGroup.LayoutParams layoutParams = this.mImgIcon.getLayoutParams();
            layoutParams.width = width;
            layoutParams.height = height;
            this.mImgIcon.setLayoutParams(layoutParams);
        }
    }

    public void setIconScaleType(ImageView.ScaleType scaleType) {
        if (this.mImgIcon != null) {
            this.mImgIcon.setScaleType(scaleType);
        }
    }

    public void setNoteMessage(CharSequence message) {
        if (this.mTxtNoteBubble == null) {
            return;
        }
        this.mTxtNoteBubble.setText(message);
        if (message == null || message.length() == 0) {
            this.mTxtNoteBubble.setVisibility(8);
        } else {
            this.mTxtNoteBubble.setVisibility(0);
            String contentDescription = this.getContext().getResources().getString(R.string.zm_accessibility_unread_message_19147, new Object[]{message});
            this.mTxtNoteBubble.setContentDescription((CharSequence)contentDescription);
        }
    }

    public void setNoteMessage(int count) {
        if (this.mTxtNoteBubble == null) {
            return;
        }
        if (count <= 0) {
            this.mTxtNoteBubble.setVisibility(8);
        } else {
            this.mTxtNoteBubble.setVisibility(0);
            this.mTxtNoteBubble.setText((CharSequence)(count > 99 ? "99+" : String.valueOf(count)));
        }
    }

    public void setOnClickListener(View.OnClickListener l) {
        this.mOnClickListener = l;
    }
}

