/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.text.Html;
import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.method.LinkMovementMethod;
import android.text.method.Touch;
import android.text.style.ClickableSpan;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.view.EmojiTextView;

public class TextViewFixTouchConsume
extends EmojiTextView {
    static final String TAG = TextViewFixTouchConsume.class.getSimpleName();
    boolean dontConsumeNonUrlClicks = true;
    boolean linkHit;

    public TextViewFixTouchConsume(Context context) {
        super(context);
    }

    public TextViewFixTouchConsume(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public TextViewFixTouchConsume(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.linkHit = false;
        boolean res = super.onTouchEvent(event);
        if (this.dontConsumeNonUrlClicks) {
            return this.linkHit;
        }
        return res;
    }

    public boolean hasFocusable() {
        return false;
    }

    public void setTextViewHTML(String html) {
        Spanned sequence = Html.fromHtml((String)html);
        SpannableStringBuilder strBuilder = new SpannableStringBuilder((CharSequence)sequence);
        this.setText((CharSequence)strBuilder);
    }

    public static class LocalLinkMovementMethod
    extends LinkMovementMethod {
        static LocalLinkMovementMethod sInstance;

        public static LocalLinkMovementMethod getInstance() {
            if (sInstance == null) {
                sInstance = new LocalLinkMovementMethod();
            }
            return sInstance;
        }

        public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
            try {
                int action = event.getAction();
                if (action == 1 || action == 0) {
                    int line;
                    int x = (int)event.getX();
                    int y = (int)event.getY();
                    x -= widget.getTotalPaddingLeft();
                    y -= widget.getTotalPaddingTop();
                    Layout layout2 = widget.getLayout();
                    int off = layout2.getOffsetForHorizontal(line = layout2.getLineForVertical(y += widget.getScrollY()), (float)(x += widget.getScrollX()));
                    ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
                    if (link.length != 0) {
                        if (action == 1) {
                            link[0].onClick((View)widget);
                        } else {
                            Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                        }
                        if (widget instanceof TextViewFixTouchConsume) {
                            ((TextViewFixTouchConsume)widget).linkHit = true;
                        }
                        return true;
                    }
                    Selection.removeSelection((Spannable)buffer);
                    Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
                    return false;
                }
                return Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

