/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.provider.Settings;
import android.view.Display;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.zipow.annotate.AnnoToolType;
import com.zipow.annotate.AnnotateView;
import com.zipow.annotate.ZoomShareData;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.confapp.ShareSessionMgr;
import com.zipow.videobox.share.ColorSelectedImage;
import com.zipow.videobox.share.ColorTable;
import com.zipow.videobox.share.IColorChangedListener;
import com.zipow.videobox.share.ZMDrawObject;
import com.zipow.videobox.view.ToolbarButton;
import com.zipow.videobox.view.ToolbarDragView;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.UiModeUtil;
import us.zoom.videomeetings.R;

public class ShareToolbar
implements View.OnClickListener,
IColorChangedListener {
    private static final String TAG = ShareToolbar.class.getSimpleName();
    private Map<String, LocationParamForScreen> loctParams = new HashMap<String, LocationParamForScreen>();
    private LocationParamForScreen loctParamNow;
    private final Context mContext = VideoBoxApplication.getInstance();
    private final WindowManager mWindowManager = (WindowManager)this.mContext.getSystemService("window");
    private final int mMaxUnitWidth;
    private final int mToolBarMargin;
    private WindowManager.LayoutParams mToolbarLayoutParams;
    private WindowManager.LayoutParams mColorLayoutParams;
    private ToolbarDragView mViewToolbar;
    private AnnotateView mDrawingView;
    private View mSpotlight;
    private View mPen;
    private View mHighlight;
    private View mLine;
    private View mRectangle;
    private View mOval;
    private View mText;
    private View mUndo;
    private View mRedo;
    private View mClear;
    private View mColorIndicator;
    private ToolbarButton mAnnotation;
    private View mColorLayoutView;
    private View mColorDismissView;
    private View mToolbarBg;
    private int mLineWidth = 2;
    private ColorTable mColorTable;
    private TextView mTxtLineWidth;
    private SeekBar mLineWidthSeekBar;
    private ColorSelectedImage mColorImage;
    private boolean isAnnotationOff = false;
    private Listener mListener;
    private Display mDisplay;

    public ShareToolbar(Listener listener) {
        this.mListener = listener;
        Resources res = this.mContext.getResources();
        this.mMaxUnitWidth = (int)res.getDimension(R.dimen.zm_share_toolbar_unit_maxWidth);
        if (this.mWindowManager != null) {
            this.mDisplay = this.mWindowManager.getDefaultDisplay();
        }
        this.mToolBarMargin = (int)res.getDimension(R.dimen.zm_share_toolbar_margin);
        this.loctParamNow = new LocationParamForScreen();
        this.loctParams.put(this.mDisplay.getWidth() + ":" + this.mDisplay.getHeight(), this.loctParamNow);
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext != null) {
            this.isAnnotationOff = confContext.isAnnoationOff();
        }
        this.init();
    }

    public void updateLayoutparameter() {
        if (this.mViewToolbar == null || this.mToolbarLayoutParams == null) {
            return;
        }
        this.setToolbarLayoutParamsWidth(this.mToolbarLayoutParams);
        String screenType = this.mDisplay.getWidth() + ":" + this.mDisplay.getHeight();
        LocationParamForScreen temp = this.loctParams.get(screenType);
        if (temp == null) {
            temp = new LocationParamForScreen();
            temp.marginLeft = this.mToolBarMargin;
            temp.marginTop = this.mDisplay.getHeight() - this.mViewToolbar.getHeight() - this.mToolBarMargin;
            this.loctParams.put(screenType, temp);
        }
        if (this.loctParamNow.dragged) {
            this.loctParamNow.marginLeft = this.mToolbarLayoutParams.x;
            this.loctParamNow.marginTop = this.mToolbarLayoutParams.y;
        }
        this.loctParamNow.dragged = false;
        this.loctParamNow = temp;
        this.mToolbarLayoutParams.x = this.loctParamNow.marginLeft;
        this.mToolbarLayoutParams.y = this.loctParamNow.marginTop;
        if (this.mToolbarLayoutParams.x + this.mToolbarLayoutParams.width > this.mDisplay.getWidth()) {
            this.mToolbarLayoutParams.x = this.mDisplay.getWidth() - this.mToolbarLayoutParams.width;
        }
        if (this.mToolbarLayoutParams.y + this.mViewToolbar.getHeight() > this.mDisplay.getHeight()) {
            this.mToolbarLayoutParams.y = this.mDisplay.getHeight() - this.mViewToolbar.getHeight();
        }
        this.mWindowManager.updateViewLayout((View)this.mViewToolbar, (ViewGroup.LayoutParams)this.mToolbarLayoutParams);
        this.updateColorViewLayout();
    }

    private void setToolbarLayoutParamsWidth(WindowManager.LayoutParams lp) {
        if (lp == null) {
            return;
        }
        int mSceenWidth = Math.min(this.mDisplay.getWidth(), this.mDisplay.getHeight());
        ViewGroup parent = (ViewGroup)this.mAnnotation.getParent();
        int visiableNo = 0;
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChildAt(i).getVisibility() != 0) continue;
            ++visiableNo;
        }
        int mUnitWidth = (mSceenWidth - 4 * this.mToolBarMargin) / visiableNo;
        mUnitWidth = mUnitWidth > this.mMaxUnitWidth ? this.mMaxUnitWidth : mUnitWidth;
        this.mToolbarLayoutParams.width = visiableNo * mUnitWidth + 2 * this.mToolBarMargin;
    }

    public void toggleAnnotation(boolean start) {
        if (this.mViewToolbar == null) {
            return;
        }
        if (start) {
            if (this.isAnnotationStart()) {
                return;
            }
            this.mSpotlight.setVisibility(0);
            this.mPen.setVisibility(0);
            this.mHighlight.setVisibility(0);
            this.mUndo.setVisibility(0);
            this.mRedo.setVisibility(0);
            this.mClear.setVisibility(0);
            this.mColorIndicator.setVisibility(0);
            int isTablet = UIUtil.isTablet((Context)this.mContext) ? 0 : 8;
            this.mLine.setVisibility(isTablet);
            this.mRectangle.setVisibility(isTablet);
            this.mOval.setVisibility(isTablet);
            this.mAnnotation.setText(R.string.zm_btn_stop_annotation);
            this.mAnnotation.setBackgroundResource(R.drawable.zm_toolbar_stopannotation_bgcolor);
            this.mDrawingView.setEditModel(true);
            this.showAnnotation();
            this.setAnnotateDisable(false);
        } else {
            if (!this.isAnnotationStart()) {
                return;
            }
            this.mSpotlight.setVisibility(8);
            this.mPen.setVisibility(8);
            this.mHighlight.setVisibility(8);
            this.mUndo.setVisibility(8);
            this.mRedo.setVisibility(8);
            this.mClear.setVisibility(8);
            this.mLine.setVisibility(8);
            this.mRectangle.setVisibility(8);
            this.mOval.setVisibility(8);
            this.mColorIndicator.setVisibility(8);
            this.mAnnotation.setText(R.string.zm_btn_start_annotation);
            this.mAnnotation.setBackgroundResource(R.drawable.zm_toolbar_annotation_bgcolor);
            this.mDrawingView.setVisibility(8);
            this.mDrawingView.setEditModel(false);
            this.setAnnotateDisable(true);
        }
        this.onAnnoStatusChanged();
        this.updateLayoutparameter();
    }

    private void init() {
        try {
            if (!this.isAnnotationOff) {
                this.addAnnotation();
                this.addColorView();
            }
            this.addToolbar();
            ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
            if (null != shareMgr) {
                boolean isShareLocked = shareMgr.isAttendeeAnnotationDisabledForMySharedContent();
                ZoomShareData.getInstance().setAttendeeAnnotateDisable(isShareLocked);
            }
            this.setAnnotateDisable(true);
        }
        catch (Exception e) {
            this.mDrawingView = null;
            this.mViewToolbar = null;
            this.mColorDismissView = null;
            this.mColorLayoutView = null;
        }
    }

    public void showToolbar() {
        if (this.mViewToolbar == null || this.mViewToolbar.getParent() == null) {
            return;
        }
        this.mViewToolbar.setVisibility(0);
    }

    private int getWindowLayoutParamsType() {
        if (OsUtil.isAtLeastN() && (Settings.canDrawOverlays((Context)this.mContext) || VideoBoxApplication.getInstance().isSDKMode())) {
            return CompatUtils.getSystemAlertWindowType((int)2003);
        }
        return CompatUtils.getSystemAlertWindowType((int)2005);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void addColorView() {
        this.mColorDismissView = new View(this.mContext);
        this.mColorDismissView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                if (ShareToolbar.this.mColorLayoutView != null && ShareToolbar.this.mColorDismissView != null) {
                    ShareToolbar.this.mColorLayoutView.setVisibility(8);
                    ShareToolbar.this.mColorDismissView.setVisibility(8);
                }
                return false;
            }
        });
        WindowManager.LayoutParams colorDismissViewParams = new WindowManager.LayoutParams();
        colorDismissViewParams.type = this.getWindowLayoutParamsType();
        colorDismissViewParams.format = 1;
        colorDismissViewParams.flags |= 0x528;
        colorDismissViewParams.width = -1;
        colorDismissViewParams.height = -1;
        this.mWindowManager.addView(this.mColorDismissView, (ViewGroup.LayoutParams)colorDismissViewParams);
        this.mColorLayoutView = View.inflate((Context)this.mContext, (int)R.layout.zm_annocolorlayout, null);
        this.mColorTable = (ColorTable)this.mColorLayoutView.findViewById(R.id.colorTable);
        this.mTxtLineWidth = (TextView)this.mColorLayoutView.findViewById(R.id.txtLineWidth);
        this.mColorTable.setOnColorChangedListener(this);
        this.mLineWidthSeekBar = (SeekBar)this.mColorLayoutView.findViewById(R.id.seekbar);
        this.mLineWidthSeekBar.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onStopTrackingTouch(SeekBar arg0) {
                ShareToolbar.this.mDrawingView.setToolWidth(ShareToolbar.this.mLineWidth, true);
            }

            public void onStartTrackingTouch(SeekBar arg0) {
            }

            public void onProgressChanged(SeekBar arg0, int value, boolean arg2) {
                ShareToolbar.this.mLineWidth = value > 0 ? value : 1;
                ShareToolbar.this.updateLineWidthPromt();
            }
        });
        this.mColorDismissView.setVisibility(8);
        this.mColorLayoutParams = new WindowManager.LayoutParams();
        this.mColorLayoutParams.type = this.getWindowLayoutParamsType();
        this.mColorLayoutParams.flags |= 0x528;
        this.mColorLayoutParams.format = 1;
        this.mColorLayoutParams.height = -2;
        this.mWindowManager.addView(this.mColorLayoutView, (ViewGroup.LayoutParams)this.mColorLayoutParams);
        this.mColorLayoutView.setVisibility(8);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void addToolbar() {
        this.mViewToolbar = (ToolbarDragView)View.inflate((Context)this.mContext, (int)R.layout.zm_share_toolbar, null);
        this.mToolbarBg = this.mViewToolbar.findViewById(R.id.toolbar_bg);
        this.mAnnotation = (ToolbarButton)this.mViewToolbar.findViewById(R.id.btnAnnotation);
        this.mSpotlight = this.mViewToolbar.findViewById(R.id.btnSpotlight);
        this.mPen = this.mViewToolbar.findViewById(R.id.btnPen);
        this.mHighlight = this.mViewToolbar.findViewById(R.id.btnHighlight);
        this.mLine = this.mViewToolbar.findViewById(R.id.btnAutoLine);
        this.mRectangle = this.mViewToolbar.findViewById(R.id.btnRectangle);
        this.mOval = this.mViewToolbar.findViewById(R.id.btnOval);
        this.mUndo = this.mViewToolbar.findViewById(R.id.btnUndo);
        this.mRedo = this.mViewToolbar.findViewById(R.id.btnRedo);
        this.mClear = this.mViewToolbar.findViewById(R.id.btnClear);
        this.mColorIndicator = this.mViewToolbar.findViewById(R.id.btnColorIndicator);
        this.mColorImage = (ColorSelectedImage)this.mViewToolbar.findViewById(R.id.colorImage);
        if (this.isAnnotationOff) {
            this.mAnnotation.setVisibility(8);
            this.mSpotlight.setVisibility(8);
            this.mPen.setVisibility(8);
            this.mHighlight.setVisibility(8);
            this.mLine.setVisibility(8);
            this.mRectangle.setVisibility(8);
            this.mOval.setVisibility(8);
            this.mUndo.setVisibility(8);
            this.mRedo.setVisibility(8);
            this.mClear.setVisibility(8);
            this.mColorIndicator.setVisibility(8);
            this.mColorImage.setVisibility(8);
        }
        this.mToolbarLayoutParams = new WindowManager.LayoutParams();
        this.mToolbarLayoutParams.type = this.getWindowLayoutParamsType();
        this.mToolbarLayoutParams.flags |= 0x528;
        this.mToolbarLayoutParams.format = 1;
        this.setToolbarLayoutParamsWidth(this.mToolbarLayoutParams);
        this.mToolbarLayoutParams.height = -2;
        this.mToolbarLayoutParams.gravity = 51;
        int toolbarHeight = this.mViewToolbar.getHeight();
        if (toolbarHeight == 0) {
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2);
            this.mViewToolbar.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.mViewToolbar.measure(this.mToolbarLayoutParams.width, 0);
            toolbarHeight = this.mViewToolbar.getMeasuredHeight();
        }
        this.mToolbarLayoutParams.x = this.mToolBarMargin;
        this.mToolbarLayoutParams.y = this.mDisplay.getHeight() - toolbarHeight - this.mToolBarMargin;
        this.loctParamNow.marginLeft = this.mToolbarLayoutParams.x;
        this.loctParamNow.marginTop = this.mToolbarLayoutParams.y;
        this.mToolbarLayoutParams.windowAnimations = 16973828;
        this.mViewToolbar.findViewById(R.id.btnAnnotation).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnSpotlight).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnHighlight).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnClear).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnColorIndicator).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnStopShare).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnPen).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnAutoLine).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnRectangle).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnOval).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnUndo).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.findViewById(R.id.btnRedo).setOnClickListener((View.OnClickListener)this);
        this.mViewToolbar.setGestureDetectorListener(new GuestureListener());
        this.mWindowManager.addView((View)this.mViewToolbar, (ViewGroup.LayoutParams)this.mToolbarLayoutParams);
        this.mViewToolbar.setVisibility(8);
    }

    private void addAnnotation() {
        this.mDrawingView = new AnnotateView(this.mContext);
        FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -1);
        this.mDrawingView.setLayoutParams((ViewGroup.LayoutParams)lp);
        WindowManager.LayoutParams inLayoutParams = new WindowManager.LayoutParams();
        inLayoutParams.type = this.getWindowLayoutParamsType();
        inLayoutParams.format = 1;
        inLayoutParams.width = -1;
        inLayoutParams.height = -1;
        this.mDrawingView.setEnabled(true);
        this.mLineWidth = this.mDrawingView.getCurrentWidth();
        this.mDrawingView.setOnKeyListener(new View.OnKeyListener(){

            public boolean onKey(View v, int keyCode, KeyEvent event) {
                if (keyCode == 4 && event.getAction() == 1) {
                    ShareToolbar.this.onBackPressed();
                }
                return false;
            }
        });
        this.mWindowManager.addView((View)this.mDrawingView, (ViewGroup.LayoutParams)inLayoutParams);
        this.mDrawingView.setVisibility(8);
        this.mDrawingView.setEnabled(true);
    }

    public void destroy() {
        if (this.mWindowManager != null) {
            if (this.mViewToolbar != null) {
                this.mWindowManager.removeView((View)this.mViewToolbar);
            }
            if (this.mDrawingView != null) {
                this.mDrawingView.stopAnnotation();
                this.mWindowManager.removeView((View)this.mDrawingView);
            }
            if (this.mColorDismissView != null) {
                this.mWindowManager.removeView(this.mColorDismissView);
            }
            if (this.mColorLayoutView != null) {
                this.mWindowManager.removeView(this.mColorLayoutView);
            }
        }
        this.mViewToolbar = null;
        this.mDrawingView = null;
        this.mColorDismissView = null;
        this.mColorLayoutView = null;
    }

    private void dragFinish() {
        this.mToolbarBg.setBackgroundResource(R.drawable.zm_screenshare_toolbar_bg_normal);
    }

    private void updateSelection() {
        if (this.mViewToolbar == null || this.mDrawingView == null) {
            return;
        }
        this.mSpotlight.setSelected(false);
        this.mHighlight.setSelected(false);
        this.mPen.setSelected(false);
        this.mLine.setSelected(false);
        this.mRectangle.setSelected(false);
        this.mOval.setSelected(false);
        this.mUndo.setSelected(false);
        this.mRedo.setSelected(false);
        switch (this.mDrawingView.getCurAnnoToolType()) {
            case ANNO_TOOL_TYPE_SPOTLIGHT: {
                this.mSpotlight.setSelected(true);
                break;
            }
            case ANNO_TOOL_TYPE_HIGHLIGHTER: {
                this.mHighlight.setSelected(true);
                break;
            }
            case ANNO_TOOL_TYPE_PEN: {
                this.mPen.setSelected(true);
                break;
            }
            case ANNO_TOOL_TYPE_AUTO_LINE: {
                this.mLine.setSelected(true);
                break;
            }
            case ANNO_TOOL_TYPE_AUTO_RECTANGLE: {
                this.mRectangle.setSelected(true);
                break;
            }
            case ANNO_TOOL_TYPE_AUTO_ELLIPSE: {
                this.mOval.setSelected(true);
                break;
            }
        }
        this.mLineWidth = this.mDrawingView.getCurrentWidth();
        this.mColorImage.setColor(this.mDrawingView.getCurrentColor());
    }

    private void onClickStopShare() {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onClickStopShare();
    }

    private void onAnnoStatusChanged() {
        if (this.mListener == null) {
            return;
        }
        this.mListener.onAnnoStatusChanged();
    }

    private void showAnnotation() {
        if (this.mViewToolbar == null || this.mDrawingView == null) {
            return;
        }
        int width = UIUtil.getDisplayWidth((Context)this.mDrawingView.getContext());
        int height = UIUtil.getDisplayHeight((Context)this.mDrawingView.getContext());
        if (UiModeUtil.isInDesktopMode((Context)this.mContext)) {
            this.mDrawingView.initBackgroundCanvasSize(width, height);
        } else {
            int maxSize = Math.max(width, height);
            this.mDrawingView.initBackgroundCanvasSize(maxSize, maxSize);
        }
        this.setRandomColor();
        this.mDrawingView.setVisibility(0);
        this.mDrawingView.setScaleAndOffsetValue(1.0f, 0.0f, 0.0f);
        if (!this.mDrawingView.isAnnotateInit()) {
            this.mDrawingView.setIsPresenter(true);
            this.mDrawingView.startAnnotation(true);
        }
        this.updateSelection();
    }

    private void setRandomColor() {
        Random rand = new Random();
        int index = rand.nextInt(9);
        int color2 = ZMDrawObject.DFT_CLR;
        if (null != this.mColorTable) {
            color2 = this.mColorTable.getColorByIndex(index);
        }
        this.mDrawingView.setToolColor(color2);
        this.mColorImage.setColor(color2);
    }

    public boolean isAnnotationStart() {
        return this.mDrawingView != null && this.mDrawingView.getParent() != null && this.mDrawingView.getVisibility() == 0;
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void updateColorViewLayout() {
        if (this.mColorLayoutView == null || this.mColorLayoutView.getVisibility() == 8) {
            return;
        }
        int colorViewHeight = this.mColorLayoutView.getHeight();
        if (colorViewHeight == 0) {
            FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(-1, -2);
            this.mColorLayoutView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.mColorLayoutView.measure(Integer.MIN_VALUE, 0);
            colorViewHeight = this.mColorLayoutView.getMeasuredHeight();
            this.mColorLayoutView.setLayoutParams((ViewGroup.LayoutParams)this.mColorLayoutParams);
        }
        int screeenHeight = this.mDisplay.getHeight();
        int mToolbarTopMargin = this.mToolbarLayoutParams.y;
        this.mColorLayoutParams.x = this.mToolbarLayoutParams.x + this.mToolBarMargin;
        this.mColorLayoutParams.width = this.mToolbarLayoutParams.width - 2 * this.mToolBarMargin;
        int padding = UIUtil.dip2px((Context)this.mContext, (float)2.0f);
        if (mToolbarTopMargin > colorViewHeight + UIUtil.dip2px((Context)this.mContext, (float)20.0f)) {
            this.mColorLayoutParams.gravity = 83;
            this.mColorLayoutParams.y = screeenHeight - mToolbarTopMargin - this.mToolBarMargin + padding;
        } else {
            this.mColorLayoutParams.gravity = 51;
            this.mColorLayoutParams.y = mToolbarTopMargin + this.mViewToolbar.getHeight() - this.mToolBarMargin + padding;
        }
        this.mColorLayoutView.setVisibility(0);
        this.mWindowManager.updateViewLayout(this.mColorLayoutView, (ViewGroup.LayoutParams)this.mColorLayoutParams);
    }

    private void onBackPressed() {
        if (this.mColorLayoutView != null && this.mColorDismissView != null && this.mColorLayoutView.isShown() && this.mColorDismissView.isShown()) {
            this.mColorLayoutView.setVisibility(8);
            this.mColorDismissView.setVisibility(8);
            return;
        }
        if (this.mDrawingView != null && this.mDrawingView.isShown()) {
            this.toggleAnnotation(false);
            return;
        }
    }

    private void showColorView() {
        if (this.mColorLayoutView != null) {
            this.mColorLayoutView.setVisibility(0);
        }
        if (this.mColorDismissView != null) {
            this.mColorDismissView.setVisibility(0);
        }
        this.updateColorViewLayout();
    }

    private void updateLineWidthPromt() {
        if (this.mColorLayoutView != null && this.mColorLayoutView.isShown()) {
            this.mLineWidthSeekBar.setProgress(this.mLineWidth);
            this.mTxtLineWidth.setText((CharSequence)String.valueOf(this.mLineWidth));
        }
    }

    private void setAnnotateDisable(boolean bDisable) {
        ShareSessionMgr shareMgr;
        if (!ZoomShareData.getInstance().getAttendeeAnnotateDisable() && null != (shareMgr = ConfMgr.getInstance().getShareObj())) {
            shareMgr.DisableAttendeeAnnotationForMySharedContent(bDisable);
        }
    }

    private void setAnnotateDisableWhenStopShare() {
        ShareSessionMgr shareMgr = ConfMgr.getInstance().getShareObj();
        if (null != shareMgr) {
            boolean bDisable = ZoomShareData.getInstance().getAttendeeAnnotateDisable();
            shareMgr.DisableAttendeeAnnotationForMySharedContent(bDisable);
        }
    }

    public void setAnnoToolbarVisible(boolean bVisible) {
        this.toggleAnnotation(bVisible);
    }

    public void onClick(View v) {
        if (this.mDrawingView == null) {
            return;
        }
        if (R.id.btnAnnotation == v.getId()) {
            this.toggleAnnotation(!this.isAnnotationStart());
        } else if (R.id.btnSpotlight == v.getId()) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_SPOTLIGHT);
        } else if (R.id.btnPen == v.getId()) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_PEN);
        } else if (R.id.btnHighlight == v.getId()) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_HIGHLIGHTER);
        } else if (R.id.btnAutoLine == v.getId()) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_AUTO_LINE);
        } else if (R.id.btnRectangle == v.getId()) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_AUTO_RECTANGLE);
        } else if (R.id.btnOval == v.getId()) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_AUTO_ELLIPSE);
        } else if (R.id.btnText == v.getId()) {
            this.mDrawingView.setCurAnnoTool(AnnoToolType.ANNO_TOOL_TYPE_TEXTBOX);
        } else if (R.id.btnUndo == v.getId()) {
            this.mDrawingView.undo();
        } else if (R.id.btnRedo == v.getId()) {
            this.mDrawingView.redo();
        } else if (R.id.btnClear == v.getId()) {
            this.mDrawingView.eraserAll();
        } else if (R.id.btnColorIndicator == v.getId()) {
            if (this.mColorLayoutView != null && this.mColorLayoutView.isShown()) {
                this.mColorLayoutView.setVisibility(8);
                this.mColorDismissView.setVisibility(8);
            } else {
                this.showColorView();
                this.updateLineWidthPromt();
            }
        } else if (R.id.btnStopShare == v.getId()) {
            this.setAnnotateDisableWhenStopShare();
            this.onClickStopShare();
        }
        if (R.id.btnColorIndicator != v.getId() && this.mColorLayoutView != null && this.mColorLayoutView.isShown()) {
            this.mColorLayoutView.setVisibility(8);
            this.mColorDismissView.setVisibility(8);
        }
        this.updateSelection();
        this.dragFinish();
    }

    @Override
    public void onColorChanged(View view, int newColor) {
    }

    @Override
    public void onColorPicked(View view, int newColor) {
        if (this.mDrawingView == null) {
            return;
        }
        this.mDrawingView.setToolColor(newColor);
        this.mColorImage.setColor(newColor);
    }

    private class GuestureListener
    extends ToolbarDragView.ToolbarScrollListener {
        float mLastRawX = -1.0f;
        float mLastRawY = -1.0f;

        @Override
        public void onTouchEventUp() {
            this.mLastRawX = -1.0f;
            this.mLastRawY = -1.0f;
            ShareToolbar.this.dragFinish();
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            int dy;
            int dx;
            if (ShareToolbar.this.mViewToolbar == null || ShareToolbar.this.mViewToolbar.getParent() == null) {
                return true;
            }
            if (ShareToolbar.this.mColorLayoutView == null) {
                return true;
            }
            if (ShareToolbar.this.mColorLayoutView.isShown()) {
                ShareToolbar.this.mColorLayoutView.setVisibility(8);
                ShareToolbar.this.mColorDismissView.setVisibility(8);
            }
            ShareToolbar.this.mToolbarBg.setBackgroundResource(R.drawable.zm_screenshare_toolbar_bg_drag);
            if ((int)this.mLastRawX == -1 || (int)this.mLastRawY == -1) {
                dx = (int)(e2.getRawX() - e1.getRawX());
                dy = (int)(e2.getRawY() - e1.getRawY());
            } else {
                dx = (int)(e2.getRawX() - this.mLastRawX);
                dy = (int)(e2.getRawY() - this.mLastRawY);
            }
            this.mLastRawX = e2.getRawX();
            this.mLastRawY = e2.getRawY();
            int width = ShareToolbar.this.mViewToolbar.getWidth();
            int height = ShareToolbar.this.mViewToolbar.getHeight();
            if (((ShareToolbar)ShareToolbar.this).mToolbarLayoutParams.x + dx < 0) {
                dx = 0 - ((ShareToolbar)ShareToolbar.this).mToolbarLayoutParams.x;
            }
            if (((ShareToolbar)ShareToolbar.this).mToolbarLayoutParams.x + dx + width > ShareToolbar.this.mDisplay.getWidth()) {
                dx = ShareToolbar.this.mDisplay.getWidth() - ((ShareToolbar)ShareToolbar.this).mToolbarLayoutParams.x - width;
            }
            if (((ShareToolbar)ShareToolbar.this).mToolbarLayoutParams.y + dy < 0) {
                dy = ((ShareToolbar)ShareToolbar.this).mToolbarLayoutParams.y;
            }
            if (((ShareToolbar)ShareToolbar.this).mToolbarLayoutParams.y + dy + height > ShareToolbar.this.mDisplay.getHeight()) {
                dy = ShareToolbar.this.mDisplay.getHeight() - ((ShareToolbar)ShareToolbar.this).mToolbarLayoutParams.y - height;
            }
            ((ShareToolbar)ShareToolbar.this).mToolbarLayoutParams.y += dy;
            ((ShareToolbar)ShareToolbar.this).mToolbarLayoutParams.x += dx;
            ShareToolbar.this.mWindowManager.updateViewLayout((View)ShareToolbar.this.mViewToolbar, (ViewGroup.LayoutParams)ShareToolbar.this.mToolbarLayoutParams);
            ((ShareToolbar)ShareToolbar.this).loctParamNow.dragged = true;
            return true;
        }
    }

    class LocationParamForScreen {
        int marginTop;
        int marginLeft;
        boolean dragged;

        LocationParamForScreen() {
        }
    }

    public static interface Listener {
        public void onClickStopShare();

        public void onAnnoStatusChanged();
    }
}

