/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.ScrollView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.ptapp.RoomDevice;
import com.zipow.videobox.view.RoomSystemCallViewListener;
import java.util.ArrayList;
import java.util.List;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.widget.IZMMenuItem;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.androidlib.widget.ZMMenuAdapter;
import us.zoom.androidlib.widget.ZMSimpleMenuItem;
import us.zoom.videomeetings.R;

public class RoomSystemCallOutView
extends ScrollView
implements TextWatcher,
View.OnClickListener,
PTUI.IRoomCallListener {
    private static final String TAG = RoomSystemCallOutView.class.getSimpleName();
    private Context mContext;
    private TextView mNotification;
    private EditText mAddressInput;
    private View mH323Btn;
    private View mSIPBtn;
    private Button mCallOutBtn;
    private Button mCancelBtn;
    private ImageView mDeviceListBtn;
    private TextView mAddressInputPromt;
    private RoomSystemCallViewListener mListener;
    private int mDeviceType = 1;
    private List<RoomDevice> mRoomDevices = new ArrayList<RoomDevice>();
    private ZMMenuAdapter<RoomDeviceListItem> mRoomDeviceListAdapter;
    private long mErrCode;
    private int mState;
    private static final int STATE_INITIALED = 0;
    private static final int STATE_CONNECTTING = 1;
    private static final int STATE_CONNECTED = 2;
    private static final int STATE_FAILED = 3;
    private static final String CALLOUT_STATE = "callout_state";
    private static final String CALLOUT_TYPE = "callout_type";
    private static final String CALLOUT_ERROR_CODE = "callout_error_code";
    private static final String CALLOUT_VIEW_STATE = "callout_view_state";

    public RoomSystemCallOutView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public RoomSystemCallOutView(Context context, Bundle saveInstanceState) {
        super(context);
        this.initView(context, saveInstanceState);
    }

    public RoomSystemCallOutView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, null);
    }

    public RoomSystemCallOutView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context, null);
    }

    private void initView(Context context, Bundle saveInstanceState) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        this.mContext = context;
        if (inflater == null) {
            return;
        }
        View view = inflater.inflate(R.layout.zm_room_system_call_out_view, (ViewGroup)this, true);
        this.mNotification = (TextView)view.findViewById(R.id.txtNotification);
        this.mAddressInput = (EditText)view.findViewById(R.id.editAddress);
        this.mAddressInputPromt = (TextView)view.findViewById(R.id.txtAddressPromt);
        this.mDeviceListBtn = (ImageView)view.findViewById(R.id.deviceList);
        this.mH323Btn = view.findViewById(R.id.h323Btn);
        this.mH323Btn.setSelected(true);
        this.mSIPBtn = view.findViewById(R.id.sipBtn);
        this.mSIPBtn.setSelected(false);
        this.mSIPBtn.setOnClickListener((View.OnClickListener)this);
        this.mCallOutBtn = (Button)view.findViewById(R.id.btnCall);
        this.mCancelBtn = (Button)view.findViewById(R.id.btnCancel);
        this.mState = 0;
        this.initial(saveInstanceState);
    }

    public void initialUIListener() {
        this.mAddressInput.addTextChangedListener((TextWatcher)this);
        this.mH323Btn.setOnClickListener((View.OnClickListener)this);
        this.mCallOutBtn.setOnClickListener((View.OnClickListener)this);
        this.mCancelBtn.setOnClickListener((View.OnClickListener)this);
        this.mDeviceListBtn.setOnClickListener((View.OnClickListener)this);
        PTUI.getInstance().addRoomCallListener(this);
    }

    private void initial(Bundle saveState) {
        if (saveState != null) {
            SparseArray viewState = saveState.getSparseParcelableArray(CALLOUT_VIEW_STATE);
            if (viewState != null) {
                try {
                    this.restoreHierarchyState(viewState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mState = saveState.getInt(CALLOUT_STATE, 0);
            this.mDeviceType = saveState.getInt(CALLOUT_TYPE, 1);
            this.mErrCode = saveState.getLong(CALLOUT_ERROR_CODE);
        }
        this.loadAllRoomDevices();
        this.refreshUI();
    }

    public Bundle getSaveInstanceState() {
        Bundle outState = new Bundle();
        outState.putInt(CALLOUT_STATE, this.mState);
        outState.putInt(CALLOUT_TYPE, this.mDeviceType);
        outState.putLong(CALLOUT_ERROR_CODE, this.mErrCode);
        SparseArray viewState = new SparseArray();
        this.saveHierarchyState(viewState);
        outState.putSparseParcelableArray(CALLOUT_VIEW_STATE, viewState);
        return outState;
    }

    public void setListener(RoomSystemCallViewListener l) {
        this.mListener = l;
    }

    public void destroy() {
        PTUI.getInstance().removeRoomCallListener(this);
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        if (v == this.mCallOutBtn) {
            this.onClickCallOut();
            UIUtil.closeSoftKeyboard((Context)this.mContext, (View)this);
        } else if (v == this.mCancelBtn) {
            this.onClickCancel();
        } else if (v == this.mH323Btn) {
            this.onClickH323();
        } else if (v == this.mSIPBtn) {
            this.onClickSip();
        } else if (v == this.mDeviceListBtn) {
            this.onClickDeviceList();
        }
        this.refreshUI();
    }

    private boolean checkInput() {
        if (StringUtil.isEmptyOrNull((String)this.mAddressInput.getText().toString())) {
            this.mCallOutBtn.setEnabled(false);
            return false;
        }
        this.mCallOutBtn.setEnabled(true);
        return true;
    }

    private void onClickCallOut() {
        if (!this.checkInput()) {
            return;
        }
        String addr = this.mAddressInput.getText().toString();
        for (RoomDevice dev : this.mRoomDevices) {
            if (!addr.equals(dev.getDisplayName())) continue;
            addr = dev.getAddress();
            break;
        }
        this.callOutRoomSystem(addr.trim(), this.mDeviceType, 2);
    }

    private void callOutRoomSystem(String address, int deviceType, int roomEncrypt) {
        if (StringUtil.isEmptyOrNull((String)address)) {
            return;
        }
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return;
        }
        boolean success = meetingHelper.callOutRoomSystem(address, deviceType, roomEncrypt);
        if (success) {
            this.mState = 1;
            if (this.mListener != null) {
                this.mListener.onConnecting(true);
            }
        } else {
            this.mState = 3;
        }
    }

    private void onClickCancel() {
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (this.mState == 1 && meetingHelper != null && meetingHelper.cancelRoomDevice()) {
            this.mState = 0;
        }
        if (this.mListener != null) {
            this.mListener.onCancel(true);
        }
    }

    private void onClickH323() {
        if (this.mDeviceType == 1) {
            return;
        }
        this.mDeviceType = 1;
    }

    private void onClickSip() {
        if (this.mDeviceType == 2) {
            return;
        }
        this.mDeviceType = 2;
    }

    private void onClickDeviceList() {
        this.ShowRoomDeviceList();
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        this.mAddressInput.setSelected(true);
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.mState = 0;
        this.refreshUI();
    }

    @Override
    public void onRoomCallEvent(int event, long result, boolean isActiveMeeting) {
        if (event != 8) {
            return;
        }
        if (result == 0L) {
            if (this.mListener != null) {
                this.mListener.onConnected(true);
            }
            this.mState = 2;
        } else {
            this.mState = 3;
            this.mErrCode = result;
            if (this.mListener != null) {
                this.mListener.onFailed(true);
            }
        }
        this.refreshUI();
    }

    private void refreshUI() {
        switch (this.mState) {
            case 0: 
            case 2: {
                this.mNotification.setVisibility(4);
                this.mCallOutBtn.setVisibility(0);
                this.mCancelBtn.setVisibility(8);
                break;
            }
            case 1: {
                this.mNotification.setVisibility(0);
                this.mNotification.setBackgroundColor(this.getResources().getColor(R.color.zm_notification_background_green));
                this.mNotification.setTextColor(this.getResources().getColor(R.color.zm_white));
                this.mNotification.setText(R.string.zm_room_system_notify_calling);
                this.mCallOutBtn.setVisibility(8);
                this.mCancelBtn.setVisibility(0);
                break;
            }
            case 3: {
                this.mNotification.setVisibility(0);
                this.mNotification.setBackgroundColor(this.getResources().getColor(R.color.zm_notification_background));
                this.mNotification.setTextColor(this.getResources().getColor(R.color.zm_notification_font_red));
                this.mNotification.setText((CharSequence)this.getResources().getString(R.string.zm_room_system_notify_call_out_failed, new Object[]{this.mErrCode}));
                this.mCallOutBtn.setVisibility(0);
                this.mCancelBtn.setVisibility(8);
            }
        }
        if (this.mDeviceType == 1) {
            this.mH323Btn.setSelected(true);
            this.mSIPBtn.setSelected(false);
            this.mAddressInputPromt.setText(R.string.zm_room_system_h323_input_instruction);
        } else {
            this.mH323Btn.setSelected(false);
            this.mSIPBtn.setSelected(true);
            this.mAddressInputPromt.setText(R.string.zm_room_system_sip_input_instruction);
        }
        if (this.mRoomDevices.size() > 0) {
            this.mDeviceListBtn.setVisibility(0);
        } else {
            this.mDeviceListBtn.setVisibility(8);
        }
        this.checkInput();
    }

    private void loadAllRoomDevices() {
        this.mRoomDevices.clear();
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return;
        }
        ArrayList<RoomDevice> devices = new ArrayList<RoomDevice>();
        if (!meetingHelper.getRoomDevices(devices)) {
            return;
        }
        for (RoomDevice dev : devices) {
            if (!this.checkRoomDevice(dev)) continue;
            this.mRoomDevices.add(dev);
        }
    }

    private ZMMenuAdapter<RoomDeviceListItem> createDeviceListAdapter() {
        ZMMenuAdapter adapter = new ZMMenuAdapter(this.mContext, false);
        for (RoomDevice dev : this.mRoomDevices) {
            String name = dev.getDisplayName();
            if (StringUtil.isEmptyOrNull((String)name)) continue;
            RoomDeviceListItem item = new RoomDeviceListItem(dev.getDeviceType(), name.trim(), dev);
            adapter.addItem((IZMMenuItem)item);
        }
        return adapter;
    }

    private void ShowRoomDeviceList() {
        this.mRoomDeviceListAdapter = this.createDeviceListAdapter();
        ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder(this.mContext).setAdapter(this.mRoomDeviceListAdapter, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                RoomSystemCallOutView.this.onClickItem((ZMMenuAdapter<RoomDeviceListItem>)RoomSystemCallOutView.this.mRoomDeviceListAdapter, which);
            }
        });
        ZMAlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(true);
        dialog.show();
    }

    protected void onClickItem(ZMMenuAdapter<RoomDeviceListItem> adapter, int which) {
        if (adapter == null) {
            return;
        }
        RoomDeviceListItem item = (RoomDeviceListItem)((Object)adapter.getItem(which));
        RoomDevice dev = item.getRoomDevice();
        if (!this.checkRoomDevice(dev)) {
            return;
        }
        this.mAddressInput.setText((CharSequence)dev.getDisplayName());
        this.mDeviceType = dev.getDeviceType();
        this.refreshUI();
    }

    private boolean checkRoomDevice(RoomDevice device) {
        if (device == null) {
            return false;
        }
        return !StringUtil.isEmptyOrNull((String)device.getIp()) || !StringUtil.isEmptyOrNull((String)device.getE164num());
    }

    private class RoomDeviceListItem
    extends ZMSimpleMenuItem {
        private RoomDevice mDevice;

        public RoomDeviceListItem(int action, String label, RoomDevice device) {
            super(action, label);
            this.mDevice = device;
        }

        public RoomDevice getRoomDevice() {
            return this.mDevice;
        }
    }
}

