/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ScrollView;
import android.widget.TextView;
import com.zipow.videobox.ptapp.MeetingHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTUI;
import com.zipow.videobox.view.RoomSystemCallViewListener;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.videomeetings.R;

public class RoomSystemCallInView
extends ScrollView
implements TextWatcher,
View.OnClickListener,
PTUI.IRoomCallListener {
    private static final String TAG = RoomSystemCallInView.class.getSimpleName();
    private Context mContext;
    private TextView mNotification;
    private EditText mEdtPairingCode = null;
    private Button mBtnInvite;
    private TextView mTxtH323Info;
    private TextView mH323Password;
    private TextView mMeetingId;
    private View mH323Info;
    private View mPasswordView;
    private long mErrCode;
    private int mState;
    private static final int STATE_INITIALED = 0;
    private static final int STATE_CONNECTTING = 1;
    private static final int STATE_CONNECTED = 2;
    private static final int STATE_FAILED = 3;
    private static final String CALLIN_STATE = "callin_sate";
    private static final String CALLIN_ERROR_CODE = "callin_error_code";
    private static final String CALLIN_VIEW_STATE = "callin_view_state";
    private RoomSystemCallViewListener mListener;

    public RoomSystemCallInView(Context context) {
        super(context);
        this.initView(context, null);
    }

    public RoomSystemCallInView(Context context, Bundle saveInstanceState) {
        super(context);
        this.initView(context, saveInstanceState);
    }

    public RoomSystemCallInView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context, null);
    }

    public RoomSystemCallInView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView(context, null);
    }

    private void initView(Context context, Bundle saveInstanceState) {
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        if (inflater == null) {
            return;
        }
        this.mContext = context;
        View view = inflater.inflate(R.layout.zm_room_system_call_in_view, (ViewGroup)this, true);
        this.mNotification = (TextView)view.findViewById(R.id.txtNotification);
        this.mEdtPairingCode = (EditText)view.findViewById(R.id.editPairingCode);
        this.mBtnInvite = (Button)view.findViewById(R.id.btnInvite);
        this.mH323Info = view.findViewById(R.id.vH323Info);
        this.mTxtH323Info = (TextView)view.findViewById(R.id.tH323IpInfo);
        this.mPasswordView = view.findViewById(R.id.vH323MeetingPassword);
        this.mH323Password = (TextView)view.findViewById(R.id.tH323MeetingPassword);
        this.mMeetingId = (TextView)view.findViewById(R.id.tH323MeetingID);
        this.initialInfo();
        this.mState = 0;
        this.initial(saveInstanceState);
    }

    public void initialUIListener() {
        this.mEdtPairingCode.addTextChangedListener((TextWatcher)this);
        this.mBtnInvite.setOnClickListener((View.OnClickListener)this);
        PTUI.getInstance().addRoomCallListener(this);
    }

    private void initial(Bundle saveState) {
        if (saveState != null) {
            SparseArray viewState = saveState.getSparseParcelableArray(CALLIN_VIEW_STATE);
            if (viewState != null) {
                try {
                    this.restoreHierarchyState(viewState);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mState = saveState.getInt(CALLIN_STATE, 0);
            this.mErrCode = saveState.getLong(CALLIN_ERROR_CODE);
        }
        this.refreshUI();
    }

    public Bundle getSaveInstanceState() {
        Bundle outState = new Bundle();
        SparseArray viewState = new SparseArray();
        this.saveHierarchyState(viewState);
        outState.putSparseParcelableArray(CALLIN_VIEW_STATE, viewState);
        outState.putInt(CALLIN_STATE, this.mState);
        outState.putLong(CALLIN_ERROR_CODE, this.mErrCode);
        return outState;
    }

    public void destroy() {
        PTUI.getInstance().removeRoomCallListener(this);
    }

    public void setListener(RoomSystemCallViewListener l) {
        this.mListener = l;
    }

    public void onClick(View v) {
        if (v == null) {
            return;
        }
        if (v == this.mBtnInvite) {
            this.onClickInvite();
            UIUtil.closeSoftKeyboard((Context)this.mContext, (View)this);
        }
        this.refreshUI();
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void onTextChanged(CharSequence s, int start, int before, int count) {
    }

    public void afterTextChanged(Editable s) {
        this.mState = 0;
        this.refreshUI();
    }

    private boolean checkInput() {
        if (this.mState == 1 || StringUtil.isEmptyOrNull((String)this.mEdtPairingCode.getText().toString())) {
            this.mBtnInvite.setEnabled(false);
            return false;
        }
        this.mBtnInvite.setEnabled(true);
        return true;
    }

    private void onClickInvite() {
        if (!this.checkInput()) {
            return;
        }
        PTApp ptapp = PTApp.getInstance();
        if (ptapp == null) {
            return;
        }
        long confNumber = ptapp.getH323AccessCode();
        MeetingHelper meetingHelper = PTApp.getInstance().getMeetingHelper();
        if (meetingHelper == null) {
            return;
        }
        String paringCode = this.mEdtPairingCode.getText().toString().trim();
        boolean success = meetingHelper.sendMeetingParingCode(confNumber, paringCode);
        this.mState = success ? 1 : 3;
    }

    private void initialInfo() {
        PTApp ptapp = PTApp.getInstance();
        if (ptapp == null) {
            return;
        }
        long confNumber = ptapp.getH323AccessCode();
        String accessCode = StringUtil.formatConfNumber((long)confNumber, (char)' ');
        String h323ConfInfo = ptapp.getH323Gateway();
        String h323Password = ptapp.getH323Password();
        if (StringUtil.isEmptyOrNull((String)h323ConfInfo)) {
            this.mH323Info.setVisibility(8);
        } else {
            this.mH323Info.setVisibility(0);
            String[] items = h323ConfInfo.split(";");
            if (items.length > 1) {
                StringBuilder builder = new StringBuilder();
                boolean first = true;
                for (String item : items) {
                    if (!first) {
                        builder.append("\n");
                    }
                    builder.append(item.trim());
                    first = false;
                }
                this.mTxtH323Info.setText((CharSequence)builder.toString());
            } else {
                this.mTxtH323Info.setText((CharSequence)h323ConfInfo);
            }
            this.mMeetingId.setText((CharSequence)accessCode);
            if (StringUtil.isEmptyOrNull((String)h323Password)) {
                this.mPasswordView.setVisibility(8);
            } else {
                this.mPasswordView.setVisibility(0);
                this.mH323Password.setText((CharSequence)h323Password);
            }
        }
    }

    private void refreshUI() {
        switch (this.mState) {
            case 0: 
            case 2: {
                this.mNotification.setVisibility(4);
                break;
            }
            case 1: {
                this.mNotification.setVisibility(0);
                this.mNotification.setBackgroundColor(this.getResources().getColor(R.color.zm_notification_background_green));
                this.mNotification.setTextColor(this.getResources().getColor(R.color.zm_white));
                this.mNotification.setText(R.string.zm_room_system_notify_inviting);
                break;
            }
            case 3: {
                this.mNotification.setVisibility(0);
                this.mNotification.setBackgroundColor(this.getResources().getColor(R.color.zm_notification_background));
                this.mNotification.setTextColor(this.getResources().getColor(R.color.zm_notification_font_red));
                this.mNotification.setText((CharSequence)this.getResources().getString(R.string.zm_room_system_notify_invite_failed, new Object[]{this.mErrCode}));
            }
        }
        this.checkInput();
    }

    @Override
    public void onRoomCallEvent(int event, long result, boolean isActiveMeeting) {
        if (event != 7) {
            return;
        }
        if (isActiveMeeting) {
            if (result == 0L) {
                if (this.mListener != null) {
                    this.mListener.onConnected(false);
                }
                this.mState = 2;
            } else {
                this.mState = 3;
                this.mErrCode = result;
            }
        }
        this.refreshUI();
    }
}

