/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.support.annotation.Nullable;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.ZoomMessengerUI;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.PresenceStateHelper;
import com.zipow.videobox.view.IMAddrBookItem;
import java.util.List;
import us.zoom.videomeetings.R;

public class PresenceStateView
extends LinearLayout {
    private TextView mTxtDeviceType;
    private ImageView mImgPresenceStatus;
    private String buddyJID = "";
    private String subPresenceMethod = "";
    private Handler mHandler = new Handler();
    private ZoomMessengerUI.IZoomMessengerUIListener mZoomMessengerUIListener = new ZoomMessengerUI.SimpleZoomMessengerUIListener(){

        @Override
        public void Indicate_TPV2_WillExpirePresence(List<String> JIDs, int type) {
            if (!ViewCompat.isAttachedToWindow((View)PresenceStateView.this)) {
                ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
                if (messenger == null) {
                    return;
                }
                if (type == 3 && JIDs.contains(PresenceStateView.this.buddyJID)) {
                    PresenceStateHelper.getInstance().addJID(PresenceStateView.this.buddyJID, PresenceStateView.this.subPresenceMethod);
                }
            } else {
                ZoomMessengerUI.getInstance().removeListener(PresenceStateView.this.mZoomMessengerUIListener);
            }
        }

        @Override
        public void onConnectReturn(int errorCode) {
            if (errorCode == 0) {
                PresenceStateHelper.getInstance().addJID(PresenceStateView.this.buddyJID, PresenceStateView.this.subPresenceMethod);
            }
        }
    };

    public PresenceStateView(Context context) {
        this(context, null);
    }

    public PresenceStateView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PresenceStateView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context, attrs);
    }

    public PresenceStateView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context, attrs);
    }

    protected void onDetachedFromWindow() {
        ZoomMessengerUI.getInstance().removeListener(this.mZoomMessengerUIListener);
        super.onDetachedFromWindow();
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ZoomMessengerUI.getInstance().addListener(this.mZoomMessengerUIListener);
    }

    private void initView(Context context, AttributeSet attrs) {
        PresenceStateView.inflate((Context)context, (int)R.layout.zm_mm_presence_state_view, (ViewGroup)this);
        this.mTxtDeviceType = (TextView)this.findViewById(R.id.txtDeviceType);
        this.mImgPresenceStatus = (ImageView)this.findViewById(R.id.imgPresences);
        this.setVisibility(8);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SubPresence);
            this.subPresenceMethod = a.getString(R.styleable.SubPresence_zm_subpresence_type);
            a.recycle();
        }
    }

    public void setmTxtDeviceTypeGone() {
        this.mTxtDeviceType.setVisibility(8);
    }

    public void setState(IMAddrBookItem item) {
        if (item == null) {
            this.setVisibility(8);
            return;
        }
        ZoomMessenger messenger = PTApp.getInstance().getZoomMessenger();
        if (messenger == null) {
            this.setVisibility(8);
            return;
        }
        ZoomBuddy buddy = messenger.getBuddyWithJID(item.getJid());
        if (buddy == null) {
            this.setVisibility(8);
            return;
        }
        this.buddyJID = buddy.getJid();
        this.mHandler.removeCallbacksAndMessages(null);
        if (messenger.isConnectionGood()) {
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    PresenceStateHelper.getInstance().addJID(PresenceStateView.this.buddyJID, PresenceStateView.this.subPresenceMethod);
                }
            }, 200L);
        }
        if (item.isBlocked()) {
            this.mTxtDeviceType.setText(R.string.zm_lbl_blocked);
            this.mTxtDeviceType.setTextColor(this.mTxtDeviceType.getResources().getColor(R.color.zm_mm_presence_busy));
            this.setVisibility(0);
            this.mImgPresenceStatus.setImageResource(R.drawable.zm_ic_buddy_blocked);
            this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_block));
            return;
        }
        if (messenger.isConnectionGood() && (item.getIsDesktopOnline() || item.getIsMobileOnline() || item.getIsRobot())) {
            switch (item.getPresence()) {
                case 3: {
                    int resString;
                    int imgRes = R.drawable.zm_status_available;
                    if (item.isZoomRoomContact()) {
                        resString = R.string.zm_lbl_room_online_33945;
                    } else if (item.getIsDesktopOnline() || item.getIsRobot()) {
                        resString = R.string.zm_lbl_desktop_online_33945;
                    } else {
                        resString = R.string.zm_lbl_mobile_online_33945;
                        imgRes = R.drawable.zm_status_mobileonline;
                    }
                    this.mTxtDeviceType.setText(resString);
                    this.mTxtDeviceType.setTextColor(this.mTxtDeviceType.getResources().getColor(R.color.zm_mm_presence_available));
                    this.setVisibility(0);
                    this.mImgPresenceStatus.setImageResource(imgRes);
                    this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_available));
                    break;
                }
                case 1: {
                    this.mTxtDeviceType.setText(R.string.zm_lbl_desktop_away);
                    this.mTxtDeviceType.setTextColor(this.mTxtDeviceType.getResources().getColor(R.color.zm_mm_presence_away));
                    this.setVisibility(0);
                    this.mImgPresenceStatus.setImageResource(R.drawable.zm_away);
                    this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_away_40739));
                    break;
                }
                case 2: {
                    if (buddy != null && buddy.getPresenceStatus() == 1) {
                        this.mTxtDeviceType.setText(R.string.zm_lbl_presence_dnd_33945);
                        this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_dnd_33945));
                    } else {
                        this.mTxtDeviceType.setText(R.string.zm_lbl_presence_dnd_19903);
                        this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_dnd_19903));
                    }
                    this.mTxtDeviceType.setTextColor(this.mTxtDeviceType.getResources().getColor(R.color.zm_mm_presence_busy));
                    this.setVisibility(0);
                    this.mImgPresenceStatus.setImageResource(R.drawable.zm_status_dnd);
                    break;
                }
                case 4: {
                    this.mTxtDeviceType.setText(R.string.zm_lbl_presence_xa_19903);
                    this.mTxtDeviceType.setTextColor(this.mTxtDeviceType.getResources().getColor(R.color.zm_mm_presence_busy));
                    this.setVisibility(0);
                    this.mImgPresenceStatus.setImageResource(R.drawable.zm_status_dnd);
                    this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_xa_19903));
                    break;
                }
                default: {
                    if (item.getIsMobileOnline()) {
                        this.mTxtDeviceType.setText(R.string.zm_lbl_mobile_online_33945);
                        this.mTxtDeviceType.setTextColor(this.mTxtDeviceType.getResources().getColor(R.color.zm_mm_presence_available));
                        this.setVisibility(0);
                        this.mImgPresenceStatus.setImageResource(R.drawable.zm_status_mobileonline);
                        this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_available));
                        break;
                    }
                    if (!buddy.isPresenceSynced()) {
                        this.mTxtDeviceType.setText(item.isZoomRoomContact() ? R.string.zm_lbl_room_offline_33945 : R.string.zm_lbl_desktop_offline_33945);
                        this.mTxtDeviceType.setTextColor(this.mTxtDeviceType.getResources().getColor(R.color.zm_mm_presence_offline));
                        this.setVisibility(0);
                        this.mImgPresenceStatus.setImageResource(R.drawable.zm_offline);
                        this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_offline));
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (!messenger.isConnectionGood() && item.getIsMobileOnline()) {
            this.mTxtDeviceType.setText(R.string.zm_lbl_mobile_offline_33945);
            this.mTxtDeviceType.setTextColor(this.mTxtDeviceType.getResources().getColor(R.color.zm_mm_presence_offline));
            this.setVisibility(0);
            this.mImgPresenceStatus.setImageResource(R.drawable.zm_offline);
            this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_offline));
        } else {
            this.mTxtDeviceType.setText(item.isZoomRoomContact() ? R.string.zm_lbl_room_offline_33945 : R.string.zm_lbl_desktop_offline_33945);
            this.mTxtDeviceType.setTextColor(this.mTxtDeviceType.getResources().getColor(R.color.zm_mm_presence_offline));
            this.setVisibility(0);
            this.mImgPresenceStatus.setImageResource(R.drawable.zm_offline);
            this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_offline));
        }
    }

    public boolean setState(int presence) {
        if (this.mImgPresenceStatus == null) {
            this.setVisibility(8);
            return false;
        }
        boolean isAvailable = true;
        this.setVisibility(0);
        this.mTxtDeviceType.setVisibility(8);
        switch (presence) {
            case 0: {
                this.mImgPresenceStatus.setImageResource(R.drawable.zm_status_available);
                this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_available));
                break;
            }
            case 3: {
                this.mImgPresenceStatus.setImageResource(R.drawable.zm_status_idle);
                this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_dnd_19903));
                break;
            }
            case 4: {
                this.mImgPresenceStatus.setImageResource(R.drawable.zm_status_dnd);
                this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_xa_19903));
                break;
            }
            case 2: {
                this.mImgPresenceStatus.setImageResource(R.drawable.zm_away);
                this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_away_40739));
                break;
            }
            default: {
                this.mImgPresenceStatus.setImageResource(R.drawable.zm_offline);
                this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_offline));
                isAvailable = false;
            }
        }
        return isAvailable;
    }

    public void resetState() {
        this.mTxtDeviceType.setTextColor(this.mTxtDeviceType.getResources().getColor(R.color.zm_mm_presence_offline));
        this.mImgPresenceStatus.setImageResource(R.drawable.zm_offline);
        this.mImgPresenceStatus.setContentDescription((CharSequence)this.mImgPresenceStatus.getResources().getString(R.string.zm_description_mm_presence_offline));
    }
}

