/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.view.OnHoldView;
import com.zipow.videobox.view.WaitingRoomView;
import us.zoom.videomeetings.R;

public class OnSilentView
extends LinearLayout {
    private Context mContext;
    private OnHoldView vOnHoldView;
    private WaitingRoomView vWaitingRoomView;

    public OnSilentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public OnSilentView(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
        this.inflateLayout();
        this.mContext = context;
        this.vOnHoldView = (OnHoldView)this.findViewById(R.id.vOnHoldView);
        this.vWaitingRoomView = (WaitingRoomView)this.findViewById(R.id.vWaitingRoomView);
        this.updateData();
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_on_silent_view, (ViewGroup)this);
    }

    public void setTitlePadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null) {
            return;
        }
        if (confContext.supportPutUserinWaitingListUponEntryFeature()) {
            if (this.vWaitingRoomView != null) {
                this.vWaitingRoomView.setTitlePadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
            }
        } else if (this.vOnHoldView != null) {
            this.vOnHoldView.setTitlePadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
        }
    }

    public void updateData() {
        if (this.isInEditMode()) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null || this.vWaitingRoomView == null || this.vOnHoldView == null) {
            return;
        }
        if (confContext.supportPutUserinWaitingListUponEntryFeature()) {
            this.vWaitingRoomView.setVisibility(0);
            this.vOnHoldView.setVisibility(8);
            this.vWaitingRoomView.updateData();
        } else {
            this.vWaitingRoomView.setVisibility(8);
            this.vOnHoldView.setVisibility(0);
            this.vOnHoldView.updateData();
        }
    }
}

