/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmConfContext;
import com.zipow.videobox.confapp.ConfMgr;
import com.zipow.videobox.dialog.LeaveAlertDialog;
import com.zipow.videobox.ptapp.MeetingInfo;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class OnHoldView
extends LinearLayout
implements View.OnClickListener {
    private View mBtnLeave = null;
    private TextView mTxtMeetingNumber = null;
    private View mTitleBar = null;

    public OnHoldView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public OnHoldView(Context context) {
        super(context);
        this.initView(context);
    }

    private void initView(Context context) {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_onhold_view, (ViewGroup)this);
        this.mBtnLeave = this.findViewById(R.id.btnLeave);
        this.mTxtMeetingNumber = (TextView)this.findViewById(R.id.txtMeetingNumber);
        this.mTitleBar = this.findViewById(R.id.vTitleBar);
        this.mBtnLeave.setOnClickListener((View.OnClickListener)this);
        this.updateData();
    }

    public void setTitlePadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.mTitleBar.setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);
    }

    public void updateData() {
        if (this.isInEditMode()) {
            return;
        }
        CmmConfContext confContext = ConfMgr.getInstance().getConfContext();
        if (confContext == null || confContext.supportPutUserinWaitingListUponEntryFeature()) {
            return;
        }
        MeetingInfo meetingInfo = confContext.getMeetingItem();
        if (meetingInfo == null) {
            return;
        }
        this.mTxtMeetingNumber.setText((CharSequence)StringUtil.formatConfNumber((long)meetingInfo.getMeetingNumber()));
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.btnLeave) {
            this.onClickBtnLeave();
        }
    }

    private void onClickBtnLeave() {
        new LeaveAlertDialog().show(((ZMActivity)this.getContext()).getSupportFragmentManager(), LeaveAlertDialog.class.getName());
    }
}

