/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.zipow.videobox.confapp.CmmFeedbackMgr;
import com.zipow.videobox.confapp.CmmUser;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class NonVerbalFeedbackListItem {
    public static final int ITEM_TYPE_LABEL = 0;
    public static final int ITEM_TYPE_FEEDBACK = 1;
    private String mScreenName;
    private int mFeedback = 0;
    private long mUserId = 0L;
    private int mItemType = 0;

    public NonVerbalFeedbackListItem(int type, CmmUser user) {
        this.mItemType = type;
        if (user != null) {
            this.mUserId = user.getNodeId();
            this.mFeedback = user.getFeedback();
            this.mScreenName = user.getScreenName();
        }
    }

    public long getUserId() {
        return this.mUserId;
    }

    public int getItemType() {
        return this.mItemType;
    }

    public int getFeedback() {
        return this.mFeedback;
    }

    public void setScreenName(String name) {
        this.mScreenName = name;
    }

    public void setFeedback(int feedback) {
        this.mFeedback = feedback;
    }

    public View getView(Context context, View convertView) {
        View view = this.mItemType == 0 ? this.getLabelView(context, convertView) : this.getFeedbackView(context, convertView);
        return view;
    }

    private View getFeedbackView(Context context, View convertView) {
        View view = convertView;
        if (view == null || !"feedback".equals(view.getTag())) {
            view = View.inflate((Context)context, (int)R.layout.zm_non_verbal_fb_item, null);
            view.setTag((Object)"feedback");
        }
        TextView screenName = (TextView)view.findViewById(R.id.txtScreenName);
        ImageView image = (ImageView)view.findViewById(R.id.imgFeedback);
        if (view.isInEditMode()) {
            int iconId;
            if (StringUtil.isEmptyOrNull((String)this.mScreenName)) {
                screenName.setText((CharSequence)"User Screen Name");
            }
            if ((iconId = CmmFeedbackMgr.getIconIdByFeedback(this.mFeedback)) == 0) {
                iconId = R.drawable.zm_ic_like;
            }
            image.setImageResource(iconId);
        } else {
            if (StringUtil.isEmptyOrNull((String)this.mScreenName)) {
                screenName.setVisibility(8);
            } else {
                screenName.setText((CharSequence)this.mScreenName);
            }
            int iconId = CmmFeedbackMgr.getIconIdByFeedback(this.mFeedback);
            if (iconId == 0) {
                image.setVisibility(8);
            } else {
                image.setImageResource(iconId);
            }
        }
        return view;
    }

    private View getLabelView(Context context, View convertView) {
        View view = convertView;
        if (view == null || !"fbLabel".equals(view.getTag())) {
            view = View.inflate((Context)context, (int)R.layout.zm_non_verbal_fb_label_item, null);
        }
        return view;
    }
}

