/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ForgetPasswordActivity;
import com.zipow.videobox.IMActivity;
import com.zipow.videobox.LoginActivity;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.dialog.FbConfirmCreateAccountDialog;
import com.zipow.videobox.fragment.MMSSOLoginFragment;
import com.zipow.videobox.fragment.MyProfileFragment;
import com.zipow.videobox.ptapp.AutoLogoffChecker;
import com.zipow.videobox.ptapp.FBAuthHelper;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.PTAppProtos;
import com.zipow.videobox.ptapp.PT_LOGIN_TYPE;
import com.zipow.videobox.ptapp.ZoomProductHelper;
import com.zipow.videobox.util.IAccountNameValidator;
import com.zipow.videobox.util.PreferenceUtil;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.util.ZoomAccountNameValidator;
import java.io.Closeable;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import us.zoom.androidlib.app.ZMActivity;
import us.zoom.androidlib.app.ZMDialogFragment;
import us.zoom.androidlib.app.ZMFragment;
import us.zoom.androidlib.cache.IoUtils;
import us.zoom.androidlib.util.EncryptUtils;
import us.zoom.androidlib.util.EventAction;
import us.zoom.androidlib.util.FingerprintUtil;
import us.zoom.androidlib.util.IUIElement;
import us.zoom.androidlib.util.NetworkUtil;
import us.zoom.androidlib.util.OsUtil;
import us.zoom.androidlib.util.ResourcesUtil;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.androidlib.util.UIUtil;
import us.zoom.androidlib.util.ZMAsyncTask;
import us.zoom.androidlib.widget.WaitingDialog;
import us.zoom.androidlib.widget.ZMAlertDialog;
import us.zoom.thirdparty.login.LoginType;
import us.zoom.thirdparty.login.ThirdPartyLoginFactory;
import us.zoom.thirdparty.login.facebook.AuthToken;
import us.zoom.thirdparty.login.facebook.FBAuthUtil;
import us.zoom.thirdparty.login.facebook.FacebookError;
import us.zoom.thirdparty.login.facebook.FbUserProfile;
import us.zoom.videomeetings.R;
import us.zoom.videomeetings.ZMBuildConfig;

public class LoginView
extends LinearLayout
implements View.OnClickListener,
TextView.OnEditorActionListener {
    private static final String TAG = LoginView.class.getSimpleName();
    private RetainedFragment mRetainedFragment;
    private int mSelectedProductVendor = 0;
    private Button mBtnBack;
    private View mBtnLoginFacebook;
    private View mBtnLoginGoogle;
    private View mBtnLoginZoom;
    private Button mBtnSignup;
    private View mLinkSSOLogin;
    private View mLinkForgetPassword;
    private EditText mEdtUserName;
    private EditText mEdtPsw;
    private View mPanelLoginViaDivider;
    private View mPanelActions;
    private TextView mTxtAutoLogoffWarn;
    private boolean mIsCachedAccount = false;
    private int mSelectedLoginType = -1;
    private AutoLogoffChecker.AutoLogoffInfo mAutologoffInfo;
    private String mDomainSearchReqID;
    private long mLastLoginStamp;
    private String mAppToken;
    private long mAppExpiresInSecond;
    private IAccountNameValidator mAccountNameValidator = null;
    private ZMAsyncTask<String, Void, FbUserProfile> mGetUserInfoZMAsyncTask;

    public LoginView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public LoginView(Context context) {
        super(context);
        this.initView();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mGetUserInfoZMAsyncTask != null) {
            if (!this.mGetUserInfoZMAsyncTask.isCancelled()) {
                this.mGetUserInfoZMAsyncTask.cancel(true);
            }
            this.mGetUserInfoZMAsyncTask = null;
        }
    }

    private void initView() {
        MyProfileFragment.FingerprintOption fingerprintOption;
        FingerprintUtil fingerprintUtil;
        if (!this.isInEditMode()) {
            this.initRetainedFragment();
        }
        View.inflate((Context)this.getContext(), (int)R.layout.zm_loginwith, (ViewGroup)this);
        this.mBtnBack = (Button)this.findViewById(R.id.btnBack);
        this.mBtnLoginFacebook = this.findViewById(R.id.btnLoginFacebook);
        this.mBtnLoginGoogle = this.findViewById(R.id.btnLoginGoogle);
        this.mBtnLoginZoom = this.findViewById(R.id.btnLoginZoom);
        this.mBtnSignup = (Button)this.findViewById(R.id.btnSignup);
        this.mLinkSSOLogin = this.findViewById(R.id.linkSSOLogin);
        this.mLinkForgetPassword = (TextView)this.findViewById(R.id.linkForgetPassword);
        this.mEdtUserName = (EditText)this.findViewById(R.id.edtUserName);
        this.mEdtPsw = (EditText)this.findViewById(R.id.edtPassword);
        this.mPanelLoginViaDivider = this.findViewById(R.id.panelLoginViaDivider);
        this.mPanelActions = this.findViewById(R.id.panelActions);
        this.mTxtAutoLogoffWarn = (TextView)this.findViewById(R.id.txtAutoLogoffWarn);
        if (Build.VERSION.SDK_INT < 11) {
            this.mEdtUserName.setGravity(3);
            this.mEdtPsw.setGravity(3);
        }
        if (OsUtil.isAtLeastN() && (fingerprintUtil = new FingerprintUtil((ZMActivity)this.getContext())).isSupportFingerprint() && (fingerprintOption = MyProfileFragment.FingerprintOption.readFromPreference()) != null && fingerprintOption.isEnableFingerprintWithUserInfo()) {
            this.mEdtUserName.setText((CharSequence)fingerprintOption.getmUserName());
        }
        this.mEdtPsw.setImeOptions(2);
        this.mEdtPsw.setOnEditorActionListener((TextView.OnEditorActionListener)this);
        this.mBtnBack.setOnClickListener((View.OnClickListener)this);
        this.mBtnLoginFacebook.setOnClickListener((View.OnClickListener)this);
        this.mBtnLoginGoogle.setOnClickListener((View.OnClickListener)this);
        this.mBtnLoginZoom.setOnClickListener((View.OnClickListener)this);
        this.mBtnSignup.setOnClickListener((View.OnClickListener)this);
        this.mLinkSSOLogin.setOnClickListener((View.OnClickListener)this);
        this.mLinkForgetPassword.setOnClickListener((View.OnClickListener)this);
    }

    public void restoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            this.mIsCachedAccount = true;
            this.loadCachedAccount();
            switch (this.mSelectedLoginType) {
                case 0: {
                    this.onClickBtnLoginFacebook();
                    break;
                }
                case 2: {
                    this.onClickBtnLoginGoogle();
                    break;
                }
                case 101: {
                    this.onClickBtnLoginSSO();
                }
            }
        } else {
            this.mIsCachedAccount = savedInstanceState.getBoolean("mIsCachedAccount");
            this.mAutologoffInfo = (AutoLogoffChecker.AutoLogoffInfo)savedInstanceState.getSerializable("mIsAutoLogff");
            this.mDomainSearchReqID = savedInstanceState.getString("mDomainSearchReqID");
            this.mLastLoginStamp = savedInstanceState.getLong("mLastLoginStamp", 0L);
        }
        this.initVendorOptions();
        TextWatcher userNameValidator = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                LoginView.this.updateLoginZoomButton();
                if (LoginView.this.mIsCachedAccount) {
                    LoginView.this.mEdtPsw.setText((CharSequence)"");
                }
                LoginView.this.mIsCachedAccount = false;
            }
        };
        TextWatcher pwdValidator = new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                LoginView.this.updateLoginZoomButton();
                LoginView.this.mIsCachedAccount = false;
            }
        };
        this.mEdtUserName.addTextChangedListener(userNameValidator);
        this.mEdtPsw.addTextChangedListener(pwdValidator);
        this.updateLoginZoomButton();
        this.updateAutoLogoffStatus();
    }

    private void updateAutoLogoffStatus() {
        if (this.mAutologoffInfo != null) {
            this.mTxtAutoLogoffWarn.setVisibility(0);
            Resources res = this.getResources();
            if (res == null) {
                return;
            }
            switch (this.mAutologoffInfo.type) {
                case 1: {
                    this.mTxtAutoLogoffWarn.setText((CharSequence)res.getString(R.string.zm_lbl_warn_autologoff, new Object[]{this.mAutologoffInfo.minutes}));
                    break;
                }
                case 2: {
                    this.mTxtAutoLogoffWarn.setText((CharSequence)res.getString(R.string.zm_lbl_warn_autologoff_sso));
                    break;
                }
            }
            this.mEdtUserName.setText((CharSequence)this.mAutologoffInfo.userName);
            if (!TextUtils.isEmpty((CharSequence)this.mAutologoffInfo.userName)) {
                this.mEdtPsw.requestFocus();
            }
        }
    }

    public void saveInstanceState(Bundle outState) {
        outState.putBoolean("mIsCachedAccount", this.mIsCachedAccount);
        outState.putSerializable("mIsAutoLogff", (Serializable)this.mAutologoffInfo);
        outState.putString("mDomainSearchReqID", this.mDomainSearchReqID);
        outState.putLong("mLastLoginStamp", this.mLastLoginStamp);
    }

    public void setSelectedProductVendor(int vendor) {
        this.mSelectedProductVendor = vendor;
    }

    public void setSelectedLoginType(int loginType) {
        this.mSelectedLoginType = loginType;
    }

    public void setAutologoffInfo(AutoLogoffChecker.AutoLogoffInfo info) {
        this.mAutologoffInfo = info;
        this.updateAutoLogoffStatus();
    }

    private void initRetainedFragment() {
        this.mRetainedFragment = this.getRetainedFragment();
        if (this.mRetainedFragment == null) {
            this.mRetainedFragment = new RetainedFragment();
            ((ZMActivity)this.getContext()).getSupportFragmentManager().beginTransaction().add((Fragment)this.mRetainedFragment, RetainedFragment.class.getName()).commit();
        }
    }

    private RetainedFragment getRetainedFragment() {
        if (this.mRetainedFragment != null) {
            return this.mRetainedFragment;
        }
        FragmentManager fm = ((ZMActivity)this.getContext()).getSupportFragmentManager();
        RetainedFragment retainedFragment = (RetainedFragment)fm.findFragmentByTag(RetainedFragment.class.getName());
        return retainedFragment;
    }

    public void onCallStatusChanged(long result) {
    }

    public void loginFacebookWithAcceptedTos() {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            ZMActivity activity = (ZMActivity)this.getContext();
            AuthFailedDialog.show(activity, message);
            return;
        }
        PTApp ptApp = PTApp.getInstance();
        if (ptApp == null) {
            return;
        }
        this.mRetainedFragment.loginFailed = false;
        this.showConnecting(true);
        this.mRetainedFragment.signingType = 0;
        ptApp.loginWithFacebook(this.mAppToken, this.mAppExpiresInSecond, true);
    }

    public void requestFocusPasswd() {
        this.mEdtPsw.requestFocus();
    }

    public void doLoginWithFacebook() {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            ZMActivity activity = (ZMActivity)this.getContext();
            AuthFailedDialog.show(activity, message);
            return;
        }
        PTApp ptApp = PTApp.getInstance();
        if (ptApp == null) {
            return;
        }
        if (!ptApp.isTokenExpired() && ptApp.loginFacebookWithLocalToken() == 0) {
            this.mRetainedFragment.loginFailed = false;
            this.showConnecting(true);
            this.mRetainedFragment.signingType = 0;
        } else {
            PTApp.getInstance().logout(0);
            this.showFBAuthUI();
        }
    }

    public void doLoginWithGoogle() {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            ZMActivity activity = (ZMActivity)this.getContext();
            AuthFailedDialog.show(activity, message);
            return;
        }
        PTApp ptApp = PTApp.getInstance();
        if (ptApp == null) {
            return;
        }
        if (!ptApp.isTokenExpired() && ptApp.loginGoogleWithLocalToken() == 0) {
            this.mRetainedFragment.loginFailed = false;
            this.showConnecting(true);
            this.mRetainedFragment.signingType = 2;
        } else {
            PTApp.getInstance().logout(0);
            this.showGoogleAuthUI();
        }
    }

    public void doLoginWithSSO() {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            ZMActivity activity = (ZMActivity)this.getContext();
            AuthFailedDialog.show(activity, message);
            return;
        }
        PTApp ptApp = PTApp.getInstance();
        if (ptApp == null) {
            return;
        }
        if (!ptApp.isTokenExpired() && ptApp.loginSSOWithLocalToken() == 0) {
            this.mRetainedFragment.loginFailed = false;
            this.showConnecting(true);
            this.mRetainedFragment.signingType = 101;
        } else {
            MMSSOLoginFragment.showAsDialog(((ZMActivity)this.getContext()).getSupportFragmentManager());
        }
    }

    public void loginSSOSite(String siteUrl) {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            ZMActivity activity = (ZMActivity)this.getContext();
            AuthFailedDialog.show(activity, message);
            return;
        }
        this.showSSOAuthUI(siteUrl);
    }

    private void showSSOAuthUI(String siteUrl) {
        ((LoginActivity)this.getContext()).showSSOAuthUI(siteUrl);
    }

    private void showGoogleAuthUI() {
        FBAuthHelper fbAuthHelper = PTApp.getInstance().getFBAuthHelper();
        if (fbAuthHelper == null) {
            return;
        }
        ThirdPartyLoginFactory.build((LoginType)LoginType.Google, (Bundle)ThirdPartyLoginFactory.buildGoogleBundle((String)fbAuthHelper.generateGoogleLoginURL())).login((Activity)((LoginActivity)this.getContext()));
    }

    public void loginZoomWithFingerprint() {
        MyProfileFragment.FingerprintOption fingerprintOption = MyProfileFragment.FingerprintOption.readFromPreference();
        if (fingerprintOption != null && fingerprintOption.isEnableFingerprintWithUserInfo()) {
            EncryptUtils encryptUtils = EncryptUtils.getInstance();
            Context context = this.getContext();
            if (context == null) {
                return;
            }
            if ((context = context.getApplicationContext()) == null) {
                return;
            }
            this.mEdtPsw.setText((CharSequence)encryptUtils.decryptString(context, fingerprintOption.getmPassword(), context.getPackageName()));
            this.onClickBtnLoginZoom();
        }
    }

    public void loginZoom(String account, String password, boolean keepLogin, boolean useCachedAccount, boolean returnToLoginWithIfFailed) {
        if (System.currentTimeMillis() - this.mLastLoginStamp < 500L) {
            return;
        }
        this.mLastLoginStamp = System.currentTimeMillis();
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            ZMActivity activity = (ZMActivity)this.getContext();
            AuthFailedDialog.show(activity, message);
            return;
        }
        this.showConnecting(true);
        this.mRetainedFragment.signingType = 100;
        PTApp ptApp = PTApp.getInstance();
        if (useCachedAccount && ptApp.getSavedZoomAccount() != null) {
            int res = ptApp.loginZoomWithLocalToken();
            if (res != 0) {
                this.showConnecting(false);
                return;
            }
        } else {
            ptApp.loginZoom(account, password, keepLogin);
        }
        this.mRetainedFragment.signingType = 100;
        this.mRetainedFragment.loginFailed = false;
    }

    private void showFBAuthUI() {
        FBAuthHelper fbAuthHelper = PTApp.getInstance().getFBAuthHelper();
        if (fbAuthHelper == null) {
            return;
        }
        ThirdPartyLoginFactory.build((LoginType)LoginType.Facebook, (Bundle)ThirdPartyLoginFactory.buildFacebookBundle((String)fbAuthHelper.generateFBLoginURL(), (int)100)).login((Activity)((LoginActivity)this.getContext()));
    }

    public void onFBAuthFailed(String error) {
        this.showConnecting(false);
        ZMActivity activity = (ZMActivity)this.getContext();
        AuthFailedDialog.show(activity, error);
    }

    public void onFBAuthFailed(FacebookError e) {
        this.showConnecting(false);
        String message = e.getMessage();
        if (message != null && message.indexOf("invalid_key:Android key mismatch") >= 0) {
            message = "Invalid debug build to integrate with Facebook App. Please contact Reed Yang to get debug keystore.";
        }
        ZMActivity activity = (ZMActivity)this.getContext();
        AuthFailedDialog.show(activity, message);
    }

    public void onFBAuthCancel() {
        this.showConnecting(false);
        if (PTApp.getInstance().getPTLoginType() == 0) {
            PTApp.getInstance().logout(0);
        }
    }

    public void onSSOAuthSuccess(String siteUrl, String token) {
        this.startLoginSSOWithToken(token);
        ZMActivity activity = (ZMActivity)this.getContext();
        Fragment fragment = activity.getSupportFragmentManager().findFragmentByTag(MMSSOLoginFragment.class.getName());
        if (fragment != null) {
            ((MMSSOLoginFragment)fragment).onSSOSuccess();
        }
    }

    public void onSSOAuthFailed(int errorCode) {
        this.showConnecting(false);
        ZMActivity activity = (ZMActivity)this.getContext();
        Fragment fragment = activity.getSupportFragmentManager().findFragmentByTag(MMSSOLoginFragment.class.getName());
        if (fragment != null) {
            ((MMSSOLoginFragment)fragment).onSSOError(errorCode);
        }
    }

    public void startFBAppIMAuth(AuthToken authToken) {
        if (StringUtil.isEmptyOrNull((String)authToken.token)) {
            return;
        }
        this.mRetainedFragment.loginFailed = false;
        this.showConnecting(true);
        long expiresInSeconds = (authToken.expires - System.currentTimeMillis()) / 1000L;
        this.mAppToken = authToken.token;
        this.mAppExpiresInSecond = expiresInSeconds;
        PTApp ptApp = PTApp.getInstance();
        ptApp.loginXmppServer(authToken.token);
        ptApp.loginWithFacebook(authToken.token, expiresInSeconds, false);
        this.mRetainedFragment.signingType = 0;
    }

    public void startFBIMAuth(String authCode, long expiresInSeconds) {
        if (StringUtil.isEmptyOrNull((String)authCode)) {
            return;
        }
        this.mRetainedFragment.loginFailed = false;
        this.showConnecting(true);
        PTApp ptApp = PTApp.getInstance();
        ptApp.loginXmppServer(authCode);
        ptApp.loginWithFacebookWithToken(authCode, expiresInSeconds);
        this.mRetainedFragment.signingType = 0;
    }

    public void startGoogleIMAuth(String authCode, String refreshCode) {
        if (StringUtil.isEmptyOrNull((String)authCode) || StringUtil.isEmptyOrNull((String)refreshCode)) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getContext();
        PTApp ptApp = PTApp.getInstance();
        int result = ptApp.loginGoogleWithCodes(authCode, refreshCode);
        if (result == 0) {
            this.mRetainedFragment.loginFailed = false;
            this.showConnecting(true);
            this.mRetainedFragment.signingType = 2;
        } else if (result == 6000) {
            String message = this.getResources().getString(R.string.zm_alert_web_auth_failed_33814);
            AuthFailedDialog.show(activity, message);
        } else {
            AuthFailedDialog.show(activity, null);
        }
    }

    public void startLoginSSOWithToken(String token) {
        if (StringUtil.isEmptyOrNull((String)token)) {
            return;
        }
        PTApp ptApp = PTApp.getInstance();
        if (0 == ptApp.loginWithSSOToken(token)) {
            this.mRetainedFragment.loginFailed = false;
            this.showConnecting(true);
            this.mRetainedFragment.signingType = 101;
        } else {
            ZMActivity activity = (ZMActivity)this.getContext();
            AuthFailedDialog.show(activity, null);
        }
    }

    public void showConnecting(boolean waiting) {
        if (this.isConnecting() == waiting) {
            return;
        }
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        if (!activity.isActive()) {
            return;
        }
        FragmentManager fm = activity.getSupportFragmentManager();
        if (fm == null) {
            return;
        }
        if (waiting) {
            WaitingDialog dialog = new WaitingDialog(R.string.zm_msg_connecting, !UIMgr.isLargeMode((Context)activity));
            dialog.show(fm, "ConnectingDialog");
        } else {
            WaitingDialog dialog = (WaitingDialog)fm.findFragmentByTag("ConnectingDialog");
            if (dialog != null) {
                dialog.dismiss();
            }
        }
    }

    public boolean isConnecting() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return false;
        }
        FragmentManager fm = activity.getSupportFragmentManager();
        if (fm == null) {
            return false;
        }
        WaitingDialog dialog = (WaitingDialog)fm.findFragmentByTag("ConnectingDialog");
        return dialog != null;
    }

    public void onIMLogin(long result) {
        if (result == 3L && !PTApp.getInstance().isAuthenticating()) {
            this.showConnecting(false);
            if (this.mRetainedFragment.signingType == 2) {
                AuthFailedDialog.show((ZMActivity)this.getContext(), this.getResources().getString(R.string.zm_alert_web_auth_failed_33814));
            }
        }
        if (!PT_LOGIN_TYPE.isTypeSupportIM(this.mRetainedFragment.signingType)) {
            return;
        }
        if (result != 0L) {
            if (result == 3L) {
                if (!PTApp.getInstance().isAuthenticating()) {
                    this.showConnecting(false);
                    if (this.mRetainedFragment.signingType == 2) {
                        this.showGoogleAuthUI();
                    } else if (this.mRetainedFragment.signingType == 0) {
                        this.showFBAuthUI();
                    }
                }
            } else if (result == 2L || result == 1L) {
                // empty if block
            }
        }
    }

    private void saveZoomUserInfo() {
        FingerprintUtil fingerprintUtil;
        if (OsUtil.isAtLeastN() && (fingerprintUtil = new FingerprintUtil((ZMActivity)this.getContext())).isHardwareDetected()) {
            String name = this.mEdtUserName.getText().toString();
            String password = this.mEdtPsw.getText().toString();
            if (!StringUtil.isEmptyOrNull((String)name) && !StringUtil.isEmptyOrNull((String)password)) {
                Context context;
                MyProfileFragment.FingerprintOption fingerprintOption = MyProfileFragment.FingerprintOption.readFromPreference();
                if (fingerprintOption == null) {
                    fingerprintOption = new MyProfileFragment.FingerprintOption();
                }
                if ((context = this.getContext()) == null) {
                    return;
                }
                if ((context = context.getApplicationContext()) == null) {
                    return;
                }
                password = EncryptUtils.getInstance().encryptString(context, password, context.getPackageName());
                if (!StringUtil.isEmptyOrNull((String)name) && !StringUtil.isEmptyOrNull((String)password)) {
                    fingerprintOption.setmUserName(name);
                    fingerprintOption.setmPassword(password);
                    fingerprintOption.savePreference();
                }
            }
        }
    }

    public void onWebLogin(long result) {
        if (result == 0L) {
            boolean useZoomLogin;
            boolean bl = useZoomLogin = this.mRetainedFragment.signingType == 100;
            if (useZoomLogin) {
                this.saveZoomUserInfo();
            }
            PreferenceUtil.saveBooleanValue("timed_chat", false);
            this.showIMActivity(useZoomLogin);
        } else if (result == 2011L) {
            if (!this.isConnecting()) {
                return;
            }
            ZMActivity activity = (ZMActivity)this.getContext();
            if (activity == null) {
                return;
            }
            Fragment fragment = activity.getSupportFragmentManager().findFragmentByTag(MMSSOLoginFragment.class.getName());
            if (fragment != null) {
                ((MMSSOLoginFragment)fragment).onSSOSuccess();
            }
            PTApp.getInstance().setRencentJid("");
            PTApp.getInstance().logout(0);
            this.showConnecting(false);
            ForceRedirectLoginDialog forceRedirectLoginDialog = new ForceRedirectLoginDialog(2);
            forceRedirectLoginDialog.show(activity.getSupportFragmentManager(), ForceRedirectLoginDialog.class.getName());
        } else if (result == 2012L) {
            if (!this.isConnecting()) {
                return;
            }
            PTApp.getInstance().logout(0);
            this.showConnecting(false);
            ZMActivity activity = (ZMActivity)this.getContext();
            if (activity == null) {
                return;
            }
            ForceRedirectLoginDialog forceRedirectLoginDialog = new ForceRedirectLoginDialog(1);
            forceRedirectLoginDialog.show(activity.getSupportFragmentManager(), ForceRedirectLoginDialog.class.getName());
        } else if (result == 1133L) {
            if (!this.isConnecting()) {
                return;
            }
            PTApp.getInstance().setRencentJid("");
            PTApp.getInstance().logout(0);
            this.pullUserProfile();
        } else {
            if (!this.isConnecting()) {
                return;
            }
            PTApp.getInstance().setRencentJid("");
            PTApp.getInstance().logout(0);
            this.showConnecting(false);
            ZMActivity loginActivity = (ZMActivity)this.getContext();
            Fragment fragment = loginActivity.getSupportFragmentManager().findFragmentByTag(MMSSOLoginFragment.class.getName());
            if (fragment != null) {
                ((MMSSOLoginFragment)fragment).onSSOError((int)result);
                return;
            }
            String message = this.getLoginErrorMessage(result);
            if (!this.mRetainedFragment.loginFailed) {
                this.mRetainedFragment.loginFailed = true;
                PTApp.getInstance().logout(0);
                ZMActivity activity = (ZMActivity)this.getContext();
                AuthFailedDialog.show(activity, message);
            }
            this.mRetainedFragment.signingType = 102;
        }
    }

    private String getLoginErrorMessage(long result) {
        switch ((int)result) {
            case 1001: 
            case 1002: {
                return this.getResources().getString(R.string.zm_alert_auth_zoom_failed_msg);
            }
            case 1006: {
                return this.getResources().getString(R.string.zm_alert_auth_token_failed_msg);
            }
            case 1019: {
                return this.getResources().getString(R.string.zm_alert_account_locked);
            }
            case 2025: 
            case 2026: {
                return this.getResources().getString(R.string.zm_alert_login_disable_19086);
            }
        }
        return this.getResources().getString(R.string.zm_alert_auth_error_code_msg, new Object[]{result});
    }

    public void onWebAccessFail() {
        this.showConnecting(false);
        int strId = 0;
        switch (this.mRetainedFragment.signingType) {
            case 0: {
                strId = R.string.zm_alert_connect_facebook_failed_msg;
                break;
            }
            case 2: {
                strId = R.string.zm_alert_connect_google_failed_msg;
                break;
            }
            case 100: 
            case 101: {
                strId = R.string.zm_alert_connect_zoomus_failed_msg;
            }
        }
        if (!this.mRetainedFragment.loginFailed && strId != 0) {
            this.mRetainedFragment.loginFailed = true;
            String message = this.getResources().getString(strId);
            AuthFailedDialog.show((ZMActivity)this.getContext(), message);
        }
    }

    private void showIMActivity(boolean usePasswd) {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        if (usePasswd) {
            IMActivity.showWithPasswd((Context)activity);
        } else {
            IMActivity.show((Context)activity);
        }
        activity.finish();
        activity.overridePendingTransition(R.anim.zm_slide_in_right, R.anim.zm_slide_out_left);
    }

    public void onIMLocalStatusChanged(int status) {
        switch (status) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.showConnecting(true);
            }
        }
    }

    public void onIMReceived(PTAppProtos.IMMessage message) {
    }

    public void onIMBuddyPresence(PTAppProtos.BuddyItem item) {
    }

    public void onIMBuddyPic(PTAppProtos.BuddyItem item) {
    }

    public void onIMBuddySort() {
    }

    private void loadCachedAccount() {
        PTAppProtos.ZoomAccount account = PTApp.getInstance().getSavedZoomAccount();
        if (account != null) {
            this.mEdtUserName.setText((CharSequence)account.getUserName());
            this.mEdtPsw.setText((CharSequence)"$$$$$$$$$$");
            this.mEdtUserName.setSelection(this.mEdtUserName.getText().length(), this.mEdtUserName.getText().length());
            this.mEdtPsw.setSelection(this.mEdtPsw.getText().length(), this.mEdtPsw.getText().length());
        }
    }

    public String querySSODomainByEmail(String email) {
        if (TextUtils.isEmpty((CharSequence)email) || !StringUtil.isValidEmailAddress((String)email)) {
            return null;
        }
        this.mDomainSearchReqID = PTApp.getInstance().querySSOVanityURL(email);
        if (!TextUtils.isEmpty((CharSequence)this.mDomainSearchReqID)) {
            this.showConnecting(true);
        }
        return this.mDomainSearchReqID;
    }

    public void onQuerySSOVanityURL(String reqId, int result, String url) {
        if (!this.isConnecting()) {
            return;
        }
        if (!TextUtils.equals((CharSequence)reqId, (CharSequence)this.mDomainSearchReqID)) {
            return;
        }
        Fragment fragment = ((ZMActivity)this.getContext()).getSupportFragmentManager().findFragmentByTag(MMSSOLoginFragment.class.getName());
        if (fragment == null) {
            return;
        }
        if (result == 0 && !TextUtils.isEmpty((CharSequence)url)) {
            this.showConnecting(false);
            PTApp.getInstance().setSSOURL(url);
            this.loginSSOSite(url);
        } else {
            this.showConnecting(false);
            ((MMSSOLoginFragment)fragment).onSSOError(result);
        }
    }

    private void initVendorOptions() {
        ZoomProductHelper productHelper;
        if (this.mSelectedProductVendor < 0 && (productHelper = PTApp.getInstance().getZoomProductHelper()) != null) {
            this.mSelectedProductVendor = productHelper.getCurrentVendor();
        }
        int countOtherLoginTypes = 0;
        if (ZMBuildConfig.BUILD_TARGET == 0 && this.mSelectedProductVendor == 1) {
            this.mPanelLoginViaDivider.setVisibility(8);
            this.mPanelActions.setVisibility(8);
            this.mLinkForgetPassword.setVisibility(8);
            this.mLinkSSOLogin.setVisibility(8);
            this.mBtnSignup.setVisibility(8);
        } else {
            if (ResourcesUtil.getBoolean((View)this, (int)R.bool.zm_config_enable_sso_login, (boolean)true)) {
                this.mLinkSSOLogin.setVisibility(0);
                ++countOtherLoginTypes;
            } else {
                this.mLinkSSOLogin.setVisibility(8);
            }
            if (ResourcesUtil.getBoolean((View)this, (int)R.bool.zm_config_enable_google_login, (boolean)true)) {
                this.mBtnLoginGoogle.setVisibility(0);
                ++countOtherLoginTypes;
            } else {
                this.mBtnLoginGoogle.setVisibility(8);
            }
            if (ResourcesUtil.getBoolean((View)this, (int)R.bool.zm_config_enable_facebook_login, (boolean)true)) {
                this.mBtnLoginFacebook.setVisibility(0);
                ++countOtherLoginTypes;
            } else {
                this.mBtnLoginFacebook.setVisibility(8);
            }
            if (ResourcesUtil.getBoolean((View)this, (int)R.bool.zm_config_show_forgot_password, (boolean)true)) {
                this.mLinkForgetPassword.setVisibility(0);
            } else {
                this.mLinkForgetPassword.setVisibility(8);
            }
            if (ResourcesUtil.getBoolean((View)this, (int)R.bool.zm_config_show_signup_on_login_screen, (boolean)false)) {
                this.mBtnSignup.setVisibility(0);
            } else {
                this.mBtnSignup.setVisibility(8);
            }
        }
        if (countOtherLoginTypes > 0) {
            this.mPanelLoginViaDivider.setVisibility(0);
            this.mPanelActions.setVisibility(0);
        } else {
            this.mPanelLoginViaDivider.setVisibility(8);
            this.mPanelActions.setVisibility(8);
        }
    }

    public void onClick(View v) {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null || !activity.isActive()) {
            return;
        }
        int id2 = v.getId();
        if (id2 == R.id.btnBack) {
            this.onClickBtnBack();
        } else if (id2 == R.id.btnLoginFacebook) {
            this.onClickBtnLoginFacebook();
        } else if (id2 == R.id.btnLoginGoogle) {
            this.onClickBtnLoginGoogle();
        } else if (id2 == R.id.btnLoginZoom) {
            this.onClickBtnLoginZoom();
        } else if (id2 == R.id.btnSignup) {
            this.onClickBtnSignup();
        } else if (id2 == R.id.linkSSOLogin) {
            this.onClickBtnLoginSSO();
        } else if (id2 == R.id.linkForgetPassword) {
            this.onClickBtnForgetPassword();
        }
    }

    private void onClickBtnBack() {
        LoginActivity activity = (LoginActivity)this.getContext();
        if (activity == null) {
            return;
        }
        if (activity.isShownForTokenExpired()) {
            PTApp.getInstance().logout(0);
        }
        activity.onBackPressed();
    }

    private void onClickBtnLoginFacebook() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        UIUtil.closeSoftKeyboard((Context)activity, (View)this.mEdtUserName);
        this.doLoginWithFacebook();
    }

    private void onClickBtnLoginGoogle() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        UIUtil.closeSoftKeyboard((Context)activity, (View)this.mEdtUserName);
        this.doLoginWithGoogle();
    }

    private void onClickBtnLoginZoom() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        UIUtil.closeSoftKeyboard((Context)activity, (View)this.mEdtUserName);
        String account = this.mEdtUserName.getText().toString();
        String password = this.mEdtPsw.getText().toString();
        IAccountNameValidator validator = this.getAccountNameValidator();
        account = validator.validate(account);
        if (StringUtil.isEmptyOrNull((String)account)) {
            this.mEdtUserName.requestFocus();
            return;
        }
        if (StringUtil.isEmptyOrNull((String)password)) {
            this.mEdtPsw.requestFocus();
            return;
        }
        ZoomProductHelper helper = PTApp.getInstance().getZoomProductHelper();
        if (helper != null && helper.getCurrentVendor() != this.mSelectedProductVendor) {
            helper.vendorSwitchTo(this.mSelectedProductVendor);
        }
        this.loginZoom(account, password, true, this.mIsCachedAccount, true);
    }

    private void onClickBtnLoginSSO() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        UIUtil.closeSoftKeyboard((Context)activity, (View)this.mEdtUserName);
        this.doLoginWithSSO();
    }

    private void onClickBtnSignup() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity == null) {
            return;
        }
        if (ResourcesUtil.getBoolean((View)this, (int)R.bool.zm_config_show_signup_as_web_url, (boolean)false)) {
            String url = PTApp.getInstance().getURLByType(6);
            if (!StringUtil.isEmptyOrNull((String)url)) {
                UIUtil.openURL((Context)activity, (String)url);
            }
        } else {
            UIUtil.openURL((Context)activity, (String)(this.getZoomScheme() + "://client/signup"));
        }
    }

    private void onClickBtnForgetPassword() {
        ZMActivity activity = (ZMActivity)this.getContext();
        if (activity != null) {
            if (ResourcesUtil.getBoolean((View)this, (int)R.bool.zm_config_show_forgot_password_as_web_url, (boolean)false)) {
                String url = PTApp.getInstance().getURLByType(7);
                if (url != null) {
                    UIUtil.openURL((Context)activity, (String)url);
                }
            } else {
                ForgetPasswordActivity.show(activity);
            }
        }
    }

    private String getZoomScheme() {
        Context context = this.getContext();
        if (context == null) {
            return "";
        }
        return context.getString(R.string.zm_zoom_scheme);
    }

    private void updateLoginZoomButton() {
        this.mBtnLoginZoom.setEnabled(this.validateZoomAccount());
    }

    private boolean validateZoomAccount() {
        String userName = this.mEdtUserName.getText().toString();
        String password = this.mEdtPsw.getText().toString();
        IAccountNameValidator validator = this.getAccountNameValidator();
        userName = validator.validate(userName);
        if (StringUtil.isEmptyOrNull((String)userName)) {
            return false;
        }
        return password.length() != 0;
    }

    private IAccountNameValidator getAccountNameValidator() {
        if (this.mAccountNameValidator != null) {
            return this.mAccountNameValidator;
        }
        String className = ResourcesUtil.getString((View)this, (int)R.string.zm_config_account_name_validator);
        try {
            Class<?> clazz = Class.forName(className);
            this.mAccountNameValidator = (IAccountNameValidator)clazz.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mAccountNameValidator == null) {
            this.mAccountNameValidator = new ZoomAccountNameValidator();
        }
        return this.mAccountNameValidator;
    }

    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        switch (actionId) {
            case 2: {
                this.onClickBtnLoginZoom();
                return true;
            }
        }
        return false;
    }

    private void pullUserProfile() {
        if (!NetworkUtil.hasDataNetwork((Context)VideoBoxApplication.getInstance())) {
            String message = this.getResources().getString(R.string.zm_alert_network_disconnected);
            ZMActivity activity = (ZMActivity)this.getContext();
            AuthFailedDialog.show(activity, message);
            return;
        }
        if (!StringUtil.isEmptyOrNull((String)this.mAppToken)) {
            this.mGetUserInfoZMAsyncTask = new ZMAsyncTask<String, Void, FbUserProfile>(){

                protected FbUserProfile doInBackground(String ... params) {
                    FbUserProfile fbUserProfile;
                    InputStream is;
                    String strUrl = params[0];
                    try {
                        URL url = new URL(strUrl);
                        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
                        int status = urlConnection.getResponseCode();
                        is = status != 200 ? urlConnection.getErrorStream() : urlConnection.getInputStream();
                        fbUserProfile = FbUserProfile.parse((InputStream)is);
                    }
                    catch (Exception e) {
                        return null;
                    }
                    IoUtils.closeSilently((Closeable)is);
                    if (this.isCancelled()) {
                        return null;
                    }
                    return fbUserProfile;
                }

                protected void onPostExecute(FbUserProfile result) {
                    LoginView.this.mGetUserInfoZMAsyncTask = null;
                    ZMActivity activity = (ZMActivity)LoginView.this.getContext();
                    if (activity == null || activity.isDestroyed()) {
                        return;
                    }
                    LoginView.this.showConnecting(false);
                    if (result == null) {
                        AuthFailedDialog.show(activity, LoginView.this.getResources().getString(R.string.zm_alert_network_disconnected));
                        return;
                    }
                    if (!StringUtil.isEmptyOrNull((String)result.getErrorMsg())) {
                        AuthFailedDialog.show(activity, result.getErrorMsg());
                        return;
                    }
                    FbConfirmCreateAccountDialog.show(activity, result);
                }
            };
            this.mGetUserInfoZMAsyncTask.execute((Object[])new String[]{FBAuthUtil.generateGraphUserUrl((String)this.mAppToken)});
        }
    }

    public static class RetainedFragment
    extends ZMFragment {
        public int signingType = 102;
        public boolean loginFailed = false;

        public RetainedFragment() {
            this.setRetainInstance(true);
        }
    }

    public static class ForceRedirectLoginDialog
    extends ZMDialogFragment
    implements View.OnClickListener {
        private static final int MODE_GOOGLE = 1;
        private static final int MODE_SSO = 2;
        int mMode = 1;

        public ForceRedirectLoginDialog(int mode) {
            this.mMode = mode;
            this.setCancelable(true);
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            ZMAlertDialog.Builder builder = new ZMAlertDialog.Builder((Context)this.getActivity()).setCancelable(true).setTheme(R.style.ZMDialog_Material_RoundRect).setView(this.createContent(), true);
            ZMAlertDialog dialog = builder.create();
            dialog.setCanceledOnTouchOutside(true);
            return dialog;
        }

        private View createContent() {
            if (this.getActivity() == null) {
                return null;
            }
            ContextThemeWrapper contextThemeWrapper = new ContextThemeWrapper((Context)this.getActivity(), R.style.ZMDialog_Material);
            View view = View.inflate((Context)contextThemeWrapper, (int)R.layout.zm_login_force_redirect, null);
            view.findViewById(R.id.llRedirect).setOnClickListener((View.OnClickListener)this);
            view.findViewById(R.id.llCancel).setOnClickListener((View.OnClickListener)this);
            TextView txtTitle = (TextView)view.findViewById(R.id.txtTitle);
            TextView txtSubTitle = (TextView)view.findViewById(R.id.txtSubTitle);
            TextView txtOk = (TextView)view.findViewById(R.id.txtOk);
            switch (this.mMode) {
                case 1: {
                    txtTitle.setText(R.string.zm_title_login_with_google_13762);
                    txtSubTitle.setText(R.string.zm_alert_login_with_google_13762);
                    txtOk.setText(R.string.zm_title_login_with_google);
                    break;
                }
                case 2: {
                    txtTitle.setText(R.string.zm_title_login_with_sso_13762);
                    txtSubTitle.setText(R.string.zm_alert_login_with_sso_13762);
                    txtOk.setText(R.string.zm_btn_login_with_sso_13762);
                    break;
                }
            }
            return view;
        }

        public void onClick(View v) {
            int id2 = v.getId();
            LoginActivity activity = (LoginActivity)this.getActivity();
            if (activity == null) {
                return;
            }
            if (id2 == R.id.llRedirect) {
                LoginView loginView = activity.getmLoginView();
                if (loginView == null) {
                    return;
                }
                View view = null;
                switch (this.mMode) {
                    case 1: {
                        view = loginView.findViewById(R.id.btnLoginGoogle);
                        break;
                    }
                    case 2: {
                        view = loginView.findViewById(R.id.linkSSOLogin);
                        break;
                    }
                }
                if (view == null) {
                    return;
                }
                this.dismissAllowingStateLoss();
                view.performClick();
            } else if (id2 == R.id.llCancel) {
                this.dismissAllowingStateLoss();
            }
        }
    }

    public static class AuthFailedDialog
    extends ZMDialogFragment {
        public AuthFailedDialog() {
            this.setCancelable(true);
        }

        public static AuthFailedDialog getAuthFailedDialog(ZMActivity zmActivity) {
            return (AuthFailedDialog)zmActivity.getSupportFragmentManager().findFragmentByTag(AuthFailedDialog.class.getName());
        }

        public static void show(ZMActivity zmActivity, final String message) {
            zmActivity.getNonNullEventTaskManagerOrThrowException().push(new EventAction(){

                public void run(IUIElement ui) {
                    AuthFailedDialog dialog = new AuthFailedDialog();
                    Bundle args = new Bundle();
                    args.putString("message", message);
                    dialog.setArguments(args);
                    dialog.show(((ZMActivity)ui).getSupportFragmentManager(), AuthFailedDialog.class.getName());
                }
            });
        }

        public void onStart() {
            super.onStart();
        }

        public Dialog onCreateDialog(Bundle savedInstanceState) {
            String message = this.getArguments().getString("message");
            return new ZMAlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.zm_alert_login_failed).setMessage(message).setNegativeButton(R.string.zm_btn_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
        }

        public void onDismiss(DialogInterface dialog) {
            super.onDismiss(dialog);
        }
    }
}

