/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.zipow.videobox.ptapp.PTApp;
import com.zipow.videobox.ptapp.mm.ZoomBuddy;
import com.zipow.videobox.ptapp.mm.ZoomMessenger;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.AvatarView;
import com.zipow.videobox.view.InviteLocalContactsListView;
import com.zipow.videobox.view.LocalContactItem;
import java.io.File;
import us.zoom.androidlib.util.StringUtil;
import us.zoom.videomeetings.R;

public class LocalContactItemView
extends LinearLayout {
    private LocalContactItem mItem;
    private TextView mTxtScreenName;
    private AvatarView mAvatarView;
    private View mBtnInvite;
    private View mTxtAdded;
    private InviteLocalContactsListView mParentListView;
    private Handler mHandler = new Handler();

    public LocalContactItemView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public LocalContactItemView(Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.inflateLayout();
        this.mTxtScreenName = (TextView)this.findViewById(R.id.txtScreenName);
        this.mAvatarView = (AvatarView)this.findViewById(R.id.avatarView);
        this.mBtnInvite = this.findViewById(R.id.btnInvite);
        this.mTxtAdded = this.findViewById(R.id.txtAdded);
        this.mBtnInvite.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (LocalContactItemView.this.mParentListView != null && LocalContactItemView.this.mItem != null) {
                    LocalContactItemView.this.mParentListView.showUserActions(LocalContactItemView.this.mItem);
                }
            }
        });
    }

    public void setParentListView(InviteLocalContactsListView parentListView) {
        this.mParentListView = parentListView;
    }

    protected void inflateLayout() {
        View.inflate((Context)this.getContext(), (int)R.layout.zm_local_contact_item, (ViewGroup)this);
    }

    public void setScreenName(CharSequence name) {
        if (name != null) {
            this.mTxtScreenName.setText(name);
        }
    }

    public void setAvatar(String imgPathName) {
        this.mAvatarView.setAvatar(imgPathName);
    }

    public void setAvatar(Bitmap bitmap) {
        this.mAvatarView.setAvatar(bitmap);
    }

    public void setAvatar(Drawable drawable2) {
        this.mAvatarView.setAvatar(drawable2);
    }

    public void setLocalContactItem(LocalContactItem item, boolean needIndicateZoomUser, boolean disableLazyLoadAvatar) {
        if (item == null) {
            return;
        }
        this.mItem = item;
        this.setScreenName(this.mItem.getScreenName());
        this.mAvatarView.setName(this.mItem.getScreenName());
        this.mAvatarView.setBgColorSeedString(this.mItem.getJid());
        if (this.mItem.getContactId() == 0) {
            this.setAvatar((String)null);
            return;
        }
        if (this.mItem.getIsZoomUser()) {
            this.mBtnInvite.setVisibility(8);
            this.mTxtAdded.setVisibility(0);
        } else {
            this.mBtnInvite.setVisibility(0);
            this.mTxtAdded.setVisibility(8);
        }
        if (this.isInEditMode()) {
            return;
        }
    }

    private void lazyLoadContactAvatar(final LocalContactItem item, final Context context) {
        this.setAvatar((String)null);
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (LocalContactItemView.this.mItem != item) {
                    return;
                }
                LocalContactItemView.this.loadAvatar(item, context, false);
            }
        }, 300L);
    }

    private boolean loadAvatar(LocalContactItem item, Context context, boolean fromMemCacheOnly) {
        ZoomMessenger messenger;
        if (this.mItem.getIsZoomUser() && (messenger = PTApp.getInstance().getZoomMessenger()) != null) {
            int count = item.getPhoneNumberCount();
            for (int i = 0; i < count; ++i) {
                File file;
                String avatar;
                String number = item.getNormalizedPhoneNumber(i);
                ZoomBuddy buddy = messenger.getBuddyWithPhoneNumber(number);
                if (buddy == null || StringUtil.isEmptyOrNull((String)(avatar = buddy.getLocalPicturePath())) || !(file = new File(avatar)).exists() || !file.isFile()) continue;
                Bitmap bitmap = ZMBitmapFactory.decodeFile(avatar, fromMemCacheOnly);
                if (bitmap != null) {
                    this.setAvatar(bitmap);
                    return true;
                }
                this.setAvatar((Bitmap)null);
                return false;
            }
        }
        Bitmap bitmap = item.getAvatarBitmap(context, fromMemCacheOnly);
        this.setAvatar(bitmap);
        return bitmap != null;
    }
}

