/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.provider.ContactsContract;
import android.view.View;
import com.zipow.videobox.VideoBoxApplication;
import com.zipow.videobox.ptapp.ABContactsCache;
import com.zipow.videobox.util.ContactsAvatarCache;
import com.zipow.videobox.util.ZMBitmapFactory;
import com.zipow.videobox.view.InviteLocalContactsListView;
import com.zipow.videobox.view.LocalContactItemView;
import java.io.Serializable;
import java.util.ArrayList;
import us.zoom.androidlib.util.CompatUtils;
import us.zoom.androidlib.util.PhoneNumberUtil;
import us.zoom.androidlib.util.StringUtil;

public class LocalContactItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TAG = LocalContactItem.class.getSimpleName();
    private String screenName = "";
    private String sortKey = "";
    private boolean isZoomUser = false;
    private int contactId = 0;
    private ArrayList<PhoneNumber> numbers = new ArrayList();
    private ArrayList<String> emails = new ArrayList();
    private boolean isEmailLoaded = false;
    private boolean needIndicateZoomUser = true;
    private String jid = "";
    private String avatarPath = null;
    private String accountEmail = null;

    public static LocalContactItem fromAddrBookContact(ABContactsCache.Contact abContact) {
        if (abContact == null) {
            return null;
        }
        LocalContactItem contact = new LocalContactItem();
        contact.setScreenName(abContact.displayName);
        contact.addPhoneNumber(abContact.number, abContact.normalizedNumber);
        contact.setContactId(abContact.contactId);
        return contact;
    }

    public View getView(Context context, View convertView, InviteLocalContactsListView parentListView, boolean disableLazyLoadAvatar) {
        LocalContactItemView view = null;
        view = convertView instanceof LocalContactItemView ? (LocalContactItemView)convertView : new LocalContactItemView(context);
        this.bindView(parentListView, view, disableLazyLoadAvatar);
        return view;
    }

    private void bindView(InviteLocalContactsListView parentListView, LocalContactItemView view, boolean disableLazyLoadAvatar) {
        view.setParentListView(parentListView);
        view.setLocalContactItem(this, this.needIndicateZoomUser, disableLazyLoadAvatar);
    }

    public String getScreenName() {
        return this.screenName;
    }

    public void setScreenName(String screenName) {
        if (screenName == null) {
            screenName = "";
        }
        this.screenName = screenName;
    }

    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    public String getSortKey() {
        return this.sortKey;
    }

    public String getAccountEmail() {
        return this.accountEmail;
    }

    public void setAccoutEmail(String email) {
        this.accountEmail = email;
    }

    public int getPhoneNumberCount() {
        return this.numbers.size();
    }

    public String getPhoneNumber(int index) {
        if (index < 0 || index > this.numbers.size()) {
            return null;
        }
        PhoneNumber number = this.numbers.get(index);
        if (number == null) {
            return null;
        }
        return number.number;
    }

    public String getNormalizedPhoneNumber(int index) {
        if (index < 0 || index > this.numbers.size()) {
            return null;
        }
        PhoneNumber number = this.numbers.get(index);
        if (number == null) {
            return null;
        }
        return number.normalizedNumber;
    }

    public String addPhoneNumber(String phoneNumber, String normalizedNumber, String phoneCountryCode) {
        if (StringUtil.isEmptyOrNull((String)phoneNumber)) {
            return phoneNumber;
        }
        if (StringUtil.isEmptyOrNull((String)normalizedNumber)) {
            normalizedNumber = this.getNormalizedNumber(phoneNumber, phoneCountryCode);
        }
        if (this.normalizedNumberExists(normalizedNumber)) {
            return normalizedNumber;
        }
        PhoneNumber numberItem = new PhoneNumber();
        numberItem.number = phoneNumber;
        numberItem.normalizedNumber = normalizedNumber;
        this.numbers.add(numberItem);
        return normalizedNumber;
    }

    public String addPhoneNumber(String phoneNumber, String normalizedNumber) {
        return this.addPhoneNumber(phoneNumber, normalizedNumber, null);
    }

    public void clearPhoneNumbers() {
        this.numbers.clear();
    }

    private boolean normalizedNumberExists(String normalizedNumber) {
        if (normalizedNumber == null) {
            return false;
        }
        for (PhoneNumber number : this.numbers) {
            if (number == null || !normalizedNumber.equals(number.normalizedNumber)) continue;
            return true;
        }
        return false;
    }

    private String getNormalizedNumber(String phoneNumber, String phoneCountryCode) {
        String normalizedPhoneNumber = PhoneNumberUtil.formatNumber((String)phoneNumber, (String)phoneCountryCode);
        return normalizedPhoneNumber;
    }

    public boolean getIsZoomUser() {
        return this.isZoomUser;
    }

    public void setIsZoomUser(boolean isZoomUser) {
        this.isZoomUser = isZoomUser;
    }

    public int getContactId() {
        return this.contactId;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public int getEmailCount() {
        if (this.isEmailLoaded) {
            return this.emails.size();
        }
        return this.loadEmails();
    }

    public String getEmail(int index) {
        if (index < 0 || index >= this.emails.size()) {
            return null;
        }
        return this.emails.get(index);
    }

    public String getJid() {
        return this.jid;
    }

    public void setJid(String jid) {
        this.jid = jid;
    }

    public void setNeedIndicateZoomUser(boolean needIndicateZoomUser) {
        this.needIndicateZoomUser = needIndicateZoomUser;
    }

    public String getAvatarPath() {
        return this.avatarPath;
    }

    public void setAvatarPath(String avatarPath) {
        this.avatarPath = avatarPath;
    }

    private int loadEmails() {
        if (this.contactId == 0) {
            return 0;
        }
        VideoBoxApplication context = VideoBoxApplication.getInstance();
        String[] projection = new String[]{"_id", "data1", "data2"};
        String selection = "contact_id = ?";
        String[] selectionArgs = new String[]{String.valueOf(this.contactId)};
        Cursor cursor = context.getContentResolver().query(ContactsContract.CommonDataKinds.Email.CONTENT_URI, projection, selection, selectionArgs, null);
        if (cursor != null) {
            boolean hasItem = cursor.moveToFirst();
            while (hasItem) {
                String address = cursor.getString(1);
                if (!StringUtil.isEmptyOrNull((String)address) && !this.emailExists(address)) {
                    this.emails.add(address);
                }
                hasItem = cursor.moveToNext();
            }
            cursor.close();
        }
        this.isEmailLoaded = true;
        return this.emails.size();
    }

    private boolean emailExists(String address) {
        String lower = address.toLowerCase(CompatUtils.getLocalDefault());
        for (String email : this.emails) {
            if (!email.toLowerCase(CompatUtils.getLocalDefault()).equals(lower)) continue;
            return true;
        }
        return false;
    }

    public Bitmap getAvatarBitmap(Context context) {
        return this.getAvatarBitmap(context, false);
    }

    public Bitmap getAvatarBitmap(Context context, boolean fromMemCacheOnly) {
        Bitmap bmp;
        if (!StringUtil.isEmptyOrNull((String)this.avatarPath) && (bmp = ZMBitmapFactory.decodeFile(this.avatarPath, fromMemCacheOnly)) != null) {
            return bmp;
        }
        return ContactsAvatarCache.getInstance().getContactAvatar(context, this.getContactId(), fromMemCacheOnly);
    }

    static class PhoneNumber
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String number;
        String normalizedNumber;

        PhoneNumber() {
        }
    }
}

