/*
 * Decompiled with CFR 0.152.
 */
package com.zipow.videobox.view;

import android.content.Context;
import android.os.Bundle;
import android.support.v4.app.FragmentManager;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import com.zipow.videobox.util.UIMgr;
import com.zipow.videobox.view.AvatarView;
import us.zoom.androidlib.app.ZMTipFragment;
import us.zoom.androidlib.widget.ZMTip;
import us.zoom.videomeetings.R;

public class JoinLeaveTip
extends ZMTipFragment {
    private static final String TAG = JoinLeaveTip.class.getSimpleName();
    public static final int TYPE_JOINED = 0;
    public static final int TYPE_LEFT = 1;
    public static final String ARG_NAME = "name";
    public static final String ARG_AVATAR = "avatar";
    public static final String ARG_TYPE = "type";
    public static final String ARG_ANCHOR_ID = "anchorId";

    public static void show(FragmentManager fragmentMgr, String avatar, String name, int type, int anchorId) {
        if (fragmentMgr == null) {
            return;
        }
        Bundle args = new Bundle();
        args.putString(ARG_AVATAR, avatar);
        args.putString(ARG_NAME, name);
        args.putInt(ARG_TYPE, type);
        args.putInt(ARG_ANCHOR_ID, anchorId);
        JoinLeaveTip tip = new JoinLeaveTip();
        tip.setArguments(args);
        tip.show(fragmentMgr, JoinLeaveTip.class.getName(), 3000L);
    }

    public static boolean isShown(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        JoinLeaveTip tip = (JoinLeaveTip)fragmentMgr.findFragmentByTag(JoinLeaveTip.class.getName());
        return tip != null;
    }

    public static boolean dismiss(FragmentManager fragmentMgr) {
        if (fragmentMgr == null) {
            return false;
        }
        try {
            fragmentMgr.executePendingTransactions();
        }
        catch (Exception exception) {
            // empty catch block
        }
        JoinLeaveTip tip = (JoinLeaveTip)fragmentMgr.findFragmentByTag(JoinLeaveTip.class.getName());
        if (tip != null) {
            tip.dismiss();
            return true;
        }
        return false;
    }

    public ZMTip onCreateTip(Context context, LayoutInflater layoutInflater, Bundle savedInstanceState) {
        View anchor;
        View view = layoutInflater.inflate(R.layout.zm_joinleft_tip, null);
        AvatarView avatar = (AvatarView)view.findViewById(R.id.avatarView);
        TextView txtMessage = (TextView)view.findViewById(R.id.txtMessage);
        Bundle args = this.getArguments();
        avatar.setAvatar(args.getString(ARG_AVATAR));
        txtMessage.setText((CharSequence)context.getString(args.getInt(ARG_TYPE) == 0 ? R.string.zm_msg_user_joined : R.string.zm_msg_user_left, new Object[]{args.getString(ARG_NAME)}));
        ZMTip tip = new ZMTip(context);
        tip.addView(view);
        int anchorId = args.getInt(ARG_ANCHOR_ID, 0);
        if (anchorId > 0 && (anchor = this.getActivity().findViewById(anchorId)) != null) {
            tip.setAnchor(anchor, UIMgr.isLargeMode((Context)this.getActivity()) ? 1 : 3);
        }
        return tip;
    }
}

